/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rw9R
 */

/*
アナログ時計

背景画像は以下より拝借。
by Sir Simon Milligan
http://www.flickr.com/photos/sirsimonmilligan/2673082587/
*/

package {
	import flash.display.Sprite;
	import flash.events.Event;
	public class Main extends Sprite {
		private var _seconds:Sprite;
		private var _minutes:Sprite;
		private var _hours:Sprite;
		public function Main() {

			// 秒針
			_seconds = new Sprite();
			_seconds.graphics.beginFill(0xe6e6e6);
			_seconds.graphics.moveTo(-1, 0);
			_seconds.graphics.lineTo(0, -175);
			_seconds.graphics.lineTo(2, -175);
			_seconds.graphics.lineTo(2, 0);
			_seconds.graphics.lineTo(-1, 0);
			_seconds.x = stage.stageWidth/2; // ステージの大きさ/2で真ん中に配置
			_seconds.y = stage.stageWidth/2; // 上に同じ
			this.addChild(_seconds);

			// 分針
			_minutes = new Sprite();
			_minutes.graphics.beginFill(0x999999);
			_minutes.graphics.moveTo(-1, 0);
			_minutes.graphics.lineTo(0, -150);
			_minutes.graphics.lineTo(2, -150);
			_minutes.graphics.lineTo(8, 0);
			_minutes.graphics.lineTo(-8, 0);
			_minutes.x = stage.stageWidth/2; // ステージの大きさ/2で真ん中に配置
			_minutes.y = stage.stageWidth/2; // 上に同じ
			this.addChild(_minutes);			

			// 時針
			_hours = new Sprite();
			_hours.graphics.beginFill(0xFFFFFF);
			_hours.graphics.moveTo(-1, 0);
			_hours.graphics.lineTo(0, -110);
			_hours.graphics.lineTo(2, -110);
			_hours.graphics.lineTo(8, 0);
			_hours.graphics.lineTo(-12, 0);
			_hours.x = stage.stageWidth/2; // ステージの大きさ/2で真ん中に配置
			_hours.y = stage.stageWidth/2; // 上に同じ
			this.addChild(_hours);			

			this.addEventListener(Event.ENTER_FRAME,onEnter);
		}

		private function onEnter(event:Event):void {
			var date:Date = new Date();
			_seconds.rotation = date.getSeconds()*6;	// [秒] 戻り値0-60で360°→ 6倍
			_minutes.rotation = date.getMinutes()*6;	// [分] 戻り値0-60で360°→ 6倍
			// [時]
			// date.getHours()の戻り値: 0-23
			// (分岐)戻り値0〜11の場合: そのまま
			// (分岐)戻り値12〜23の場合: 戻り値から-12
			// ↑の分岐で戻り値が0〜11の12個になったので360/12=30、30倍すればOK
			var dateHour:Number=date.getHours();
			if (date.getHours()>=12) {
					dateHour=dateHour-12;
					}
					_hours.rotation=(dateHour*30)+(date.getMinutes()/2);
				}
			}
	}
