/**
 * Copyright swingpants ( http://wonderfl.net/user/swingpants )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rw4w
 */

// forked from checkmate's fladdict challenge for professionals
/**
 * Theme:
 * Play with BitmapPatterBuilder.
 * Purpose of this trial is to find the possibility of the dot pattern.
 *
 * by Takayuki Fukatsu aka fladdict
 **/
 
 /**
 * Noise Waves 0.1
 * Just a quickie to kick off the playing
 * Purpose of this trial is to find the possibility of the dot pattern.
 *
 * by Swingpants
 **/
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.display.StageScaleMode;
    import flash.events.*;
    import flash.text.*
    
    
    public class Professional extends Sprite 
    {
        private var col1:uint=0xff0000ff;
        private var col2:uint=0xff000099;
        private var col3:uint=0xff000000;
        private var col4:uint=0xff000044;
        private var col5:uint=0xff222222;
        private var col6:uint=0xff333333;
        private var col7:uint=0xff444444;
        private var col8:uint=0xff555555;
        private var colour_array:Array=[col1,col2,col3,col4,col5,col6,col7,col8]
        private var num_colours:int=8
        private var dot_pattern:Array=[]
        private var index_x:int=0
        private var index_y:int=0
        private var gridsize_w:int=2
        private var gridsize_h:int=2
        private var max_size:int=50
        private var min_size:int=2
        private var grid_dir:int=1
        private var pattern:BitmapData=getBitmapDataPattern()
        private var col_dir:int=1
        
        
        public function Professional() 
        {
            stage.scaleMode = StageScaleMode.NO_SCALE;
            
            num_colours=3
            
            dot_pattern=arrayMaker(gridsize_w,gridsize_h)
            
            stage.addEventListener( Event.ENTER_FRAME, oef);
        }
        
        private function oef(event:Event):void
        {
            pattern.dispose()
            pattern=getBitmapDataPattern()
            
            var g:Graphics = graphics;
            g.beginBitmapFill(pattern);
            g.drawRect(0,0,480,480);
            g.endFill();
        }
        

        private function arrayMaker(w:int,h:int):Array
        {
            var new_pattern:Array=[]
            for (var i:int=0;i<h;i++)
                {
                    new_pattern.push(getNewLine())
                }
            return new_pattern
        }
        
        private function getNewLine():Array
        {
            var new_line:Array=[]
            for (var j:int=0;j<gridsize_w;j++)
                {
                     new_line.push(getNewDot())
                }
            return new_line
        }
        private function getNewDot():int
        {
            return Math.floor(Math.random()*num_colours)
        }
        
        public function getBitmapDataPattern():BitmapData
        {

             dot_pattern[index_y]=getNewLine()
             index_y++
             if(index_y==gridsize_h)
                 {
                     index_y=0
                     //Trying out a change of colour selection
                     num_colours+=col_dir
                     col_dir=num_colours<3||num_colours>8?-col_dir:col_dir
                     //Trying out a change of gridsize
                     changeGridSize()
                     
                 }
             return BitmapPatternBuilder.build(dot_pattern, colour_array);
        }
        
        private function changeGridSize():void
        {
            switch(grid_dir)
                {
                    case -1:
                        doReduceGridSize()
                        break;
                    case 1:
                        doIncreaseGridSize()
                        break;
                }
            gridsize_w+=grid_dir
            gridsize_h+=grid_dir
            if(gridsize_w<min_size||gridsize_w>max_size)grid_dir=-grid_dir
        }
        
        private function doReduceGridSize():void
        {
            for (var i:int=0;i<gridsize_w;i++)
                {
                   dot_pattern[i].pop()
                }
            dot_pattern.pop()
        }
        
        private function doIncreaseGridSize():void
        {
            for (var i:int=0;i<gridsize_w;i++)
                {
                   dot_pattern[i].push(getNewDot())
                }
            dot_pattern.push(getNewLine())
        }
    }
}

/**-----------------------------------------------------
 * Use following BitmapPatternBuilder class 
 * 
 * DO NOT CHANGE any codes below this comment.
 *
 * -----------------------------------------------------
*/
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Graphics;
    
class BitmapPatternBuilder{
    /**
     * creates BitmapData filled with dot pattern.
     * First parameter is 2d array that contains color index for each pixels;
     * Second parameter contains color reference table.
     *
     * @parameter pattern:Array 2d array that contains color index for each pixel.
     * @parameter colors:Array 1d array that contains color table.
     * @returns BitmapData
     */
    public static function build(pattern:Array, colors:Array):BitmapData{
        var bitmapW:int = pattern[0].length;
        var bitmapH:int = pattern.length;
        var bmd:BitmapData = new BitmapData(bitmapW,bitmapH,true,0x000000);
        for(var yy:int=0; yy<bitmapH; yy++){
            for(var xx:int=0; xx<bitmapW; xx++){
                var color:int = colors[pattern[yy][xx]];
                bmd.setPixel32(xx, yy, color);
            }
        }
        return bmd;
    }
    
    /**
     * short cut function for Graphics.beginBitmapFill with pattern.
     */
    public static function beginBitmapFill(pattern:Array, colors:Array, graphics:Graphics):void{
        var bmd:BitmapData = build(pattern, colors);
        graphics.beginBitmapFill(bmd);
        bmd.dispose();        
    }
}