/**
 * Copyright Tamanegi_kenshi ( http://wonderfl.net/user/Tamanegi_kenshi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rw3t
 */

//質問にお答えいただいてありがとうございました。
//クラスを使えばコードをすっきりすることができてとても便利ですね。
//クラスについてはまだ勉強不足であまり理解していなかったので、o8queさんに
//教えていただいてとても参考になりました。

//本当にありがとうございました。



// forked from o8que's forked from: コードを短くするにはどうすればよいですか？
/*
 * それぞれのボールがやっていることはほとんど同じなので、
 * 「ボールのクラス」という形で共通部分を一つにまとめることができると、
 * 無駄な繰り返しが無くなってスッキリします。
 * 
 * また、同じようなものを複数作成して、変数で持っておきたい時には、
 * その数だけ変数を作っていくのでは無く、配列でまとめて管理してしまうと便利です。
 * 
 * コードの行数はほとんど変わっていませんが、
 * 無駄な繰り返しを無くし、各ボールを配列でまとめて処理するようにしているので、
 * ボールの数が変わってもちゃんと動くようになっています。
 * 
 * 調子に乗ってコードをかなり自己流に書き換えてしまったので、逆にわかりづらかったらすいません…。
 * 
 */

package	{
	import flash.display.Sprite;
	import flash.events.Event;
	
	public class sp extends Sprite {
		// ボールの数（この数を変えても、ちゃんと動くようになっています）
		public static const BALL_NUM:int = 3;
		// ボールをまとめて保持するための配列
		private var _balls:Array;
		
		public function sp() {
			init();
		}
		
		private function init():void {
			_balls = new Array();
			
			// for文でBALL_NUMで決めた数だけ、
			// ボールを作成し、作ったボールは配列に入れてまとめる
			for (var i:int = 0; i < BALL_NUM; i++) {
				var ball:Ball;
				var spring:Number;
				
				// 先頭のボールだけ別に作成する
				if (i == 0) {
					spring = 0.08;
					ball = new Ball(spring);
				}else {
					spring = 0.07;
					// 親（一つ前）のボールを求める
					var parent:Ball = _balls[i - 1];
					ball = new Ball(spring, parent);
				}
				addChild(ball);
				
				// 配列（の最後尾）に入れる
				_balls.push(ball);
			}
			
			addEventListener(Event.ENTER_FRAME, onEnterFrame);
		}
		
		// 毎フレームの更新処理
		private function onEnterFrame(e:Event):void {
			// 作成したボールは全て配列にまとめられているので、
			// for文で順番に一つずつボールを更新する作業を繰り返していく
			for (var i:int = 0; i < BALL_NUM; i++) {
				_balls[i].update();
			}
		}
	}
}

/*
 * 「ボールのクラス」です。
 * ボールの画像の作成、ボールの運動を、ここで定義しています。
 * 
 */

import flash.display.GradientType;
import flash.display.Sprite;
import flash.geom.Matrix;

class Ball extends Sprite {
	// 変わらない値は定数にしておく
	public static const GRAVITY:Number = 4;
	public static const FRICTION:Number = 0.9;
	
	// 変数
	private var _vx:Number;
	private var _vy:Number;
	private var _spring:Number;
	private var _parentBall:Sprite;	// 親（一つ前）のボール
	
	// コンストラクタ
	public function Ball(spring:Number, parent:Sprite = null) {
		_vx = 0;
		_vy = 0;
		_spring = spring;
		_parentBall = parent;
		
		// ボールの画像を作成
		var colors:Array = [0x000000, 0x000000];
 		var alphas:Array = [0.3, 1];
 		var ratios:Array = [0, 255];
 		var matrix:Matrix = new Matrix();
 		matrix.createGradientBox(30, 30, 0, -20, -20);
 		this.graphics.beginGradientFill(GradientType.RADIAL, colors, alphas, ratios, matrix);
 		this.graphics.drawCircle(0,0,20);
 		this.graphics.endFill();
	}
	
	// 毎フレームの更新処理
	public function update():void {
		var parentX:Number;
		var parentY:Number;
		
		// 親（一つ前）のボールの位置を求める
		if (_parentBall != null) {
			parentX = _parentBall.x;
			parentY = _parentBall.y;
		// 親が無い（一番先頭のボール）なら、マウスの位置を求める
		}else {
			parentX = stage.mouseX;
			parentY = stage.mouseY;
		}
		
 	    var ax:Number = (parentX - this.x) * _spring;
 	    var ay:Number = (parentY - this.y) * _spring;
 	    _vx = (_vx + ax) * FRICTION;
		_vy = (_vy + ay) * FRICTION;
 	    _vy += GRAVITY;
		
		this.x += _vx;
		this.y += _vy;
	}
}