/**
 * Copyright iong ( http://wonderfl.net/user/iong )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rvp8
 */

package
{
    /*
    setPixelの勉強中...
    */
	import flash.display.Sprite;

	public class FlashTest extends Sprite
	{
		import flash.display.Bitmap;
		import flash.display.BitmapData;

		import flash.events.Event;

		var cv:BitmapData;
		var sp:Sprite;

		var aryArea:Array = new Array();
		var iw:uint       = 5;
		var ih:uint       = 5;

		public function FlashTest():void
		{
			cv = new BitmapData(465, 465, false);
			sp = new Sprite();
			addChild(new Bitmap(cv));

			init();
			addEventListener(Event.ENTER_FRAME, mR);
		}

		private function init():void
		{
			var ri:uint = Math.ceil(465/iw);
			var rk:uint = Math.ceil(465/ih);
			for(var i:int=0; i<ri; i++){
				for(var k:int=0; k<rk; k++){
					aryArea.push(i+"_"+k);
				}
			}
		}

		private function mR(e:Event):void
		{
			cv.lock();
			for(var cnt:int=0; cnt<40; cnt++){
				var aryT:Array = retTarget();
				var icN:Array  = (aryArea.length>0) ? retCOffset(100) : retAAVG(false, aryT[0], aryT[1]);
				var icX:Array  = (aryArea.length>0) ? retCOffset(100) : retAAVG(true,  aryT[0], aryT[1]);
				var tmpC:Array = new Array();
				for(var cc:int=0; cc<ih; cc++){
					var tR:int = icN[0]+Math.round((icN[0]-icX[0])/ih*cc);
					var tG:int = icN[1]+Math.round((icN[1]-icX[1])/ih*cc);
					var tB:int = icN[2]+Math.round((icN[2]-icX[2])/ih*cc);

					tR = (tR<0) ? 0: (tR>255) ? 255: tR;
					tG = (tG<0) ? 0: (tG>255) ? 255: tG;
					tB = (tB<0) ? 0: (tB>255) ? 255: tB;

					var pR:String = tR.toString(16); pR = (pR.length==1) ? "0"+pR: pR;
					var pG:String = tG.toString(16); pG = (pG.length==1) ? "0"+pG: pG;
					var pB:String = tB.toString(16); pB = (pB.length==1) ? "0"+pB: pB;

					tmpC.push( parseInt("0x"+ pR+pG+pB ,16) );
				}
	
				sp.x = aryT[0]*iw;
				sp.y = aryT[1]*ih;
	
				for(var i:int=1; i<=iw; i++){
					for(var k:int=1; k<=ih; k++){
						cv.setPixel(sp.x+i, sp.y+k, tmpC[(k-1)]);
					}
				}
			}
			cv.unlock();
		}

		// ランダムカラーをreturn(0=r, 1=g, 2=b)
        private function retCOffset(n:uint):Array
        {
            var ofR:int = n+Math.round(Math.random()*(255-n));
            var ofG:int = n+Math.round(Math.random()*(255-n));
            var ofB:int = n+Math.round(Math.random()*(255-n));
            return new Array(ofR, ofG, ofB);
        }

		// ランダム座標をreturn
		private function retTarget():Array
		{
			var tX:uint;
			var tY:uint;
			if(aryArea.length>0){
				var tGP:uint = Math.round(Math.random()*(aryArea.length-1));
				var tG:Array = aryArea[tGP].split("_");
				tX = uint(tG[0]);
				tY = uint(tG[1]);
				aryArea.splice(tGP,1);

			}else{
				tX = Math.round(Math.random()*(465/iw));
				tY = Math.round(Math.random()*(465/ih));
			}
			return new Array(tX, tY);
		}

		// 座標に隣接するpixelの最高/最低のRGBをreturn
		// true=max, false=min
		private function retAAVG(flg:Boolean, vx:uint, vy:uint):Array
		{
			var retR:int=(flg) ? 0:255; var retG:int=(flg) ? 0:255; var retB:int=(flg) ? 0:255;
			var i:int; var tV:uint;
			if(vx-1>0){
				for(i=0; i<=iw; i++){
					tV   = cv.getPixel(vx-1, vy+i);
					retR = retAAVGPiece(retR, tV, "r", flg);
					retG = retAAVGPiece(retG, tV, "g", flg);
					retB = retAAVGPiece(retB, tV, "b", flg);
				}
			}
/*
			if(vx+iw+1<465){
				for(i=0; i<=iw; i++){
					tV   = cv.getPixel(vx+iw+1, vy+i);
					retR = retAAVGPiece(retR, tV, "r", flg);
					retG = retAAVGPiece(retG, tV, "g", flg);
					retB = retAAVGPiece(retB, tV, "b", flg);
				}
			}
*/
			if(vy-1>0){
				for(i=0; i<=ih; i++){
					tV   = cv.getPixel(vx+i, vy-1);
					retR = retAAVGPiece(retR, tV, "r", flg);
					retG = retAAVGPiece(retG, tV, "g", flg);
					retB = retAAVGPiece(retB, tV, "b", flg);
				}
			}
/*
			if(vy+ih+1<465){
				for(i=0; i<=ih; i++){
					tV   = cv.getPixel(vx+i, vy+ih+1);
					retR = retAAVGPiece(retR, tV, "r", flg);
					retG = retAAVGPiece(retG, tV, "g", flg);
					retB = retAAVGPiece(retB, tV, "b", flg);
				}
			}
*/
			return new Array(retR, retG, retB);
		}
		private function retAAVGPiece(v:uint, tV:uint, type:String, flg:Boolean):uint
		{
			var retVal:uint = v;
			var tP:uint     = 0;
			switch(type){
				case "r":
					tP = tV >> 16 & 0xFF;
					break;
				case "g":
					tP = tV >> 8 & 0xFF;
					break;
				case "b":
					tP = tV & 0xFF;
					break;
			}
			if(flg && retVal<tP)  retVal = tP;
			if(!flg && retVal>tP) retVal = tP;
			return retVal;
		}
	}
}