/**
 * Copyright MMMMMonchi ( http://wonderfl.net/user/MMMMMonchi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rvcQ
 */

// forked from daniwell's Typography for CUTE CUTE CAT
package  
{
    import flash.display.Sprite;
    import flash.events.Event;
    
    [SWF(backgroundColor = "0x000000", frameRate = "30", width = "465", height = "465")]
    public class Typography extends Sprite
    {
        private const SEP :int = 5;
        
        private var _cnt  :int = 0;
        private var _loop :Loop;
        private var _typo :TypoArea;
        
        public function Typography() 
        {
            stage.align = "TL"; stage.scaleMode = "noScale";
            
            _loop = addChild(new Loop(_getLoopClip(80))) as Loop;
            _typo = addChild(new TypoArea()) as TypoArea;
            
            _resize();
            stage.addEventListener(Event.RESIZE, _resize);
            stage.addEventListener(Event.ENTER_FRAME, _enterFrame);
        }
        
        /* 背景ループ用タイルの生成 */
        private function _getLoopClip ( size :int ) :Sprite
        {
            var sp :Sprite = new Sprite();
            sp.graphics.beginFill(0); sp.graphics.drawRect(0, 0, size, size); // 背景
            sp.graphics.lineStyle(0, 0x999999); sp.graphics.moveTo(0, size); sp.graphics.lineTo(size, 0); // 線
            return sp;
        }
        
        /* ENTER FRAME */
        private function _enterFrame ( evt :Event ) :void 
        {
            var px :Number = stage.stageWidth  / 2 - _typo.mouseX;
            var py :Number = stage.stageHeight / 2 - _typo.mouseY;
            
            if (++ _cnt % 10 == 0)
            {
                var c :int;
                var r :Number = Math.random();
                // 英語, 日本語
                     if (r < 0.3) c = Math.random() * 26 + 65;
                else if (r < 1.0) c = Math.random() * (12534 - 12353) + 12353;
                // else              c = Math.random() * (40657 - 20124) + 20124;
                
                var s :String = String.fromCharCode(c);
                _typo.add(s, _typo.mouseX, _typo.mouseY, (mouseY - stage.stageHeight / 2) / 10);
            }
            
            _loop.x += (px - _loop.x) / SEP; _loop.y += (py - _loop.y) / SEP;
            _typo.x += (px - _typo.x) / SEP; _typo.y += (py - _typo.y) / SEP;
        }
        /* RESIZE */
        private function _resize ( evt :Event = null ) :void { _loop.resize(stage.stageWidth, stage.stageHeight); }
    }
}


import caurina.transitions.Tweener;
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.DisplayObject;
import flash.display.Sprite;
import flash.geom.Matrix;
import flash.text.TextField;
import flash.text.TextFormat;

/* ループ背景 */
class Loop extends Sprite {
    
    private var _width  :int;
    private var _height :int;
    private var _bmd    :BitmapData;
    
    private var _x  :Number = 0;
    private var _y  :Number = 0;
    private var _xx :Number = 0;
    private var _yy :Number = 0;
    
    public function Loop ( source :DisplayObject ) 
    {
        _width  = source.width;
        _height = source.height;
        _bmd = new BitmapData(_width, _height, true, 0x0);
        _bmd.draw(source);
    }
    public function resize ( w :int, h :int ) :void
    {
        graphics.clear();
        graphics.beginBitmapFill(_bmd);
        graphics.drawRect(0, 0, w + _width, h + _height);
    }
    
    override public function get x ( ) :Number { return _x; }
    override public function get y ( ) :Number { return _y; }
    
    override public function set x ( value :Number ) :void 
    {
        _xx += value - _x; _x = value;
        while (1) { if (_xx < - _width) { _xx += _width; } else { break; } }
        while (1) { if (  0 <      _xx) { _xx -= _width; } else { break; } }
        super.x = _xx;
    }
    override public function set y ( value :Number ) :void 
    {
        _yy += value - _y; _y = value;
        while (1) { if (_yy < - _height) { _yy += _height; } else { break; } }
        while (1) { if (  0 <       _yy) { _yy -= _height; } else { break; } }
        super.y = _yy;
    }
}
/* Text を表示する領域 */
class TypoArea extends Sprite {
    
    private var _texts :/*Text*/Array = [];
    
    public function TypoArea () {}
    
    public function add ( str :String, px :int, py :int, rot :Number = 0 ) :void
    {
        // Text
        var text :Text = addChild(new Text(str, 24, 72)) as Text;
        text.rotation = rot;
        text.x = px; text.y = py; text.show();
        _texts.push(text);
    }    
}
/* Text */
class Text extends Sprite {
    
    private var _bmp :Bitmap;
    
    public function Text ( str :String, min :int, max :int ) :void
    {
        var tf :TextField = new TextField();
        tf.autoSize = "left"; tf.embedFonts = false;
        tf.defaultTextFormat = new TextFormat("_明朝", int(Math.random() * (max - min) + min), 0xffffff, true);
        tf.text = str;
        
        var w :int = tf.width  * 2.5;
        var h :int = tf.height * 2.5;
        var bmd :BitmapData = new BitmapData(w, h, true, 0);
        bmd.draw(tf, new Matrix(2.5, 0, 0, 2.5));
        
        _bmp = addChild(new Bitmap(bmd, "auto", true)) as Bitmap;
        _bmp.x = - (w / 2); _bmp.y = - (h / 2);
    }
    
    public function show ( ) :void { scaleX = scaleY = 0; Tweener.addTween(this, { scaleX:1.0, scaleY:1.0, time:0.8, transition:"easeOutElastic" }); }
}
