/**
 * Copyright yd_niku ( http://wonderfl.net/user/yd_niku )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rvaf
 */

package {
    
    import flash.utils.Timer;
    import flash.display.Sprite;
    import flash.events.*;
    import flash.geom.Rectangle;
    public class FlashTest extends Sprite {
        private var _nodes:Array = [];
        private var _queue:Array = [];
        
        private var _timer:Timer;
        
        private var _lim:Number = 0;
        
        public function FlashTest() {
            separate(new Node(0,0,456,456));
            
            _timer = new Timer(20);
            _timer.addEventListener(TimerEvent.TIMER, loop);
            _timer.start();
        }
        
        private function loop(e:Event):void {
            if(_queue.length>0) {
                var n:Node = _queue.shift();
                drawNode(n, 0x00, (n.size.length/100)*0xff<<16);
            }
            if(_nodes.length>0) {
                n = _nodes.shift();
                separate(n);
            }
        }
        
        public function drawNode(n:Node, color:uint=0xFF0000, fill:uint = 0):void {
            graphics.lineStyle(0,color);
            if(!isNaN(fill) && fill!=0) graphics.beginFill(fill);
            graphics.drawRect(n.x, n.y, n.width, n.height);
            graphics.endFill();
        }
        public function addNode(n:Node):void {
            if(n.width<_lim||n.height<_lim) return;
            
            //drawNode(n, 0x99ff99);
            _nodes.push(n);
        }
        public function addQueue(n:Node):void {
            _queue.push(n);
        }
        
        
        public function separate(n:Node):void {
            var partA_height:Number = Math.random()*0.4+0.3,
                partB_height:Number = 1-partA_height;
            var partA_width:Number = Math.random()*0.4+0.3,
                partB_width:Number = 1-partA_width;
                
            if( partA_height<partB_height ) {
                if( partA_width<partB_width) {
                    addQueue(new Node(
                        n.x, n.y,
                        n.width*partA_width, n.height*partA_height
                        ) );
                    addNode(new Node(
                        n.x+n.width*partA_width, n.y,
                        n.width*partB_width, n.height*partA_height
                        ) );
                }
                else {
                    addQueue(new Node(
                        n.x+n.width*partA_width, n.y,
                        n.width*partB_width, n.height*partA_height
                        ) );
                    addNode(new Node(
                        n.x, n.y,
                        n.width*partA_width, n.height*partA_height
                        ) );
                }
                addNode(new Node(n.x, n.y+n.height*partA_height, n.width, n.height*partB_height) );
            }
            else {
                if( partA_width<partB_width) {
                    addQueue(new Node(
                        n.x, n.y+n.height*partA_height,
                        n.width*partA_width, n.height*partB_height
                        ) );
                    addNode(new Node(
                        n.x+n.width*partA_width, n.y+n.height*partA_height,
                        n.width*partB_width, n.height*partB_height
                        ) );
                }
                else {
                    addQueue(new Node(
                        n.x+n.width*partA_width, n.y+n.height*partA_height,
                        n.width*partB_width, n.height*partB_height
                        ) );
                    addNode(new Node(
                        n.x, n.y+n.height*partA_height,
                        n.width*partA_width, n.height*partB_height
                        ) );
                }
                addNode(new Node(n.x, n.y, n.width, n.height*partA_height) );
            }
        }
        
    }
}
import flash.geom.Rectangle;

class Node extends Rectangle {
    public function Node(x:Number,y:Number,w:Number,h:Number):void {
        super(x,y,w,h)
    }
}