/**
 * Copyright ug24k8 ( http://wonderfl.net/user/ug24k8 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ruqf
 */

// forked from nutsu's BitmapDataSample9
package {
    import flash.text.*;
    import flash.display.*;
    import flash.geom.Point;
    import flash.events.Event;
    import com.bit101.components.*;

    [SWF(width=465,height=465,backgroundColor=0)]
    public class BitmapDataSample9 extends Sprite {

        private var bmpdata:BitmapData;

        public function BitmapDataSample9() {
            //BitmapDataを作成して表示リストに追加
            bmpdata = new BitmapData( 120, 120, false, 0 );
            var bmp:Bitmap = new Bitmap(bmpdata);
            bmp.scaleX = bmp.scaleY = 4;
            addChild( bmp );

            var i:int;
            for (i = 0; i < SL_SIZE; ++i) {
                value_sliders[i] = new HSlider(this, 5, 5 + i * 16, update_slider);
                value_sliders[i].minimum = SL_DATA[i].min;
                value_sliders[i].maximum = SL_DATA[i].max;
                value_sliders[i].value = SL_DATA[i].def;
                value_sliders[i].width = 200;
                value_sliders[i].alpha = 0.25;
                value_texts[i] = new TextField();
                value_texts[i].textColor = 0xFFFFFF;
                value_texts[i].x = 210;
                value_texts[i].y = 5 + i * 15;
                value_texts[i].autoSize = TextFieldAutoSize.LEFT;
                addChild(value_texts[i]);
            }

            for (i = 0; i < CB_SIZE; ++i) {
                check_buttons[i] = new CheckBox(this, 190, 5 + (i + SL_SIZE) * 16, null, update_slider);
                check_buttons[i].alpha = 0.25;
                check_texts[i] = new TextField();
                check_texts[i].textColor = 0xFFFFFF;
                check_texts[i].x = 210;
                check_texts[i].y = 5 + (i + SL_SIZE) * 15;
                check_texts[i].autoSize = TextFieldAutoSize.LEFT;
                addChild(check_texts[i]);
            }
            update_slider();

            //イベント
            addEventListener( Event.ENTER_FRAME, enterframe );
        }
        

        private var octaves:uint         = 1;
        private var channelOptions:int   = BitmapDataChannel.RED|BitmapDataChannel.BLUE;
        private var value_sliders:Array = new Array();
        private var value_texts:Array = new Array();
        private var check_buttons:Array = new Array();
        private var check_texts:Array = new Array();
        private const SL_BASEX:uint = 0;
        private const SL_BASEY:uint = 1;
        private const SL_RAND_SEED:uint = 2;
        private const SL_XOFFSET:uint = 3;
        private const SL_YOFFSET:uint = 4;
        private const SL_SIZE:uint = 5;

        private const SL_DATA:Array = [
                            {   target_label:"baseX   :", min:0, max:200, def:50 },
                            {   target_label:"baseY   :", min:0, max:200, def:50 },
                            {   target_label:"seed    :", min:0, max:999, def:0 },
                            {   target_label:"offsetX :", min:0, max:465, def:0 },
                            {   target_label:"offsetY :", min:0, max:465, def:0 }
                        ];

        private const CB_STITCH:uint = 0;
        private const CB_FRACTAL:uint = 1;
        private const CB_GRAY:uint = 2;
        private const CB_SIZE:uint = 3;

        private const CB_DATA:Array = [
                            {    target_label:"stitch  :" },
                            {    target_label:"fractal :" },
                            {    target_label:"gray    :" }
                        ];

        private function enterframe(e:Event):void {
            //PerlinNoise
            bmpdata.perlinNoise(
                    value_sliders[SL_BASEX].value,
                    value_sliders[SL_BASEY].value,
                    1,
                    value_sliders[SL_RAND_SEED].value,
                    check_buttons[CB_STITCH].selected,
                    check_buttons[CB_FRACTAL].selected,
                    channelOptions, 
                    check_buttons[CB_GRAY].selected,
                    [new Point(value_sliders[SL_XOFFSET].value,
                                value_sliders[SL_YOFFSET].value)]);
        }

        private function update_slider(evt:Event = null):void {
            var i:int;
            for (i = 0; i < SL_SIZE; ++i) {
                value_sliders[i].value = Math.round(value_sliders[i].value);
                value_texts[i].text = SL_DATA[i].target_label + value_sliders[i].value;
            }
            for (i = 0; i < CB_SIZE; ++i) {
                check_texts[i].text = CB_DATA[i].target_label + check_buttons[i].selected;
            }
        }
    }
}
