/**
 * Copyright umi_kappa ( http://wonderfl.net/user/umi_kappa )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/ruVl
 */

// forked from umhr's forked from: Test that uses Face.com
/*
 * いつものようにコードを読み解いてみる。
 * でも、face.comをASで使うっていう情報が少ないんで
 * ちょっと、TIME。
 * 
 * まだまだ理解できないない。
 * 
 * 一通りみてみました。
 * でも、もっと見てみないと。
 * */
package {
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.PerspectiveProjection;
	import flash.geom.Point;
	import flash.net.URLLoader;
	import flash.net.URLRequest;
	import flash.net.URLVariables;
	import flash.system.LoaderContext;
	import flash.text.TextField;
	
	import com.adobe.serialization.json.JSON;
	
	public class Main extends Sprite {
		
		/*------------------------------------------------------------------
		 * コンストラクタ
		 * ---------------------------------------------------------------*/
		public function Main() {
			//画像の読み込み
			var loader:Loader = new Loader();
			loader.load(new URLRequest("http://assets.wonderfl.net/images/related_images/6/62/62d5/62d5691c23ef2c10bcb72f0e8663c97973e91b67"), new LoaderContext(true));
			//読み込みが終わったら
			loader.contentLoaderInfo.addEventListener(Event.COMPLETE, loadComp);
		}
		
		/*------------------------------------------------------------------
		 * 画像の読み込みが完了したら
		 * APIの読み込み
		 * ---------------------------------------------------------------*/
		public function loadComp(event:Event):void {
			//読み込んだ画像を配置
			addChild(event.target.content);
			
			var loader:URLLoader = new URLLoader();
			var request:URLRequest = new URLRequest("http://api.face.com/faces/detect.format");
			request.data = new URLVariables();//URLVariables クラスを使用して、Flashアプリケーションとサーバーの間で変数を転送できます。
			request.data.api_key = "415352afd1220103ff13d0e47991a5ad";
			request.data.urls = event.target.url;
			request.data.api_secret = "42265bf332ccf4503b31daab9aa6450a";
			loader.load(request);
			//読み込みが終わったら
			loader.addEventListener(Event.COMPLETE, completeHandler );
		}
		/*
		 * APIの読み込み完了
		 * */
		private function completeHandler(event:Event):void {
			//JSON は XMLのようにデータを文字列で格納するファイル形式。
			//JSONエンコーダーを利用してObject型に変換
			var data:Object = JSON.decode(URLLoader(event.target).data);
			
			//検出した顔の数
			var n:int = data.photos[0].tags.length;
			
			for ( var i:int = 0; i < n; ++i ) {
				var face:Sprite = Face.getSprite(data.photos[0].tags[i], data.photos[0].width, data.photos[0].height);
				//data.photos[].tags[] 
				//     何枚目の写真.いくつめの顔
				//左上がひとつめの顔？
				
				//消失点設定
				var pp:PerspectiveProjection = new PerspectiveProjection();
				pp.projectionCenter = new Point(data.photos[0].tags[i].center.x, data.photos[0].tags[i].center.y);
				//data.photos[0].tags[i].center.x
				//     何枚目の写真.いくつめの顔.center(顔の中心のポイント).x座標
				face.transform.perspectiveProjection = pp;
				
				//returnで帰ってきた顔のSpriteを配置
				addChild(face);
			}
		}
	}
}



import flash.display.Sprite;
import flash.geom.Point;

class Face {
	static public function getSprite(tag:Object,photoWidth:Number,photoHeight:Number):Sprite {
		photoWidth *= 0.01;
		photoHeight *= 0.01;
		
		//顔の大きさ
		var size:Number = (new Point(tag.width, tag.height)).length;
		//顔のパーツがすべて入るSprite
		var result:Sprite = new Sprite();
		
		var faceRectSp:Sprite = new Sprite();
		var w:Number = tag.width * photoWidth;
		var h:Number = tag.height * photoHeight;
		
		//顔の周りのわくの設定--------------------------------------------------------------
		if (tag.attributes.gender.value == "male") {
			faceRectSp.graphics.lineStyle(3, 0x0000FF, 0.5);
		}else{
			faceRectSp.graphics.lineStyle(3, 0xFF0000, 0.5);
		}
		
		//四角を描画(左上のx,左上のy,幅,高さ)
		faceRectSp.graphics.drawRect( - w * 0.5, - h * 0.5, w, h);
		//四角を回転させて
		faceRectSp.rotationX = -tag.pitch;
		faceRectSp.rotationY = -tag.yaw;
		faceRectSp.rotationZ = tag.roll;
		
		result.addChild(faceRectSp);
		//-----------------------------------------------------------------------------
		
		//左目
		if (tag.eye_left) {
			result.addChild(getEye(tag, photoWidth, photoHeight, size, tag.eye_left.x, tag.eye_left.y));
		}
		
		//右目
		if(tag.eye_right){
			result.addChild(getEye(tag, photoWidth, photoHeight, size, tag.eye_right.x, tag.eye_right.y));
		}
		
		//赤はな---------------------------------------------
		if(tag.nose){
			tag.nose.x -= tag.center.x;
			tag.nose.y -= tag.center.y;
			
			var nose:Sprite = new Sprite();
			nose.graphics.beginFill(0xFF0000);
			nose.graphics.drawCircle(0,0, size / 3);
			nose.x = tag.nose.x * photoWidth;
			nose.y = tag.nose.y * photoHeight;
			
			result.addChild(nose);
		}
		//--------------------------------------------------
		
		//塗りの終了
		result.graphics.endFill();
		
		//口の左側
		tag.mouth_left.x -= tag.center.x;
		tag.mouth_left.y -= tag.center.y;
		//口の中央
		tag.mouth_center.x -= tag.center.x;
		tag.mouth_center.y -= tag.center.y;
		//口の右側
		tag.mouth_right.x -= tag.center.x;
		tag.mouth_right.y -= tag.center.y;
		
		//くち-----------------------------------------------------------------------------------------
		result.graphics.lineStyle(size/5, 0xFFFF00);
		result.graphics.moveTo(tag.mouth_left.x*photoWidth, tag.mouth_left.y*photoHeight);
		result.graphics.lineTo(tag.mouth_center.x*photoWidth, tag.mouth_center.y*photoHeight);
		result.graphics.lineTo(tag.mouth_right.x * photoWidth, tag.mouth_right.y * photoHeight);
		
		result.graphics.lineStyle(1, 0x000000);
		result.graphics.moveTo(tag.mouth_left.x*photoWidth, tag.mouth_left.y*photoHeight);
		result.graphics.lineTo(tag.mouth_center.x*photoWidth, tag.mouth_center.y*photoHeight);
		result.graphics.lineTo(tag.mouth_right.x * photoWidth, tag.mouth_right.y * photoHeight);
		//-------------------------------------------------------------------------------------------
		
		//顔全体の移動
		result.x = tag.center.x * photoWidth;
		result.y = tag.center.y * photoHeight;
		
		return result;
	}
	
	static public function getEye(tag:Object, photoWidth:Number, photoHeight:Number, size:Number, x:Number, y:Number):Sprite {
		//左上の座標をセット
		x -= tag.center.x;
		y -= tag.center.y;
		
		//白目
		var result:Sprite = new Sprite();
		result.graphics.beginFill(0xFFFFFF);
		//塗られた丸を描画(x,y,半径)
		result.graphics.drawCircle(0, 0, size / 3);
		
		//黒目
		var leftEyeBall:Sprite = new Sprite();
		leftEyeBall.graphics.beginFill(0x000000);
		leftEyeBall.graphics.drawCircle(0, 0, size / 8);
		//手前にずらすことで目が別の方向を見ているように見える
		leftEyeBall.z = -4.5;
		
		//目を移動
		result.x = x * photoWidth;
		result.y = y * photoHeight;
		result.z = 0;
		
		//目を回転
		result.rotationZ = tag.roll;
		result.rotationY = -tag.yaw;
		result.rotationX = -tag.pitch;
		
		//白目のSpriteに配置
		result.addChild(leftEyeBall);
		
		return result;
	}
}
