/**
 * Copyright FLASHMAFIA ( http://wonderfl.net/user/FLASHMAFIA )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rtXA
 */

package {
    import flash.display.CapsStyle;
    import flash.display.GradientType;
    import flash.display.LineScaleMode;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageQuality;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.geom.Matrix;
    import flash.geom.Rectangle;

    [SWF(width = '465', height = '465')]
    public class Noodle2A extends Sprite {
        /* */
        private const NUM_BITS : uint = 1 << 9;
        /* */
        private var node0 : Node;
        private var node22 : Node;
        private var thk0 : Number = 0.0;
        private var thkD : Number = 0.0;
        private var thkT : Number = 0.0;
        private var thkDT : Number = 0.0;
        private var mood : uint;
        private var colorMoods : Vector.<int> = Vector.<int>([0x010302, 0x000101, 0x010203, 0x030201, 0x040302, 0x000100, 0x010100, 0x010101, 0x020202, 0x030303, 0x040404, 0x050505, 0x060504, 0x050403, 0x040302, 0x030201]);
        private var bgColors : Array = [0x0, 0x0];
        private var bgAlphas : Array = [1.0, 1.0];
        private var bgRatios : Array = [0, 255];
        private var mtx : Matrix;
        private var fcnt : int;

        public function Noodle2A() {
            /* */

            var sw : int = stage.stageWidth;
            var sh : int = stage.stageHeight;

            stage.stageFocusRect = mouseEnabled = mouseChildren = tabEnabled = tabChildren = false;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            stage.fullScreenSourceRect = new Rectangle(0, 0, sw, sh);
            stage.quality = StageQuality.MEDIUM;
            stage.frameRate = 64;
            opaqueBackground = 0x0;

            /* */

            mtx = new Matrix();
            mtx.createGradientBox(sw, sh, 3.141592653589793);

            /* */

            var node : Node = node0 = new Node();
            var i : uint = NUM_BITS;
            while (i-- != 0) {
                node.c = 0x808080;
                node.x = sw >> 1;
                node.y = sh >> 1;

                node.next = new Node();
                node.next.prev = node;
                node = node.next;
            }

            node0.prev = node;

            /* */

            node22 = node0.next.next.next.next.next.next.next.next.next.next.next.next.next.next.next.next.next.next.next.next;
            colorMoods.fixed = true;

            mood = (colorMoods.length * Math.random());

            /* */

            addEventListener(Event.ENTER_FRAME, oef);
        }

        private function oef(e : Event) : void {
            var sw : int = stage.stageWidth;
            var sh : int = stage.stageHeight;

            graphics.clear();

            /* ==================================== TRACK MOUSE === */

            var tx : Number = stage.mouseX;
            var ty : Number = stage.mouseY;

            /* ==================================== COLOR === */

            if ((++fcnt & 255) == 255) mood = (colorMoods.length * Math.random());
            var cinc : int = colorMoods[mood];

            /* ========================================= BKG === */

            var c0 : uint = node0.c;
            var c1 : uint = node22.c;

            if (c0 < c1) {
                c0 ^= c1;
                c1 ^= c0;
                c0 ^= c1;
            }

            bgColors[0] = c0;
            bgColors[1] = (int((c1 >> 16) * 0.66) << 16) | (int(((c1 >> 8) & 0xFF) * 0.66) << 8) | (int((c1 & 0xFF) * 0.66));

            graphics.beginGradientFill(GradientType.RADIAL, bgColors, bgAlphas, bgRatios, mtx);
            graphics.drawRect(0, 0, sw, sh);
            graphics.endFill();

            /* ==================================== GURF & SIZE === */
            
            if ((fcnt & 127) == 1)
            {
                thkT = 32 + 128 * Math.random();
                thkDT = 1.0 - ((1.0 + 6.0 * Math.random()) / NUM_BITS);
            }

            thk0 += (thkT - thk0) * 0.04;
            thkD += (thkDT - thkD) * 0.04;

            var thk : Number = thk0;
            var thkd : Number = thkD;

            /* =================================== NODES :: 0 === */

            var node : Node = node0;
            node.a = 3.141592653589793 + Math.atan2(ty - node.y, tx - node.x);

            node.x += ((tx - 0.5 + Math.random()) - node.x) * 0.16;
            node.y += ((ty - 0.5 + Math.random()) - node.y) * 0.16;

            node = node.next;

            /* =================================== NODES DLL === */

            graphics.moveTo(node.x, node.y);

            while (node != null) {
                var pnode : Node = node.prev;

                var dx : Number = pnode.x - node.x;
                var dy : Number = pnode.y - node.y;
                var absy : Number = (dy < 0) ? -dy : dy;
                node.a = 3.141592653589793 + ((dx >= 0.0) ? (dy < 0.0) ? -(0.7853981633974483 - 0.7853981633974483 * ((dx - absy) / (dx + absy))) : (0.7853981633974483 - 0.7853981633974483 * ((dx - absy) / (dx + absy))) : (dy < 0.0) ? -((3.0 * 0.7853981633974483) - 0.7853981633974483 * ((dx + absy) / (absy - dx))) : ((3.0 * 0.7853981633974483) - 0.7853981633974483 * ((dx + absy) / (absy - dx))));

                node.x = pnode.x + 8 * Math.cos(pnode.a);
                node.y = pnode.y + 8 * Math.sin(pnode.a);

                c0 = pnode.c;
                if ((c0 > 0xCCCCCC) || (c0 < 0x404040)) cinc = -cinc;
                node.c = c0 + cinc;

                thk *= thkd;

                graphics.lineStyle(thk, node.c, 1.0, false, LineScaleMode.NONE, CapsStyle.ROUND);
                graphics.lineTo(node.x, node.y);

                node = node.next;
            }
        }
    }
}
internal class Node {
    public var next : Node;
    public var prev : Node;
    public var x : Number;
    public var y : Number;
    public var a : Number;
    public var c : uint;

    function Node() {
    }
}