/**
 * Copyright geko ( http://wonderfl.net/user/geko )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rsug
 */

package {
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    import flash.filters.DropShadowFilter;
    import flash.ui.Mouse;
    
    public class SpinningRainbow extends Sprite {
        private var rainbow:Rainbow;
        private var screw:Screw;
        
        public function SpinningRainbow() {
            Mouse.hide();
            filters = [new DropShadowFilter(0, 90, 0x0, 0.8, 16, 16, 1.4, 3, true),
                       new DropShadowFilter(0.5, 90, 0x0, 0.8, 2, 2, 2, 3),
                       new DropShadowFilter(1, 90, 0x0, 0.8, 8, 8, 1, 3)];
            
            rainbow = new Rainbow(18);
            addChild(rainbow);
            
            screw = new Screw(18);
            addChild(screw);
            
            if(!stage) return;
            rainbow.x = screw.x = stage.stageWidth/2;
            rainbow.y = screw.y = stage.stageHeight/2;
            
            stage.addEventListener(MouseEvent.MOUSE_MOVE, function move(event:MouseEvent):void{
                rainbow.x = screw.x = mouseX;
                rainbow.y = screw.y = mouseY;
            });
        }
        
    }
}


import flash.display.Shape;
import flash.events.Event;
import flash.geom.Point;
import frocessing.color.ColorHSV;

class Rainbow extends Shape{
    public function Rainbow(radius:Number){
        var _color:ColorHSV = new ColorHSV;
        var _rad:Number = 0;
        
        //draw rainbow
        for(var i:int = 0; i < 360; i++){
            _rad = Math.PI*2*i/360;
            _color.hr = Math.PI - _rad;
             
            graphics.beginFill(_color.value);
            graphics.moveTo(0, 0);
            graphics.lineTo(radius*Math.cos(_rad), radius*Math.sin(_rad));
            graphics.lineTo(radius*Math.cos(Math.PI*2*(i+1)/360), radius*Math.sin(Math.PI*2*(i+1)/360));
            graphics.endFill();
        }
    }
}


class Screw extends Shape{
    public function Screw(radius:Number){
        blendMode = "multiply";
        
        //draw screw
        graphics.beginFill(0x0, 0.4);
        for(var i:int = 0; i < 10; i += 2){
            var radA:Number = Math.PI*2/10*i;
            var radB:Number = Math.PI*2/10*(i+1);
            var div:Number = Math.max(1, Math.floor(Math.abs(radA - radB)/0.4));
            var lx:Number;
            var ly:Number;
            var lt:Number;
            
            graphics.moveTo(0, 0);
            for(var j:int = 0; j <= div; j++){
                var ct:Number = radA + (radB - radA)*j/div;
                var cx:Number = Math.cos(ct)*radius;
                var cy:Number = Math.sin(ct)*radius;
            
                if(j == 0){
                    graphics.curveTo(cx, cy, cx, cy);
                }
                else{
                    var cp:Point = getControlPoint(new Point(lx, ly), lt+Math.PI/2, new Point(cx, cy), ct+Math.PI/2); 
                    graphics.curveTo(cp.x, cp.y, cx, cy);
                }
                lx = cx;
                ly = cy;
                lt = ct;
            }
            graphics.curveTo(0, 0, 0, 0);
        }
        graphics.endFill();
        addEventListener(Event.ENTER_FRAME, enterFrame);
    }
    
    //コントロールポイントの計算
    private function getControlPoint(p1:Point, t1:Number, p2:Point, t2:Number):Point{
        var dif:Point = p2.subtract(p1);
        var l12:Number = Math.sqrt(dif.x*dif.x + dif.y*dif.y);
        var t12:Number = Math.atan2(dif.y, dif.x);
        var l13:Number = l12*Math.sin(t2 - t12)/Math.sin(t2 - t1);
        
        return new Point(p1.x+l13*Math.cos(t1), p1.y+l13*Math.sin(t1));
    }
    
    private function enterFrame(event:Event):void{
        rotation += 10;
    }
}