/**
 * Copyright milkmidi ( http://wonderfl.net/user/milkmidi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rskL
 */

/**
 * @author milkmidi
 * @see http://milkmidi.blogspot.com
 * @version 1.0.1
 * @date created 2010/06/08/
 */
package  {		
	import com.bit101.components.Label;
	import flash.display.DisplayObject;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import org.papervision3d.materials.WireframeMaterial;
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.objects.primitives.Plane;
	import org.papervision3d.view.BasicView;
	import org.papervision3d.view.layer.ViewportLayer;
	
	public class RendererDemo extends BasicView{		
		
		private var _planeArr:Vector.<Plane> = new Vector.<Plane>();
		private var _layer1:ViewportLayer;
		private var _layer2:ViewportLayer;
		private var _isRender:Boolean;
		public function RendererDemo()  {			
			new Label(this, 0, 0, "CLICK STAGE TO SWITCH RENDER");
			
			addEventListener(Event.ENTER_FRAME, _enterFrameHandler);
			
			
			var _d3d1:DisplayObject3D = _createContainer3D();
			_layer1 = viewport.getChildLayer( _d3d1 );
			scene.addChild(_d3d1);
			
			
			var _d3d2:DisplayObject3D = _createContainer3D();
			_layer2 = viewport.getChildLayer( _d3d2 );
			scene.addChild(_d3d2);
			
			stage.addEventListener(MouseEvent.MOUSE_DOWN , function ():void {
				_isRender = !_isRender;
			});
		}		
		private function _createContainer3D():DisplayObject3D {
			var _d3d:DisplayObject3D = new DisplayObject3D;			
			for (var i:int = 0; i < 10; i++) {
				var _wireMat:WireframeMaterial = new WireframeMaterial(Math.random() * 0xffffff);
				_wireMat.doubleSided = true;
				var _plane:Plane = new Plane(_wireMat, 200, 200);				
				_plane.x = Math.random() * 800 - 400;
				_plane.y = Math.random() * 800 - 400;
				_plane.x = Math.random() * 800 - 400;
				_d3d.addChild(_plane);
				_planeArr.push(_plane);
			}
			return _d3d;
		}		
		private function _enterFrameHandler(e:Event):void {			
			if (_isRender)
				renderer.renderLayers( scene, camera, viewport, [_layer1]);	
			else
				renderer.renderLayers( scene, camera, viewport, [_layer2]);
			
			for each (var p:Plane in _planeArr) {
				p.yaw(2);
			}
		}		
	}	
}