/**
 * Copyright arumajirou ( http://wonderfl.net/user/arumajirou )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rsPt
 */

// forked from arumajirou's BG test
package {
	import flash.text.TextFormat;
	import flash.text.TextField;
    import flash.display.Sprite;
    import flash.events.*;
    import flash.geom.*;

    	[SWF( backgroundColor="0x0", frameRate=60 )]

    public class FlashTest extends Sprite {

    		public static var tt : TextField = new TextField();
	    	private var apps : cApp = null;

        public function FlashTest() {
            // write as3 code here..
            var tf : TextFormat = new TextFormat();
            tf.color = 0xffffff;
//            FlashTest.tt.setTextFormat( tf );
			FlashTest.tt.defaultTextFormat = tf;
            FlashTest.tt.text = "test";
            parent.addChild( tt );
            graphics.clear();
    
			apps = new cApp( parent );
            parent.addEventListener( MouseEvent.MOUSE_MOVE, apps.mouseMove );
            parent.addEventListener( Event.ENTER_FRAME, apps.polling );
        }
    }
}

import flash.display.*;
import flash.events.*;
import flash.geom.*;
class cSubject
{
	private var observers : Vector.<iObserver>;

	public function cSubject()
	{
	 	observers = new Vector.<iObserver>();
	}

	public function attach( o : iObserver ) : void
	{
	 	observers.push( o );
	}

	public function dettach( o : iObserver ) : void
	{
	 	var result : int = observers.indexOf( o );
	 	if( result == -1 ) return;
	 	observers.splice( result, 1 );
	}

	public function notify( o : Object ) : void
	{
	 	var len : int = observers.length;
	 	
	 	for( var i : int = 0 ; i < len ; i++ )
	 	{
	 	 	observers[ i ].update( o );
	 	}
	}
}

interface iObserver
{
	function update( o : Object ) : void;
}

class cApp extends EventDispatcher
{
	private var _stage : DisplayObjectContainer = null;
	
    	private var tasks : cCharacterTask = null;
    	private var ref : cReferencePosition = null;
    	private var bg : cBg = null;
    	private var pp : cPlayerCharacter = null;
    	
    	public function cApp( s : DisplayObjectContainer = null )
    	{
    		_stage = new Sprite();
    		s.addChild( _stage );

        tasks = new cCharacterTask();
        ref = new cReferencePosition( new Rectangle( 0, 0, s.stage.stageWidth, s.stage.stageHeight ) );
		bg = new cBg( _stage );
		pp = new cPlayerCharacter( _stage, bg.getRegion() );
		pp.addEventListener( "EVENT_PLAYER", ref.update );
		pp.addEventListener( "EVENT_GENERATE", this.generateCharacter );

        tasks.addTask( bg, 0 );
        tasks.addTask( pp, 0 );
        tasks.addTask( new cPlayerCharacter(_stage, bg.getRegion(), new Vector3D(0, 0, 0, 1)), 1 );
    	}
    	public function mouseMove( e : MouseEvent ) : void
    	{
	        	var np : Vector3D = new Vector3D( _stage.stage.stageWidth / 2, _stage.stage.stageHeight / 2, 0, 1 );
		    var m : Vector3D = new Vector3D( e.stageX, e.stageY, 0, 1 );
		    var moves : Vector3D = m.subtract( np );
		    moves.normalize();
		    pp.update( moves );
    	}
    	public function generateCharacter( e : cGenerateEvent ) : void
    	{
    		(cBullet)(e.ta).addEventListener( "EVENT_BULLET", bulletEvent );
    		tasks.addTask( e.ta, 1 );
    	}
    	public function bulletEvent( e : cBulletEvent ) : void
    	{
    		tasks.removeTask( (iCharacter)(e.ta) );
    	}
    	public function polling( e : Event ) : void
    	{
		tasks.poll( ref );
    	}
}
class cGenerateEvent extends Event
{
	public var ta : iCharacter;
	
	public function cGenerateEvent( o : iCharacter )
	{
		super( "EVENT_GENERATE" );
		ta = o;
	}
}
class cPlayerEvent extends Event
{
	public var vec : Vector3D;
	
	public function cPlayerEvent( v : Vector3D = null )
	{
		super( "EVENT_PLAYER" );
		vec = v.clone();
	}
}
class cBulletEvent extends Event
{
	public var ta : Object;
	
	public function cBulletEvent( o : Object = null )
	{
		super( "EVENT_BULLET" );
		ta = o;
	}
}
class cCharacterTask
{
	static public const MAX_DEPTH : int = 3;
	private var list : Vector.<Vector.<iCharacter>>;
	private var removes : Vector.<iCharacter>;
	
	public function cCharacterTask()
	{
		list = new Vector.<Vector.<iCharacter>>( cCharacterTask.MAX_DEPTH );
		removes = new Vector.<iCharacter>();
		for( var i : int = 0 ; i < cCharacterTask.MAX_DEPTH ; i++ )
		{
			list[i] = ( new Vector.<iCharacter>() );
		}
	}
	public function addTask( t : iCharacter, depth : int ) : void
	{
		list[ depth ].push( t );
	}
	public function removeTask( t : iCharacter ) : void
	{
		removes.push( t );
	}
	public function poll( pos : cReferencePosition ) : void
	{
		for( var i : int = 0 ; i < cCharacterTask.MAX_DEPTH ; i++ )
		{
			var len : int = list[ i ].length;
			for( var j : int = 0 ; j < len ; j++ )
			{
				list[ i ][ j ].process();
			}
		}
		var v : Vector3D = pos.getter();
		for( i = 0 ; i < cCharacterTask.MAX_DEPTH ; i++ )
		{
			len = list[ i ].length;
			for( j = 0 ; j < len ; j++ )
			{
				list[ i ][ j ].draw( v );
			}
		}
		for each( var t : iCharacter in removes )
		{
			for( i = 0 ; i < cCharacterTask.MAX_DEPTH ; i++ )
			{
				var num : int = 0;
				if( ( num = list[ i ].indexOf( t ) ) != -1 )
				{
					list[ i ].splice( num, 1 );
				}
			}
		}
		removes.splice( 0, removes.length );
	}
}
class cReferencePosition
{
	private var displayArea : Rectangle;
	private var position : Vector3D;
	
	public function cReferencePosition( a : Rectangle = null )
	{
		displayArea = a;
		update( new cPlayerEvent( new Vector3D( 0,0,0,1 ) ) );
	}
	public function setter( v : Vector3D ) : void
	{
		position = v.clone();
	}
	public function getter() : Vector3D
	{
		return position.clone();
	}
	public function update( e : cPlayerEvent ) : Vector3D
	{
		return ( position = ( new Vector3D( displayArea.width / 2, displayArea.height / 2, 0, 1 ) ).subtract( e.vec ) );
	}
}

interface iCharacter
{
	function process() : void;
	function draw( v : Vector3D ) : void;
}

class cCharacter extends EventDispatcher implements iCharacter
{
	protected var _stage : DisplayObjectContainer = null;
	protected var _visual : Sprite = null;
	protected var _pos : Vector3D = null;
	public function cCharacter( d : DisplayObjectContainer = null )
	{
		_stage = d;
		_pos = new Vector3D( 0, 0, 0, 1 );
	}
	public function process() : void
	{
	}
	public function draw( v : Vector3D ) : void
	{
	}
}

class cBg extends cCharacter
{
	public static const W : int = 1024;
	public static const H : int = 1024;

	private var parts : Vector.<Sprite>;
	private var region : Rectangle;
	
	public function cBg( d : DisplayObjectContainer = null )
	{
		parts = new Vector.<Sprite>();
		region = new Rectangle( 0, 0, 1024, 1024 );
		_visual = new Sprite();
    		_visual.graphics.clear();
    		var temp : Sprite = new Sprite();
    		temp.graphics.lineStyle( 1, 0xffffffff );        		
    		for( var i : int = 0 ; i < 24 ; i++ )
    		{
    			temp.graphics.drawCircle( Math.random() * 128 , Math.random() * 128, 1 );
    		}
    		_visual.addChild( temp );
    		parts.push( temp );
    		var tempSprite : Sprite = null;
    		for( i = 1 ; i < 128 ; i++ )
    		{
    			tempSprite = new Sprite();
    			tempSprite.graphics.copyFrom( temp.graphics );
    			tempSprite.x = ( i % 5 ) * 128;
    			tempSprite.y = Math.floor( i / 5 ) * 128;
	    		parts.push( tempSprite );
	    		_visual.addChild( tempSprite );
    		}
    		d.addChild( _visual );
	}
	public override function draw( v : Vector3D ) : void
	{
		var p : Vector3D = new Vector3D( region.left, region.top, 0, 1 );
		p = p.add( v );
		_visual.x = ( p.x + region.width ) % 128 - 128;
		_visual.y = ( p.y + region.height ) % 128 - 128;
	}
	public function update( m : Vector3D ) : void
	{
	}
	public function getRegion() : Rectangle
	{
		return region.clone();
	}
}
class cMovableCharacter extends cCharacter
{
	protected var region : Rectangle = null;
	protected var _moves : Vector3D = null;
	protected var hostility : int = -1;
	protected var life : int = 0;
	
	public function cMovableCharacter( d : DisplayObjectContainer = null, r : Rectangle = null )
	{
		super(d);
		region = r;
	}
	public override function process() : void
	{
    		_pos = _pos.add( _moves );
    		_pos.x = ( _pos.x - region.left + region.width ) % region.width + region.left;
    		_pos.y = ( _pos.y - region.top + region.height ) % region.height + region.top;
	}
	public override function draw( v : Vector3D ) : void
	{
		_visual.x = ( _pos.x + v.x + 1024 ) % 1024;
		_visual.y = ( _pos.y + v.y + 1024 ) % 1024;
	}
}
class cControllableCharacter extends cMovableCharacter
{
//	protected var : iArm = null;

	public function cControllableCharacter( d : DisplayObjectContainer = null, r : Rectangle = null )
	{
		super( d, r );
	}
}
class cPlayerCharacter extends cControllableCharacter
{
	public function cPlayerCharacter( d : DisplayObjectContainer = null, r : Rectangle = null, p : Vector3D = null )
	{
		super( d, r );
		_visual = new Sprite();
		var g : Graphics = _visual.graphics;
    		g.clear();
    		g.lineStyle( 1, 0x0000ff );
    		g.beginFill( 0x0000ff );
		g.moveTo( 0, -10 );
		g.lineTo( 5, 10 );
		g.lineTo( -5, 10 );
   		g.endFill();
     		
    		d.addChild( _visual );
    		_visual.x = 232;
    		_visual.y = 232;
    		
    		if( p != null ) _pos = p;
    		_moves = new Vector3D( 0, 0, 0, 1 );
	}
	public function update( v : Vector3D ) : void
	{
		_moves = v.clone();
		_moves.normalize();
		
		var b : cBullet = new cBullet( _stage, _pos, _moves, region );
		dispatchEvent( new cGenerateEvent( b ) );
	}
	public override function process() : void
	{
		super.process();
		dispatchEvent( new cPlayerEvent( _pos ) );
		
	}
	public override function draw( v : Vector3D ) : void
	{
		super.draw( v );
		var np : Vector3D = new Vector3D( 0, -1, 0, 1 );
		var mp : Vector3D = _moves.clone();
		mp.normalize();
		_visual.rotation = Math.atan2( np.crossProduct( mp ).z, np.dotProduct( mp ) ) * 180 / Math.PI;
	}
}
class cBullet extends cMovableCharacter
{
	private var operatingLife : int = 0;
	
	public function cBullet( d : DisplayObjectContainer = null, p : Vector3D = null , v : Vector3D = null, r : Rectangle = null )
	{
		super( d, r );
		_visual = new Sprite();
		var g : Graphics = _visual.graphics;
    		g.clear();
    		g.lineStyle( 1, 0xffff00 );
    		g.beginFill( 0xff0000 );
		g.drawCircle( 0, 0, 2 );
   		g.endFill();

    		d.addChild( _visual );

    		_pos = p.clone();
    		_moves = v.clone();
    		_moves.scaleBy( 2 );
    		
    		operatingLife = 1000;
	}
	
	public override function process() : void
	{
		super.process();
		operatingLife--;
		if( operatingLife <= 0 )
		{
			evaporation();
		}
	}
	public function evaporation() : void
	{
		dispatchEvent( new cBulletEvent( this ) );
		_stage.removeChild( _visual );
	}
}
