/**
 * Copyright bkzen ( http://wonderfl.net/user/bkzen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rsL8
 */

// forked from bkzen's MoviePuzzleTest
package  
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.DisplayObject;
    import flash.display.Sprite;
    import flash.events.Event;
    
    /**
     * [企画]皆で動くパズル作ろうぜ
     * http://wonderfl.net/c/yb0z
     * 前から気になってた事があって、Wonderfl は色んな作品があるけど作品同士のつながりがないのが気になっていた。
     * 例えば、パーツだけ作って読み込んでロードするだけで使える[素材]を作るとか。
     * あと Fork することで何かに参加できるようにすればもっと面白い事になって行きそうなきがする。
     * チェックメイトやJAMのような方法ではなく、Forkされたもの全てが一つの作品を作るというか。
     * これからもチェックメイトやJAM以外にも[企画]タグや[素材]タグが増えていくといいなぁ。
     * @author jc at bk-zen.com
     */
    [SWF (backgroundColor = "0x000000", frameRate = "60", width = "465", height = "465")]
    public class MoviePuzzle extends Sprite 
    {
        private static const BG_COLOR: uint = 0x000000;
        private static const FRAME_RATE: uint = 30;
        private static const LEVEL: uint = 2;
        
        public function MoviePuzzle() 
        {
            // ローダーで読み込まれなかった時の為のデモ用
            addEventListener(Event.ADDED_TO_STAGE, demo);
        }
        
        /**
         * 
         * MoviePuzzle -> MovieJigsawPuzzle
         *         obj["disp"]      : DisplayObject : 描画対象このオブジェクトの440x440の範囲で切り取られて描画されます。
         *         obj["color"]     : uint : 背景色(省略時は0x000000)
         *         obj["frameRate"] : uint : フレームレート(省略時は60)
         *         obj["level"]     : uint : 上限レベル(省略時は1)
         * @param    obj : <Object>
         */
        public function initialize(obj: Object): void
        {
            disp = new MooPuzzle();
            obj["disp"]  = disp;
            obj["color"] = BG_COLOR;
            obj["frameRate"]  = FRAME_RATE;
            obj["level"] = LEVEL;
        }
        
        /**
         * スタートする時に呼ばれます。
         * @param    level : uint : 指定レベル : 変える必要があれば。
         */
        public function start(level: uint): void
        {
            Object(disp).start(level);
        }
        
        /**
         * 終了した時に呼ばれます。
         */
        public function end(): void
        {
            Object(disp).end();
        }
        
        private var disp: DisplayObject;
        
        /**
         * デモ用
         * @param    e
         */
        private function demo(e: Event): void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, demo);
            //
            var obj: Object = {};
            initialize(obj);
            disp = obj["disp"];
            var col: uint = obj["color"];
            var bmd: BitmapData = new BitmapData(440, 440, false, col);
            var bmp: Bitmap = new Bitmap(bmd, "auto", true);
            start(2);
            addChild(bmp);
            addEventListener(Event.ENTER_FRAME, function(e: Event): void {
                bmd.lock();
                bmd.fillRect(bmd.rect, col);
                bmd.draw(disp);
                bmd.unlock();
            } );
        }
    }
}
import com.bit101.components.PushButton;
import flash.display.Sprite
import flash.events.Event;

/**
 * ベーシックな15パズル
 */
class MooPuzzle extends Sprite
{
    private var _level: uint;
    private var isStart: Boolean;
    private var btns: Array = [];
    private var cnt: int;
    function MooPuzzle() { }
    
    public function start(level: uint): void
    {
        if (isStart) return;
        isStart = true;
        _level = level;
        var i: int, n: int = 16;
        switch (_level)
        {
            case 1:
                for (i = 0; i < n; i++) 
                {
                    var btn: PushButton = new PushButton(this, (i % 4) * 110, (i / 4 | 0) * 110, "" + i);
                    btn.setSize(110, 110);
                    btns[i] = btn;
                }
            break;
            case 2:
                for (i = 0; i < n; i++) 
                {
                    btn = new PushButton(this, (i % 4) * 110, (i / 4 | 0) * 110, "" + i);
                    btn.setSize(110, 110);
                    btns[i] = btn;
                }
                cnt = 0;
                addEventListener(Event.ENTER_FRAME, loop);
            break;
        }
    }
    
    private function loop(e: Event): void 
    {
        cnt++;
        if (cnt % 300 == 0)
        {
            var i: int = 0, n: int = 16;
            for (i = 0; i < n; i++) 
            {
                var btn: PushButton = btns[i];
                if (cnt % 600) btn.move((i / 4 | 0) * 110, (i % 4) * 110);
                else btn.move((i % 4) * 110, (i / 4 | 0) * 110);
            }
        }
    }
    
    public function end(): void
    {
        while (numChildren > 0) removeChildAt(0);
        btns = [];
        isStart = false;
        removeEventListener(Event.ENTER_FRAME, loop);
    }
}