/**
 * Copyright fra978 ( http://wonderfl.net/user/fra978 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rrqK
 */

package
{
    import flash.display.*;
    import flash.events.*;
    import flash.media.*;
    import flash.text.TextField;

    public class DynamicSound extends Sprite
    {
        private var sound:Sound;
        private var noise:Number = 0;
        private var tracer:TextField;
        
        public function DynamicSound():void
        {
           // setTracer ();
            sound = new Sound();
            sound.addEventListener(SampleDataEvent.SAMPLE_DATA, sineWave3);
            sound.play();
        }
        
        private function setTracer ():void
        {
            tracer.background = true;
            tracer.backgroundColor = 0x000000;
        }

        
        private function onCallback(evt:SampleDataEvent):void
        {
            for(var i:int=0; i<8192; i++)
            {
                noise += (mouseX * mouseY) / 44100;
                
                var sample:Number = noise * Math.PI * 2;
                evt.data.writeFloat(Math.sin(sample));
                evt.data.writeFloat(Math.sin(sample));
                
                
            }
        }
        private function sineWave3(event:SampleDataEvent):void 
        {
            const AMP_MULTIPLIER:Number = .5//(mouseY / 100);//0.15;
            const BASE_FREQ:int = (mouseX); // pure A = 440
            const SAMPLING_RATE:int = 44100;
            const TWO_PI:Number = 2*Math.PI;
            const TWO_PI_OVER_SR:Number = TWO_PI/SAMPLING_RATE;

            var sample:Number;
            
            for (var i:int=0; i<8192; i++) 
            {
                sample = Math.sin((i+event.position) * TWO_PI_OVER_SR * BASE_FREQ);
                
                event.data.writeFloat(sample * AMP_MULTIPLIER);
                event.data.writeFloat(sample * AMP_MULTIPLIER);
            }
            tracer.text = ("BASE FREQ: " + BASE_FREQ + "\nAMP MULTIPLIER: " + AMP_MULTIPLIER + "\nSAMPLING RATE: "+SAMPLING_RATE);
        }

    } // endclass
}

