/**
 * Copyright akkey.guitar ( http://wonderfl.net/user/akkey.guitar )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rqzo
 */

// forked from ProjectNya's TransitPhoto [Flickr]
////////////////////////////////////////////////////////////////////////////////
// [AS3.0] TransitPhotoクラスだ！ (3)
// http://www.project-nya.jp/modules/weblog/details.php?blog_id=1027
////////////////////////////////////////////////////////////////////////////////
/*
トランジションの種類

fade                : フェード(アルファ変化)
brightness    : 明度変化
block [1]        : ブロック(左上から右下へ)
block [2]        : ブロック(左下から右上へ)
block [3]        : ブロック(右上から左下へ)
block [4]        : ブロック(右下から左上へ)
blind [x]        : ブラインド(左から右へ)
blind [y]        : ブラインド(上から下へ)
circle            : 円(左上から右下へ)
tile                : タイル(渦巻き状)
noise            : ピクセルディゾルブ
perlin noise    : 破けるような燃えるような変化
*/

package {

    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Rectangle;

    [SWF(backgroundColor="#FFFFFF", width="465", height="465", frameRate="30")]

    public class Main extends Sprite {
        private var provider:DataProvider;
        private var transit:TransitPhoto;
        private var itemList:Array;
        private var transitList:Array;
        private var photo:Label;
        private var txt:Label;

        public function Main() {
            Wonderfl.capture_delay(6);
            init();
        }

        private function init():void {
            createTitle();
            transit = new TransitPhoto();
            addChild(transit);
            transit.x = 32;
            transit.y = 32;
            //
            provider = new DataProvider();
            provider.addEventListener(DataProvider.COMPLETE, complete, false, 0, true);
            provider.search("landscape", 20);
            //
            var fade:Fade = new Fade();
            var brightness:Brightness = new Brightness();
            var block1:Block = new Block("++", 40, 40, 10, 10);
            block1.transitName = "block [1]";
            var block2:Block = new Block("+-", 40, 40, 10, 10);
            block2.transitName = "block [2]";
            var block3:Block = new Block("-+", 40, 40, 10, 10);
            block3.transitName = "block [3]";
            var block4:Block = new Block("--", 40, 40, 10, 10);
            block4.transitName = "block [4]";
            var blindX:Blind = new Blind("x", 20, 400, 20, 1);
            blindX.transitName = "blind [x]";
            var blindY:Blind = new Blind("y", 400, 20, 1, 20);
            blindY.transitName = "blind [y]";
            var circle:Circle = new Circle("++", 30, 40, 40, 10, 10);
            circle.transitName = "circle";
            //
            var rect:Rectangle = new Rectangle(0, 0, 400, 400);
            var tile:BitmapTile = new BitmapTile(rect, 20);
            var thresholdTile:TransitThreshold = new TransitThreshold(tile);
            thresholdTile.transitName = "tile";
            var noise:Noise = new Noise(rect, 0);
            var thresholdNoise:TransitThreshold = new TransitThreshold(noise);
            thresholdNoise.transitName = "noise";
            var perlinNoise:PerlinNoise = new PerlinNoise(rect, 40, 4, 0);
            var thresholdPerlinNoise:TransitThreshold = new TransitThreshold(perlinNoise);
            thresholdPerlinNoise.transitName = "perlin noise";
            //
            transitList = new Array();
            transitList.push(fade);
            transitList.push(brightness);
            transitList.push(block1);
            transitList.push(block2);
            transitList.push(block3);
            transitList.push(block4);
            transitList.push(blindX);
            transitList.push(blindY);
            transitList.push(circle);
            transitList.push(thresholdTile);
            transitList.push(thresholdNoise);
            transitList.push(thresholdPerlinNoise);
            transitList = ArrayUtils.shuffle(transitList);
            //
            transit.label(photo, txt);
        }
        private function complete(evt:Event):void {
            var data:Object = evt.target.data;
            transit.dataProvider = data.p;
            transit.transitType(transitList);
        }
        private function createTitle():void {
            var title:Label = new Label(150);
            addChild(title);
            title.x = 305;
            title.y = 8;
            title.textColor = 0x333333;
            title.text = "[AS3.0] TransitPhoto";
            var order:Label = new Label(120);
            addChild(order);
            order.x = 35;
            order.y = 438;
            order.textColor = 0x333333;
            order.text = "photo";
            var type:Label = new Label(120);
            addChild(type);
            type.x = 155;
            type.y = 438;
            type.textColor = 0x333333;
            type.text = "transit";
            photo = new Label(60);
            addChild(photo);
            photo.x = 85;
            photo.y = 438;
            photo.textColor = 0x000000;
            txt = new Label(80);
            addChild(txt);
            txt.x = 210;
            txt.y = 438;
            txt.textColor = 0x000000;
        }

    }

}


//////////////////////////////////////////////////
// DataProviderクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.system.Security;
import flash.events.Event;

class DataProvider extends Sprite {
    private var loader:TextLoader;
    private var dataXML:XML;
    public var data:Object;
    private var sList:Array;
    private var tList:Array;
    private var mList:Array;
    private var pList:Array;
    private var oList:Array;
    private var iList:Array;
    private static var reqURL:String = "http://api.flickr.com/services/rest/";
    private static var method:String = "method=flickr.photos.search";
    private static var key:String = "7a4e79f1dbe398cd714ecd6dbe6a9cbb";
    private var flickrURL:String;
    public static const COMPLETE:String = Event.COMPLETE;
    public static const ERROR:String = "error";

    public function DataProvider() {
        Security.loadPolicyFile("http://api.flickr.com/crossdomain.xml");
        Security.loadPolicyFile("http://farm1.static.flickr.com/crossdomain.xml");
        Security.loadPolicyFile("http://farm2.static.flickr.com/crossdomain.xml");
        Security.loadPolicyFile("http://farm3.static.flickr.com/crossdomain.xml");
        Security.loadPolicyFile("http://farm4.static.flickr.com/crossdomain.xml");
        Security.loadPolicyFile("http://farm5.static.flickr.com/crossdomain.xml");
        init();
    }

    private function init():void {
        sList = new Array();
        tList = new Array();
        mList = new Array();
        pList = new Array();
        oList = new Array();
        iList = new Array();
        loader = new TextLoader();
        loader.addEventListener(TextLoader.COMPLETE, complete, false, 0, true);
    }
    public function search(tags:String, n:uint):void {
        var option:String = "&license=1,2,3,4,5,6&sort=interestingness-desc&per_page=" + n;
        flickrURL = reqURL + "?" + method +"&api_key=" + key + "&tags=" + tags + option;
        try {
            loader.load(flickrURL);
        } catch (err:Error) {
            dispatchEvent(new Event(DataProvider.ERROR));
        }
    }
    private function complete(evt:Event):void {
        var xml:XML = new XML(evt.target.data);
        xml.ignoreWhite = true;
        for (var n:uint = 0; n < xml.photos.photo.length(); n++) {
            var element:XML = xml.photos.photo[n];
            var farm:String = element.@farm;
            var server:String = element.@server;
            var id:String = element.@id;
            var secret:String = element.@secret;
            var title:String = element.@title;
            var owner:String = element.@owner;
            var basePath:String = "http://farm" + farm + ".static.flickr.com/" + server +"/" + id + "_" + secret;
            sList[n] = basePath + "_s.jpg";
            tList[n] = basePath + "_t.jpg";
            mList[n] = basePath + "_m.jpg";
            pList[n] = basePath + ".jpg";
            oList[n] = basePath + "_o.jpg";
            iList[n] = {title: title, owner: owner};
        }
        data = {s: sList, t: tList, m: mList, p: pList, o: oList, i:iList};
        dispatchEvent(new Event(DataProvider.COMPLETE));
    }

}


//////////////////////////////////////////////////
// TextLoaderクラス
//////////////////////////////////////////////////

import flash.events.EventDispatcher;
import flash.net.URLLoader;
import flash.net.URLLoaderDataFormat;
import flash.net.URLRequest;
import flash.events.Event;
import flash.events.IOErrorEvent;
import flash.events.HTTPStatusEvent;
import flash.events.SecurityErrorEvent;

class TextLoader extends EventDispatcher {
    private var loader:URLLoader;
    private var _data:*;
    public static const TEXT:String = URLLoaderDataFormat.TEXT;
    public static const BINARY:String = URLLoaderDataFormat.BINARY;
    public static const COMPLETE:String = "complete";

    public function TextLoader() {
        loader = new URLLoader();
    }

    public function load(file:String, format:String = TextLoader.TEXT):void {
        loader.dataFormat = format;
        loader.addEventListener(IOErrorEvent.IO_ERROR, ioerror, false, 0, true);
        loader.addEventListener(HTTPStatusEvent.HTTP_STATUS, httpstatus, false, 0, true);
        loader.addEventListener(SecurityErrorEvent.SECURITY_ERROR, securityerror, false, 0, true);
        loader.addEventListener(Event.COMPLETE, complete, false, 0, true);
        try {
            loader.load(new URLRequest(file));
        } catch (err:Error) {
            trace(err.message);
        }
    }
    private function ioerror(evt:IOErrorEvent):void {
        trace(evt.text);
    }
    private function httpstatus(evt:HTTPStatusEvent):void {
        trace(evt.status);
    }
    private function securityerror(evt:SecurityErrorEvent):void {
        trace(evt.text);
    }
    private function complete(evt:Event):void {
        loader.removeEventListener(IOErrorEvent.IO_ERROR, ioerror);
        loader.removeEventListener(HTTPStatusEvent.HTTP_STATUS, httpstatus);
        loader.removeEventListener(SecurityErrorEvent.SECURITY_ERROR, securityerror);
        loader.removeEventListener(Event.COMPLETE, complete);
        _data = evt.target.data;
        dispatchEvent(new Event(TextLoader.COMPLETE));
    }
    public function get data():* {
        return _data;
    }

}


//////////////////////////////////////////////////
// TransitPhotoクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.events.Event;
import flash.utils.Timer;
import flash.events.TimerEvent;

class TransitPhoto extends Sprite {
    private var loaderList:Array;
    private var photoList:Array;
    private var max:uint;
    private var transitList:Array;
    private var transitID:uint = 0;
    private var hideID:uint = 0;
    private var showID:uint = 0;
    private var timer:Timer;
    public var interval:uint = 2;
    private var transit:*;
    public static const COMPLETE:String = "transitComplete";
    private var photo:Label;
    private var txt:Label;

    public function TransitPhoto() {
    }

    public function set dataProvider(list:Array):void {
        photoList = list;
        max = photoList.length;
        initialize();
    }
    public function transitType(list:Array):void {
        reset();
        transitList = list;
        exchangeTransit();
        load(showID);
    }
    private function initialize():void {
        loaderList = new Array();
        for (var n:uint = 0; n < max; n++) {
            var loader:PhotoLoader = new PhotoLoader();
            loaderList.push(loader);
            loader.addEventListener(PhotoLoader.INIT, loadInit, false, 0, true);
        }
    }
    private function reset():void {
        if (transit) {
            transit.reset();
            transit.removeEventListener(TransitPhoto.COMPLETE, setInterval);
        }
        if (timer) {
            timer.removeEventListener(TimerEvent.TIMER_COMPLETE, transitPhoto);
            timer.stop();
        }
        transitID = 0;
        var hide:PhotoLoader = loaderList[hideID];
        var show:PhotoLoader = loaderList[showID];
        if (contains(hide)) removeChild(hide);
        if (contains(show)) removeChild(show);
        hideID = 0;
        showID = 0;
    }
    private function load(id:uint):void {
        var loader:PhotoLoader = loaderList[id];
        var filePath:String = photoList[id];
        loader.load(filePath, true);
    }
    private function loadInit(evt:Event):void {
        var hide:PhotoLoader = loaderList[hideID];
        var show:PhotoLoader = loaderList[showID];
        if (hide) addChild(hide);
        addChild(show);
        transitEffect();
    }
    private function transitEffect():void {
        var show:PhotoLoader = loaderList[showID];
        transit.effect(show);
        transit.addEventListener(TransitPhoto.COMPLETE, setInterval, false, 0, true);
    }
    private function setInterval(evt:Event):void {
        transit.removeEventListener(TransitPhoto.COMPLETE, setInterval);
        timer = new Timer(1000*interval, 1);
        timer.addEventListener(TimerEvent.TIMER_COMPLETE, transitPhoto, false, 0, true);
        timer.start();
    }
    private function transitPhoto(evt:TimerEvent):void {
        timer.removeEventListener(TimerEvent.TIMER_COMPLETE, transitPhoto);
        var hide:PhotoLoader = loaderList[hideID];
        if (hideID != showID) removeChild(hide);
        hideID = showID;
        showID ++;
        if (showID >= max) showID = 0;
        exchangeTransit();
        load(showID);
    }
    private function exchangeTransit():void {
        var id:uint = transitID%transitList.length;
        transit = transitList[id];
        photo.text = "[" + (hideID+1) + "-" + (showID+1) + "] ";
        txt.text = transit.transitName;
        transitID ++;
    }
    public function label(p:Label, t:Label):void {
        photo = p;
        txt = t;
    }

}


//////////////////////////////////////////////////
// PhotoLoaderクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Loader;
import flash.display.LoaderInfo;
import flash.net.URLRequest;
import flash.display.Bitmap;
import flash.events.Event;
import flash.events.IOErrorEvent;
import flash.events.HTTPStatusEvent;
import flash.events.SecurityErrorEvent;
import flash.system.LoaderContext;

class PhotoLoader extends Sprite {
    private var loader:Loader;
    private var info:LoaderInfo;
    public var content:*;
    private var smoothing:Boolean;
    public static const IO_ERROR:String = IOErrorEvent.IO_ERROR;
    public static const HTTP_STATUS:String = HTTPStatusEvent.HTTP_STATUS;
    public static const SECURITY_ERROR:String = SecurityErrorEvent.SECURITY_ERROR;
    public static const INIT:String = Event.INIT;
    public static const COMPLETE:String = Event.COMPLETE;

    public function PhotoLoader() {
        loader = new Loader();
        info = loader.contentLoaderInfo;
    }

    public function load(file:String, s:Boolean = false):void {
        smoothing = s;
        info.addEventListener(IOErrorEvent.IO_ERROR, ioerror, false, 0, true);
        info.addEventListener(HTTPStatusEvent.HTTP_STATUS, httpstatus, false, 0, true);
        info.addEventListener(SecurityErrorEvent.SECURITY_ERROR, securityerror, false, 0, true);
        info.addEventListener(Event.INIT, initialize, false, 0, true);
        info.addEventListener(Event.COMPLETE, complete, false, 0, true);
        try {
            loader.load(new URLRequest(file), new LoaderContext(true));
        } catch (err:Error) {
            trace(err.message);
        }
    }
    public function unload():void {
        loader.unload();
    }
    private function ioerror(evt:IOErrorEvent):void {
        loader.unload();
        dispatchEvent(new Event(PhotoLoader.IO_ERROR));
    }
    private function httpstatus(evt:HTTPStatusEvent):void {
        dispatchEvent(new Event(PhotoLoader.HTTP_STATUS));
    }
    private function securityerror(evt:SecurityErrorEvent):void {
        dispatchEvent(new Event(PhotoLoader.SECURITY_ERROR));
    }
    private function initialize(evt:Event):void {
        if (smoothing) {
            content = Bitmap(info.content);
            content.smoothing = true;
        } else {
            content = info.content;
        }
        dispatchEvent(new Event(PhotoLoader.INIT));
    }
    private function complete(evt:Event):void {
        info.removeEventListener(IOErrorEvent.IO_ERROR, ioerror);
        info.removeEventListener(HTTPStatusEvent.HTTP_STATUS, httpstatus);
        info.removeEventListener(SecurityErrorEvent.SECURITY_ERROR, securityerror);
        info.removeEventListener(Event.INIT, initialize);
        info.removeEventListener(Event.COMPLETE, complete);
        loader.width = loader.height = 400;
        addChild(loader);
        dispatchEvent(new Event(PhotoLoader.COMPLETE));
    }
    public function centerize():void {
        content.x = -uint(content.width*0.5);
        content.y = -uint(content.height*0.5);
    }

}


//////////////////////////////////////////////////
// transitionsクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.events.Event;

class Fade extends Sprite {
    public static var className:String = "Fade";
    public var transitName:String = "fade";
    private var loader:PhotoLoader;
    private static var speed:Number = 0.05;
    public static const COMPLETE:String = "complete";

    public function Fade() {
    }

    public function effect(target:PhotoLoader):void {
        loader = target;
        loader.alpha = 0;
        addEventListener(Event.ENTER_FRAME, transit, false, 0, true);
    }
    private function transit(evt:Event):void {
        loader.alpha += speed;
        if (loader.alpha >= 1) {
            loader.alpha = 1;
            removeEventListener(Event.ENTER_FRAME, transit);
            dispatchEvent(new Event(TransitPhoto.COMPLETE));
        }
    }
    public function reset():void {
        if (loader) {
            loader.alpha = 1;
        }
    }

}


import flash.display.Sprite;
import flash.events.Event;

class Brightness extends Sprite {
    public static var className:String = "Brightness";
    public var transitName:String = "brightness";
    private var loader:PhotoLoader;
    private var _brightOffset:Number = 0;
    private static var speed:Number = 5;
    public static const COMPLETE:String = "complete";

    public function Brightness() {
    }

    public function effect(target:PhotoLoader):void {
        loader = target;
        brightOffset = 100;
        addEventListener(Event.ENTER_FRAME, transit, false, 0, true);
    }
    private function transit(evt:Event):void {
        brightOffset -= speed;
        if (brightOffset <= 0) {
            brightOffset = 0;
            removeEventListener(Event.ENTER_FRAME, transit);
            dispatchEvent(new Event(TransitPhoto.COMPLETE));
        }
    }
    public function get brightOffset():Number {
        return _brightOffset;
    }
    public function set brightOffset(param:Number):void {
        _brightOffset = param;
        ColorManager.brightOffset(loader, _brightOffset);
    }
    public function reset():void {
        if (loader) {
            brightOffset = 0;
        }
    }

}


import flash.display.Sprite;
import flash.events.Event;

class Block extends Sprite {
    public static var className:String = "Block";
    public var transitName:String = "block";
    private var loader:PhotoLoader;
    private var type:String;
    private var mWidth:uint;
    private var mHeight:uint;
    private var cols:uint;
    private var rows:uint;
    private var blocks:Sprite;
    private var blockList:Array;
    private var completed:uint = 0;
    public static const COMPLETE:String = "complete";

    public function Block(t:String, w:uint, h:uint, c:uint, r:uint) {
        type = t;
        mWidth = w;
        mHeight = h;
        cols = c;
        rows = r;
        init();
    }

    private function init():void {
        if (!blocks) {
            blocks = new Sprite();
            blockList = new Array();
            createBlocks();
        }
    }
    public function effect(target:PhotoLoader):void {
        loader = target;
        loader.addChild(blocks);
        loader.mask = blocks;
        transit()
    }
    private function transit():void {
        for (var n:uint = 0; n < rows*cols; n++) {
            var block:BlockMask = blockList[n];
            block.effect();
            block.addEventListener(Block.COMPLETE, complete, false, 0, true);
        }
    }
    private function complete(evt:Event):void {
        evt.target.removeEventListener(Block.COMPLETE, complete);
        completed ++;
        if (completed >= rows*cols) {
            reset();
            dispatchEvent(new Event(TransitPhoto.COMPLETE));
        }
    }
    private function createBlocks():void {
        for (var r:uint = 0; r < rows; r++) {
            for (var c:uint = 0; c < cols; c++) {
                var xPos:uint;
                var yPos:uint;
                switch (type) {
                    case "++" :
                        xPos = mWidth/2 + mWidth*(c%cols);
                        yPos = mHeight/2 + mHeight*r;
                        break;
                    case "+-" :
                        xPos = mWidth/2 + mWidth*(c%cols);
                        yPos = mHeight/2 + mHeight*(rows - r - 1);
                        break;
                    case "-+" :
                        xPos = mWidth/2 + mWidth*((cols - c - 1)%cols);
                        yPos = mHeight/2 + mHeight*r;
                        break;
                    case "--" :
                        xPos = mWidth/2 + mWidth*((cols - c - 1)%cols);
                        yPos = mHeight/2 + mHeight*(rows - r - 1);
                        break;
                }
                var block:BlockMask = new BlockMask(mWidth, mHeight);
                blockList.push(block);
                block.x = xPos;
                block.y = yPos;
                block.generation = r + c;
                blocks.addChild(block);
            }
        }
    }
    public function reset():void {
        if (loader) {
            if (loader.contains(blocks)) {
                loader.removeChild(blocks);
                loader.mask = null;
            }
        }
        close();
    }
    private function close():void {
        for (var n:uint = 0; n < rows*cols; n++) {
            var block:BlockMask = blockList[n];
            block.close();
            block.removeEventListener(Block.COMPLETE, complete);
        }
        completed = 0;
    }

}


import flash.display.Sprite;
import flash.events.Event;
import flash.utils.Timer;
import flash.events.TimerEvent;

class BlockMask extends Sprite {
    public var generation:uint;
    private var mWidth:uint;
    private var mHeight:uint;
    private var _scale:Number = 1;
    private var timer:Timer;
    private static var deceleration:Number = 0.4;
    public static const COMPLETE:String = "complete";

    public function BlockMask(w:uint, h:uint) {
        mWidth = w;
        mHeight = h;
        init();
    }

    private function init():void {
        graphics.beginFill(0x000000);
        graphics.drawRect(-mWidth/2, -mHeight/2, mWidth, mHeight);
        graphics.endFill();
    }
    public function effect():void {
        scale = 0;
        var offset:uint = 300*(generation + 1);
        timer = new Timer(offset, 1);
        timer.addEventListener(TimerEvent.TIMER_COMPLETE, open, false, 0, true);
        timer.start();
    }
    private function open(evt:TimerEvent):void {
        timer.removeEventListener(TimerEvent.TIMER_COMPLETE, open);
        addEventListener(Event.ENTER_FRAME, transit, false, 0, true);
    }
    private function transit(evt:Event):void {
        scale += (1- scale)*deceleration;
        if (Math.abs(1 - scale) < 0.005) {
            scale = 1;
            removeEventListener(Event.ENTER_FRAME, transit);
            dispatchEvent(new Event(BlockMask.COMPLETE));
        }
    }
    public function get scale():Number {
        return _scale;
    }
    public function set scale(param:Number):void {
        _scale = param;
        scaleX = scaleY = _scale;
    }
    public function close():void {
        scale = 0;
        timer.removeEventListener(TimerEvent.TIMER_COMPLETE, open);
        timer.stop();
        removeEventListener(Event.ENTER_FRAME, transit);
    }

}


import flash.display.Sprite;
import flash.events.Event;

class Blind extends Sprite {
    public static var className:String = "Blind";
    public var transitName:String = "blind";
    private var loader:PhotoLoader;
    private var type:String;
    private var mWidth:uint;
    private var mHeight:uint;
    private var cols:uint;
    private var rows:uint;
    private var blinds:Sprite;
    private var blindList:Array;
    private var completed:uint = 0;
    public static const COMPLETE:String = "complete";

    public function Blind(t:String, w:uint, h:uint, c:uint, r:uint) {
        type = t;
        mWidth = w;
        mHeight = h;
        cols = c;
        rows = r;
        init();
    }

    private function init():void {
        if (!blinds) {
            blinds = new Sprite();
            blindList = new Array();
            createBlinds();
        }
    }
    public function effect(target:PhotoLoader):void {
        loader = target;
        loader.addChild(blinds);
        loader.mask = blinds;
        transit()
    }
    private function transit():void {
        for (var n:uint = 0; n < rows*cols; n++) {
            var blind:BlindMask = blindList[n];
            blind.effect();
            blind.addEventListener(Blind.COMPLETE, complete, false, 0, true);
        }
    }
    private function complete(evt:Event):void {
        evt.target.removeEventListener(Blind.COMPLETE, complete);
        completed ++;
        if (completed >= rows*cols) {
            reset();
            dispatchEvent(new Event(TransitPhoto.COMPLETE));
        }
    }
    private function createBlinds():void {
        for (var r:uint = 0; r < rows; r++) {
            for (var c:uint = 0; c < cols; c++) {
                var xPos:uint = mWidth/2 + mWidth*(c%cols);
                var yPos:uint = mHeight/2 + mHeight*r;
                var blind:BlindMask = new BlindMask(type, mWidth, mHeight);
                blindList.push(blind);
                blind.x = xPos;
                blind.y = yPos;
                blind.generation = r + c;
                blinds.addChild(blind);
            }
        }
    }
    public function reset():void {
        if (loader) {
            if (loader.contains(blinds)) {
                loader.removeChild(blinds);
                loader.mask = null;
            }
        }
        close();
    }
    private function close():void {
        for (var n:uint = 0; n < rows*cols; n++) {
            var blind:BlindMask = blindList[n];
            blind.close();
            blind.removeEventListener(Blind.COMPLETE, complete);
        }
        completed = 0;
    }

}


import flash.display.Sprite;
import flash.events.Event;
import flash.utils.Timer;
import flash.events.TimerEvent;

class BlindMask extends Sprite {
    public var generation:uint;
    private var type:String;
    private var mWidth:uint;
    private var mHeight:uint;
    private var _scale:Number = 1;
    private var timer:Timer;
    private static var deceleration:Number = 0.4;
    public static const COMPLETE:String = "complete";

    public function BlindMask(t:String, w:uint, h:uint) {
        type = t;
        mWidth = w;
        mHeight = h;
        init();
    }

    private function init():void {
        graphics.beginFill(0x000000);
        graphics.drawRect(-mWidth/2, -mHeight/2, mWidth, mHeight);
        graphics.endFill();
    }
    public function effect():void {
        scale = 0;
        var offset:uint = 300*(generation + 1);
        timer = new Timer(offset, 1);
        timer.addEventListener(TimerEvent.TIMER_COMPLETE, open, false, 0, true);
        timer.start();
    }
    private function open(evt:TimerEvent):void {
        timer.removeEventListener(TimerEvent.TIMER_COMPLETE, open);
        addEventListener(Event.ENTER_FRAME, transit, false, 0, true);
    }
    private function transit(evt:Event):void {
        scale += (1- scale)*deceleration;
        if (Math.abs(1 - scale) < 0.005) {
            scale = 1;
            removeEventListener(Event.ENTER_FRAME, transit);
            dispatchEvent(new Event(BlindMask.COMPLETE));
        }
    }
    public function close():void {
        scale = 0;
        timer.removeEventListener(TimerEvent.TIMER_COMPLETE, open);
        timer.stop();
        removeEventListener(Event.ENTER_FRAME, transit);
    }
    public function get scale():Number {
        return _scale;
    }
    public function set scale(param:Number):void {
        _scale = param;
        switch (type) {
            case "x" :
                scaleX = _scale;
                break;
            case "y" :
                scaleY = _scale;
                break;
        }
    }

}


import flash.display.Sprite;
import flash.events.Event;

class Circle extends Sprite {
    public static var className:String = "Circle";
    public var transitName:String = "circle";
    private var loader:PhotoLoader;
    private var type:String;
    private var radius:uint;
    private var mWidth:uint;
    private var mHeight:uint;
    private var cols:uint;
    private var rows:uint;
    private var circles:Sprite;
    private var circleList:Array;
    private var completed:uint = 0;
    public static const COMPLETE:String = "complete";

    public function Circle(t:String, rd:uint, w:uint, h:uint, c:uint, r:uint) {
        type = t;
        radius = rd;
        mWidth = w;
        mHeight = h;
        cols = c;
        rows = r;
        init();
    }

    private function init():void {
        if (!circles) {
            circles = new Sprite();
            circleList = new Array();
            createCircles();
        }
    }
    public function effect(target:PhotoLoader):void {
        loader = target;
        loader.addChild(circles);
        loader.mask = circles;
        transit()
    }
    private function transit():void {
        for (var n:uint = 0; n < rows*cols; n++) {
            var circle:CircleMask = circleList[n];
            circle.effect();
            circle.addEventListener(Circle.COMPLETE, complete, false, 0, true);
        }
    }
    private function complete(evt:Event):void {
        evt.target.removeEventListener(Circle.COMPLETE, complete);
        completed ++;
        if (completed >= rows*cols) {
            reset();
            dispatchEvent(new Event(TransitPhoto.COMPLETE));
        }
    }
    private function createCircles():void {
        for (var r:uint = 0; r < rows; r++) {
            for (var c:uint = 0; c < cols; c++) {
                var xPos:uint;
                var yPos:uint;
                switch (type) {
                    case "++" :
                        xPos = mWidth/2 + mWidth*(c%cols);
                        yPos = mHeight/2 + mHeight*r;
                        break;
                    case "+-" :
                        xPos = mWidth/2 + mWidth*(c%cols);
                        yPos = mHeight/2 + mHeight*(rows - r - 1);
                        break;
                    case "-+" :
                        xPos = mWidth/2 + mWidth*((cols - c - 1)%cols);
                        yPos = mHeight/2 + mHeight*r;
                        break;
                    case "--" :
                        xPos = mWidth/2 + mWidth*((cols - c - 1)%cols);
                        yPos = mHeight/2 + mHeight*(rows - r - 1);
                        break;
                }
                var circle:CircleMask = new CircleMask(radius);
                circleList.push(circle);
                circle.x = xPos;
                circle.y = yPos;
                circle.generation = r + c;
                circles.addChild(circle);
            }
        }
    }
    public function reset():void {
        if (loader) {
            if (loader.contains(circles)) {
                loader.removeChild(circles);
                loader.mask = null;
            }
        }
        close();
    }
    private function close():void {
        for (var n:uint = 0; n < rows*cols; n++) {
            var circle:CircleMask = circleList[n];
            circle.close();
            circle.removeEventListener(Circle.COMPLETE, complete);
        }
        completed = 0;
    }

}


import flash.display.Sprite;
import flash.events.Event;
import flash.utils.Timer;
import flash.events.TimerEvent;

class CircleMask extends Sprite {
    public var generation:uint;
    private var radius:uint;
    private var _scale:Number = 1;
    private var timer:Timer;
    private static var speed:Number = 0.05;
    public static const COMPLETE:String = "complete";

    public function CircleMask(r:uint) {
        radius = r;
        init();
    }

    private function init():void {
        graphics.beginFill(0x000000);
        graphics.drawCircle(0, 0, radius);
        graphics.endFill();
    }
    public function effect():void {
        scale = 0;
        var offset:uint = 300*(generation + 1);
        timer = new Timer(offset, 1);
        timer.addEventListener(TimerEvent.TIMER_COMPLETE, open, false, 0, true);
        timer.start();
    }
    private function open(evt:TimerEvent):void {
        timer.removeEventListener(TimerEvent.TIMER_COMPLETE, open);
        addEventListener(Event.ENTER_FRAME, transit, false, 0, true);
    }
    private function transit(evt:Event):void {
        scale += speed;
        if (scale >= 1) {
            scale = 1;
            removeEventListener(Event.ENTER_FRAME, transit);
            dispatchEvent(new Event(CircleMask.COMPLETE));
        }
    }
    public function get scale():Number {
        return _scale;
    }
    public function set scale(param:Number):void {
        _scale = param;
        scaleX = scaleY = _scale;
    }
    public function close():void {
        scale = 0;
        timer.removeEventListener(TimerEvent.TIMER_COMPLETE, open);
        timer.stop();
        removeEventListener(Event.ENTER_FRAME, transit);
    }

}


import flash.display.Sprite;
import flash.events.Event;
import flash.display.BitmapData;
import flash.display.Bitmap;
import flash.geom.Rectangle;

class TransitThreshold extends Sprite {
    public static var className:String = "TransitThreshold";
    public var transitName:String = "threshold";
    private var loader:PhotoLoader;
    private var rect:Rectangle;
    private var source:BitmapData;
    private var threshold:Threshold;
    private var bitmap:Bitmap;
    //private static var operation:String = Threshold.OPERATION_HIGH;
    private static var operation:String = ">=";
    private var _threshold:uint = 0x000000;
    private static var speed:uint = 0x020202;
    private static var color:uint = 0x00000000;
    private static var _mask:uint = 0x00FFFFFF;
    public static const COMPLETE:String = "complete";

    public function TransitThreshold(bd:BitmapData) {
        source = bd;
        rect = new Rectangle(0, 0, bd.width, bd.height);
        init();
    }

    private function init():void {
        var bitmapData:BitmapData = new BitmapData(rect.width, rect.height, false);
        bitmap = new Bitmap(bitmapData);
        threshold = new Threshold(source);
        bitmap.bitmapData = threshold;
    }
    public function effect(target:PhotoLoader):void {
        loader = target;
        loader.cacheAsBitmap = true;
        bitmap.cacheAsBitmap = true;
        loader.mask = bitmap;
        if (!loader.contains(bitmap)) loader.addChild(bitmap);
        //bitmap.x = loader.parent.x;
        //bitmap.y = loader.parent.y;
        _threshold = 0x000000;
        threshold.reset(0x00000000);
        addEventListener(Event.ENTER_FRAME, transit, false, 0, true);
    }
    private function transit(evt:Event):void {
        _threshold += speed;
        threshold.apply(operation, _threshold, color, _mask);
        if (_threshold > 0xFFFFFF) {
            _threshold = 0xFFFFFF;
            removeEventListener(Event.ENTER_FRAME, transit);
            dispatchEvent(new Event(TransitPhoto.COMPLETE));
            reset();
        }
    }
    public function reset():void {
        if (loader) {
            if (loader.contains(bitmap)) {
                loader.removeChild(bitmap);
                loader.mask = null;
            }
        }
    }

}


import flash.display.BitmapData;
import flash.geom.Rectangle;
import flash.geom.Point;

class Threshold extends BitmapData {
    private var source:BitmapData;
    private static var point:Point = new Point();
    private var operation:String;
    private var _threshold:uint;
    private var color:uint;
    private var mask:uint;
    public static const OPERATION_LOW:String = "<=";
    public static const OPERATION_HIGH:String = ">=";

    public function Threshold(bd:BitmapData, o:String = OPERATION_LOW, t:uint = 0x000000, c:uint = 0x00000000, m:uint = 0xFFFFFFFF) {
        super(bd.rect.width, bd.rect.height, true, 0xFFFFFFFF);
        source = bd;
        apply(o, t, c, m);
    }

    public function apply(o:String, t:uint, c:uint, m:uint):void {
        operation = o;
        _threshold = t;
        color = c;
        mask = m;
        lock();
        reset();
        threshold(source, rect, point, operation, _threshold, color, mask, false);
        unlock();
    }
    public function reset(fill:uint = 0xFFFFFFFF):void {
        fillRect(rect, fill);
    }

}


import flash.display.BitmapData;
import flash.display.Shape;
import flash.geom.Rectangle;
import frocessing.color.ColorHSV;

class BitmapTile extends BitmapData {
    private var _rect:Rectangle;
    private var unit:uint;

    public function BitmapTile(r:Rectangle, u:uint) {
        _rect = r;
        unit = u;
        super(_rect.width, _rect.height, false);
        init();
    }

    private function init():void {
        var shape:Shape = new Shape();
        var cols:uint = _rect.width/unit;
        var rows:uint = _rect.height/unit;
        var px:uint = 0;
        var py:uint = 0;
        var direction:uint = 0;
        var round:uint = 1;
        var hsv:ColorHSV = new ColorHSV(0, 0, 0);
        var c:Number = 1/(cols*rows - 1);
        for (var n:uint = 0; n < cols*rows; n++) {
            hsv.v = c*n;
            var color:uint = hsv.value;
            shape.graphics.beginFill(color);
            shape.graphics.drawRect(unit*px, unit*py, unit, unit);
            shape.graphics.endFill();
            switch (direction) {
                case 0 :
                    px ++;
                    if (px > cols - round - 1) {
                        direction = 1;
                    }
                    break;
                case 1 :
                    py ++;
                    if (py > rows - round - 1) {
                        direction = 2;
                    }
                    break;
                case 2 :
                    px --;
                    if (px < round) {
                        direction = 3;
                    }
                    break;
                case 3 :
                    py --;
                    if (py < round + 1) {
                        direction = 0;
                        round ++;
                    }
                    break;
            }
        }
        draw(shape);
    }

}


import flash.display.BitmapData;
import flash.geom.Rectangle;
import flash.geom.ColorTransform;

class Noise extends BitmapData {
    private var source:BitmapData;
    private var seed:uint;
    private static var low:uint = 0;
    private static var high:uint = 255;
    private var color:ColorTransform;
    private var multiplier:Object = {r: 1, g: 1, b: 1};
    private var offset:Object = {r: 0x00, g: 0x00, b: 0x00};

    public function Noise(rect:Rectangle, s:uint = 1) {
        super(rect.width, rect.height, false, 0xFF000000);
        source = new BitmapData(rect.width, rect.height, false, 0xFF000000);
        create(s);
    }

    public function create(s:uint):void {
        seed = s;
        if (seed == 0) seed = Math.floor(Math.random()*1000);
        lock();
        source.noise(seed, low, high, 0, true);
        draw(source);
        unlock();
    }
    public function colorize(m:Object, o:Object):void {
        multiplier = m;
        offset = o;
        color = new ColorTransform(multiplier.r, multiplier.g, multiplier.b, 1, offset.r, offset.g, offset.b, 0);
        lock();
        draw(source, null, color);
        unlock();
    }

}


import flash.display.BitmapData;
import flash.geom.Rectangle;
import flash.geom.Point;
import flash.geom.ColorTransform;

class PerlinNoise extends BitmapData {
    private var source:BitmapData;
    private var base:uint;
    private var octaves:uint;
    private var seed:uint;
    private static var point:Point = new Point();
    private var offsets:Array = [point, point];
    private var color:ColorTransform;
    private var multiplier:Object = {r: 1, g: 1, b: 1};
    private var offset:Object = {r: 0x00, g: 0x00, b: 0x00};

    public function PerlinNoise(rect:Rectangle, b:uint = 20, o:uint = 2, s:uint = 1) {
        super(rect.width, rect.height, false, 0xFF000000);
        source = new BitmapData(rect.width, rect.height, false, 0xFF000000);
        create(b, o, s);
    }

    public function create(b:uint, o:uint, s:uint):void {
        base = b;
        octaves = o;
        seed = s;
        if (seed == 0) seed = Math.floor(Math.random()*1000);
        lock();
        source.perlinNoise(base, base, octaves, seed, false, true, 0, true, offsets);
        draw(source);
        unlock();
    }
    public function colorize(m:Object, o:Object):void {
        multiplier = m;
        offset = o;
        color = new ColorTransform(multiplier.r, multiplier.g, multiplier.b, 1, offset.r, offset.g, offset.b, 0);
        lock();
        draw(source, null, color);
        unlock();
    }

}


//////////////////////////////////////////////////
// ColorManagerクラス
//////////////////////////////////////////////////

import flash.display.DisplayObject;
import flash.geom.ColorTransform;
import flash.filters.ColorMatrixFilter;

class ColorManager {
    private static var rs:Number = 0.3086;
    private static var gs:Number = 0.6094;
    private static var bs:Number = 0.0820;

    public function ColorManager() {
    }

    public static function brightOffset(target:DisplayObject, param:Number):void {
        target.transform.colorTransform = getBrightOffset(param);
    }
    private static function getBrightOffset(param:Number):ColorTransform {
        var percent:Number = 1;
        var offset:Number = param*2.55;
        var colorTrans:ColorTransform = new ColorTransform(0, 0, 0, 1, 0, 0, 0, 0);
        colorTrans.redMultiplier = percent;
        colorTrans.greenMultiplier = percent;
        colorTrans.blueMultiplier = percent;
        colorTrans.redOffset = offset;
        colorTrans.greenOffset = offset;
        colorTrans.blueOffset = offset;
        colorTrans.alphaMultiplier = 1;
        colorTrans.alphaOffset = 0;
        return colorTrans;
    }
    public static function saturation(target:DisplayObject, param:Number):void {
        target.filters = [getSaturation(param)];
    }
    private static function getSaturation(param:Number):ColorMatrixFilter {
        var colorMatrix:ColorMatrixFilter = new ColorMatrixFilter();
        var p:Number = param*0.01;
        var r:Number = (1 - p)*rs;
        var g:Number = (1 - p)*gs;
        var b:Number = (1 - p)*bs;
        var matrix:Array = [r + p, g, b, 0, 0, r, g + p, b, 0, 0, r, g, b + p, 0, 0, 0, 0, 0, 1, 0];
        colorMatrix.matrix = matrix;
        return colorMatrix;
    }

}


//////////////////////////////////////////////////
// ArrayUtilsクラス
//////////////////////////////////////////////////

class ArrayUtils {

    public function ArrayUtils() {
    }

    public static function shuffle(list:Array):Array {
        var n:uint = list.length;
        var sList:Array = list.concat();
        while (n--) {
            var i:uint = uint(Math.random()*(n+1));
            var t:Object = sList[n];
            sList[n] = sList[i];
            sList[i] = t;
        }
        return sList;
    }

}


//////////////////////////////////////////////////
// Labelクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.TextFieldAutoSize;
import flash.text.AntiAliasType;
import flash.text.TextFormat;
import flash.text.TextFormatAlign;

class Label extends Sprite {
    private var txt:TextField;
    private static var fontType:String = "_ゴシック";
    private var _width:uint;
    private static var _height:uint = 20;
    public static const LEFT:String = TextFormatAlign.LEFT;
    public static const CENTER:String = TextFormatAlign.CENTER;
    public static const RIGHT:String = TextFormatAlign.RIGHT;

    public function Label(w:uint, align:String = LEFT) {
        _width = w;
        draw(align);
    }

    private function draw(align:String):void {
        txt = new TextField();
        addChild(txt);
        txt.width = _width;
        txt.height = _height - 1;
        txt.autoSize = align;
        txt.type = TextFieldType.DYNAMIC;
        txt.selectable = false;
        //txt.embedFonts = true;
        //txt.antiAliasType = AntiAliasType.ADVANCED;
        var tf:TextFormat = new TextFormat();
        tf.font = fontType;
        tf.size = 12;
        tf.align = align;
        txt.defaultTextFormat = tf;
        textColor = 0x000000;
    }
    public function set text(param:String):void {
        txt.text = param;
    }
    public function set textColor(param:uint):void {
        txt.textColor = param;
    }

}
