/**
 * Copyright miyaoka ( http://wonderfl.net/user/miyaoka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rqmM
 */

package 
{
	import flash.display.*;
	import flash.events.*;
	import flash.geom.*;
	import caurina.transitions.Tweener;
import flash.filters.*;	
	[SWF(width = "465", height = "465", backgroundColor = 0xFFFFFF, frameRate = "60")]
	
	public class Carpets extends Sprite 
	{
		public function Carpets() 
		{
			var sw:Number = stage.stageWidth;
			var sh:Number = stage.stageHeight;
			var lastPt:Point = new Point();
			var lastAngle:Number = 0;
			var bmd:BitmapData = new BitmapData(sw, sh, true, 0x00000000);
			var gf:GlowFilter = new GlowFilter( 0x000000, 0.5, 2, 2, 5, 1, false, false );
			addChild(new Bitmap(bmd));
			stage.addEventListener(MouseEvent.MOUSE_MOVE, function ():void 
			{
				var angle:Number = (Math.atan2( -(mouseY - lastPt.y), mouseX - lastPt.x) + Math.PI * 2) % (Math.PI * 2);
				lastPt = new Point(mouseX, mouseY);
				lastAngle = angle;
				
				var c:Carpet = new Carpet();
				c.x = mouseX;
				c.y = mouseY;
				c.rotation = 90 - angle * 180 / Math.PI -90;
				addChild(c);
				c.addEventListener(Event.COMPLETE, function ():void 
				{
					var mtx:Matrix = new Matrix();
					mtx.rotate(-angle);
					mtx.translate(c.x, c.y);
					var tempBmd:BitmapData = new BitmapData(bmd.width, bmd.height, true, 0x00000000);
					tempBmd.draw(c, mtx);
					tempBmd.applyFilter(tempBmd, tempBmd.rect, tempBmd.rect.topLeft, gf);
					bmd.draw(tempBmd);
					tempBmd.dispose();
					c.removeEventListener(Event.COMPLETE, arguments.callee);
					removeChild(c);
					c = null;
				});
				
			})
		}
		
	}
	
}
import flash.display.*;
import flash.events.*;
import flash.geom.*;
import caurina.transitions.Tweener;

class Carpet
extends Shape
{
	public var f:Number = 0;
	public function Carpet():void 
	{
		var radius:Number = 700;
		var clr:uint = Math.random() * 0xffffff;
		var openAngle:Number = Math.PI * 0.03 * Math.random() * Math.random();
		var ptSt1:Point = Point.polar(radius, Math.PI + openAngle);
		var ptSt2:Point = Point.polar(radius, Math.PI - openAngle);
		var ptEnd1:Point = Point.polar(radius, 0 - openAngle * Math.random());
		var ptEnd2:Point = Point.polar(radius, 0 + openAngle * Math.random());
		var g:Graphics = graphics;
		g.beginFill(clr);
		Tweener.addTween(this,
		{
			time: 1.0,
			f:1,
			transition: "linear",
			onUpdate: function ():void 
			{
				g.clear();
				g.beginFill(clr);
				g.moveTo(ptSt1.x, ptSt1.y);
				g.lineTo(ptSt2.x, ptSt2.y);
				var pt:Point = Point.interpolate(ptEnd2, ptSt2, f) 
				g.lineTo(pt.x, pt.y);
				pt = Point.interpolate(ptEnd1, ptSt1, f) 
				g.lineTo(pt.x, pt.y);
			},
			onComplete: function ():void 
			{			
				dispatchEvent(new Event(Event.COMPLETE));
			}
		});

	}
}