/**
 * Copyright hgw ( http://wonderfl.net/user/hgw )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rqgr
 */

/*

┏━┓┏…┓┏━┓┏…┓┏━┓┏…┓┏━┓┏…┓┏━┓┏…┓┏━┓
┃テ┃┃ク┃┃ニ┃┃ッ┃┃ク┃┃に┃┃自┃┃信┃┃の┃┃な┃┃い┃
┗…┛┗━┛┗…┛┗━┛┗…┛┗━┛┗…┛┗━┛┗…┛┗━┛┗…┛
┏━┓┏…┓┏━┓┏…┓┏━┓┏…┓
┃貴┃┃方┃┃に┃┃朗┃┃報┃┃!!┃
┗…┛┗━┛┗…┛┗━┛┗…┛┗━┛

*/


package
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.ColorTransform;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	
	[SWF(width="465", height="465", backgroundColor="0xFFFFFF", frameRate="60")]

	public class ShapePerceive extends Sprite
	{
		private var src:BitmapData;
		private var canvas:Bitmap;
		private var d_cir:PerceiveShape;
		public function ShapePerceive()
		{
			d_cir = new PerceiveShape();
			d_cir.start();
			
			//addChild( d_cir );
			d_cir.x = 465*.5;
			d_cir.y = 465*.5;
			
			src = new BitmapData(465,465,true,0x0);
			
			canvas = new Bitmap( new BitmapData(465, 465, true, 0x0) );
			addChild( canvas );
			addEventListener(Event.ENTER_FRAME, update);
		}
		
		private var baff:Vector.<BitmapData> = new Vector.<BitmapData>();
		private var ct:ColorTransform = new ColorTransform(1,1,1,.9);
		private function update(e:Event):void
		{	
			src.lock();
			src.draw( d_cir, d_cir.transform.matrix );
			src.colorTransform( src.rect, ct);
			src.unlock();
			
			baff.push( src.clone() );
			
			canvas.bitmapData.lock();
			for(var i:int=0; i<src.height; i++)
			{
				if(baff.length-1<i) break;
				canvas.bitmapData.copyPixels( baff[i], new Rectangle( 0, i, 465, 1 ), new Point(0,i));
			}
			canvas.bitmapData.unlock();
			
			if(baff.length>465){
				baff.splice(0,1);
			}
		}
	}
}
import flash.display.Graphics;
import flash.display.Shape;
import flash.events.Event;
import flash.geom.Point;


internal class PerceiveShape extends Shape
{
	private var seg:int = 4;
	private var counts:Vector.<Number>;
	
	public function PerceiveShape()
	{
		counts = new Vector.<Number>();
		for(var i:int=0; i<seg; i++)
		{
			counts.push( Math.random() );
		}

		draw();
	}
	
	
	public function start():void
	{
		
		addEventListener(Event.ENTER_FRAME, loop);
	}
	
	private function loop(e:Event):void
	{
		update();
		draw();
	}
	
	
	
	private function update():void
	{		
		for(var i:int=0; i<seg; i++)
		{
			counts[i] += 0.25;
		}
	}
	
	private function draw():void
	{
		var x0:Number = 0;
		var y0:Number = 0;
		
		var w:Number = 150;
		var h:Number = 150;
		var margin:Number = 25;
		var angle:Number = Math.PI / seg;
		var angle2:Number = angle * 2;
		var halfPI:Number = Math.PI / 2;
		
		var aPoints:Vector.<Point> = new Vector.<Point>();
		var cPoints:Vector.<Point> = new Vector.<Point>();
		
		var g:Graphics = graphics;
		g.clear();
		g.beginFill(0xFF0000);
		g.lineStyle(2,0xFFFFFF);
		g.moveTo(x0 + w-Math.sin(counts[0])*margin, y0);
		for (var i:uint = 1; i<=seg; i++)
		{
			var r:Number = i * angle2;
			
			var aPt:Point = new Point( (w - (Math.sin(counts[i-1])*margin))*Math.cos(r), (h-(Math.cos(counts[i-1])*margin)) *Math.sin(r));
			aPoints.push( aPt );
			
			var cPt:Point = new Point( aPt.x+ (w - (Math.sin(counts[i-1])*margin) )  *Math.tan(angle)*Math.cos(r-halfPI), aPt.y+   (h-(Math.cos(counts[i-1])*margin))   *Math.tan(angle)*Math.sin(r-halfPI) );
			cPoints.push( cPt );
			
			if(i!=seg){
				g.curveTo(cPt.x+x0, cPt.y+y0, aPt.x+x0, aPt.y+y0);
			}
			else
			{
				g.curveTo(cPt.x+x0, cPt.y+y0, x0 + w- Math.sin(counts[0])*margin , y0);				
			}
		}		
		g.endFill();
	}
	
}



