/**
 * Copyright aobyrne ( http://wonderfl.net/user/aobyrne )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rqIR
 */

// forked from Kay's [QuickBox2D] Soft Object #3
// forked from Kay's [QuickBox2D] Soft Object #2
// forked from Kay's forked from: QuickBox2D sample
// forked from mash's QuickBox2D sample
/*
 * centerを多角形にして周りをジェルで覆うイメージにしてみた
 */
package {
    import flash.display.*;
    import com.actionsnippet.qbox.*;
    import flash.geom.*;
    import flash.events.*;

    public class FlashTest extends MovieClip {
            private const SW:Number = stage.stageWidth;
            private const SH:Number = stage.stageHeight;
        private const radius:Number = 0.2;
        private var inner:Array = new Array();
        private var outer:Array = new Array();
        private const jHz:Number = 100;
        private const jDr:Number = 100;
        private const nColor:int = 0xff0000;
        public function FlashTest() {
            stage.frameRate = 60;
            var sim:QuickBox2D = new QuickBox2D(this, { debug:true, gravityX:0, gravityY:10 });
            sim.createStageWalls();
            var center:Point = new Point(SW/2/30, SH/2/30);
            var nRadius:Number = 2;
            // Outer
            for (var o:int = 0; o < 12; o++) {
                    nR = Math.PI*2/12*o;
                var dot:QuickObject = sim.addCircle({
                    x:center.x+nRadius*Math.cos(nR), 
                    y:center.y+nRadius*Math.sin(nR), 
                    radius:radius, fillAlpha:0, lineAlpha:0 , fixedRotation:true
                    ,restitution:0.1
                    ,linearDamping:0.9
                    });
                outer.push(dot);
                if (o > 0) {
                    sim.addJoint({a:outer[o-1].body, b:dot.body, frequencyHz:jHz, dampingRatio:jDr});
                }
            }
            sim.addJoint({a:outer[11].body, b:outer[0].body, frequencyHz:jHz, dampingRatio:jDr});
            //Inner
            for (var i:int = 0; i < 6; i++) {
                    var nR:Number = Math.PI*2/6*i;
                    var p:Point = new Point(nRadius*0.75*Math.cos(nR), nRadius*0.75*Math.sin(nR));
                inner.push(p);
            }
            // Center
            var centerPoly:QuickObject = sim.addPoly({x:center.x, y:center.y, 
            verts:[[inner[0].x,inner[0].y, 
                inner[1].x,inner[1].y, 
                inner[2].x,inner[2].y, 
                inner[3].x,inner[3].y, inner[4].x,inner[4].y, inner[5].x,inner[5].y]], density:5,fillAlpha:0, lineAlpha:0});
            
            // Outer
            for (i = 0; i < 6; i++) {
                sim.addJoint({a:outer[i*2+1].body, b:centerPoly.body, x2:inner[i].x+center.x, y2:inner[i].y+center.y, frequencyHz:jHz, dampingRatio:jDr});
                sim.addJoint({a:outer[i*2].body, b:centerPoly.body, x2:inner[i].x+center.x, y2:inner[i].y+center.y, frequencyHz:jHz, dampingRatio:jDr});
                sim.addJoint({a:outer[(i*2-1+12)%12].body, b:centerPoly.body, x2:inner[i].x+center.x, y2:inner[i].y+center.y, frequencyHz:jHz, dampingRatio:jDr});
            }
            
                sim.start();
            sim.mouseDrag();
            
            addEventListener(Event.ENTER_FRAME, xFake);                       
        }
        private function xFake(e:Event):void {
                graphics.clear();
                graphics.lineStyle(10,nColor);
                graphics.beginFill(nColor);
                var sPos:Point = new Point();
                for (var i:int = 0; i < 12; i++) {
                    var circle:QuickObject = outer[i];
                    if (i == 0) {
                        sPos = new Point(circle.x*30, circle.y*30);
                        graphics.moveTo(sPos.x, sPos.y);
                    } else {
                        graphics.lineTo(circle.x*30,circle.y*30);
                    }
                }
                graphics.lineTo(sPos.x, sPos.y);
                graphics.endFill();
        }
    }
}
