/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rqDD
 */

// forked from tai2's White Noize
package {
    import flash.display.Sprite;
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.events.Event;
    
    public class WhiteNoize extends Sprite {
        private var canvas:BitmapData;
        private var canvasBitmap:Bitmap;
        
        public function WhiteNoize() {
            canvas = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0x000000);
            canvasBitmap = new Bitmap(canvas);            
            addChild(canvasBitmap); 
            
            addEventListener(Event.ENTER_FRAME, enterFrame);
        }
        
        private function enterFrame(event:Event) : void {
            canvas.lock();
            var x:int;
            var y:int;
            for (y = 0; y < stage.stageHeight; y++) {
                for (x = 0; x < stage.stageWidth; x++) {
                    var v:int = 255 * Math.random();
                    canvas.setPixel(x, y, (v<<16) | (v<<8) | (v<<0));
                }
            }
            canvas.unlock();            
        }

    }
}