/**
 * Copyright takashi ( http://wonderfl.net/user/takashi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rpvy
 */

// forked from takashi's forked from: パーティクルシステムのサンプル改
// forked from autumngoodluck's パーティクルシステムのサンプル改
// forked from autumngoodluck's パーティクルシステムのサンプル
// forked from autumngoodluck's MyTemplate
/*
 * パーティクルシステムのサンプル
 *
 * マウスカーソルの位置からパーティクル（粒子）が無限に噴水のように放出されるサンプル。
 */
package
{
    import flash.display.Sprite;
	import flash.events.Event;

    [SWF(width="465", height="465", backgroundColor="0x000000", frameRate="24")]
    public class ParticleSample extends Sprite
    {
		public function ParticleSample()
        {
			addEventListener(Event.ENTER_FRAME, loop, false, 0, true);
			blendMode = 'add';
        }
        
        /*
         * 繰り返し処理
         *
         * 無限にパーティクル（粒子）をマウスカーソルの位置から上方向に放出する。
         */
		public function loop(event:Event):void
        {
			var particle:Particle = new Particle(mouseX,						// パーティクルの放出位置（x 座標）
			                                     mouseY,						// パーティクルの放出位置（y 座標）
			                                     Math.random() * 10 - 5,		// パーティクルの放出速度（x 方向）
			                                     Math.random() * -10,			// パーティクルの放出速度（y 方向）
			                                     0.2,							// 重力
			                                     Math.random() * 0xFFFFFF);	// パーティクルの色
			addChild(particle);
        }
    }
}

import flash.display.GradientType;
import flash.display.Sprite;
import flash.events.Event;

/*
 * パーティクル（粒子）クラス
 */
class Particle extends Sprite
{
	// 速度
	private var _velX:Number;
	private var _velY:Number;
	
	// 重力
	private var _grav:Number;

	/*
	 * パーティクルの生成
	 *
	 * 引数
	 *   curX - パーティクルの放出位置（x 座標）
	 *   curY - パーティクルの放出位置（y 座標）
	 *   velX - パーティクルの放出速度（x 方向）
	 *   velY - パーティクルの放出速度（y 方向）
	 *   grav - 重力
	 *   col  - パーティクルの色
	 */	
	public function Particle(curX:Number, curY:Number, velX:Number, velY:Number, grav:Number, col:uint)
	{
		var colors:Array = [col, 0];
		var alphas:Array = [1, 1];
		var ratios:Array = [0, 255];

		_velX = velX;
		_velY = velY;
		_grav = grav;
		
		// パーティクルを指定色で、半径 50 の円としてとりあえず描画する。
		// 位置、大きさは後で変更する。
		graphics.beginGradientFill(GradientType.RADIAL, colors, alphas, ratios);
		graphics.drawCircle(50, 50, 50);
		graphics.endFill();
		blendMode = 'add';
		// パーティクルの位置、透明度および大きさを変更する。
		x      = curX;
		y      = curY;
		scaleX = scaleY = Math.random() * 0.3 + 0.1;	// 大きさは、0.1 倍以上 0.4 倍未満
		
		addEventListener(Event.ENTER_FRAME, loop, false, 0, true);
	}
	
	/*
	 * 繰り返し処理
	 *
	 * パーティクルを放出速度に従い動かす。なお、y 方向については重力を考慮する。
	 */
	private function loop(event:Event):void
	{
		// 重力による落下速度の変化
		_velY += _grav;
		
		// 移動
		x += _velX;
		y += _velY;
		if (x < 0 || x > stage.stageWidth || y > stage.stageHeight)
		{
			// 不要になったパーティクルの削除
			removeEventListener(Event.ENTER_FRAME, loop);
			parent.removeChild(this);
		}
	}
}