/**
 * Copyright beinteractive ( http://wonderfl.net/user/beinteractive )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rpiR
 */

package
{
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.display.Sprite;
    
    public class FlashTest extends Sprite
    {
        public function FlashTest()
        {
            // trace 出力用
            _field = new TextField();
            _field.autoSize = TextFieldAutoSize.LEFT;
            addChild(_field);
            
            // 本編ここから
            useHeavyObject();
        }
        
        // IDisposable なオブジェクトを使う例
        private function useHeavyObject():void
        {
            $trace('Start using HeavyObject');
            
            // using ステートメントを使うとスコープが終わったら自動的に開放されるよ！
            using (new HeavyObject(), function(obj:HeavyObject):void
            {
                obj.doSomething();
            })
            
            $trace('End using HeavyObject');
        }

        // using の実装
        protected function using(d:IDisposable, closure:Function):void
        {
            // 渡された関数を実行して
            try {
                closure(d);
            }
            finally {
                // 最後に IDisposable を破棄してあげるだけ
                if (d != null) {
                    d.dispose();
                }
            }
        }

        public static var _field:TextField;
    }
}

// C# 同様の IDisposable インターフェイス
interface IDisposable
{
    function dispose():void;
}

// 使い終わったら開放する必要があるオブジェクト
class HeavyObject implements IDisposable
{
    // 何かする
    public function doSomething():void
    {
        $trace('Do something');
    }

    // 破棄する
    public function dispose():void
    {
        $trace('Dispose!');
    }
}

// とれぇす
function $trace(...args):void
{
    FlashTest._field.appendText(args.join(' ') + '\n');
}
