/**
 * Copyright George.Profenza ( http://wonderfl.net/user/George.Profenza )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rpWT
 */

package {
    import flash.text.TextFormat;
    import flash.text.TextField;
    import flash.display.DisplayObject;

    import flash.events.Event;

    import org.papervision3d.events.FileLoadEvent;
    import org.papervision3d.events.InteractiveScene3DEvent;
    import org.papervision3d.materials.BitmapMaterial;
    import org.papervision3d.materials.ColorMaterial;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.parsers.DAE;
    import org.papervision3d.view.BasicView;
    import org.papervision3d.objects.parsers.Collada;
    import org.papervision3d.objects.primitives.PaperPlane;
    import org.papervision3d.objects.special.UCS;

    public class modelTest extends BasicView
    {
        private var mesh:DisplayObject3D;
        private var model:DAE;
        private var distance:Number = 1000;
        private var speed:Number = 0.2;
        private var rangeX:Number = 0.02;
        private var rangeY:Number = 0.02;
        private var rangeZ:Number = 0.05;
        private var targetRotationX:Number = 0;
        
        private var debug:TextField;

        public function modelTest()
        {   
            super(640,480,false,false,"Debug");
            scene.addChild(new UCS(1000));
            stage.frameRate = 40;

            init();
            startRendering();
        }

        private function init():void
        {
            model = new DAE();
            model.load("http://imageedit.netai.net/cube.dae");
            
            
            mesh = scene.addChild(new PaperPlane());

            model.addEventListener(FileLoadEvent.LOAD_COMPLETE, modelLoaded);
            model.addEventListener(FileLoadEvent.LOAD_ERROR,modelError);
            model.addEventListener(FileLoadEvent.SECURITY_LOAD_ERROR,modelError);
            
            scene.addChild(model);
            
            debug = addChild(new TextField) as TextField;
            debug.border = true;
            debug.background = true;
            debug.backgroundColor = 0;
            debug.defaultTextFormat = new TextFormat("Verdana",11,0xFFFFFF);
            debug.x = 300;
            debug.text = ""+model.numChildren;
        }
        private function modelError(event:FileLoadEvent):void{
            debug.appendText(event.toString());
        }

        private function modelLoaded(e:FileLoadEvent):void
        {
            trace("Used materials by this model: " + model.materials);
            
        }


        override protected function onRenderTick(e:Event=null):void
        {   
            super.onRenderTick();
        }
    }
}