/**
 * Copyright uwi ( http://wonderfl.net/user/uwi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rp9t
 */

package {
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.utils.getTimer;
    
    // とある問題に使えそうなので
    public class SegmentSieve extends Sprite {
        private var _tf : TextField;
  
        public function SegmentSieve() {
            _tf = new TextField();
            _tf.width = 465;
            _tf.height = 465;
            addChild(_tf);
            
            var s : int = getTimer();
            
            tr(doSegment(10000000000, 10000000100));
//            tr(doSegment(100000, 100100));
            
            var g : int = getTimer();
            tr((g - s) + " ms");
        }
        
        private function doSegment(l : Number, h : Number) : Array
        {
            var sqh : int = Math.sqrt(h);
            var primes : Array = doEratosthenes(sqh);
            var s : Array = new Array(h - l);
            var i : int;
            for(i = 0;i < h - l;i++)s[i] = l + i;
            
            for each(var p : int in primes){
                var mod : int = l % p;
                for(i = mod == 0 ? 0 : p - mod; i < h - l;i += p){
                    s[i] = 0;
                }
            }
            
            var ret : Array = [];
            for each(var v : Number in s){
                if(v != 0)ret.push(v);
            }
            return ret;
        }
        
        private static function doEratosthenes(n : int) : Array
        {
            var ar : Vector.<uint> = new Vector.<uint>(n / 2 - 1);
            var i : int;
            for(i = 0;i < ar.length;i++)ar[i] = 1;
            
            var sq : int = (Math.sqrt(n) - 3) >> 1;
            for(var p : int = 0;p <= sq;p++){
                if(ar[p] == 1){
                    var m : int = (p << 1) + 3;
                    var m2 : int = m << 1;
                    for(var mm : int = m * m;mm <= n;mm += m2){
                        ar[(mm - 3) >> 1] = 0;
                    }
                }
            }
            var ret : Array = [2];
            for(i = 0;i < ar.length;i++){
                if(ar[i] == 1)ret.push((i << 1) + 3);
            }
            return ret;
        }
        
        private function tr(...o : Array) : void
        {
            _tf.appendText(o + "\n");
        }
    }
}