/**
 * Copyright DoraMilitaru ( http://wonderfl.net/user/DoraMilitaru )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rogi
 */

// forked from Murai's forked from: Milkyway forked from: soundtest6
// forked from Murai's Milkyway forked from: soundtest6
// forked from gaina's soundtest6
/**
 * Copyright gaina ( http://wonderfl.net/user/gaina )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/dllp
 */

package {
    import org.libspark.betweenas3.BetweenAS3;

    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.display.Sprite;
    import flash.display.StageQuality;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.filters.GlowFilter;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.media.SoundLoaderContext;
    import flash.media.SoundMixer;
    import flash.net.URLRequest;
    import flash.text.TextField;
    import flash.text.TextFieldAutoSize;
    import flash.text.TextFormat;
    import flash.utils.ByteArray;

    [SWF(backgroundColor="#000000", frameRate="60", width="465", height="465")]

    public class SoundSpectrum extends Sprite {

        private var leftRightSpList:Array;
        private var snd:Sound;
        private var FFTswitch:Boolean = false;
        private var grows:Array;
        private var tf:TextField;
        private var tfm:TextFormat;
        private var particleContainer:Sprite;
        private var bmp:Bitmap;
        private var m:Matrix;
        private var filter:BlurFilter;
        private var color:Sprite;
        private var count:int;
        private var vol:Number;

        function SoundSpectrum() {
            
                
            graphics.beginFill(0x000000);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            
            stage.quality = StageQuality.LOW;
            grows = [new GlowFilter(0xCCCCCC, 1, 4, 4, 4),new GlowFilter(0x888888, 1, 4, 4, 4),new GlowFilter(0xFFFFFF, 1, 4, 4, 4)];                
                
            playSound("http://www.mechaboy.com/fwd.mp3");
            
            addChild(particleContainer = new Sprite());
            addChild(bmp = new Bitmap());
            addChild(color = new Sprite());
            with(color) {
                graphics.beginFill(0x000000, 1);
                graphics.drawRect(-5, -5, 10, 10);
                graphics.endFill();
            };
            color.blendMode = BlendMode.ADD;
            
            bmp.bitmapData = new BitmapData(600, 600, true, 0x00000000);
            //            bmp.blendMode = BlendMode.SCREEN;
            tf = new TextField();
            tfm = new TextFormat();
            tfm.font = 'Trebuchet MS';
            tfm.size = 70;
            
            filter = new BlurFilter(2, 2, 2);
            //            filter=new GlowFilter(0xFFFFFF,1,8,8,2,2);
            leftRightSpList = makeLeftRightSpList();
            
            count = 0;
            
            addEventListener(Event.ENTER_FRAME, render);
        }

        private function change():void {
            
            var hex:uint = [0xBA0718,0x127996,0x00BDAA,0xEBAC27,0xDB3615][count++ % 5];
            color.transform.colorTransform = new ColorTransform(0, 0, 0, 1, hex >> 16 & 0xff, hex >> 8 & 0xff, hex & 0xff, 1);
            color.width = stage.stageWidth;
            color.height = stage.stageHeight;
            color.x = 465 / 2;
            color.y = 465 / 2;
            
            bmp.x = (465 - 600) / 2;
            bmp.y = (465 - 600) / 2;
            
            BetweenAS3.tween(color, {alpha:1}, {alpha:0.5}, 0.5).gotoAndPlay(0);
        }

        private function format(n:Number):String {
            var str:String = String(n);
            return (str.length < 2) ? new Array((2 - str.length) + 1).join('0') + n : String(n);
        };

        private function playSound(sndUrl:String):void {
            snd = new Sound();
            var context:SoundLoaderContext = new SoundLoaderContext(10, true);
            var req:URLRequest = new URLRequest(sndUrl);
            snd.load(req, context);
            var sndChannel:SoundChannel = new SoundChannel();
            sndChannel = snd.play(0, 9999);
        }

        private function render(event:Event):void {
            var sp:Sprite = new Sprite();
            var bytes:ByteArray = new ByteArray();
            SoundMixer.computeSpectrum(bytes, FFTswitch, 0);
            var i:uint, j:uint;
            for (i = 0;i < 2;i++) {
                var spList:Array = leftRightSpList[i];
                for (j = 0;j < 256;j++) {
                    sp = spList[j];
                    var rf:Number = bytes.readFloat();
                    var scale:Number = Math.max(0.05, 1 + rf * 100);
                    sp.scaleX = scale;
                    sp.scaleY = scale / 5 + 1;
                    
                    sp.filters = ((Math.random() * 10 >> 0) % 2) ? [grows[Math.random() * 3 >> 0]] : null;
                        
                    if(!FFTswitch) {
                        sp.x += sp.x * rf * 5 + 8;
                    } else {
                        sp.x = sp.x * rf * 5 + 8;
                    }
                }
            }
            SoundMixer.computeSpectrum(bytes, false, 60);
            vol = bytes.readFloat();
            if(vol > .25)change();
            
                       
            tf.text = "ROB LEE MECHABOY";
            tf.selectable = false;
            tf.textColor = 0x000000;
            tf.autoSize = TextFieldAutoSize.LEFT;
            tf.setTextFormat(tfm);
            m = new Matrix(1, 0, 0, 1, (600 - tf.width) / 2, (600 - tf.height) / 2);
            bmp.bitmapData.fillRect(bmp.bitmapData.rect, 0x00000000);
            bmp.bitmapData.draw(tf, m, null, null, null, true);
            bmp.bitmapData.applyFilter(bmp.bitmapData, bmp.bitmapData.rect, new Point(0, 0), filter);
        }

        private function makeLeftRightSpList():Array {
            var spLRList:Array = new Array();
            var n:uint;
            var i:uint;
            for (n = 0;n < 2;n++) {
                var spList:Array = new Array();
                for (i = 0;i < 256;i++) {
                    var sp:Sprite = new Sprite();
                    sp.graphics.beginFill(0x000000);
                    sp.blendMode = BlendMode.ADD;
                    sp.graphics.drawRect(0, 0, 5, 1);
                    sp.graphics.endFill();
                    sp.y = stage.stageHeight / 256 * i;
                    particleContainer.addChild(sp);
                    spList.push(sp);
                }
                spLRList.push(spList);
            }
            return spLRList;
        }
    }
}