/**
 * Copyright chenjinglin.xidian ( http://wonderfl.net/user/chenjinglin.xidian )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/roVG
 */

// forked from abakane's Threshold transition
package{
    import flash.display.*;
    import flash.events.*;
    import flash.net.*;
    import flash.filters.*;
    import flash.geom.*;
    import flash.system.*;
    [SWF(width=465, height=465, backgroundColor=0x0, frameRate=60)]
    
    public class Transition extends Sprite{
        private var t:uint = 0;
        private var p:Point = new Point(0, 0);
        private var _canvas:BitmapData;
        private var _source:BitmapData;
        private var _mask:BitmapData;
        private var _perlin:BitmapData;
        
        public function Transition(){
            var loader:Loader = new Loader();
            loader.load( new URLRequest("http://bkmrk.abakane.com/lab/lib/flower.jpg"), new LoaderContext(true));
            loader.contentLoaderInfo.addEventListener( Event.COMPLETE, onComplete);//
        }
        
        private function onComplete( e:Event ):void{
            _source = Bitmap( LoaderInfo(e.target).loader.content ).bitmapData;
            _canvas = new BitmapData( _source.width, _source.height, true, 0x0);
            _perlin = new BitmapData( _source.width, _source.height, false, 0x0);
            reset();//
            var bmpd:BitmapData = _source.clone();
            var ary:Array = [
                0.3, 0.6, 0.1, 0, 0,
                0.3, 0.6, 0.1, 0, 0,
                0.3, 0.6, 0.1, 0, 0,
                0, 0, 0, 1, 0];
            var bmp:Bitmap = new Bitmap(bmpd);
            bmp.filters = [ new ColorMatrixFilter(ary) ];
            this.addChild( bmp );
            this.addChild( new Bitmap(_canvas) );
            stage.addEventListener( MouseEvent.CLICK, onClick);//
        }
        
        private function update( e:Event ):void{
            _mask.threshold( _perlin, _mask.rect, p, "<=", t, 0xFFFFFFFF, 0x00FFFFFF, false);
            _canvas.copyPixels(_source, _canvas.rect, p, _mask, null, true);
            _canvas.applyFilter( _canvas, _canvas.rect, p, new GlowFilter( 0x330800, 1, 2, 2, 2, 1, true, false));
            t += (0xFFFFFF - t)*0.005;
            if( t > 0xEFFFFF ){
                _canvas.fillRect( _canvas.rect, 0x0);
                t = 0;
                reset();//
                this.removeEventListener( Event.ENTER_FRAME, update);//
                stage.addEventListener( MouseEvent.CLICK, onClick);//
            } 
        }
        
        private function onClick( e:MouseEvent ):void{
            stage.removeEventListener( MouseEvent.CLICK, onClick);//
            this.addEventListener( Event.ENTER_FRAME, update);//
        }

        private function reset():void{
            _mask = _canvas.clone();
            _perlin.perlinNoise( 50, 50, 1, Math.floor(Math.random()*100), false, true, 0, true, null);
           
        }
    
    }
}