/**
 * Copyright nkheart4 ( http://wonderfl.net/user/nkheart4 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rno4
 */

package {
    import flash.text.TextField;
    import flash.filters.GlowFilter;
    import flash.display.BlendMode;
    import flash.geom.Rectangle;
    import flash.geom.Point;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    
    public class FlashTest extends Sprite {
        
        private  var landLayer:BitmapData ;
        private var bd:BitmapData;
        private  var seaLayer:BitmapData;
        private  var landGlow1:GlowFilter = new GlowFilter(0x009900 , 0.7 ,30,30 , 5 , 1 , true);
        private var landGlow2:GlowFilter = new GlowFilter(0x006600 , 0.3 ,30,30 , 5 , 1 , true);
        
        public function FlashTest() {
            // write as3 code here..
            bd = new BitmapData(stage.stageWidth , stage.stageHeight,false,0xFFFFFF);
            
            landLayer = new BitmapData(stage.stageWidth , stage.stageHeight , true , 0 );
            seaLayer = new BitmapData(stage.stageWidth , stage.stageHeight , true , 0 );
           
            var land:Bitmap = new Bitmap(landLayer);
            var sea:Bitmap = new Bitmap(seaLayer);
            addChild( land );
            addChild( sea );
            
            reGenerate();
            
            stage.addEventListener(MouseEvent.CLICK , reGenerate );
            
            var txt:TextField = new TextField();
            txt.width = 400;
            addChild( txt );
            txt.text = "Click To New Generate";
        }
        private function reGenerate(e:MouseEvent = null): void{
            landLayer.fillRect( landLayer.rect , 0 );
            seaLayer.fillRect( seaLayer.rect , 0 );
             
            var randomNum:Number = Math.floor(Math.random() * 10);
             bd.perlinNoise(100, 80, 10, randomNum, false, true, 200, true, null);
             var midColor:uint = 0x888888;
             bd.threshold(bd,bd.rect,new Point(),"<" , midColor , 0 , 0xFFFFFF );
             bd.threshold(bd,bd.rect,new Point(),">" , midColor , 0xFFFFFFFF  , 0xFFFFFF );
             var pixelSize:int = 3;
             for( var _x:int=0; _x<=bd.width ; _x += pixelSize ){
                 for(var _y:int=0; _y<=bd.height ; _y += pixelSize){
                     if( bd.getPixel(_x,_y) == 0 ){
                         seaLayer.fillRect( new Rectangle(_x,_y,pixelSize,pixelSize) , 0xFF0066cc );
                     }else{
                         landLayer.fillRect( new Rectangle(_x,_y,pixelSize,pixelSize) , 0xFF99CC00 );
                     }
                 }
             }
               landLayer.applyFilter(landLayer,landLayer.rect,new Point(),landGlow1 );
             seaLayer.applyFilter(seaLayer,seaLayer.rect,new Point(),landGlow2 );
        }
        
        


    }
}