/**
 * Copyright mousepancyo ( http://wonderfl.net/user/mousepancyo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rn51
 */

/*
ConvolutionFilterを使用したビデオエフェクトのテスト
左のセレクターでパラメーター変更
右のセレクターでエフェクトのアルファ値変更
*/

package  {    
    import flash.events.Event;
    import flash.filters.ConvolutionFilter;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.display.Sprite;
    import flash.geom.Point;
    import com.bit101.components.*;
    
    [SWF(width=465, height=465, backgroundColor=0, frameRate=24)]
    public class Main extends Sprite{
        
        private var _sp:Sprite = new Sprite()
        private var _cam:CameraCapture
        
        private var _matrix:Array
        private var _matrixList:Array
        private var _divisorList:Array
        private var _biasList:Array
        private var _blendModeList:Array
        private var _matrixPixcelList:Array
        
        private var _filter:ConvolutionFilter
        private var _bmd:BitmapData;
        private var _bm:Bitmap;
        
        private var _selector:RotarySelector
        private var _selector2:RotarySelector

        public function Main() {
            addChild(_sp)
            _cam = new CameraCapture(stage.stageWidth, stage.stageHeight)
            _sp.addChild(_cam)
            //
            _bmd = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0)
            _bm = new Bitmap(_bmd)
            addChild(_bm)
            //
            _matrixList = [
                        [1, 1, 1,
                         1, 0, 1,
                         1, 1, 1],
                        [1, 1, 1,
                         1, 1, 1,
                         1, 1, 1],
                        [-1, -1, -1,
                         -1, 1, -1,
                         -1, -1, -1],
                        [-1, -1, -1,
                         -1, 1, -1,
                         -1, -1, -1],
                        [-1, -1, -1,-1, -1,
                         -1, 1, 1, 1, -1,
                         -1, 1, 1, 1, -1,
                         -1, 1, 1, 1, -1,
                         -1, -1, -1, -1, -1
                         ]
                        ]

            _divisorList = [4, 2, 1, 1, 1]
            _biasList = [0, 768, 256, 1280, 768]
            _blendModeList = ["hardlight", "overlay", "add", "difference", "screen"]
            _matrixPixcelList = [3, 3, 120, 3, 24]
            //
            _selector = new RotarySelector(this, 20, 385, "Parameters Selector", selectorClick);
            _selector.numChoices = 10;
            _selector2 = new RotarySelector(this, 120, 385, "Alpha Selector", selectorClick);
            _selector2.labelMode = RotarySelector.NUMERIC;
            _selector2.numChoices = 10;
            _selector2.choice = 9
            //
            modeChange(0, false)
            addEventListener(Event.ENTER_FRAME, update)
        }
        
        private function selectorClick(e:Event):void{
            var n:Number = e.currentTarget.choice
            removeEventListener(Event.ENTER_FRAME, update)
            if(e.currentTarget == _selector){
                switch(n){
                    case 0:
                        modeChange(0, true)
                        break;
                    case 1:
                        modeChange(0, false)
                        break;
                    case 2:
                        modeChange(1, true)
                        break;
                    case 3:
                        modeChange(1, false)
                        break;
                    case 4:
                        modeChange(2, true)
                        break;
                    case 5:
                        modeChange(2, false)
                        break;
                    case 6:
                        modeChange(3, true)
                        break;
                    case 7:
                        modeChange(3, false)
                        break;
                    case 8:
                        modeChange(4, true)
                        break;
                    case 9:
                        modeChange(4, false)
                        break;
                }
            }else{
                _bm.alpha = n/10+0.1
            }
            addEventListener(Event.ENTER_FRAME, update)
        }
        
        
        private function update(e:Event):void{
            _bmd.draw(_sp)
            _bmd.applyFilter(_bmd, _bmd.rect, new Point(), _filter);
        }
        
        private function modeChange(n:int, flg:Boolean):void{
            if(flg){
                _bm.blendMode = _blendModeList[n]
            }else{
                _bm.blendMode = "normal"
            }
            _matrix = _matrixList[n]
            _filter = new ConvolutionFilter();
            _filter.matrixX = _matrixPixcelList[n];
            _filter.matrixY = _matrixPixcelList[n];
            _filter.divisor = _divisorList[n]; 
            _filter.bias = _biasList[n]; 
            _filter.matrix = _matrix;
        }

    }
}


//class CameraCapture
import flash.events.ActivityEvent;
import flash.events.Event;
import flash.media.Camera;
import flash.display.Sprite;
import flash.media.Video;

class CameraCapture extends Video{
    private var _cam:Camera;
    private var _camW:Number
    private var _camH:Number
    private var _fps:Number
    private var _activityThreshold:Number
    private var _actLevel:int
    public static const ACTIVE:String = "active"
    public static const INACTIVE:String = "inactive"

    public function CameraCapture(camW:Number, camH:Number, fps:Number=15, activityThreshold:Number=10) {
        this.width = camW
        this.height = camH
        _camW = camW
        _camH = camH
        _fps = fps
        _activityThreshold = activityThreshold
        setUpCamera();
    }

    private function setUpCamera():void {
        _cam = Camera.getCamera();
        _cam.setMode(_camW, _camH, _fps);
        this.attachCamera(_cam);
        _cam.addEventListener(ActivityEvent.ACTIVITY, CamActivityCheck);
    }
        
    private function CamActivityCheck(e:ActivityEvent):void {
        if (_cam.activityLevel >= _activityThreshold) {
            dispatchEvent(new Event(CameraCapture.ACTIVE))
        } else {
            dispatchEvent(new Event(CameraCapture.INACTIVE))
        }
        _actLevel = _cam.activityLevel
    }
        
    public function get actLevel():Number{
        return _actLevel
    }
        
}