/**
 * Copyright yuuma23 ( http://wonderfl.net/user/yuuma23 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rmn1
 */

// forked from umhr's (4.3)twitterの検索
/*
 * 
 * */

package 
{
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.KeyboardEvent;
	import flash.net.URLRequest;
	import flash.net.URLLoader;
	import flash.text.TextField;
	import flash.text.TextFieldType;
	/**
	 * ...
	 * @author umhr
	 */
	[SWF(backgroundColor="0xFFFFFF")]
	public class Main extends Sprite 
	{
		private var _resultStage:Sprite = new Sprite();
		public function Main():void 
		{
			//ヘッダーのサーチエリア
			//背景
			var titleArea:Shape = new Shape();
			titleArea.graphics.beginFill(0xFFFFFF);
			titleArea.graphics.drawRect(0, 0, 465, 24);
			addChild(titleArea);
			//Serchの文字
			var serchWord:TextField = new TextField();
			serchWord.text = "★ ツイット検索";
			serchWord.width = 88;
			serchWord.height = 18;
			serchWord.x = 2;
			serchWord.y = 2;
			serchWord.textColor = 0x463EDF;
			addChild(serchWord);
			//テキスト入力欄。キーボードのキーを押し上げた際にonKeyUpが実行される
			var title:TextField = new TextField();
			title.text = "名月 酒";
			title.width = 299;
			title.height = 19;
			title.x = 97;
			title.y = 2;
			title.border = true;
			title.borderColor = 0xDCDCDC;
			title.background = true;
			title.backgroundColor = 0xFFFFF2;
			title.type = TextFieldType.INPUT;
			title.addEventListener(KeyboardEvent.KEY_UP, onKeyUp);
			addChild(title);
			
			//検索結果を配置するSpriteをaddChild
			_resultStage.y = 35;
			addChild(_resultStage);
			
			//初期状態で検索結果画面が出るように、検索を実行する。
			serch(title.text);
		}
		
		private function onKeyUp(e:KeyboardEvent):void
		{
			//Enterキーのキーコード13だったら、serchメソッドを実行。引数には適すと入力欄の文字列
			if (e.keyCode == 13) {
				serch(e.currentTarget.text)
			}
		}
		
		public function serch(serchWord:String):void
		{
			//検索APIにリクエストを投げる
			var myURLLoader:URLLoader = new URLLoader();
			myURLLoader.addEventListener (Event.COMPLETE, onComplete);
			var URLstr:String = "http://search.twitter.com/search.atom?q=";
			//encodeURIComponent()を使うことによって、#や日本語（２バイト文字）にも対応
			URLstr += encodeURIComponent(serchWord);
			myURLLoader.load(new URLRequest(URLstr));
		}
           
		private function onComplete(e:Event):void 
		{
			//eventListenerを削除
			e.currentTarget.removeEventListener(Event.COMPLETE, onComplete);
			//_resultStage上のオブジェクトを全て削除
			while (_resultStage.numChildren) {
				_resultStage.removeChildAt(0);
			}
			
			//XML型にキャスト
			var myXML:XML = new XML(e.currentTarget.data);
			//namespaceを設定
			default xml namespace = new Namespace("http://www.w3.org/2005/Atom");
			
			//ヘッダーの下
			var tfY:int = 0;
			//要素を取り出して、textFieldを作りならべる
			var itemLength:int = myXML.entry.length();
			
			for (var i:int = 0; i < itemLength; i++) {
				//xmlからlink,authorName,titleの各値を取得
				var link:String = myXML.entry[i].link[0].@href;
				var authorName:String = myXML.entry[i].author.name;
				var title:String = myXML.entry[i].title;
				//アイコンの画像名を取得
				var imgURL:String = myXML.entry[i].link[1].@href;
				//bmpフォーマットのアイコン画像を使っている人も少なくないため、Flashで使えるファイルの拡張子かどうかを判別
				var extention:String = imgURL.substr( -4);
				extention = extention.toLowerCase();
				if (extention != ".jpg" && extention != ".gif" && extention != ".png") {
					//Flashで使える画像の拡張子ではなかった場合にはデフォルトアイコンを指定
					imgURL = "http://s.twimg.com/a/1254440757/images/default_profile_mini.png";
				}
				//小さい画像で十分なので、名前を差し替える
				imgURL = imgURL.replace(/_normal\./, "_mini\.");
				//画像のファイル名が２バイト文字である場合を考慮しエンコードする
				imgURL = encodeURI(imgURL);
				
				//得られた各値をhtmlTextに入るように整形
				var htmldata:String = "";
				htmldata = "<a href='" + link + "' target='_blank'>";
				htmldata += "<img src='" + imgURL + "' width='24' height='24' />";
				htmldata += "<b>" + authorName + "</b> " + title + "</a>";
				
				//検索結果のテキストフィールド
				var myTextField:TextField = new TextField();
				myTextField.width = 450;
				myTextField.x = 2;
				myTextField.wordWrap = true;
				myTextField.background = true;
				myTextField.backgroundColor = 0xFFFFFF;
				myTextField.border = true;
				myTextField.borderColor = 0xF2FBFB;
				myTextField.htmlText = htmldata;
				myTextField.autoSize = "left";
				//テキストフィールドのy座標はtfYに加算していくことにより、決定
				myTextField.y = tfY;
				tfY += myTextField.height + 4;
				_resultStage.addChild(myTextField);
			}
		}
	}
}