/**
 * Copyright antalg ( http://wonderfl.net/user/antalg )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rlyb
 */

package {
    import flash.events.MouseEvent;
    import flash.text.TextField;
    import flash.display.Sprite;
    
    public class Test extends Sprite {
        public function Test() {
            // write as3 code here..
            
            var map:Array = genMap(40,40);
            addChild(render(map, 10, 10));
            
            stage.addEventListener(MouseEvent.CLICK, genNew);
        }   
        
        private function genNew(e:MouseEvent):void {
            var map:Array = genMap(40,40);
            addChild(render(map, 10, 10));
        }
        
        private function genMap(w:int, h:int):Array {
            var map:Array = new Array();
            var last:int = 0;
            
            for(var x:int = 0; x<w; x++) {
                map.push(new Array());
                for(var y:int = 0; y<h; y++) {
                    
                    var val:int = int(Math.random()*5);
                    
                    if(last == 0) {
                        if(val == 0)
                            map[x].push(1);
                        else
                            map[x].push(0);
                    } else {
                        if(val == 0)
                            map[x].push(0);
                        else
                            map[x].push(1);
                    }
                    last = map[x][y];
                }
            }
            
            return map;
        }
        
        private function render(ar:Array, w:int, h:int):Sprite {
            var mapSpr:Sprite = new Sprite();
            
            for(var x:int = 0; x<ar.length; x++) {
                for(var y:int = 0; y<ar[0].length; y++) {
                    var spr:Sprite;
                    
                    switch(ar[x][y]) {
                        case 0:
                            spr = block(0x777777, w, h);
                            break;
                        case 1:
                            spr = block(0x333333, w, h);
                            break;
                        default:
                            throw new Error("Unknown map value!");
                    }
                    
                    mapSpr.addChild(spr);
                    
                    spr.x = w*x;
                    spr.y = h*y;
                }
            }
            
            return mapSpr;
        }
        
        private function block(color:uint, w:int, h:int):Sprite {
            var spr:Sprite = new Sprite();
            
            spr.graphics.beginFill(color);
            spr.graphics.drawRect(0,0,w,h);
            spr.graphics.endFill();
            
            return spr;
        }
    }
}