/**
 * Copyright kotobuki ( http://wonderfl.net/user/kotobuki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rlxZ
 */

// forked from kotobuki's forked from: RGBCube for AS3
// forked from kotobuki's RGBCube for AS3
package {
    import flash.events.Event;

    import org.papervision3d.cameras.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.objects.*;
    import org.papervision3d.objects.primitives.Cube;
    import org.papervision3d.scenes.*;
    import org.papervision3d.view.*;

    import funnel.*;
    import funnel.gui.*;

    [SWF(backgroundColor="0x808080")]

    public class MeasuringTheTilt_Accelerometer extends BasicView {
        // 立方体
        private var cube:Cube;

        private var fioSystem:Fio;
        private var fio:IOModule;

        // 加速度センサのx軸を接続したアナログピン
        private var xAxisPin:Pin;

        // 加速度センサのy軸を接続したアナログピン
        private var yAxisPin:Pin;
    
        public function MeasuringTheTilt_Accelerometer() {
            var config:Configuration = Fio.FIRMATA;

            // 必要ないアナログ入力をすべて出力にセットする
            // これによりデータの転送量が少なくなりレスポンスが良くなる
            // （ArduinoではA0、A1…はD14、D15に対応する）
            config.setDigitalPinMode(17, OUT);    // A3
            config.setDigitalPinMode(18, OUT);    // A4
            config.setDigitalPinMode(19, OUT);    // A5
            config.setDigitalPinMode(20, OUT);    // A6
            config.setDigitalPinMode(21, OUT);    // A7
            fioSystem = new Fio([1], config);
            fio = fioSystem.ioModule(1);

            xAxisPin = fio.analogPin(2);
            yAxisPin = fio.analogPin(1);

            // 2つの軸のそれぞれにフィルタをセット
            // ・細かな変動を取り除くための移動平均フィルタ
            // ・-1Gから1Gまでの変化を-1から1までにスケーリングするためのフィルタ
            xAxisPin.addFilter(new Convolution(Convolution.MOVING_AVERAGE));
            xAxisPin.addFilter(new Scaler(0.30, 0.70, -1, 1));
            yAxisPin.addFilter(new Convolution(Convolution.MOVING_AVERAGE));
            yAxisPin.addFilter(new Scaler(0.30, 0.70, -1, 1));

            // 立方体のためのマテリアルを準備
            var materialsList:MaterialsList = new MaterialsList();
            materialsList.addMaterial(new ColorMaterial(0xFF0000), "front");
            materialsList.addMaterial(new ColorMaterial(0x00FF00), "back");
            materialsList.addMaterial(new ColorMaterial(0x0000FF), "right");
            materialsList.addMaterial(new ColorMaterial(0xFFFF00), "left");
            materialsList.addMaterial(new ColorMaterial(0xFF00FF), "top");
            materialsList.addMaterial(new ColorMaterial(0x00FFFF), "bottom");

            // 立方体のインスタンスを生成
            cube = new Cube(materialsList, 200, 200, 200);
            scene.addChild(cube);

            // カメラをセット
            camera.x = 0;
            camera.y = 0;
            camera.z = -500;
            camera.focus = 500;
            camera.zoom = 1;

            var gui:ArduinoGUI = new ArduinoGUI();
            addChild(gui);
            fio.gui = gui;
      
            // レンダリング開始
            startRendering();
        }

        override protected function onRenderTick(event:Event = null):void {
            // 立方体の角度をセット
            cube.rotationZ = Math.asin(yAxisPin.value) / Math.PI * 180;;
            cube.rotationX = Math.asin(xAxisPin.value) / Math.PI * 180;;

            // シーンをレンダリング
            renderer.renderScene(scene, camera, viewport);
        }
    }
}