/**
 * Copyright kotobuki ( http://wonderfl.net/user/kotobuki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rlPX
 */

// forked from kotobuki's Gainer Basic Example: SignalScope
// A very basic SignalScope example
// 3 analog input channels version
// 
// Reference
// http://funnel.cc/Software/ActionScript3

package {
    import flash.display.Sprite;
    import flash.events.Event;
    
    import funnel.*;
    import funnel.gui.*;

    [SWF(backgroundColor="0x808080")]

    public class GainerTest extends Sprite {
        private const NUM_CHANNELS:int = 3;

        private var gio:Gainer;
        private var scopes:Array;

        public function GainerTest() {
            gio = new Gainer();

            scopes = new Array(NUM_CHANNELS);
            for (var i:int = 0; i < NUM_CHANNELS; i++) {
                scopes[i] = new SignalScope(0, 0 + (53 * i), 200, "ain " + i);
                addChild(scopes[i]);
            }

            var gui:GainerGUI = new GainerGUI();
            addChild(gui);
            gio.gui = gui;
            gui.setPosition(IOModuleGUI.LEFT_BOTTOM);

            addEventListener(Event.ENTER_FRAME, loop);
        }

        private function loop(event:Event):void {
            for (var i:int = 0; i < NUM_CHANNELS; i++) {
                scopes[i].update(gio.analogInput(i));
            }
        }
    }
}
