/**
 * Copyright ThatsAsif ( http://wonderfl.net/user/ThatsAsif )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rksC
 */

package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.GlowFilter;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.text.TextFormatAlign;
    
    /**
     * ...
     * @author Asif Maknojia
     */
    [SWF(width="465",height="465",frameRate="60",backgroundColor="0x000000")]
    
    public class Main extends Sprite {
        
        public function Main():void {
            if (stage)
                init();
            else
                addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            var textFormat:TextFormat = new TextFormat();
            textFormat.font = "Times New Roman";
            textFormat.size = "30";
            textFormat.align = TextFormatAlign.JUSTIFY;
            
            var textArray:Array = new Array();
            textArray.push("Hello");
            textArray.push("THIS IS");
            textArray.push("GlowingText");
            textArray.push("Effect");
            
            var glowparams:Array = new Array();
            glowparams.push(["Lazy", 0x00b014, 0.05, 0, 5, false]);
            glowparams.push(["Normal", 0x7800a7, 0.2, 0, 5, false]);
            glowparams.push(["HyperActive", 0xff00ff, 0.8, 0, 8, false]);
            glowparams.push(["Random Color", 0xff00ff, 0.3, 0, 8, true]);
            glowparams.push(["No Glow Change & No Color", 0xff00, 0, 5, 5, false]);
            glowparams.push(["No Glow Change & Random Color", 0xff00ff, 0.1, 2, 2, true]);
            glowparams.push(["Big Glow", 0xff00ff, 0.3, 0, 28, true]);
            glowparams.push(["--New Feature Below Random Text--", 0xffffff, 0, 0, 5, false]);
            glowparams.push(["", 0xff00ff, 0.05, 0, 5, true, textArray]);
            
            for (var i:Number = 0; i < glowparams.length; i++){
                var txt:TextField = new TextField();
                txt.autoSize = "center";
                txt.defaultTextFormat = textFormat;
                addChild(txt);
                txt.text = glowparams[i][0];
                txt.x = stage.stageWidth / 2 - txt.width / 2;
                txt.y = -txt.height + (i * 20) + (i*30);
                GlowingText.setGlow(txt, glowparams[i][1], glowparams[i][2], glowparams[i][3], glowparams[i][4], glowparams[i][5], glowparams[i][6]);
            }
        }
    
    }
}

    
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.filters.GlowFilter;
    import flash.text.TextField;
    import flash.text.TextFormat;
    import flash.text.TextFormatAlign;
    
    class GlowingText {
        //Variable use to set the strength in animation.
        private var initStrength:Number = 1;
        //Speed of the animation.
        private var speed:Number = .2;
        //Max strength of the glow.
        private var maxStrength:Number = 5;
        //Min strength of the glow.    
        private var minStrength:Number = 0;
        //Default color of the glow anim.
        private var color:uint = 0xff0000;
        //Glow filter to apply the text.
        private var glow:GlowFilter;
        //Boolean Variable to check whether to increase or decrease the glow.
        private var inc:Boolean = false;
        //Boolean Variable to check whether random color or not.
        private var rndColor:Boolean = false;
        //Textfield for displaying text.
        private var strText:TextField = new TextField();;
        private var textFormat:TextFormat;
        
        private var textArray:Array = [];
        private var currentText:int = 0;
        
        private static var gt:GlowingText;
                
        public static function setGlow(txt:TextField, col:uint = 0xff0000, speed:Number = 0.2, minstrength:Number = 0, maxstrength:Number = 5, randomcolor:Boolean = false, txtArray:Array = null):void {
            gt = new GlowingText();
            gt.addText(txt, col, speed, minstrength, maxstrength, randomcolor, txtArray);
        }
        
        private function addText(txt:TextField, col:uint = 0xff0000, speed:Number = 0.2, minstrength:Number = 0, maxstrength:Number = 5, randomcolor:Boolean = false, txtArray:Array = null):void {
            this.color = col;
            this.speed = speed;
            this.minStrength = minstrength;
            this.maxStrength = maxstrength;
            this.rndColor = randomcolor;
            
            glow = new GlowFilter(color, 1, 10, 10, initStrength, 3, false, true);
            strText = txt;
            
            if (txtArray != null) {
                this.textArray = txtArray;
                strText.text = textArray[currentText];
            }
            
            strText.filters = [glow];
            if ((minstrength == maxstrength) && (randomcolor == false)) { 
                return; 
                };
            strText.addEventListener(Event.ENTER_FRAME, EnterFrameHandler);
        }
        
        private function EnterFrameHandler(evt:Event):void {
            if (initStrength > maxStrength){
                inc = true;
            } else if (initStrength < minStrength){
                inc = false;
                if (rndColor == true){
                    color = Math.random() * 0xFFFFFF;
                }
                if (textArray.length > 0) {
                    currentText++;
                    if (currentText == textArray.length) currentText = 0;
                    strText.text = textArray[currentText];
                }
                
            }
            
            if (inc == false){
                initStrength += speed;
            } else if (inc == true){
                initStrength -= speed;
            }
            
            changeGlow();
            
            strText.filters = [glow];
        }
        
        private function changeGlow():void {
            glow.color = color
            glow.blurX = 2 + initStrength;
            glow.blurY = 2 + initStrength;
            glow.strength = initStrength;
        }
    }