/**
 * Copyright _ryotaros ( http://wonderfl.net/user/_ryotaros )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rkry
 */

// forked from _ryotaros's flash on 2010-1-24
package {
	import flash.accessibility.Accessibility;
	import flash.events.Event;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        
        public var ballNum:int = 5;
        
        public var spring:Number = 0.025;
        public var springLength:Number = 20;
        public var friction:Number = 0.8;
        public var gravity:Number = 1;
        public var balls:Array;
        
        public function FlashTest() {
			   init();      
        }
        
        public function init():void{
        		
        	 	balls = [];
        	 	for (var i:int = 0; i < ballNum;i++){
        	 			balls[i] = new ball(Math.random()*10+10, 0xFFFF00);
        	 			addChild(balls[i]);
        	 			balls[i].x = Math.random()*stage.stageWidth;
        	 			balls[i].y = Math.random()*stage.stageHeight;
        	 	}
        	 	
        	 	addEventListener(Event.ENTER_FRAME, enterframe);
        	 	
        }
        
        public function enterframe(e:Event):void{
        		
        		graphics.clear();
        		
        		moveTo(balls[0], mouseX, mouseY);	
        		for(var i:int = 1; i < ballNum; i++){
        			moveTo(balls[i], balls[i-1].x, balls[i-1].y);	
        		}
        		
        }
        
        public function moveTo(ball:ball, tX:Number, tY:Number ):void {

        		var dx:Number = ball.x - tX;
        		var dy:Number = ball.y - tY;
        		var angle:Number = Math.atan2(dy, dx);
        		var targetX:Number = tX + Math.cos(angle) * springLength;
        		var targetY:Number = tY + Math.sin(angle) * springLength;
        		
        		ball.vx += (targetX - ball.x) * spring;
        		ball.vy += (targetY - ball.y) * spring;
        		ball.vx *= friction;
        		ball.vy *= friction;
        		
        		ball.vy += gravity;
        		
        		ball.x += ball.vx;
        		ball.y += ball.vy;
        		
        		
        		graphics.lineStyle(1);
        		graphics.moveTo(ball.x, ball.y);
        		graphics.lineTo(tX, tY);
        		
        }
        
    }
}
import flash.display.Sprite;

class ball extends Sprite {
	
	public var radius:int;
	public var color:uint;
	public var vx:Number = 0;
	public var vy:Number = 0;
		
	public function ball (rad:int =10,clr:uint=0x000000):void {
		this.radius = rad;
		this.color = clr;
		init();
	}
	
	public function init():void{
		graphics.beginFill(color);
		graphics.drawCircle(0,0,radius);
		graphics.endFill();	
	}
}