package {
	import flash.display.Sprite;
	
	/**
	* World map :)
	* @author makc
	* @license WTFPLv2, http://sam.zoy.org/wtfpl/
	*/
	public class WorldMap extends Sprite {
		
		public function WorldMap () {
			graphics.lineStyle (0);
			var lines:Array = world.toString().split("\n");
			for each (var line:String in lines) {
				var a:Array = line.split (" ");
				if (a.length > 2) {
					switch (a [2].charAt (0)) {
						case "m":
							graphics.endFill ();
							graphics.beginFill (0xFFFFFF * Math.random ());
							graphics.moveTo (465 * parseFloat (a[0]), 465 * (0.5 - parseFloat (a[1])));
							break;
						case "L":
							graphics.lineTo (465 * parseFloat (a[0]), 465 * (0.5 - parseFloat (a[1])));
							break;
						default:
					}
				}
			}
			trace (0)
		}

		/**
		 * Robinson Projection World Map  (J. Novak)
		 * http://library.wolfram.com/infocenter/Demos/4664/gallery.nb
		 */
		public var world:XML = <world>%!
%%Creator: Mathematica
%%AspectRatio: .5 
MathPictureStart
%% Graphics
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 4.409171e-05 0.25 4.409171e-05 [
[ 0 0 0 0 ]
[ 1 .5 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
[ ] 0 setdash
0 g
p
P
0 0 m
1 0 L
1 .5 L
0 .5 L
closepath
clip
newpath
p
p
P
p
p
.001 w
.02381 .0119 m
.02381 .02143 L
.02381 .03095 L
.02381 .04048 L
.02381 .05 L
.02381 .05952 L
.02381 .06905 L
.02381 .07857 L
.02381 .0881 L
.02381 .09762 L
.02381 .10714 L
.02381 .11667 L
.02381 .12619 L
.02381 .13571 L
.02381 .14524 L
.02381 .15476 L
.02381 .16429 L
.02381 .17381 L
.02381 .18333 L
.02381 .19286 L
.02381 .20238 L
.02381 .2119 L
.02381 .22143 L
.02381 .23095 L
.02381 .24048 L
.02381 .25 L
.02381 .25952 L
.02381 .26905 L
.02381 .27857 L
.02381 .2881 L
.02381 .29762 L
.02381 .30714 L
.02381 .31667 L
.02381 .32619 L
.02381 .33571 L
.02381 .34524 L
.02381 .35476 L
.02381 .36429 L
.02381 .37381 L
.02381 .38333 L
.02381 .39286 L
.02381 .40238 L
.02381 .4119 L
.02381 .42143 L
.02381 .43095 L
.02381 .44048 L
.02381 .45 L
.02381 .45952 L
.02381 .46905 L
.02381 .47857 L
Mistroke
.02381 .4881 L
.02381 .4881 L
Mfstroke
.10317 .0119 m
.10317 .02143 L
.10317 .03095 L
.10317 .04048 L
.10317 .05 L
.10317 .05952 L
.10317 .06905 L
.10317 .07857 L
.10317 .0881 L
.10317 .09762 L
.10317 .10714 L
.10317 .11667 L
.10317 .12619 L
.10317 .13571 L
.10317 .14524 L
.10317 .15476 L
.10317 .16429 L
.10317 .17381 L
.10317 .18333 L
.10317 .19286 L
.10317 .20238 L
.10317 .2119 L
.10317 .22143 L
.10317 .23095 L
.10317 .24048 L
.10317 .25 L
.10317 .25952 L
.10317 .26905 L
.10317 .27857 L
.10317 .2881 L
.10317 .29762 L
.10317 .30714 L
.10317 .31667 L
.10317 .32619 L
.10317 .33571 L
.10317 .34524 L
.10317 .35476 L
.10317 .36429 L
.10317 .37381 L
.10317 .38333 L
.10317 .39286 L
.10317 .40238 L
.10317 .4119 L
.10317 .42143 L
.10317 .43095 L
.10317 .44048 L
.10317 .45 L
.10317 .45952 L
.10317 .46905 L
.10317 .47857 L
Mistroke
.10317 .4881 L
.10317 .4881 L
Mfstroke
.18254 .0119 m
.18254 .02143 L
.18254 .03095 L
.18254 .04048 L
.18254 .05 L
.18254 .05952 L
.18254 .06905 L
.18254 .07857 L
.18254 .0881 L
.18254 .09762 L
.18254 .10714 L
.18254 .11667 L
.18254 .12619 L
.18254 .13571 L
.18254 .14524 L
.18254 .15476 L
.18254 .16429 L
.18254 .17381 L
.18254 .18333 L
.18254 .19286 L
.18254 .20238 L
.18254 .2119 L
.18254 .22143 L
.18254 .23095 L
.18254 .24048 L
.18254 .25 L
.18254 .25952 L
.18254 .26905 L
.18254 .27857 L
.18254 .2881 L
.18254 .29762 L
.18254 .30714 L
.18254 .31667 L
.18254 .32619 L
.18254 .33571 L
.18254 .34524 L
.18254 .35476 L
.18254 .36429 L
.18254 .37381 L
.18254 .38333 L
.18254 .39286 L
.18254 .40238 L
.18254 .4119 L
.18254 .42143 L
.18254 .43095 L
.18254 .44048 L
.18254 .45 L
.18254 .45952 L
.18254 .46905 L
.18254 .47857 L
Mistroke
.18254 .4881 L
.18254 .4881 L
Mfstroke
.2619 .0119 m
.2619 .02143 L
.2619 .03095 L
.2619 .04048 L
.2619 .05 L
.2619 .05952 L
.2619 .06905 L
.2619 .07857 L
.2619 .0881 L
.2619 .09762 L
.2619 .10714 L
.2619 .11667 L
.2619 .12619 L
.2619 .13571 L
.2619 .14524 L
.2619 .15476 L
.2619 .16429 L
.2619 .17381 L
.2619 .18333 L
.2619 .19286 L
.2619 .20238 L
.2619 .2119 L
.2619 .22143 L
.2619 .23095 L
.2619 .24048 L
.2619 .25 L
.2619 .25952 L
.2619 .26905 L
.2619 .27857 L
.2619 .2881 L
.2619 .29762 L
.2619 .30714 L
.2619 .31667 L
.2619 .32619 L
.2619 .33571 L
.2619 .34524 L
.2619 .35476 L
.2619 .36429 L
.2619 .37381 L
.2619 .38333 L
.2619 .39286 L
.2619 .40238 L
.2619 .4119 L
.2619 .42143 L
.2619 .43095 L
.2619 .44048 L
.2619 .45 L
.2619 .45952 L
.2619 .46905 L
.2619 .47857 L
Mistroke
.2619 .4881 L
.2619 .4881 L
Mfstroke
.34127 .0119 m
.34127 .02143 L
.34127 .03095 L
.34127 .04048 L
.34127 .05 L
.34127 .05952 L
.34127 .06905 L
.34127 .07857 L
.34127 .0881 L
.34127 .09762 L
.34127 .10714 L
.34127 .11667 L
.34127 .12619 L
.34127 .13571 L
.34127 .14524 L
.34127 .15476 L
.34127 .16429 L
.34127 .17381 L
.34127 .18333 L
.34127 .19286 L
.34127 .20238 L
.34127 .2119 L
.34127 .22143 L
.34127 .23095 L
.34127 .24048 L
.34127 .25 L
.34127 .25952 L
.34127 .26905 L
.34127 .27857 L
.34127 .2881 L
.34127 .29762 L
.34127 .30714 L
.34127 .31667 L
.34127 .32619 L
.34127 .33571 L
.34127 .34524 L
.34127 .35476 L
.34127 .36429 L
.34127 .37381 L
.34127 .38333 L
.34127 .39286 L
.34127 .40238 L
.34127 .4119 L
.34127 .42143 L
.34127 .43095 L
.34127 .44048 L
.34127 .45 L
.34127 .45952 L
.34127 .46905 L
.34127 .47857 L
Mistroke
.34127 .4881 L
.34127 .4881 L
Mfstroke
.42063 .0119 m
.42063 .02143 L
.42063 .03095 L
.42063 .04048 L
.42063 .05 L
.42063 .05952 L
.42063 .06905 L
.42063 .07857 L
.42063 .0881 L
.42063 .09762 L
.42063 .10714 L
.42063 .11667 L
.42063 .12619 L
.42063 .13571 L
.42063 .14524 L
.42063 .15476 L
.42063 .16429 L
.42063 .17381 L
.42063 .18333 L
.42063 .19286 L
.42063 .20238 L
.42063 .2119 L
.42063 .22143 L
.42063 .23095 L
.42063 .24048 L
.42063 .25 L
.42063 .25952 L
.42063 .26905 L
.42063 .27857 L
.42063 .2881 L
.42063 .29762 L
.42063 .30714 L
.42063 .31667 L
.42063 .32619 L
.42063 .33571 L
.42063 .34524 L
.42063 .35476 L
.42063 .36429 L
.42063 .37381 L
.42063 .38333 L
.42063 .39286 L
.42063 .40238 L
.42063 .4119 L
.42063 .42143 L
.42063 .43095 L
.42063 .44048 L
.42063 .45 L
.42063 .45952 L
.42063 .46905 L
.42063 .47857 L
Mistroke
.42063 .4881 L
.42063 .4881 L
Mfstroke
.5 .0119 m
.5 .02143 L
.5 .03095 L
.5 .04048 L
.5 .05 L
.5 .05952 L
.5 .06905 L
.5 .07857 L
.5 .0881 L
.5 .09762 L
.5 .10714 L
.5 .11667 L
.5 .12619 L
.5 .13571 L
.5 .14524 L
.5 .15476 L
.5 .16429 L
.5 .17381 L
.5 .18333 L
.5 .19286 L
.5 .20238 L
.5 .2119 L
.5 .22143 L
.5 .23095 L
.5 .24048 L
.5 .25 L
.5 .25952 L
.5 .26905 L
.5 .27857 L
.5 .2881 L
.5 .29762 L
.5 .30714 L
.5 .31667 L
.5 .32619 L
.5 .33571 L
.5 .34524 L
.5 .35476 L
.5 .36429 L
.5 .37381 L
.5 .38333 L
.5 .39286 L
.5 .40238 L
.5 .4119 L
.5 .42143 L
.5 .43095 L
.5 .44048 L
.5 .45 L
.5 .45952 L
.5 .46905 L
.5 .47857 L
Mistroke
.5 .4881 L
.5 .4881 L
Mfstroke
.57937 .0119 m
.57937 .02143 L
.57937 .03095 L
.57937 .04048 L
.57937 .05 L
.57937 .05952 L
.57937 .06905 L
.57937 .07857 L
.57937 .0881 L
.57937 .09762 L
.57937 .10714 L
.57937 .11667 L
.57937 .12619 L
.57937 .13571 L
.57937 .14524 L
.57937 .15476 L
.57937 .16429 L
.57937 .17381 L
.57937 .18333 L
.57937 .19286 L
.57937 .20238 L
.57937 .2119 L
.57937 .22143 L
.57937 .23095 L
.57937 .24048 L
.57937 .25 L
.57937 .25952 L
.57937 .26905 L
.57937 .27857 L
.57937 .2881 L
.57937 .29762 L
.57937 .30714 L
.57937 .31667 L
.57937 .32619 L
.57937 .33571 L
.57937 .34524 L
.57937 .35476 L
.57937 .36429 L
.57937 .37381 L
.57937 .38333 L
.57937 .39286 L
.57937 .40238 L
.57937 .4119 L
.57937 .42143 L
.57937 .43095 L
.57937 .44048 L
.57937 .45 L
.57937 .45952 L
.57937 .46905 L
.57937 .47857 L
Mistroke
.57937 .4881 L
.57937 .4881 L
Mfstroke
.65873 .0119 m
.65873 .02143 L
.65873 .03095 L
.65873 .04048 L
.65873 .05 L
.65873 .05952 L
.65873 .06905 L
.65873 .07857 L
.65873 .0881 L
.65873 .09762 L
.65873 .10714 L
.65873 .11667 L
.65873 .12619 L
.65873 .13571 L
.65873 .14524 L
.65873 .15476 L
.65873 .16429 L
.65873 .17381 L
.65873 .18333 L
.65873 .19286 L
.65873 .20238 L
.65873 .2119 L
.65873 .22143 L
.65873 .23095 L
.65873 .24048 L
.65873 .25 L
.65873 .25952 L
.65873 .26905 L
.65873 .27857 L
.65873 .2881 L
.65873 .29762 L
.65873 .30714 L
.65873 .31667 L
.65873 .32619 L
.65873 .33571 L
.65873 .34524 L
.65873 .35476 L
.65873 .36429 L
.65873 .37381 L
.65873 .38333 L
.65873 .39286 L
.65873 .40238 L
.65873 .4119 L
.65873 .42143 L
.65873 .43095 L
.65873 .44048 L
.65873 .45 L
.65873 .45952 L
.65873 .46905 L
.65873 .47857 L
Mistroke
.65873 .4881 L
.65873 .4881 L
Mfstroke
.7381 .0119 m
.7381 .02143 L
.7381 .03095 L
.7381 .04048 L
.7381 .05 L
.7381 .05952 L
.7381 .06905 L
.7381 .07857 L
.7381 .0881 L
.7381 .09762 L
.7381 .10714 L
.7381 .11667 L
.7381 .12619 L
.7381 .13571 L
.7381 .14524 L
.7381 .15476 L
.7381 .16429 L
.7381 .17381 L
.7381 .18333 L
.7381 .19286 L
.7381 .20238 L
.7381 .2119 L
.7381 .22143 L
.7381 .23095 L
.7381 .24048 L
.7381 .25 L
.7381 .25952 L
.7381 .26905 L
.7381 .27857 L
.7381 .2881 L
.7381 .29762 L
.7381 .30714 L
.7381 .31667 L
.7381 .32619 L
.7381 .33571 L
.7381 .34524 L
.7381 .35476 L
.7381 .36429 L
.7381 .37381 L
.7381 .38333 L
.7381 .39286 L
.7381 .40238 L
.7381 .4119 L
.7381 .42143 L
.7381 .43095 L
.7381 .44048 L
.7381 .45 L
.7381 .45952 L
.7381 .46905 L
.7381 .47857 L
Mistroke
.7381 .4881 L
.7381 .4881 L
Mfstroke
.81746 .0119 m
.81746 .02143 L
.81746 .03095 L
.81746 .04048 L
.81746 .05 L
.81746 .05952 L
.81746 .06905 L
.81746 .07857 L
.81746 .0881 L
.81746 .09762 L
.81746 .10714 L
.81746 .11667 L
.81746 .12619 L
.81746 .13571 L
.81746 .14524 L
.81746 .15476 L
.81746 .16429 L
.81746 .17381 L
.81746 .18333 L
.81746 .19286 L
.81746 .20238 L
.81746 .2119 L
.81746 .22143 L
.81746 .23095 L
.81746 .24048 L
.81746 .25 L
.81746 .25952 L
.81746 .26905 L
.81746 .27857 L
.81746 .2881 L
.81746 .29762 L
.81746 .30714 L
.81746 .31667 L
.81746 .32619 L
.81746 .33571 L
.81746 .34524 L
.81746 .35476 L
.81746 .36429 L
.81746 .37381 L
.81746 .38333 L
.81746 .39286 L
.81746 .40238 L
.81746 .4119 L
.81746 .42143 L
.81746 .43095 L
.81746 .44048 L
.81746 .45 L
.81746 .45952 L
.81746 .46905 L
.81746 .47857 L
Mistroke
.81746 .4881 L
.81746 .4881 L
Mfstroke
.89683 .0119 m
.89683 .02143 L
.89683 .03095 L
.89683 .04048 L
.89683 .05 L
.89683 .05952 L
.89683 .06905 L
.89683 .07857 L
.89683 .0881 L
.89683 .09762 L
.89683 .10714 L
.89683 .11667 L
.89683 .12619 L
.89683 .13571 L
.89683 .14524 L
.89683 .15476 L
.89683 .16429 L
.89683 .17381 L
.89683 .18333 L
.89683 .19286 L
.89683 .20238 L
.89683 .2119 L
.89683 .22143 L
.89683 .23095 L
.89683 .24048 L
.89683 .25 L
.89683 .25952 L
.89683 .26905 L
.89683 .27857 L
.89683 .2881 L
.89683 .29762 L
.89683 .30714 L
.89683 .31667 L
.89683 .32619 L
.89683 .33571 L
.89683 .34524 L
.89683 .35476 L
.89683 .36429 L
.89683 .37381 L
.89683 .38333 L
.89683 .39286 L
.89683 .40238 L
.89683 .4119 L
.89683 .42143 L
.89683 .43095 L
.89683 .44048 L
.89683 .45 L
.89683 .45952 L
.89683 .46905 L
.89683 .47857 L
Mistroke
.89683 .4881 L
.89683 .4881 L
Mfstroke
.97619 .0119 m
.97619 .02143 L
.97619 .03095 L
.97619 .04048 L
.97619 .05 L
.97619 .05952 L
.97619 .06905 L
.97619 .07857 L
.97619 .0881 L
.97619 .09762 L
.97619 .10714 L
.97619 .11667 L
.97619 .12619 L
.97619 .13571 L
.97619 .14524 L
.97619 .15476 L
.97619 .16429 L
.97619 .17381 L
.97619 .18333 L
.97619 .19286 L
.97619 .20238 L
.97619 .2119 L
.97619 .22143 L
.97619 .23095 L
.97619 .24048 L
.97619 .25 L
.97619 .25952 L
.97619 .26905 L
.97619 .27857 L
.97619 .2881 L
.97619 .29762 L
.97619 .30714 L
.97619 .31667 L
.97619 .32619 L
.97619 .33571 L
.97619 .34524 L
.97619 .35476 L
.97619 .36429 L
.97619 .37381 L
.97619 .38333 L
.97619 .39286 L
.97619 .40238 L
.97619 .4119 L
.97619 .42143 L
.97619 .43095 L
.97619 .44048 L
.97619 .45 L
.97619 .45952 L
.97619 .46905 L
.97619 .47857 L
Mistroke
.97619 .4881 L
.97619 .4881 L
Mfstroke
.02381 .0119 m
.03333 .0119 L
.04286 .0119 L
.05238 .0119 L
.0619 .0119 L
.07143 .0119 L
.08095 .0119 L
.09048 .0119 L
.1 .0119 L
.10952 .0119 L
.11905 .0119 L
.12857 .0119 L
.1381 .0119 L
.14762 .0119 L
.15714 .0119 L
.16667 .0119 L
.17619 .0119 L
.18571 .0119 L
.19524 .0119 L
.20476 .0119 L
.21429 .0119 L
.22381 .0119 L
.23333 .0119 L
.24286 .0119 L
.25238 .0119 L
.2619 .0119 L
.27143 .0119 L
.28095 .0119 L
.29048 .0119 L
.3 .0119 L
.30952 .0119 L
.31905 .0119 L
.32857 .0119 L
.3381 .0119 L
.34762 .0119 L
.35714 .0119 L
.36667 .0119 L
.37619 .0119 L
.38571 .0119 L
.39524 .0119 L
.40476 .0119 L
.41429 .0119 L
.42381 .0119 L
.43333 .0119 L
.44286 .0119 L
.45238 .0119 L
.4619 .0119 L
.47143 .0119 L
.48095 .0119 L
.49048 .0119 L
Mistroke
.5 .0119 L
.50952 .0119 L
.51905 .0119 L
.52857 .0119 L
.5381 .0119 L
.54762 .0119 L
.55714 .0119 L
.56667 .0119 L
.57619 .0119 L
.58571 .0119 L
.59524 .0119 L
.60476 .0119 L
.61429 .0119 L
.62381 .0119 L
.63333 .0119 L
.64286 .0119 L
.65238 .0119 L
.6619 .0119 L
.67143 .0119 L
.68095 .0119 L
.69048 .0119 L
.7 .0119 L
.70952 .0119 L
.71905 .0119 L
.72857 .0119 L
.7381 .0119 L
.74762 .0119 L
.75714 .0119 L
.76667 .0119 L
.77619 .0119 L
.78571 .0119 L
.79524 .0119 L
.80476 .0119 L
.81429 .0119 L
.82381 .0119 L
.83333 .0119 L
.84286 .0119 L
.85238 .0119 L
.8619 .0119 L
.87143 .0119 L
.88095 .0119 L
.89048 .0119 L
.9 .0119 L
.90952 .0119 L
.91905 .0119 L
.92857 .0119 L
.9381 .0119 L
.94762 .0119 L
.95714 .0119 L
.96667 .0119 L
Mistroke
.97619 .0119 L
.97619 .0119 L
Mfstroke
.02381 .09127 m
.03333 .09127 L
.04286 .09127 L
.05238 .09127 L
.0619 .09127 L
.07143 .09127 L
.08095 .09127 L
.09048 .09127 L
.1 .09127 L
.10952 .09127 L
.11905 .09127 L
.12857 .09127 L
.1381 .09127 L
.14762 .09127 L
.15714 .09127 L
.16667 .09127 L
.17619 .09127 L
.18571 .09127 L
.19524 .09127 L
.20476 .09127 L
.21429 .09127 L
.22381 .09127 L
.23333 .09127 L
.24286 .09127 L
.25238 .09127 L
.2619 .09127 L
.27143 .09127 L
.28095 .09127 L
.29048 .09127 L
.3 .09127 L
.30952 .09127 L
.31905 .09127 L
.32857 .09127 L
.3381 .09127 L
.34762 .09127 L
.35714 .09127 L
.36667 .09127 L
.37619 .09127 L
.38571 .09127 L
.39524 .09127 L
.40476 .09127 L
.41429 .09127 L
.42381 .09127 L
.43333 .09127 L
.44286 .09127 L
.45238 .09127 L
.4619 .09127 L
.47143 .09127 L
.48095 .09127 L
.49048 .09127 L
Mistroke
.5 .09127 L
.50952 .09127 L
.51905 .09127 L
.52857 .09127 L
.5381 .09127 L
.54762 .09127 L
.55714 .09127 L
.56667 .09127 L
.57619 .09127 L
.58571 .09127 L
.59524 .09127 L
.60476 .09127 L
.61429 .09127 L
.62381 .09127 L
.63333 .09127 L
.64286 .09127 L
.65238 .09127 L
.6619 .09127 L
.67143 .09127 L
.68095 .09127 L
.69048 .09127 L
.7 .09127 L
.70952 .09127 L
.71905 .09127 L
.72857 .09127 L
.7381 .09127 L
.74762 .09127 L
.75714 .09127 L
.76667 .09127 L
.77619 .09127 L
.78571 .09127 L
.79524 .09127 L
.80476 .09127 L
.81429 .09127 L
.82381 .09127 L
.83333 .09127 L
.84286 .09127 L
.85238 .09127 L
.8619 .09127 L
.87143 .09127 L
.88095 .09127 L
.89048 .09127 L
.9 .09127 L
.90952 .09127 L
.91905 .09127 L
.92857 .09127 L
.9381 .09127 L
.94762 .09127 L
.95714 .09127 L
.96667 .09127 L
Mistroke
.97619 .09127 L
.97619 .09127 L
Mfstroke
.02381 .17063 m
.03333 .17063 L
.04286 .17063 L
.05238 .17063 L
.0619 .17063 L
.07143 .17063 L
.08095 .17063 L
.09048 .17063 L
.1 .17063 L
.10952 .17063 L
.11905 .17063 L
.12857 .17063 L
.1381 .17063 L
.14762 .17063 L
.15714 .17063 L
.16667 .17063 L
.17619 .17063 L
.18571 .17063 L
.19524 .17063 L
.20476 .17063 L
.21429 .17063 L
.22381 .17063 L
.23333 .17063 L
.24286 .17063 L
.25238 .17063 L
.2619 .17063 L
.27143 .17063 L
.28095 .17063 L
.29048 .17063 L
.3 .17063 L
.30952 .17063 L
.31905 .17063 L
.32857 .17063 L
.3381 .17063 L
.34762 .17063 L
.35714 .17063 L
.36667 .17063 L
.37619 .17063 L
.38571 .17063 L
.39524 .17063 L
.40476 .17063 L
.41429 .17063 L
.42381 .17063 L
.43333 .17063 L
.44286 .17063 L
.45238 .17063 L
.4619 .17063 L
.47143 .17063 L
.48095 .17063 L
.49048 .17063 L
Mistroke
.5 .17063 L
.50952 .17063 L
.51905 .17063 L
.52857 .17063 L
.5381 .17063 L
.54762 .17063 L
.55714 .17063 L
.56667 .17063 L
.57619 .17063 L
.58571 .17063 L
.59524 .17063 L
.60476 .17063 L
.61429 .17063 L
.62381 .17063 L
.63333 .17063 L
.64286 .17063 L
.65238 .17063 L
.6619 .17063 L
.67143 .17063 L
.68095 .17063 L
.69048 .17063 L
.7 .17063 L
.70952 .17063 L
.71905 .17063 L
.72857 .17063 L
.7381 .17063 L
.74762 .17063 L
.75714 .17063 L
.76667 .17063 L
.77619 .17063 L
.78571 .17063 L
.79524 .17063 L
.80476 .17063 L
.81429 .17063 L
.82381 .17063 L
.83333 .17063 L
.84286 .17063 L
.85238 .17063 L
.8619 .17063 L
.87143 .17063 L
.88095 .17063 L
.89048 .17063 L
.9 .17063 L
.90952 .17063 L
.91905 .17063 L
.92857 .17063 L
.9381 .17063 L
.94762 .17063 L
.95714 .17063 L
.96667 .17063 L
Mistroke
.97619 .17063 L
.97619 .17063 L
Mfstroke
.02381 .25 m
.03333 .25 L
.04286 .25 L
.05238 .25 L
.0619 .25 L
.07143 .25 L
.08095 .25 L
.09048 .25 L
.1 .25 L
.10952 .25 L
.11905 .25 L
.12857 .25 L
.1381 .25 L
.14762 .25 L
.15714 .25 L
.16667 .25 L
.17619 .25 L
.18571 .25 L
.19524 .25 L
.20476 .25 L
.21429 .25 L
.22381 .25 L
.23333 .25 L
.24286 .25 L
.25238 .25 L
.2619 .25 L
.27143 .25 L
.28095 .25 L
.29048 .25 L
.3 .25 L
.30952 .25 L
.31905 .25 L
.32857 .25 L
.3381 .25 L
.34762 .25 L
.35714 .25 L
.36667 .25 L
.37619 .25 L
.38571 .25 L
.39524 .25 L
.40476 .25 L
.41429 .25 L
.42381 .25 L
.43333 .25 L
.44286 .25 L
.45238 .25 L
.4619 .25 L
.47143 .25 L
.48095 .25 L
.49048 .25 L
Mistroke
.5 .25 L
.50952 .25 L
.51905 .25 L
.52857 .25 L
.5381 .25 L
.54762 .25 L
.55714 .25 L
.56667 .25 L
.57619 .25 L
.58571 .25 L
.59524 .25 L
.60476 .25 L
.61429 .25 L
.62381 .25 L
.63333 .25 L
.64286 .25 L
.65238 .25 L
.6619 .25 L
.67143 .25 L
.68095 .25 L
.69048 .25 L
.7 .25 L
.70952 .25 L
.71905 .25 L
.72857 .25 L
.7381 .25 L
.74762 .25 L
.75714 .25 L
.76667 .25 L
.77619 .25 L
.78571 .25 L
.79524 .25 L
.80476 .25 L
.81429 .25 L
.82381 .25 L
.83333 .25 L
.84286 .25 L
.85238 .25 L
.8619 .25 L
.87143 .25 L
.88095 .25 L
.89048 .25 L
.9 .25 L
.90952 .25 L
.91905 .25 L
.92857 .25 L
.9381 .25 L
.94762 .25 L
.95714 .25 L
.96667 .25 L
Mistroke
.97619 .25 L
.97619 .25 L
Mfstroke
.02381 .32937 m
.03333 .32937 L
.04286 .32937 L
.05238 .32937 L
.0619 .32937 L
.07143 .32937 L
.08095 .32937 L
.09048 .32937 L
.1 .32937 L
.10952 .32937 L
.11905 .32937 L
.12857 .32937 L
.1381 .32937 L
.14762 .32937 L
.15714 .32937 L
.16667 .32937 L
.17619 .32937 L
.18571 .32937 L
.19524 .32937 L
.20476 .32937 L
.21429 .32937 L
.22381 .32937 L
.23333 .32937 L
.24286 .32937 L
.25238 .32937 L
.2619 .32937 L
.27143 .32937 L
.28095 .32937 L
.29048 .32937 L
.3 .32937 L
.30952 .32937 L
.31905 .32937 L
.32857 .32937 L
.3381 .32937 L
.34762 .32937 L
.35714 .32937 L
.36667 .32937 L
.37619 .32937 L
.38571 .32937 L
.39524 .32937 L
.40476 .32937 L
.41429 .32937 L
.42381 .32937 L
.43333 .32937 L
.44286 .32937 L
.45238 .32937 L
.4619 .32937 L
.47143 .32937 L
.48095 .32937 L
.49048 .32937 L
Mistroke
.5 .32937 L
.50952 .32937 L
.51905 .32937 L
.52857 .32937 L
.5381 .32937 L
.54762 .32937 L
.55714 .32937 L
.56667 .32937 L
.57619 .32937 L
.58571 .32937 L
.59524 .32937 L
.60476 .32937 L
.61429 .32937 L
.62381 .32937 L
.63333 .32937 L
.64286 .32937 L
.65238 .32937 L
.6619 .32937 L
.67143 .32937 L
.68095 .32937 L
.69048 .32937 L
.7 .32937 L
.70952 .32937 L
.71905 .32937 L
.72857 .32937 L
.7381 .32937 L
.74762 .32937 L
.75714 .32937 L
.76667 .32937 L
.77619 .32937 L
.78571 .32937 L
.79524 .32937 L
.80476 .32937 L
.81429 .32937 L
.82381 .32937 L
.83333 .32937 L
.84286 .32937 L
.85238 .32937 L
.8619 .32937 L
.87143 .32937 L
.88095 .32937 L
.89048 .32937 L
.9 .32937 L
.90952 .32937 L
.91905 .32937 L
.92857 .32937 L
.9381 .32937 L
.94762 .32937 L
.95714 .32937 L
.96667 .32937 L
Mistroke
.97619 .32937 L
.97619 .32937 L
Mfstroke
.02381 .40873 m
.03333 .40873 L
.04286 .40873 L
.05238 .40873 L
.0619 .40873 L
.07143 .40873 L
.08095 .40873 L
.09048 .40873 L
.1 .40873 L
.10952 .40873 L
.11905 .40873 L
.12857 .40873 L
.1381 .40873 L
.14762 .40873 L
.15714 .40873 L
.16667 .40873 L
.17619 .40873 L
.18571 .40873 L
.19524 .40873 L
.20476 .40873 L
.21429 .40873 L
.22381 .40873 L
.23333 .40873 L
.24286 .40873 L
.25238 .40873 L
.2619 .40873 L
.27143 .40873 L
.28095 .40873 L
.29048 .40873 L
.3 .40873 L
.30952 .40873 L
.31905 .40873 L
.32857 .40873 L
.3381 .40873 L
.34762 .40873 L
.35714 .40873 L
.36667 .40873 L
.37619 .40873 L
.38571 .40873 L
.39524 .40873 L
.40476 .40873 L
.41429 .40873 L
.42381 .40873 L
.43333 .40873 L
.44286 .40873 L
.45238 .40873 L
.4619 .40873 L
.47143 .40873 L
.48095 .40873 L
.49048 .40873 L
Mistroke
.5 .40873 L
.50952 .40873 L
.51905 .40873 L
.52857 .40873 L
.5381 .40873 L
.54762 .40873 L
.55714 .40873 L
.56667 .40873 L
.57619 .40873 L
.58571 .40873 L
.59524 .40873 L
.60476 .40873 L
.61429 .40873 L
.62381 .40873 L
.63333 .40873 L
.64286 .40873 L
.65238 .40873 L
.6619 .40873 L
.67143 .40873 L
.68095 .40873 L
.69048 .40873 L
.7 .40873 L
.70952 .40873 L
.71905 .40873 L
.72857 .40873 L
.7381 .40873 L
.74762 .40873 L
.75714 .40873 L
.76667 .40873 L
.77619 .40873 L
.78571 .40873 L
.79524 .40873 L
.80476 .40873 L
.81429 .40873 L
.82381 .40873 L
.83333 .40873 L
.84286 .40873 L
.85238 .40873 L
.8619 .40873 L
.87143 .40873 L
.88095 .40873 L
.89048 .40873 L
.9 .40873 L
.90952 .40873 L
.91905 .40873 L
.92857 .40873 L
.9381 .40873 L
.94762 .40873 L
.95714 .40873 L
.96667 .40873 L
Mistroke
.97619 .40873 L
.97619 .40873 L
Mfstroke
.02381 .4881 m
.03333 .4881 L
.04286 .4881 L
.05238 .4881 L
.0619 .4881 L
.07143 .4881 L
.08095 .4881 L
.09048 .4881 L
.1 .4881 L
.10952 .4881 L
.11905 .4881 L
.12857 .4881 L
.1381 .4881 L
.14762 .4881 L
.15714 .4881 L
.16667 .4881 L
.17619 .4881 L
.18571 .4881 L
.19524 .4881 L
.20476 .4881 L
.21429 .4881 L
.22381 .4881 L
.23333 .4881 L
.24286 .4881 L
.25238 .4881 L
.2619 .4881 L
.27143 .4881 L
.28095 .4881 L
.29048 .4881 L
.3 .4881 L
.30952 .4881 L
.31905 .4881 L
.32857 .4881 L
.3381 .4881 L
.34762 .4881 L
.35714 .4881 L
.36667 .4881 L
.37619 .4881 L
.38571 .4881 L
.39524 .4881 L
.40476 .4881 L
.41429 .4881 L
.42381 .4881 L
.43333 .4881 L
.44286 .4881 L
.45238 .4881 L
.4619 .4881 L
.47143 .4881 L
.48095 .4881 L
.49048 .4881 L
Mistroke
.5 .4881 L
.50952 .4881 L
.51905 .4881 L
.52857 .4881 L
.5381 .4881 L
.54762 .4881 L
.55714 .4881 L
.56667 .4881 L
.57619 .4881 L
.58571 .4881 L
.59524 .4881 L
.60476 .4881 L
.61429 .4881 L
.62381 .4881 L
.63333 .4881 L
.64286 .4881 L
.65238 .4881 L
.6619 .4881 L
.67143 .4881 L
.68095 .4881 L
.69048 .4881 L
.7 .4881 L
.70952 .4881 L
.71905 .4881 L
.72857 .4881 L
.7381 .4881 L
.74762 .4881 L
.75714 .4881 L
.76667 .4881 L
.77619 .4881 L
.78571 .4881 L
.79524 .4881 L
.80476 .4881 L
.81429 .4881 L
.82381 .4881 L
.83333 .4881 L
.84286 .4881 L
.85238 .4881 L
.8619 .4881 L
.87143 .4881 L
.88095 .4881 L
.89048 .4881 L
.9 .4881 L
.90952 .4881 L
.91905 .4881 L
.92857 .4881 L
.9381 .4881 L
.94762 .4881 L
.95714 .4881 L
.96667 .4881 L
Mistroke
.97619 .4881 L
.97619 .4881 L
Mfstroke
P
p
p
.399 .063 .21 r
p
.66213 .34418 m
.66949 .34524 L
.67403 .34938 L
.67928 .34841 L
.67928 .34846 L
.6877 .35176 L
.68964 .34705 L
.69819 .3485 L
.69815 .3485 L
.69727 .34797 L
.69727 .34797 L
.68951 .34647 L
.68492 .33999 L
.68342 .33448 L
.6765 .33258 L
.67526 .32897 L
.66102 .32901 L
.66102 .32901 L
.66362 .33205 L
.66027 .33748 L
.66213 .34418 L
F
P
P
p
.576 .685 .742 r
p
.55295 .35498 m
.55123 .36071 L
.55123 .36071 L
.55335 .36248 L
.55551 .35807 L
.55551 .35807 L
.55295 .35498 L
F
P
P
p
.798 .194 .718 r
p
.5228 .34771 m
.5 .3448 L
.49418 .34286 L
.49414 .34281 L
.49687 .33492 L
.4899 .33386 L
.49039 .33192 L
.47707 .32597 L
.47707 .32319 L
.47707 .32319 L
.47707 .32222 L
.47707 .32218 L
.4873 .31614 L
.4873 .31614 L
.5 .30776 L
.51124 .30066 L
.51124 .30066 L
.5317 .31221 L
.53175 .31221 L
.52487 .31918 L
.52522 .32998 L
.52522 .32998 L
.51984 .33964 L
.52284 .34775 L
F
P
P
p
.461 .955 .233 r
p
.50463 .36243 m
.50397 .3627 L
.50392 .3627 L
.50463 .36243 L
F
P
P
p
.466 .091 .183 r
p
.53488 .23448 m
.53241 .23386 L
.53651 .21878 L
.53113 .20437 L
.53113 .20437 L
.53664 .20414 L
.56213 .20335 L
.56213 .20335 L
.5582 .20723 L
.5582 .21561 L
.56354 .21561 L
.56345 .22125 L
.56345 .22125 L
.55864 .22125 L
.55763 .23073 L
.54762 .22857 L
.54493 .23082 L
.54369 .23444 L
.53488 .23452 L
F
P
P
p
.523 .087 .264 r
p
.06221 .02509 m
.13307 .02522 L
.09793 .02707 L
.08541 .03536 L
.11927 .03651 L
.08704 .04096 L
.08285 .04603 L
.1045 .04427 L
.11499 .04683 L
.10758 .04863 L
.14158 .05295 L
.19832 .05467 L
.20203 .05198 L
.23382 .05062 L
.22703 .0552 L
.23761 .05525 L
.22685 .05754 L
.26349 .05794 L
.28783 .05683 L
.30441 .05498 L
.32121 .05732 L
.32138 .06129 L
.32138 .06129 L
.32147 .07262 L
.33867 .0806 L
.34996 .08188 L
.33889 .07478 L
.32668 .07169 L
.32747 .06847 L
.33765 .06332 L
.33933 .05326 L
.294 .04943 L
.2754 .04669 L
.29555 .04255 L
.28391 .04061 L
.29854 .03999 L
.2881 .03845 L
.30507 .03593 L
.30507 .03593 L
.3459 .03034 L
.41949 .03717 L
.40683 .04405 L
.46371 .05437 L
.45529 .05481 L
.46865 .06142 L
.48435 .06296 L
.48408 .06107 L
.5 .06085 L
.52297 .06464 L
.5619 .0634 L
.58986 .06878 L
.60181 .06481 L
.60873 .06874 L
.63448 .07235 L
.63748 .07544 L
.65022 .07262 L
.67729 .07068 L
.67729 .07068 L
.68426 .07072 L
.67989 .06424 L
.68889 .06142 L
.706 .06728 L
.70886 .06975 L
.73342 .07531 L
.73704 .07319 L
.76464 .07632 L
.78801 .07297 L
.8 .07615 L
.81155 .0728 L
.84224 .07266 L
.8582 .07535 L
.88457 .07271 L
.89162 .06905 L
.92068 .06667 L
.95185 .06041 L
.95185 .06041 L
.92923 .05203 L
.94255 .04202 L
.92328 .04118 L
.92116 .03862 L
.97619 .03065 L
.97619 .02113 L
.97619 .0119 L
.97619 .0119 L
.97619 .0119 L
.96667 .0119 L
.95714 .0119 L
.94762 .0119 L
.9381 .0119 L
.92857 .0119 L
.91905 .0119 L
.90952 .0119 L
.9 .0119 L
.89048 .0119 L
.88095 .0119 L
.87143 .0119 L
.8619 .0119 L
.85238 .0119 L
.84286 .0119 L
.83333 .0119 L
.82381 .0119 L
.81429 .0119 L
.80476 .0119 L
.79524 .0119 L
.78571 .0119 L
.77619 .0119 L
.76667 .0119 L
.75714 .0119 L
.74762 .0119 L
.7381 .0119 L
.72857 .0119 L
.71905 .0119 L
.70952 .0119 L
.7 .0119 L
.69048 .0119 L
.68095 .0119 L
.67143 .0119 L
.6619 .0119 L
.65238 .0119 L
.64286 .0119 L
.63333 .0119 L
.62381 .0119 L
.61429 .0119 L
.60476 .0119 L
.59524 .0119 L
.58571 .0119 L
.57619 .0119 L
.56667 .0119 L
.55714 .0119 L
.54762 .0119 L
.5381 .0119 L
.52857 .0119 L
.51905 .0119 L
.50952 .0119 L
.5 .0119 L
.49048 .0119 L
.48095 .0119 L
.47143 .0119 L
.4619 .0119 L
.45238 .0119 L
.44286 .0119 L
.43333 .0119 L
.42381 .0119 L
.41429 .0119 L
.40476 .0119 L
.39524 .0119 L
.38571 .0119 L
.37619 .0119 L
.36667 .0119 L
.35714 .0119 L
.34762 .0119 L
.3381 .0119 L
.32857 .0119 L
.31905 .0119 L
.30952 .0119 L
.3 .0119 L
.29048 .0119 L
.28095 .0119 L
.27143 .0119 L
.2619 .0119 L
.25238 .0119 L
.24286 .0119 L
.23333 .0119 L
.22381 .0119 L
.21429 .0119 L
.20476 .0119 L
.19524 .0119 L
.18571 .0119 L
.17619 .0119 L
.16667 .0119 L
.15714 .0119 L
.14762 .0119 L
.1381 .0119 L
.12857 .0119 L
.11905 .0119 L
.10952 .0119 L
.1 .0119 L
.09048 .0119 L
.08095 .0119 L
.07143 .0119 L
.0619 .0119 L
.05238 .0119 L
.04286 .0119 L
.03333 .0119 L
.02381 .0119 L
.02381 .0119 L
.02381 .02113 L
.02381 .03065 L
.06217 .02509 L
.06221 .02509 L
F
.24599 .05811 m
.22937 .05913 L
.23854 .06058 L
.24599 .05811 L
F
.3093 .05785 m
.31019 .06058 L
.29982 .06098 L
.31323 .0623 L
.30935 .06728 L
.31989 .06049 L
.3093 .05785 L
F
.30723 .04524 m
.30238 .04347 L
.28611 .04555 L
.30723 .04524 L
F
.34224 .03858 m
.34074 .03563 L
.32509 .03748 L
.34224 .03858 L
F
P
P
p
.325 .73 .549 r
p
.34603 .16415 m
.34519 .15886 L
.35009 .15238 L
.34572 .14819 L
.33496 .14735 L
.33519 .14202 L
.32769 .14193 L
.33179 .13726 L
.32813 .13713 L
.32646 .13091 L
.32121 .12831 L
.3261 .12465 L
.31742 .11768 L
.31896 .11142 L
.31896 .11142 L
.3097 .11248 L
.30534 .11896 L
.3119 .13219 L
.30917 .13814 L
.3153 .15944 L
.31332 .16715 L
.31927 .17844 L
.32227 .18964 L
.32227 .18964 L
.32478 .19237 L
.32985 .18951 L
.33086 .1918 L
.3343 .19118 L
.33426 .19118 L
.34722 .18338 L
.34497 .17773 L
.35295 .17782 L
.35556 .18236 L
.35556 .18236 L
.35767 .17822 L
.34753 .16997 L
.34753 .17002 L
.34603 .16415 L
F
.31847 .11071 m
.32769 .10542 L
.31843 .10507 L
.31843 .10481 L
.31847 .11071 L
F
P
P
p
.469 .485 .718 r
p
.88263 .14859 m
.87976 .14718 L
.87134 .1496 L
.869 .15498 L
.8653 .15966 L
.86199 .15661 L
.86446 .16398 L
.85966 .15745 L
.85392 .16477 L
.84709 .16671 L
.83329 .16451 L
.8175 .16023 L
.81204 .15701 L
.80454 .15904 L
.80617 .16561 L
.79934 .18082 L
.8022 .18086 L
.8 .18607 L
.8 .18607 L
.80168 .19228 L
.80904 .19577 L
.82019 .19832 L
.82522 .2067 L
.82743 .20269 L
.82703 .20732 L
.83135 .20877 L
.83338 .21323 L
.83708 .2131 L
.83818 .20873 L
.8399 .21093 L
.84444 .2093 L
.84312 .21327 L
.84656 .21781 L
.85101 .21777 L
.84916 .22037 L
.85904 .21746 L
.85904 .21746 L
.86239 .2172 L
.85833 .21036 L
.87063 .20313 L
.87491 .2097 L
.87601 .22081 L
.87857 .21772 L
.88038 .21195 L
.88457 .21041 L
.88699 .20004 L
.89361 .19643 L
.89586 .19034 L
.89894 .19039 L
.90454 .18307 L
.90639 .17385 L
.8974 .15547 L
.8974 .15547 L
.89581 .15022 L
.88721 .14643 L
.88263 .14859 L
F
.90485 .18183 m
.90547 .18466 L
.90485 .18183 L
F
.88563 .1358 m
.8828 .14237 L
.89246 .14162 L
.89149 .13576 L
.88563 .13585 L
F
.84638 .21843 m
.84493 .22037 L
.84771 .22011 L
.84638 .21843 L
F
P
P
p
.15 .406 .275 r
p
.52575 .37575 m
.53452 .37566 L
.5366 .37901 L
.5366 .37901 L
.54541 .37703 L
.54541 .37703 L
.54264 .37399 L
.54264 .37399 L
.53629 .3731 L
.53629 .3731 L
.52769 .37399 L
.52769 .37403 L
.52535 .37451 L
.5254 .37451 L
.52522 .37504 L
.52522 .37504 L
.52531 .37575 L
F
P
P
p
.143 .464 .664 r
p
.6336 .3194 m
% vacuous filled polygon
newpath
P
P
p
.477 .949 .747 r
p
.74392 .30595 m
.74202 .31063 L
.73611 .31336 L
.73973 .30917 L
.73554 .30798 L
.73554 .30798 L
.73549 .31689 L
.73391 .32046 L
.7377 .31689 L
.74444 .31623 L
.74118 .31252 L
.74237 .31071 L
.74414 .31252 L
.74497 .30816 L
.74497 .30816 L
.74392 .30591 L
F
P
P
p
.203 .522 .716 r
p
.50675 .38514 m
.50895 .38593 L
.50891 .38589 L
.51592 .38426 L
.51592 .3843 L
.51623 .38263 L
.51623 .38263 L
.51539 .38108 L
.51539 .38104 L
.50675 .38514 L
F
P
P
p
.28 .112 .339 r
p
.26645 .2989 m
.26477 .29206 L
.2642 .29713 L
.26477 .29206 L
.2642 .29713 L
.2664 .2989 L
F
P
P
p
.193 .193 .849 r
p
.50432 .26645 m
.50723 .26684 L
.50719 .26684 L
.50944 .28108 L
.50944 .28108 L
.50635 .28144 L
.50635 .28148 L
.50256 .2791 L
.50243 .2791 L
.50432 .26645 L
F
P
P
p
.014 .463 .644 r
p
.3287 .33549 m
% vacuous filled polygon
newpath
P
P
p
.379 .529 .744 r
p
.73523 .32227 m
.7381 .32491 L
.74246 .32346 L
.73523 .32227 L
F
P
P
p
.495 .973 .254 r
p
.31596 .22103 m
.31834 .21693 L
.31614 .2037 L
.31614 .2037 L
.32227 .18964 L
.32227 .18964 L
.32478 .19237 L
.32985 .18951 L
.33086 .1918 L
.3343 .19118 L
.3343 .19118 L
.33664 .19802 L
.34612 .19665 L
.34612 .19665 L
.34802 .20185 L
.34568 .20692 L
.34083 .20697 L
.34004 .21349 L
.32963 .21702 L
.3272 .22112 L
.3269 .22438 L
.31596 .22103 L
F
P
P
p
.602 .03 .31 r
p
.56684 .20291 m
.55556 .20154 L
.55291 .1918 L
.55291 .18448 L
.55291 .18448 L
.55463 .17901 L
.55732 .17892 L
.56032 .18214 L
.5675 .1821 L
.57773 .19127 L
.57769 .19127 L
.56684 .20291 L
F
P
P
p
.777 .653 .283 r
p
.35882 .16076 m
.36433 .17059 L
.36623 .16944 L
.36226 .1649 L
.37103 .17451 L
.37103 .18294 L
.39162 .19184 L
.39647 .20322 L
.39687 .21371 L
.39705 .21631 L
.39907 .21631 L
.39907 .21631 L
.40758 .22791 L
.40631 .2362 L
.39418 .24246 L
.38153 .24127 L
.38201 .24537 L
.37615 .2481 L
.37055 .24528 L
.37055 .24528 L
.36856 .2429 L
.36927 .24528 L
.36583 .24528 L
.36548 .24757 L
.36054 .24577 L
.36803 .25309 L
.36327 .26067 L
.36327 .26067 L
.36049 .25617 L
.35551 .25617 L
.35556 .25617 L
.35062 .25516 L
.35062 .25516 L
.34325 .25366 L
.34215 .2616 L
.33933 .26376 L
.33933 .26376 L
.33726 .26129 L
.33364 .25944 L
.32857 .26133 L
.33228 .25569 L
.3231 .25322 L
.3231 .25322 L
.31521 .25454 L
.31715 .25172 L
.31468 .25154 L
.31495 .23884 L
.31495 .23884 L
.30714 .23642 L
.30419 .23007 L
.30635 .22513 L
.31345 .22504 L
.31314 .22086 L
.31596 .22103 L
.31596 .22103 L
.3269 .22438 L
.3272 .22112 L
.32963 .21702 L
.34004 .21349 L
.34083 .20697 L
.34568 .20692 L
.34802 .20185 L
.34612 .19665 L
.34612 .19665 L
.3466 .19158 L
.35225 .19105 L
.35344 .1866 L
.35648 .18638 L
.35556 .18236 L
.35556 .18236 L
.35767 .17822 L
.34753 .16997 L
.34753 .17002 L
.3578 .16521 L
.35877 .16071 L
F
.37196 .24929 m
.36671 .24515 L
.36618 .24947 L
.37196 .24929 L
F
P
P
p
.107 .255 .937 r
p
.80181 .26213 m
.80428 .26287 L
.80428 .26292 L
.80181 .26213 L
F
.80463 .26296 m
.80432 .26274 L
.80432 .26274 L
.80463 .26296 L
F
P
P
p
.003 .995 .916 r
p
.57562 .36574 m
.57412 .36107 L
.57412 .36107 L
.56971 .36036 L
.56975 .36036 L
.56067 .35939 L
.56067 .35935 L
.56001 .36702 L
.56001 .36702 L
.57562 .36574 L
F
P
P
p
.745 .81 .146 r
p
.4929 .27509 m
.48541 .27765 L
.48541 .2776 L
.48951 .28571 L
.5 .28968 L
.50062 .28968 L
.50062 .28968 L
.50635 .28148 L
.50635 .28148 L
.50256 .2791 L
.50256 .2791 L
.49956 .27945 L
.49956 .27945 L
.4925 .2791 L
.4929 .27509 L
F
P
P
p
.901 .282 .166 r
p
.76124 .27738 m
.75855 .29383 L
.75631 .29616 L
.75309 .2922 L
.74934 .29224 L
.7489 .30128 L
.74392 .30595 L
.74392 .30591 L
.74497 .30816 L
.74497 .30816 L
.75168 .32041 L
.75697 .32165 L
.75754 .32465 L
.75754 .32465 L
.75966 .32443 L
.75966 .32443 L
.76116 .31843 L
.75802 .31332 L
.76164 .31376 L
.76759 .30705 L
.76477 .30384 L
.76759 .30705 L
.76477 .30384 L
.75754 .29907 L
.76173 .29334 L
.75974 .28995 L
.76367 .28131 L
.76124 .27738 L
F
P
P
p
.767 .372 .538 r
p
.57676 .24272 m
.57782 .23823 L
.57676 .24272 L
.58086 .24365 L
.58086 .24365 L
.57782 .23823 L
F
P
P
p
.671 .793 .118 r
p
.54101 .26993 m
.54916 .27125 L
.56023 .27897 L
.56054 .27888 L
.56221 .27306 L
.57262 .26327 L
.57262 .26327 L
.55908 .26093 L
.55079 .26314 L
.54929 .25922 L
.54929 .25922 L
.54387 .25922 L
.54286 .25586 L
.54286 .25586 L
.53814 .26601 L
.54101 .26993 L
F
P
P
p
.936 .641 .483 r
p
.53179 .23673 m
.53228 .2347 L
.53228 .2347 L
.53466 .23774 L
.53461 .23774 L
.53183 .23673 L
F
P
P
p
.341 .283 .358 r
p
.77227 .28078 m
.77632 .27756 L
.77227 .28078 L
.77072 .28585 L
.77835 .28796 L
.77835 .28796 L
.78452 .28889 L
.78452 .28889 L
.78452 .28267 L
.78003 .28086 L
.77632 .27756 L
F
P
P
p
.376 .087 .346 r
p
.52597 .25622 m
.52579 .26093 L
.52275 .26274 L
.52275 .26274 L
.52593 .26799 L
.53144 .26874 L
.53876 .2806 L
.53721 .28461 L
.53721 .28461 L
.54149 .27641 L
.5369 .27549 L
.54101 .26993 L
.54101 .26993 L
.53814 .26601 L
.54286 .25586 L
.54286 .25586 L
.53519 .25573 L
.53519 .25573 L
.52998 .25573 L
.52998 .25573 L
.52597 .25622 L
F
P
P
p
.355 .381 .171 r
p
.17531 .37963 m
.19039 .37963 L
.19039 .37963 L
.19303 .37963 L
.19303 .37963 L
.22487 .37963 L
.22487 .37963 L
.24286 .37963 L
.24286 .37963 L
.26301 .37698 L
.26301 .37698 L
.27743 .3731 L
.28197 .3638 L
.28197 .3638 L
.28135 .36257 L
.28135 .36257 L
.28122 .36027 L
.29123 .36354 L
.29083 .36402 L
.29083 .36446 L
.29083 .36446 L
.29947 .36768 L
.29947 .36768 L
.30595 .36909 L
.30591 .36909 L
.31085 .36909 L
.31085 .36909 L
.31195 .36984 L
.3119 .36984 L
.31684 .37557 L
.32222 .36953 L
.32222 .36953 L
.32615 .36975 L
.32615 .36975 L
.3287 .37191 L
.32822 .36997 L
.33236 .37002 L
.32491 .3675 L
.32681 .36499 L
.33871 .36975 L
.3362 .37138 L
.33135 .37125 L
.32888 .37628 L
.32315 .37698 L
.33011 .37831 L
.32685 .38034 L
.31138 .37368 L
.31552 .37729 L
.31199 .37813 L
.31565 .37734 L
.32945 .38311 L
.32945 .38311 L
.34092 .3828 L
.35287 .38814 L
.35247 .3907 L
.34647 .39347 L
.34017 .39092 L
.34559 .39347 L
.34828 .3944 L
.33946 .3955 L
.33545 .40004 L
.33545 .40004 L
.32848 .4097 L
.32522 .40428 L
.32011 .40498 L
.31649 .40282 L
.31958 .40489 L
.31208 .40891 L
.31649 .41111 L
.3093 .41332 L
.3093 .41332 L
.29339 .4149 L
.29215 .40507 L
.2974 .40141 L
.29594 .39722 L
.28898 .39458 L
.29012 .38417 L
.28338 .38805 L
.28228 .3959 L
.27403 .39546 L
.26499 .40035 L
.25428 .40053 L
.25053 .40472 L
.25053 .40472 L
.24921 .41005 L
.26023 .41684 L
.2519 .4198 L
.26724 .4198 L
.26975 .42257 L
.25794 .42447 L
.26878 .4228 L
.27857 .42509 L
.27456 .42703 L
.28439 .42725 L
.28483 .43302 L
.27363 .43483 L
.26971 .42791 L
.26971 .42791 L
.26468 .43316 L
.26124 .43051 L
.25419 .4343 L
.24982 .44048 L
.24462 .43554 L
.253 .43157 L
.24744 .42892 L
.24652 .42615 L
.24555 .42919 L
.24114 .43135 L
.24286 .42888 L
.22954 .42906 L
.219 .43236 L
.2131 .43038 L
.2131 .43038 L
.2205 .43157 L
.21627 .42553 L
.20877 .42989 L
.1955 .42937 L
.19581 .43219 L
.17108 .43347 L
.1705 .43558 L
.16817 .43338 L
.16138 .43673 L
.15397 .43347 L
.14691 .43223 L
.15697 .43589 L
.14802 .43377 L
.14242 .43161 L
.12694 .43426 L
.12698 .43426 L
.12698 .40952 L
.14162 .4082 L
.15604 .39793 L
.15608 .39793 L
.15595 .39255 L
.15882 .39167 L
.16049 .38854 L
.16473 .38854 L
.16168 .38668 L
.16195 .38536 L
.1698 .3847 L
.17526 .37959 L
F
.15168 .39317 m
.14894 .39087 L
.14797 .3933 L
.15168 .39317 L
F
.16279 .38413 m
.17315 .37778 L
.16274 .38413 L
F
.18325 .44586 m
.19493 .4444 L
.17513 .43805 L
.16667 .44039 L
.16989 .44665 L
.1832 .44586 L
F
.19683 .44206 m
.2127 .44184 L
.21468 .43942 L
.21407 .44405 L
.22169 .44149 L
.23289 .43558 L
.22778 .43201 L
.21803 .43386 L
.20022 .43113 L
.18933 .43519 L
.20507 .43607 L
.18898 .43677 L
.19559 .43924 L
.18492 .43964 L
.18955 .4429 L
.19683 .44206 L
F
.28038 .42174 m
.2858 .41786 L
.27451 .41698 L
.26936 .41821 L
.2735 .42438 L
.28038 .42174 L
F
.22359 .44453 m
.22147 .44272 L
.21684 .4444 L
.22359 .44453 L
F
.24109 .43488 m
.24727 .43166 L
.23695 .43223 L
.24109 .43488 L
F
.35287 .38655 m
.3496 .38108 L
.35348 .37972 L
.35851 .38038 L
.35802 .37571 L
.36023 .37725 L
.35957 .37341 L
.35648 .37672 L
.35348 .37399 L
.35247 .37685 L
.34312 .37597 L
.34286 .37676 L
.347 .38183 L
.347 .38183 L
.35287 .38651 L
F
.34043 .37394 m
.33823 .3709 L
.3418 .37152 L
.33726 .37152 L
.34043 .37394 L
F
.32213 .43064 m
.33792 .42628 L
.33188 .42165 L
.32976 .42553 L
.31869 .4254 L
.32174 .42337 L
.32174 .42337 L
.32901 .4164 L
.31746 .41865 L
.32522 .41367 L
.31111 .4168 L
.30106 .4205 L
.30106 .4205 L
.29365 .42041 L
.29515 .42319 L
.30057 .42121 L
.3056 .42315 L
.31151 .42447 L
.31689 .4261 L
.30692 .42659 L
.29722 .43175 L
.29096 .43699 L
.28585 .43444 L
.26742 .4358 L
.26305 .43805 L
.26186 .44017 L
.26186 .44017 L
.27209 .44541 L
.27037 .43779 L
.27332 .44286 L
.28316 .44506 L
.2858 .44017 L
.29612 .44246 L
.30137 .43832 L
.30586 .43779 L
.30974 .43933 L
.30789 .43686 L
.31076 .43523 L
.31517 .43752 L
.31746 .43519 L
.31746 .43519 L
.31473 .43395 L
.32337 .43342 L
.3164 .43219 L
.32213 .43064 L
F
.24846 .44581 m
.26138 .4455 L
.25115 .44043 L
.24846 .44581 L
F
.18611 .45467 m
.19339 .45287 L
.18166 .45053 L
.17451 .45128 L
.18611 .45467 L
F
.22566 .45992 m
.23761 .45591 L
.22271 .45728 L
.22566 .45992 L
F
.23444 .45273 m
.24175 .44872 L
.22809 .44987 L
.23051 .45225 L
.23444 .45273 L
F
P
P
p
.601 .545 .235 r
p
.56349 .30159 m
.54233 .31217 L
.53959 .3108 L
.53968 .31085 L
.54233 .30384 L
.54096 .29471 L
.53607 .28629 L
.53607 .28629 L
.53726 .28457 L
.53721 .28461 L
.54149 .27641 L
.5369 .27549 L
.54101 .26993 L
.54101 .26993 L
.54916 .27125 L
.56023 .27897 L
.56023 .27897 L
.55776 .28386 L
.56067 .29114 L
.56349 .29153 L
.56349 .30159 L
F
P
P
p
.27 .319 .379 r
p
.31376 .20146 m
.31098 .16362 L
.30507 .15123 L
.30873 .14052 L
.30794 .13228 L
.30494 .1269 L
.30379 .12884 L
.29974 .12663 L
.30287 .12619 L
.30287 .12619 L
.30631 .12302 L
.30251 .12297 L
.30238 .1172 L
.30542 .1123 L
.30829 .11301 L
.30569 .10979 L
.31093 .11076 L
.30631 .10917 L
.31186 .11019 L
.30917 .10877 L
.30917 .10877 L
.31896 .11142 L
.31896 .11142 L
.3097 .11248 L
.30534 .11896 L
.3119 .13219 L
.30917 .13814 L
.3153 .15944 L
.31332 .16715 L
.31927 .17844 L
.32227 .18964 L
.32227 .18964 L
.31614 .2037 L
.31376 .20146 L
.31614 .2037 L
F
.32262 .10423 m
.31914 .10463 L
.32262 .10423 L
F
.31905 .10459 m
.31989 .1026 L
.31473 .10406 L
.31909 .10459 L
F
.31843 .10481 m
.30948 .10578 L
.31746 .10591 L
.31371 .11041 L
.31847 .11071 L
.31847 .11071 L
.31843 .10481 L
F
.3045 .13523 m
.30556 .13929 L
.3045 .13523 L
F
P
P
p
.469 .897 .781 r
p
.82901 .35608 m
.82059 .35243 L
.82244 .35582 L
.8224 .35842 L
.81711 .35578 L
.81711 .35578 L
.8116 .35128 L
.8116 .35128 L
.81464 .34881 L
.8246 .34894 L
.81556 .34277 L
.81561 .34277 L
.82249 .33395 L
.81645 .33558 L
.82244 .33192 L
.81786 .32989 L
.8231 .32906 L
.81861 .322 L
.81865 .32205 L
.81508 .31918 L
.81001 .31248 L
.81001 .31248 L
.80234 .30891 L
.8 .31111 L
.8004 .30869 L
.79533 .30692 L
.79193 .3067 L
.79078 .30353 L
.79061 .30481 L
.79087 .30683 L
.78567 .30701 L
.78602 .30675 L
.77914 .31133 L
.77914 .31133 L
.77019 .30926 L
.77019 .30926 L
.76759 .30705 L
.76759 .30705 L
.76164 .31376 L
.75802 .31332 L
.76116 .31843 L
.75966 .32443 L
.75966 .32443 L
.75754 .32465 L
.75754 .32465 L
.75419 .32795 L
.7425 .32346 L
.74246 .32346 L
.7381 .32491 L
.73523 .32227 L
.73523 .32227 L
.7332 .32372 L
.7332 .32372 L
.71433 .32989 L
.71437 .32989 L
.70741 .33607 L
.71032 .33638 L
.70873 .33986 L
.71217 .34286 L
.71217 .34286 L
.70586 .34392 L
.70586 .34392 L
.69727 .34797 L
.69727 .34797 L
.69815 .3485 L
.69815 .3485 L
.69577 .35595 L
.71235 .36124 L
.71129 .36878 L
.71843 .3694 L
.71966 .37491 L
.72668 .37487 L
.73108 .37989 L
.73104 .37989 L
.73236 .38007 L
.73241 .38007 L
.74048 .37421 L
.73995 .36989 L
.75238 .36711 L
.75498 .36305 L
.75498 .3631 L
.77844 .36041 L
.7784 .36041 L
.79136 .36283 L
.79621 .36561 L
.7963 .36931 L
.8172 .3735 L
.8172 .37346 L
.81332 .37698 L
.80578 .37668 L
.80877 .38183 L
.80877 .38183 L
.81543 .38232 L
.81755 .38959 L
.82284 .39131 L
.8228 .39131 L
.83232 .39034 L
.83739 .38175 L
.84568 .37928 L
.84652 .37619 L
.85644 .37769 L
.85216 .36936 L
.84643 .36861 L
.8455 .36221 L
.8455 .36221 L
.82901 .35608 L
F
.78986 .30287 m
.79352 .30282 L
.79242 .29969 L
.78752 .29894 L
.7899 .30287 L
F
P
P
p
.708 .675 .779 r
p
.31133 .28135 m
.30194 .27945 L
.29696 .27094 L
.29533 .27293 L
.29533 .27293 L
.29396 .26914 L
.29396 .26914 L
.29621 .26036 L
.29149 .25379 L
.29149 .25379 L
.30084 .24974 L
.30084 .24974 L
.30705 .24356 L
.31455 .24303 L
.31292 .23999 L
.31495 .23884 L
.31495 .23884 L
.31468 .25154 L
.31715 .25172 L
.31521 .25454 L
.3231 .25322 L
.3231 .25322 L
.3205 .25736 L
.32156 .2664 L
.30952 .26856 L
.30586 .27429 L
.31133 .28135 L
F
P
P
p
.845 .067 .192 r
p
.52954 .23955 m
.53179 .23673 L
.53183 .23673 L
.53461 .23774 L
.53461 .23774 L
.54206 .23964 L
.54929 .25922 L
.54929 .25922 L
.54387 .25922 L
.54286 .25586 L
.54286 .25586 L
.53519 .25573 L
.53519 .25573 L
.53483 .25326 L
.53836 .25247 L
.53823 .24497 L
.53064 .24383 L
.52954 .23955 L
F
P
P
p
.437 .562 .709 r
p
.2787 .27888 m
.28157 .27531 L
.28157 .27531 L
.28069 .27125 L
.28069 .27125 L
.27337 .27619 L
.27332 .27928 L
.27332 .27932 L
.2787 .27888 L
F
P
P
p
.816 .351 .216 r
p
.27535 .30798 m
.28536 .31142 L
.2955 .30754 L
.30388 .3034 L
.29506 .30331 L
.28338 .31001 L
.27535 .30798 L
F
P
P
p
.354 .434 .18 r
p
.59149 .34436 m
.58739 .34145 L
.58536 .34277 L
.59149 .34436 L
F
P
P
p
.615 .809 .199 r
p
.55966 .37985 m
.5586 .37809 L
.55966 .37985 L
.53924 .38457 L
.53201 .38311 L
.53924 .38457 L
.53201 .38311 L
.5366 .37901 L
.5366 .37901 L
.54541 .37703 L
.54537 .37698 L
.5586 .37809 L
F
P
P
p
.91 .296 .43 r
p
.52293 .39524 m
.52152 .39969 L
.52632 .40093 L
.52183 .40031 L
.52791 .40273 L
.525 .39502 L
.525 .39502 L
.52293 .39528 L
F
P
P
p
.73 .013 .515 r
p
.61451 .28047 m
.61248 .28051 L
.61407 .2836 L
.61407 .28364 L
.61049 .28047 L
.61362 .2791 L
.61362 .2791 L
.61442 .28038 L
F
P
P
p
.721 .055 .234 r
p
.31014 .30212 m
.31927 .29921 L
.3101 .29775 L
.3101 .29775 L
.31019 .30212 L
F
P
P
p
.67 .654 .863 r
p
.28748 .24109 m
.28898 .24466 L
.28593 .24387 L
.28593 .24727 L
.29149 .25379 L
.29149 .25379 L
.30084 .24974 L
.30084 .24974 L
.29092 .23677 L
.28708 .23827 L
.28739 .24109 L
F
P
P
p
.796 .108 .945 r
p
.59422 .3112 m
.58554 .32831 L
.59061 .32337 L
.5925 .32817 L
.59233 .328 L
.59065 .33258 L
.59065 .33258 L
.59052 .33289 L
.56653 .33373 L
.59052 .33289 L
.56653 .33373 L
.56614 .3082 L
.56614 .3082 L
.58977 .30754 L
.59422 .3112 L
F
P
P
p
.048 .446 .892 r
p
.26764 .28554 m
.26164 .28638 L
.26362 .28818 L
.26164 .28638 L
.26362 .28818 L
.26764 .28554 L
F
P
P
p
.591 .613 .266 r
p
.52597 .25622 m
.52593 .25265 L
.52597 .25622 L
.52998 .25573 L
.52998 .25573 L
.53003 .25265 L
.52593 .25265 L
F
P
P
p
.276 .781 .414 r
p
.60216 .29771 m
.60507 .2899 L
.61407 .2836 L
.61407 .28364 L
.61049 .28047 L
.61362 .2791 L
.61362 .2791 L
.61645 .27381 L
.62694 .27116 L
.61892 .26296 L
.61085 .26054 L
.61089 .26058 L
.60454 .25908 L
.59506 .26221 L
.59506 .26221 L
.58726 .27099 L
.5907 .27791 L
.59563 .2836 L
.59788 .29515 L
.60212 .29762 L
F
P
P
p
.356 .98 .352 r
p
.33854 .11239 m
.34334 .11402 L
.33854 .11239 L
F
.34202 .11213 m
.34727 .11323 L
.34202 .11217 L
F
P
P
p
.684 .343 .464 r
p
.97046 .20406 m
.97275 .20238 L
.9709 .20168 L
F
P
P
p
.63 .628 .109 r
p
.56393 .42412 m
.56733 .42183 L
.55582 .41605 L
.55666 .41027 L
.56054 .4082 L
.57372 .41023 L
.57368 .41023 L
.58355 .41645 L
.57676 .43263 L
.57663 .43267 L
.57381 .43541 L
.56812 .4325 L
.5545 .43267 L
.5545 .43267 L
.56393 .42412 L
F
P
P
p
.794 .976 .765 r
p
.51993 .36583 m
.51966 .36574 L
.51953 .3657 L
.51966 .36574 L
.51958 .3657 L
.51027 .36521 L
.50851 .36226 L
.50851 .36226 L
.50463 .36243 L
.50463 .36243 L
.50397 .3627 L
.50392 .3627 L
.49533 .36481 L
.49533 .36481 L
.49705 .37253 L
.48735 .37835 L
.49643 .37866 L
.49489 .38157 L
.5 .38051 L
.50675 .38514 L
.50675 .38514 L
.51539 .38104 L
.51534 .38108 L
.51684 .38086 L
.51684 .38086 L
.52178 .37954 L
.52006 .37588 L
.52006 .37588 L
.51578 .37227 L
.51861 .37152 L
.51861 .37152 L
.51993 .36583 L
F
P
P
p
.313 .686 .031 r
p
.3567 .26415 m
.35996 .26442 L
.36327 .26067 L
.36327 .26067 L
.36049 .25617 L
.35551 .25617 L
.35556 .25617 L
.3567 .26415 L
F
P
P
p
.718 .867 .795 r
p
.52593 .25265 m
.52306 .24832 L
.52954 .23955 L
.52954 .23955 L
.53064 .24383 L
.53823 .24497 L
.53836 .25247 L
.53483 .25326 L
.53519 .25573 L
.53519 .25573 L
.52998 .25573 L
.52998 .25573 L
.53003 .25265 L
.52593 .25265 L
F
P
P
p
.44 .104 .601 r
p
.45617 .28593 m
.45952 .28558 L
.45569 .28448 L
.45569 .28457 L
.46349 .28541 L
.45617 .28593 L
F
P
P
p
.518 .659 .69 r
p
.51905 .39083 m
.52601 .39162 L
.52293 .39528 L
.52293 .39528 L
.525 .39502 L
.525 .39506 L
.52884 .39272 L
.53774 .39215 L
.53765 .39268 L
.53924 .38457 L
.53201 .38311 L
.5366 .37901 L
.5366 .37901 L
.53452 .37566 L
.52575 .37575 L
.52531 .37575 L
.52006 .37588 L
.52006 .37588 L
.52178 .37954 L
.51684 .38086 L
.51684 .38086 L
.51623 .38263 L
.51623 .38263 L
.51592 .3843 L
.51592 .38426 L
.51909 .39087 L
F
P
P
p
.245 .539 .307 r
p
.4918 .26345 m
.5 .26486 L
.50317 .26614 L
.50317 .26614 L
.5 .27804 L
.49978 .27831 L
.5 .27937 L
.4996 .27945 L
.49956 .27945 L
.4925 .2791 L
.4929 .27509 L
.4929 .27509 L
.4918 .26345 L
F
P
P
p
.007 .902 .074 r
p
.4858 .34568 m
.48576 .34563 L
.48576 .34563 L
.4858 .34563 L
F
P
P
p
.677 .378 .793 r
p
.56887 .35776 m
.5627 .35772 L
.55974 .35705 L
.55957 .35278 L
.56367 .35106 L
.5601 .34938 L
.56138 .34638 L
.55582 .35013 L
.55877 .35101 L
.56146 .35093 L
.55392 .35392 L
.55392 .35392 L
.55295 .35498 L
.55295 .35498 L
.55551 .35807 L
.55551 .35807 L
.56067 .35939 L
.56067 .35939 L
.56975 .36036 L
.56971 .36036 L
.56892 .35776 L
F
P
P
p
.28 .701 .613 r
p
.40525 .42496 m
.41407 .43153 L
.428 .43131 L
.44101 .43519 L
.42275 .43624 L
.43276 .43854 L
.42434 .44083 L
.44295 .43642 L
.43241 .44153 L
.43241 .44153 L
.42738 .44431 L
.44577 .44431 L
.44149 .44731 L
.44978 .44705 L
.44065 .44885 L
.44885 .44947 L
.44056 .45326 L
.45207 .45357 L
.44171 .45551 L
.45736 .46296 L
.44378 .46314 L
.46786 .46587 L
.43527 .46305 L
.44101 .46715 L
.43325 .46693 L
.41362 .46609 L
.41362 .46609 L
.44361 .46852 L
.40613 .46892 L
.4321 .47033 L
.41265 .47121 L
.3765 .46962 L
.39444 .46869 L
.37897 .46896 L
.38192 .46627 L
.36808 .46592 L
.34502 .4672 L
.35066 .46517 L
.34092 .46675 L
.32593 .45935 L
.30785 .45767 L
.32522 .45503 L
.3112 .45384 L
.31878 .45128 L
.34105 .4511 L
.34105 .4511 L
.35212 .43964 L
.35829 .4414 L
.36645 .43655 L
.35547 .4369 L
.36715 .43523 L
.35877 .43078 L
.36733 .42972 L
.35785 .42866 L
.36517 .42963 L
.36517 .42963 L
.3575 .42787 L
.36675 .42769 L
.35723 .42743 L
.35851 .42487 L
.36772 .4272 L
.35855 .42456 L
.36627 .42385 L
.36093 .4228 L
.36243 .41984 L
.36772 .4216 L
.36649 .41768 L
.36649 .41768 L
.3724 .41089 L
.38038 .4119 L
.38064 .40891 L
.38598 .40899 L
.38765 .41332 L
.38765 .41332 L
.38585 .41601 L
.39123 .42227 L
.40525 .42496 L
F
.35635 .43602 m
.36287 .43422 L
.35829 .43316 L
.35635 .43602 L
F
P
P
p
.48 .594 .67 r
p
.26477 .29206 m
.26662 .29158 L
.26662 .29158 L
.26362 .28818 L
.26362 .28818 L
.26164 .28638 L
.26164 .28638 L
.25595 .28849 L
.25595 .28849 L
.25732 .2925 L
.26076 .29259 L
.2593 .29713 L
.2642 .29713 L
.2642 .29713 L
.26477 .29206 L
F
P
P
p
.895 .613 .799 r
p
.46481 .2739 m
.46027 .27897 L
.46027 .27897 L
.46371 .28355 L
.46371 .28355 L
.46997 .28298 L
.46993 .2828 L
.47623 .2828 L
.47888 .27685 L
.47892 .2769 L
.4776 .27002 L
.4776 .27002 L
.47284 .27244 L
.47288 .27244 L
.47033 .27646 L
.46481 .2739 L
F
P
P
p
.229 .791 .012 r
p
.45578 .28258 m
.46032 .28166 L
.45899 .27998 L
.46027 .27897 L
.46027 .27897 L
.46371 .28355 L
.46371 .28355 L
.45578 .28258 L
F
P
P
p
.28 .57 .101 r
p
.34854 .26451 m
.34475 .26689 L
.34528 .26949 L
.34127 .27257 L
.34131 .27257 L
.33761 .26574 L
.33933 .26376 L
.33933 .26376 L
.34215 .2616 L
.34325 .25366 L
.35062 .25516 L
.35062 .25516 L
.34643 .26058 L
.34854 .26451 L
F
P
P
p
.767 .742 .263 r
p
.31014 .29771 m
.30295 .29877 L
.3086 .29903 L
.30569 .30225 L
.31019 .30212 L
.31019 .30212 L
.3101 .29775 L
F
P
P
p
.094 .864 .667 r
p
.26662 .29158 m
.28007 .28968 L
.26905 .28435 L
.28007 .28968 L
.26905 .28435 L
.26764 .28554 L
.26764 .28554 L
.26362 .28818 L
.26362 .28818 L
.26662 .29158 L
F
P
P
p
.586 .716 .071 r
p
.56058 .37685 m
.5586 .37809 L
.5586 .37809 L
.54537 .37698 L
.54541 .37703 L
.54264 .37399 L
.54255 .37399 L
.54727 .37108 L
.55362 .372 L
.55362 .372 L
.56058 .37685 L
F
P
P
p
.387 .885 .103 r
p
.44347 .41892 m
.43638 .4216 L
.44259 .42315 L
.4351 .42328 L
.43884 .42575 L
.44422 .4224 L
.45723 .42601 L
.46393 .42319 L
.46393 .42319 L
.45194 .4179 L
.44347 .41892 L
F
P
P
p
.591 .794 .215 r
p
.73554 .30798 m
.73254 .3093 L
.72862 .30287 L
.71239 .29153 L
.71124 .27954 L
.71124 .27954 L
.71019 .27421 L
.70362 .27222 L
.69392 .29369 L
.6929 .30891 L
.69078 .30608 L
.68713 .30481 L
.68241 .30899 L
.68651 .31111 L
.68042 .31287 L
.68042 .31287 L
.6881 .31459 L
.68391 .32143 L
.69021 .32399 L
.69757 .33219 L
.69943 .33541 L
.69563 .34167 L
.70586 .34392 L
.70586 .34392 L
.71217 .34286 L
.71217 .34286 L
.70873 .33986 L
.71032 .33638 L
.70741 .33607 L
.71437 .32989 L
.71437 .32989 L
.71182 .32628 L
.71896 .32275 L
.73104 .31971 L
.7332 .32372 L
.7332 .32372 L
.73523 .32227 L
.73523 .32227 L
.74246 .32346 L
.7425 .32346 L
.75419 .32795 L
.75754 .32465 L
.75754 .32465 L
.75697 .32165 L
.75168 .32041 L
.74497 .30816 L
.74497 .30816 L
.74414 .31252 L
.74237 .31071 L
.74118 .31252 L
.74444 .31623 L
.7377 .31689 L
.73391 .32046 L
.73549 .31689 L
.73554 .30798 L
F
P
P
p
.208 .977 .995 r
p
.75194 .26473 m
.75798 .26389 L
.77231 .25185 L
.77099 .25066 L
.77443 .25075 L
.77615 .24727 L
.77654 .24268 L
.78064 .24145 L
.77985 .23457 L
.7769 .2343 L
.76878 .24149 L
.75194 .26473 L
F
.76243 .24533 m
.7616 .24757 L
.76243 .24533 L
F
.78011 .24608 m
.78179 .2418 L
.77813 .24453 L
.78016 .24603 L
F
.79008 .25547 m
.78867 .24868 L
.79162 .24211 L
.79594 .24056 L
.80326 .23893 L
.80688 .24061 L
.80745 .24528 L
.8119 .25295 L
.81486 .2526 L
.80961 .25952 L
.81107 .26102 L
.81111 .26102 L
.80653 .26155 L
.80392 .25547 L
.7925 .25225 L
.79008 .25547 L
F
.79074 .22928 m
.80309 .22676 L
.80273 .22937 L
.79369 .23298 L
.78316 .23435 L
.77835 .2321 L
.79074 .22928 L
F
.79877 .23175 m
.80194 .23161 L
.79881 .23175 L
F
.80287 .22857 m
.80613 .22778 L
.80287 .22862 L
F
.80776 .22826 m
.80692 .22641 L
.8078 .22826 L
F
.8101 .22782 m
.81481 .22782 L
.80966 .22588 L
.8101 .22782 L
F
.8149 .22504 m
.81962 .22359 L
.8149 .22504 L
F
.81817 .22813 m
.8254 .22817 L
.82015 .22632 L
.8172 .22654 L
.81821 .22813 L
F
.82928 .22848 m
.83104 .22795 L
.82928 .22848 L
F
.83095 .22496 m
.83677 .22778 L
.83108 .22716 L
.82663 .22257 L
.83095 .22496 L
F
.84828 .23117 m
.84691 .22879 L
.84828 .23117 L
F
.81636 .23514 m
.8142 .2418 L
.81755 .2519 L
.83135 .25397 L
.8287 .25097 L
.81812 .25093 L
.81922 .2463 L
.82659 .24797 L
.8209 .24524 L
.82513 .23836 L
.82152 .23836 L
.81949 .24308 L
.81839 .2384 L
.81764 .23523 L
F
.82685 .24656 m
.82487 .24616 L
.82685 .24652 L
F
.82914 .24563 m
.83153 .24502 L
.82914 .24563 L
F
.83179 .24528 m
.83426 .24519 L
.83179 .24528 L
F
.82465 .23779 m
.8235 .23576 L
.82465 .23779 L
F
.82562 .23836 m
.82491 .23496 L
.82557 .23836 L
F
.83369 .24175 m
.83664 .24109 L
.83369 .24175 L
F
.83911 .24242 m
.84546 .24171 L
.84612 .23977 L
.8384 .24056 L
.83911 .24242 L
F
.85586 .23563 m
.85538 .23351 L
.85586 .23563 L
F
.84101 .25053 m
.8384 .25053 L
.83977 .24757 L
.83748 .2511 L
.83876 .25582 L
.83765 .25243 L
.84101 .25053 L
F
.86653 .23047 m
.86746 .22862 L
.86415 .22769 L
.86658 .23047 L
F
.87302 .22584 m
.87077 .22914 L
.8675 .22804 L
.86526 .23571 L
.85441 .23981 L
.85414 .24224 L
.85159 .2392 L
.84907 .24264 L
.85432 .24444 L
.84643 .24621 L
.85035 .24907 L
.85511 .24621 L
.85745 .24109 L
.86468 .24612 L
.87302 .24312 L
.87302 .24312 L
.87302 .22584 L
F
P
P
p
.986 .417 .965 r
p
.66301 .31667 m
.65287 .31781 L
.64211 .32063 L
.63263 .32923 L
.6284 .32928 L
.62844 .32928 L
.62011 .33986 L
.62262 .34471 L
.61852 .34832 L
.61852 .34832 L
.61852 .35489 L
.61852 .35489 L
.62213 .35273 L
.62734 .35476 L
.62932 .35172 L
.62932 .35172 L
.63519 .34718 L
.64259 .34885 L
.64259 .34881 L
.65132 .35128 L
.65758 .34846 L
.66213 .34418 L
.66213 .34418 L
.66027 .33748 L
.66362 .33205 L
.66102 .32901 L
.66102 .32901 L
.66755 .32178 L
.66301 .31667 L
F
P
P
p
.715 .415 .316 r
p
.62685 .32941 m
.6284 .32928 L
.62844 .32928 L
.62011 .33986 L
.62262 .34471 L
.61852 .34832 L
.61847 .34828 L
.61204 .34815 L
.61204 .34819 L
.60847 .34105 L
.60265 .33827 L
.60265 .33832 L
.60397 .33527 L
.60397 .33527 L
.6183 .32725 L
.6183 .32725 L
.62315 .32698 L
.62315 .32698 L
.62685 .32941 L
F
P
P
p
.199 .973 .152 r
p
.48342 .39308 m
.48316 .38805 L
.47416 .38611 L
.47231 .38805 L
.4769 .38933 L
.47324 .39312 L
.48082 .39568 L
.48082 .39563 L
.47844 .394 L
.48342 .39312 L
F
P
P
p
.222 .334 .306 r
p
.59052 .33289 m
.59286 .33757 L
.59286 .33757 L
.594 .33792 L
.594 .33792 L
.59422 .33796 L
.59436 .33796 L
.59431 .33646 L
.59431 .33646 L
.59387 .33333 L
.5925 .32817 L
.59255 .32817 L
.5925 .32817 L
.59233 .328 L
.59065 .33258 L
.59065 .33258 L
.59052 .33289 L
F
P
P
p
.566 .506 .263 r
p
.53629 .37063 m
.53245 .37024 L
.53276 .36698 L
.54899 .35617 L
.54396 .35608 L
.5425 .35031 L
.54145 .35591 L
.52937 .36217 L
.52672 .36645 L
.51993 .36583 L
.51993 .36583 L
.51861 .37152 L
.51861 .37152 L
.52769 .37403 L
.52769 .37399 L
.53629 .3731 L
.53629 .3731 L
.53629 .37063 L
F
.54131 .35119 m
.5399 .34696 L
.53285 .35 L
.54131 .35119 L
F
.52447 .35913 m
.52341 .35287 L
.52152 .35776 L
.52447 .35913 L
F
P
P
p
.918 .681 .403 r
p
.48007 .26151 m
.4918 .26345 L
.4918 .26345 L
.4929 .27509 L
.4929 .27509 L
.48541 .27765 L
.48541 .2776 L
.47892 .2769 L
.47892 .2769 L
.4776 .27002 L
.4776 .27002 L
.48011 .26151 L
F
P
P
p
.673 .124 .466 r
p
.29268 .29832 m
% vacuous filled polygon
newpath
P
P
p
.196 .695 .129 r
p
.84828 .33585 m
.8466 .33981 L
.84281 .33823 L
.84568 .33201 L
.84828 .33585 L
F
.85608 .34017 m
.8519 .33651 L
.84925 .33818 L
.85608 .34012 L
F
.87337 .35961 m
.87584 .35463 L
.87125 .34295 L
.86733 .34153 L
.86204 .34281 L
.85917 .33845 L
.85802 .34184 L
.84625 .33977 L
.85207 .34414 L
.86182 .34881 L
.86653 .34885 L
.87337 .35961 L
F
.87553 .37041 m
.88034 .36667 L
.88576 .36473 L
.87892 .36089 L
.8716 .36261 L
.87354 .36058 L
.87046 .35966 L
.87407 .36451 L
.87557 .37037 L
F
.83937 .32108 m
.8377 .319 L
.83937 .32103 L
F
P
P
p
.48 .779 .73 r
p
.5925 .32769 m
.59255 .32817 L
.5925 .32817 L
.59387 .33333 L
.59431 .33646 L
.59431 .33646 L
.60265 .33832 L
.60265 .33832 L
.60397 .33527 L
.60397 .33527 L
.59788 .33333 L
.59921 .32937 L
.5925 .32769 L
F
P
P
p
.415 .064 .463 r
p
.60996 .24559 m
.6037 .23765 L
.6037 .23765 L
.58973 .24735 L
.58973 .24735 L
.59268 .25507 L
.58995 .26116 L
.58995 .26116 L
.59506 .26221 L
.59506 .26221 L
.60454 .25908 L
.61089 .26058 L
.61089 .26054 L
.60842 .2575 L
.60992 .24559 L
F
P
P
p
.532 .442 .912 r
p
.62809 .32553 m
.62685 .32941 L
.62685 .32941 L
.62315 .32698 L
.62809 .32553 L
.62315 .32698 L
F
P
P
p
.24 .197 .136 r
p
.76477 .30384 m
.76759 .30705 L
.76759 .30705 L
.77019 .30926 L
.77019 .30926 L
.77293 .30516 L
.77685 .30467 L
.77482 .30106 L
.7843 .29255 L
.78452 .28889 L
.78452 .28889 L
.77835 .28796 L
.77835 .28796 L
.77703 .2963 L
.77354 .29877 L
.76698 .29647 L
.76795 .30176 L
.76481 .30384 L
F
P
P
p
.346 .734 .934 r
p
.59515 .34167 m
.59286 .33757 L
.59286 .33757 L
.594 .33792 L
.594 .33792 L
.59422 .33796 L
.59422 .33796 L
.59515 .34167 L
F
P
P
p
.218 .665 .33 r
p
.46958 .26834 m
.48007 .26151 L
.48011 .26151 L
.4776 .27002 L
.4776 .27002 L
.47284 .27244 L
.47284 .27244 L
.46962 .26834 L
F
P
P
p
.262 .094 .199 r
p
.53051 .33774 m
.54211 .33285 L
.55115 .33011 L
.55745 .33717 L
.56653 .33373 L
.56653 .33373 L
.56614 .3082 L
.56614 .3082 L
.56614 .30291 L
.56349 .30159 L
.56349 .30159 L
.54233 .31217 L
.53959 .3108 L
.53959 .3108 L
.5317 .31221 L
.53175 .31221 L
.52487 .31918 L
.52522 .32998 L
.52522 .32998 L
.53051 .33774 L
F
P
P
p
.134 .566 .965 r
p
.5254 .37451 m
.52522 .37509 L
.52522 .37504 L
.5254 .37451 L
F
P
P
p
.719 .356 .836 r
p
.51623 .38263 m
.51684 .38086 L
.51623 .38263 L
.51539 .38108 L
.51534 .38108 L
.51684 .38086 L
F
P
P
p
.55 .655 .893 r
p
.61459 .19215 m
.61777 .19722 L
.61764 .20719 L
.62698 .21093 L
.63038 .21839 L
.6336 .20948 L
.63131 .20886 L
.62469 .18391 L
.61658 .18399 L
.61459 .19215 L
F
P
P
p
.305 .108 .743 r
p
.58726 .22491 m
.59083 .22425 L
.5925 .2194 L
.59246 .2194 L
.59145 .21468 L
.59502 .21063 L
.59334 .20467 L
.59136 .21142 L
.58787 .21292 L
.58787 .21292 L
.58726 .22491 L
F
P
P
p
.653 .107 .972 r
p
.79008 .25547 m
.7925 .25225 L
.80392 .25547 L
.80653 .26155 L
.81111 .26102 L
.81107 .26102 L
.81556 .26415 L
.81076 .26552 L
.80992 .26852 L
.80463 .26296 L
.80463 .26296 L
.80432 .26274 L
.80432 .26274 L
.80428 .26292 L
.80428 .26287 L
.80181 .26213 L
.80181 .26213 L
.79484 .2571 L
.79466 .25357 L
.79008 .25547 L
F
.7649 .26698 m
.76795 .2575 L
.77385 .25335 L
.77593 .25384 L
.77368 .2627 L
.77011 .26649 L
.77011 .26649 L
.76759 .2649 L
.76486 .26698 L
F
P
P
p
.397 .919 .173 r
p
.51124 .30066 m
.5 .30776 L
.4873 .31614 L
.4873 .31614 L
.48258 .31614 L
.48545 .29101 L
.46958 .2914 L
.46812 .28898 L
.46759 .28907 L
.46997 .28298 L
.46993 .2828 L
.47623 .2828 L
.47888 .27685 L
.47892 .2769 L
.48541 .2776 L
.48541 .2776 L
.48951 .28571 L
.5 .28968 L
.50062 .28968 L
.50062 .28968 L
.51027 .29158 L
.51124 .30066 L
F
P
P
p
.754 .732 .589 r
p
.45489 .30494 m
.45714 .30348 L
.45626 .2925 L
.45626 .29246 L
.46459 .29242 L
.46812 .28893 L
.46812 .28898 L
.46958 .2914 L
.48545 .29101 L
.48258 .31614 L
.4873 .31614 L
.4873 .31614 L
.47707 .32218 L
.47707 .32222 L
.47707 .31878 L
.46825 .31878 L
.46534 .31058 L
.46561 .30644 L
.45489 .30494 L
F
P
P
p
.911 .66 .533 r
p
.24303 .31869 m
.24105 .30979 L
.24638 .29951 L
.25877 .29938 L
.25829 .29991 L
.26102 .30564 L
.26953 .30719 L
.2664 .2989 L
.2664 .2989 L
.2642 .29713 L
.2642 .29713 L
.2593 .29713 L
.26076 .29259 L
.25732 .2925 L
.25595 .28849 L
.25454 .2899 L
.25595 .28849 L
.24903 .29347 L
.24131 .29224 L
.22623 .2985 L
.22103 .30269 L
.22033 .30961 L
.21058 .31781 L
.20326 .32663 L
.20084 .33263 L
.19568 .33452 L
.20141 .32482 L
.20141 .32482 L
.21027 .3112 L
.20344 .31543 L
.19572 .32337 L
.19824 .32544 L
.19012 .33611 L
.19017 .33607 L
.19652 .33655 L
.19652 .33655 L
.21151 .33289 L
.21151 .33289 L
.21821 .33408 L
.21821 .33408 L
.22474 .3276 L
.23325 .32747 L
.23787 .31984 L
.24303 .31869 L
F
P
P
p
.455 .345 .695 r
p
.51971 .36574 m
.51953 .36565 L
.51953 .3657 L
.51966 .36574 L
F
P
P
p
.813 .099 .509 r
p
.73241 .38007 m
.74048 .37421 L
.73995 .36989 L
.75238 .36711 L
.75498 .36305 L
.75498 .3631 L
.77844 .36041 L
.7784 .36041 L
.79136 .36283 L
.79621 .36561 L
.7963 .36931 L
.8172 .3735 L
.8172 .37346 L
.81332 .37698 L
.80578 .37668 L
.80877 .38183 L
.80877 .38183 L
.78717 .38051 L
.77332 .3828 L
.76173 .38796 L
.76173 .38796 L
.7575 .38157 L
.7444 .38457 L
.73241 .38007 L
F
P
P
p
.145 .158 .206 r
p
.49418 .34286 m
.48567 .34502 L
.48351 .34264 L
.47544 .33611 L
.47293 .32756 L
.46512 .32319 L
.46517 .32319 L
.47707 .32319 L
.47707 .32319 L
.47707 .32597 L
.49039 .33192 L
.4899 .33386 L
.49687 .33492 L
.49414 .34281 L
F
P
P
p
.204 .036 .415 r
p
.60697 .22227 m
.60758 .20957 L
.59145 .1981 L
.59392 .18624 L
.58682 .18228 L
.58704 .17897 L
.58699 .17897 L
.58501 .17901 L
.58501 .17901 L
.58457 .18135 L
.58457 .18135 L
.5828 .1907 L
.5828 .1907 L
.58739 .197 L
.58726 .20578 L
.58047 .20864 L
.58047 .20864 L
.58787 .21292 L
.58787 .21292 L
.59136 .21142 L
.59334 .20467 L
.59502 .21063 L
.59145 .21468 L
.59246 .2194 L
.59246 .2194 L
.60697 .22227 L
F
P
P
p
.553 .097 .064 r
p
.53113 .20437 m
.53845 .18999 L
.53845 .18999 L
.53823 .1888 L
.53823 .1888 L
.54361 .17438 L
.54361 .17438 L
.55291 .17478 L
.55291 .18448 L
.55291 .18448 L
.55291 .1918 L
.55556 .20154 L
.56684 .20291 L
.56684 .20291 L
.56213 .20335 L
.56213 .20335 L
.56213 .20335 L
.53664 .20414 L
.53113 .20437 L
F
P
P
p
.018 .634 .924 r
p
.71433 .32989 m
.7332 .32372 L
.7332 .32372 L
.73104 .31971 L
.71896 .32275 L
.71182 .32628 L
.71437 .32989 L
F
P
P
p
.311 .286 .045 r
p
.50891 .38589 m
.51252 .39012 L
.51909 .39087 L
.51909 .39087 L
.51592 .38426 L
.51592 .38426 L
.50891 .38589 L
F
P
P
p
.013 .651 .753 r
p
.96036 .13973 m
.95692 .14286 L
.95362 .13955 L
.94109 .12773 L
.95181 .12862 L
.95101 .13161 L
.95556 .13386 L
.95225 .13545 L
.95701 .13554 L
.96036 .13973 L
F
.96808 .14502 m
.96358 .1399 L
.96389 .14365 L
.95979 .14572 L
.96283 .15194 L
.95688 .15895 L
.96561 .15044 L
.97235 .15026 L
.96812 .14502 L
F
P
P
p
.59 .668 .956 r
p
.28007 .28968 m
.2787 .27888 L
.2787 .27888 L
.27332 .27932 L
.27332 .27928 L
.26896 .2843 L
.26905 .28435 L
.28007 .28968 L
F
P
P
p
.94 .491 .159 r
p
.53959 .3108 m
.5317 .31221 L
.5317 .31221 L
.51124 .30066 L
.51124 .30066 L
.51027 .29158 L
.50062 .28968 L
.50062 .28968 L
.50635 .28148 L
.50635 .28144 L
.50944 .28108 L
.50952 .28095 L
.51292 .28646 L
.52549 .28386 L
.53607 .28629 L
.53607 .28629 L
.54096 .29471 L
.54233 .30384 L
.53968 .31085 L
F
P
P
p
.811 .782 .285 r
p
.52271 .2627 m
.51614 .26129 L
.51398 .26561 L
.50719 .26684 L
.50719 .26684 L
.50944 .28108 L
.50952 .28095 L
.51292 .28646 L
.52549 .28386 L
.53607 .28629 L
.53607 .28629 L
.53726 .28457 L
.53721 .28461 L
.53876 .2806 L
.53144 .26874 L
.52593 .26799 L
.52275 .26274 L
F
P
P
p
.955 .775 .367 r
p
.83959 .35216 m
.8373 .35507 L
.84577 .36186 L
.84572 .3619 L
.8455 .36221 L
.8455 .36221 L
.82901 .35608 L
.82901 .35608 L
.83241 .3522 L
.82981 .35084 L
.83519 .35009 L
.83514 .35009 L
.83959 .35216 L
F
P
P
p
.732 .858 .711 r
p
.58144 .43461 m
.58219 .43593 L
.57698 .43748 L
.57315 .43814 L
.56711 .43774 L
.54788 .43338 L
.53488 .42637 L
.53488 .42637 L
.52526 .41869 L
.53029 .41874 L
.51821 .41645 L
.51345 .41451 L
.51803 .41367 L
.51376 .41164 L
.52037 .41199 L
.51371 .41045 L
.51371 .41045 L
.51878 .41005 L
.51371 .40741 L
.51746 .40362 L
.52795 .40842 L
.53025 .40604 L
.53025 .40604 L
.5321 .41821 L
.55445 .43267 L
.5545 .43267 L
.56812 .4325 L
.57381 .43541 L
.57663 .43267 L
.57676 .43263 L
.58161 .43466 L
F
.56574 .46257 m
.56327 .45948 L
.54705 .46199 L
.56574 .46257 L
F
.52826 .46041 m
.53439 .45688 L
.54577 .45745 L
.53593 .45648 L
.54325 .45256 L
.55701 .45838 L
.54312 .46182 L
.54352 .45873 L
.52826 .46041 L
F
P
P
p
.349 .099 .934 r
p
.64048 .294 m
.65291 .30018 L
.6582 .30877 L
.64974 .31481 L
.64974 .31481 L
.64771 .31129 L
.64771 .31129 L
.64991 .3082 L
.63752 .30026 L
.63752 .30026 L
.64043 .294 L
F
P
P
p
.4 .063 .054 r
p
.66301 .31667 m
.67646 .31645 L
.68042 .31287 L
.68042 .31287 L
.6881 .31459 L
.68391 .32143 L
.69021 .32399 L
.69757 .33219 L
.69943 .33541 L
.69563 .34167 L
.70586 .34392 L
.70586 .34392 L
.69727 .34797 L
.69727 .34797 L
.68951 .34647 L
.68492 .33999 L
.68342 .33448 L
.6765 .33258 L
.67526 .32897 L
.66102 .32901 L
.66102 .32901 L
.66755 .32178 L
.66301 .31667 L
F
P
P
p
.921 .749 .309 r
p
.28157 .27531 m
.28827 .27456 L
.28827 .27451 L
.2888 .27478 L
.2888 .27478 L
.29533 .27297 L
.29533 .27293 L
.29396 .26914 L
.29396 .26914 L
.29334 .27262 L
.28959 .27363 L
.28959 .27363 L
.28942 .2735 L
.28942 .2735 L
.28721 .26918 L
.28069 .27125 L
.28069 .27125 L
.28157 .27531 L
F
P
P
p
.464 .254 .793 r
p
.87302 .24312 m
.89017 .23417 L
.88937 .23025 L
.89916 .22293 L
.89078 .22328 L
.88232 .23016 L
.87601 .22822 L
.87919 .2261 L
.87302 .22584 L
.87302 .24312 L
F
.9026 .23902 m
.89956 .23399 L
.8925 .23549 L
.89929 .23549 L
.9026 .23902 L
F
P
P
p
.369 .972 .094 r
p
.35556 .18236 m
.35295 .17782 L
.34497 .17773 L
.34722 .18338 L
.33426 .19118 L
.3343 .19118 L
.33664 .19802 L
.34612 .19665 L
.34612 .19665 L
.3466 .19158 L
.35225 .19105 L
.35344 .1866 L
.35648 .18638 L
.35556 .18236 L
F
P
P
p
.981 .587 .687 r
p
.31376 .20146 m
.29819 .21252 L
.29162 .22729 L
.28523 .23413 L
.28748 .24109 L
.28739 .24109 L
.28708 .23827 L
.29092 .23677 L
.30084 .24974 L
.30084 .24974 L
.30705 .24356 L
.31455 .24303 L
.31292 .23999 L
.31495 .23884 L
.31495 .23884 L
.30714 .23642 L
.30419 .23007 L
.30635 .22513 L
.31345 .22504 L
.31314 .22086 L
.31596 .22103 L
.31596 .22103 L
.31834 .21693 L
.31614 .2037 L
.31614 .2037 L
.31376 .20146 L
F
P
P
p
.139 .206 .22 r
p
.8235 .29868 m
.82112 .29043 L
.82262 .28699 L
.82787 .28646 L
.82826 .2832 L
.82416 .28695 L
.82434 .28483 L
.81914 .28651 L
.81689 .29317 L
.81905 .29903 L
.82354 .29868 L
F
.8261 .28329 m
.82822 .28104 L
.8261 .28329 L
F
.81843 .28576 m
.82156 .2847 L
.82041 .28236 L
.81847 .28576 L
F
.83188 .27593 m
.83496 .26922 L
.83386 .26658 L
.83245 .26918 L
.83175 .26477 L
.8272 .27068 L
.82244 .26878 L
.82646 .27306 L
.8272 .27108 L
.83205 .27381 L
.83188 .27597 L
F
.82919 .27672 m
.82751 .27579 L
.82923 .27672 L
F
.82681 .27879 m
.82597 .27407 L
.82381 .27601 L
.82681 .27879 L
F
.82284 .28148 m
.82584 .28034 L
.82257 .2776 L
.82284 .28148 L
F
.81618 .2802 m
.81671 .27778 L
.81001 .27205 L
.81618 .28016 L
F
P
P
p
.955 .281 .496 r
p
.53761 .3925 m
.53774 .3922 L
.53765 .39268 L
.53765 .3925 L
.53765 .39268 L
.5519 .39409 L
.55185 .39414 L
.56217 .39272 L
.56217 .39272 L
.56243 .38629 L
.56243 .38633 L
.55966 .37985 L
.55966 .37985 L
.53924 .38457 L
.53924 .38457 L
.53765 .39268 L
F
P
P
p
.871 .856 .347 r
p
.48038 .34837 m
.47641 .34837 L
.47487 .35243 L
.47685 .36102 L
.47685 .36102 L
.48364 .36001 L
.48038 .34837 L
F
P
P
p
.095 .809 .802 r
p
.32205 .29863 m
% vacuous filled polygon
newpath
P
P
p
.426 .346 .5 r
p
.63549 .31512 m
.63558 .31918 L
.63448 .31548 L
.63448 .31548 L
.63549 .31512 L
F
P
P
p
.339 .172 .554 r
p
.57848 .36962 m
.57562 .36574 L
.57562 .36574 L
.56001 .36702 L
.56001 .36698 L
.55362 .372 L
.55362 .372 L
.56058 .37685 L
.56058 .37685 L
.57055 .37765 L
.5705 .37765 L
.57451 .37028 L
.57848 .36962 L
F
P
P
p
.131 .366 .077 r
p
.57831 .24634 m
.57681 .24277 L
.57676 .24272 L
.58086 .24365 L
.58086 .24365 L
.58064 .24718 L
.58064 .24718 L
.57831 .24634 L
F
P
P
p
.572 .544 .679 r
p
.5328 .36618 m
.5328 .36618 L
% vacuous filled polygon
newpath
P
P
p
.938 .366 .324 r
p
.5925 .32769 m
.59145 .32429 L
.60366 .30582 L
.61318 .29334 L
.61318 .29334 L
.61772 .29603 L
.62059 .28995 L
.62059 .28995 L
.63752 .30026 L
.63752 .30026 L
.64991 .3082 L
.64771 .31129 L
.64771 .31129 L
.64506 .30996 L
.63536 .31305 L
.63549 .31512 L
.63549 .31512 L
.63448 .31548 L
.63448 .31548 L
.62809 .32553 L
.62809 .32553 L
.62315 .32698 L
.62315 .32698 L
.6183 .32725 L
.6183 .32725 L
.60397 .33527 L
.60397 .33527 L
.59788 .33333 L
.59921 .32937 L
.5925 .32769 L
F
P
P
p
.724 .657 .87 r
p
.45626 .2925 m
.45362 .28902 L
.45617 .28593 L
.45617 .28593 L
.46349 .28541 L
.45569 .28457 L
.45569 .28452 L
.4593 .28395 L
.45578 .28258 L
.45578 .28258 L
.46371 .28355 L
.46371 .28355 L
.46997 .28298 L
.46997 .28298 L
.46759 .28907 L
.46812 .28893 L
.46459 .29242 L
.45626 .29246 L
F
P
P
p
.452 .868 .31 r
p
.46481 .2739 m
.46962 .2683 L
.46962 .26834 L
.47284 .27244 L
.47288 .27244 L
.47033 .27646 L
.46481 .2739 L
F
P
P
p
.775 .644 .066 r
p
.77509 .25366 m
.77509 .25366 L
% vacuous filled polygon
newpath
P
P
p
.884 .429 .144 r
p
.60992 .24559 m
.62685 .26182 L
.63602 .27765 L
.63435 .28175 L
.61883 .27756 L
.61451 .28047 L
.61442 .28038 L
.61362 .2791 L
.61362 .2791 L
.61645 .27381 L
.62694 .27116 L
.61892 .26296 L
.61085 .26054 L
.61089 .26054 L
.60842 .2575 L
.60992 .24559 L
F
P
P
p
.727 .712 .875 r
p
.54361 .17438 m
.54846 .15961 L
.55291 .15789 L
.57381 .16261 L
.58704 .17897 L
.58699 .17897 L
.58501 .17901 L
.58501 .17901 L
.58153 .1791 L
.58457 .18131 L
.58457 .18135 L
.5828 .1907 L
.5828 .1907 L
.57769 .19131 L
.57773 .19127 L
.5675 .1821 L
.56032 .18214 L
.55732 .17892 L
.55463 .17901 L
.55291 .18448 L
.55291 .18448 L
.55291 .17478 L
.54361 .17438 L
F
P
P
p
.013 .361 .635 r
p
.57593 .17429 m
.57147 .1716 L
.57434 .16887 L
.57791 .17235 L
.57593 .17429 L
F
P
P
p
.303 .469 .681 r
p
.83519 .35009 m
.8347 .3407 L
.84242 .34387 L
.83959 .35216 L
.83959 .35216 L
.83514 .35009 L
F
P
P
p
.697 .937 .145 r
p
.50851 .36226 m
.5 .35569 L
.49969 .353 L
.5 .35216 L
.49436 .34718 L
.4858 .34563 L
.4858 .34563 L
.48576 .34563 L
.48576 .34563 L
.48038 .34837 L
.48038 .34837 L
.48364 .36001 L
.47685 .36102 L
.47685 .36102 L
.47544 .36393 L
.4791 .36583 L
.49533 .36481 L
.49533 .36481 L
.50392 .3627 L
.50463 .36243 L
.50392 .3627 L
.50463 .36243 L
.50851 .36226 L
F
P
P
p
.957 .04 .066 r
p
.71111 .27011 m
.71287 .2657 L
.71662 .26927 L
.71142 .27584 L
.71327 .275 L
.71111 .27011 L
F
P
P
p
.693 .089 .73 r
p
.60216 .29771 m
.59762 .30829 L
.59422 .3112 L
.59422 .3112 L
.58977 .30754 L
.56614 .3082 L
.56614 .3082 L
.56614 .30291 L
.56349 .30159 L
.56349 .30159 L
.56349 .29153 L
.56067 .29114 L
.55776 .28386 L
.56023 .27897 L
.56054 .27888 L
.56221 .27306 L
.57262 .26327 L
.57262 .26327 L
.58166 .25922 L
.58166 .25922 L
.58995 .26116 L
.58995 .26116 L
.59506 .26221 L
.59506 .26221 L
.58726 .27099 L
.5907 .27791 L
.59563 .2836 L
.59788 .29515 L
.60212 .29762 L
F
P
P
p
.291 .049 .023 r
p
.3567 .26415 m
.34854 .26451 L
.34854 .26451 L
.34643 .26058 L
.35062 .25516 L
.35062 .25516 L
.35556 .25617 L
.35556 .25617 L
.3567 .26415 L
F
P
P
p
.846 .863 .905 r
p
.58501 .17901 m
.58457 .18135 L
.58457 .18131 L
.58153 .1791 L
.58501 .17901 L
F
P
P
p
.297 .133 .988 r
p
.53025 .40604 m
.53519 .39638 L
.54193 .39837 L
.54281 .40511 L
.54872 .40644 L
.54237 .40741 L
.55049 .40802 L
.54586 .4153 L
.56393 .42412 L
.56393 .42412 L
.5545 .43267 L
.55445 .43267 L
.5321 .41821 L
.53025 .40604 L
F
P
P
p
.892 .936 .498 r
p
.51861 .37152 m
.52769 .37403 L
.52769 .37403 L
.52535 .37451 L
.5254 .37451 L
.52522 .37509 L
.52522 .37504 L
.52531 .37575 L
.52531 .37575 L
.52006 .37588 L
.52006 .37588 L
.51578 .37227 L
.51861 .37152 L
F
P
P
p
.685 .423 .255 r
p
.59502 .34506 m
.59515 .34167 L
.59515 .34167 L
.59422 .33796 L
.59436 .33796 L
.59431 .33646 L
.59431 .33646 L
.60265 .33832 L
.60265 .33827 L
.60847 .34105 L
.61204 .34819 L
.61204 .34815 L
.597 .34744 L
.59502 .34506 L
F
P
P
p
.801 .748 .278 r
p
.82086 .31645 m
.82275 .31614 L
.81936 .30802 L
.81777 .31248 L
.82086 .31645 L
F
P
P
p
.297 .761 .682 r
p
.60697 .22227 m
.6026 .23399 L
.6037 .23765 L
.6037 .23765 L
.58973 .24735 L
.58973 .24735 L
.58064 .24718 L
.58064 .24718 L
.58086 .24365 L
.58086 .24365 L
.57782 .23823 L
.57787 .23823 L
.58139 .22835 L
.58139 .22831 L
.58726 .22509 L
.58726 .22491 L
.59083 .22425 L
.5925 .2194 L
.59246 .2194 L
.60697 .22227 L
F
P
P
p
.585 .208 .031 r
p
.77227 .28078 m
.76684 .28347 L
.76526 .28576 L
.7623 .27743 L
.76565 .26896 L
.77011 .26649 L
.77011 .26649 L
.76759 .2649 L
.76486 .26698 L
.7649 .26698 L
.76001 .27174 L
.76124 .27738 L
.76124 .27738 L
.76367 .28131 L
.75974 .28995 L
.76173 .29334 L
.75754 .29907 L
.76477 .30384 L
.76481 .30384 L
.76795 .30176 L
.76698 .29647 L
.77354 .29877 L
.77703 .2963 L
.77835 .28796 L
.77835 .28796 L
.77072 .28585 L
.77227 .28078 L
F
P
P
p
.39 .536 .185 r
p
.50317 .26614 m
.50437 .26645 L
.50432 .26645 L
.50243 .2791 L
.50256 .2791 L
.49956 .27945 L
.4996 .27945 L
.5 .27937 L
.49978 .27831 L
.5 .27804 L
.50317 .26614 L
F
P
P
p
.186 .528 .631 r
p
.5228 .34771 m
.52923 .3481 L
.52646 .34039 L
.53051 .33774 L
.53051 .33774 L
.52522 .32998 L
.52522 .32998 L
.51984 .33964 L
.52284 .34775 L
F
P
P
p
.888 .052 .54 r
p
.59502 .34506 m
.59528 .34771 L
.58677 .34528 L
.57853 .34555 L
.5724 .34705 L
.57496 .34797 L
.5694 .35123 L
.57187 .35172 L
.56918 .35569 L
.57835 .35895 L
.57835 .35895 L
.59246 .36138 L
.60983 .35979 L
.60988 .35983 L
.61856 .35485 L
.61852 .35489 L
.61852 .34832 L
.61847 .34828 L
.61204 .34815 L
.61204 .34815 L
.597 .34744 L
.59502 .34506 L
F
.56887 .35776 m
.56927 .35595 L
.57668 .35847 L
.57412 .36107 L
.56971 .36036 L
.57412 .36107 L
.56971 .36036 L
.56892 .35776 L
F
P
P
p
.738 .952 .554 r
p
.63549 .31512 m
.64317 .31384 L
.64912 .3198 L
.64974 .31481 L
.64974 .31481 L
.64771 .31129 L
.64771 .31129 L
.64506 .30996 L
.63536 .31305 L
.63549 .31512 L
F
P
P
p
.855 .315 .698 r
p
.48677 .40511 m
.49202 .40511 L
.48876 .40212 L
.49519 .40238 L
.49026 .39819 L
.5 .39224 L
.50035 .39175 L
.5 .39162 L
.50467 .38884 L
.50101 .38611 L
.50062 .38422 L
.48699 .38382 L
.49369 .3869 L
.48862 .38668 L
.48862 .38668 L
.48752 .38981 L
.49277 .39109 L
.49202 .39546 L
.48642 .39511 L
.48695 .39885 L
.48461 .3963 L
.48677 .40511 L
F
.48082 .39568 m
.48347 .39308 L
.48342 .39312 L
.47844 .394 L
.48082 .39563 L
F
P
P
p
.753 .106 .037 r
p
.19017 .33607 m
.18973 .3373 L
.18973 .3373 L
.18091 .34145 L
.17597 .34925 L
.17879 .35057 L
.17275 .353 L
.17147 .36111 L
.17147 .36111 L
.17178 .37244 L
.17178 .37244 L
.17006 .37804 L
.17526 .37743 L
.17443 .37465 L
.17526 .37959 L
.17531 .37963 L
.19039 .37963 L
.19039 .37963 L
.19303 .37963 L
.19303 .37963 L
.22487 .37963 L
.22487 .37963 L
.24286 .37963 L
.24286 .37963 L
.26301 .37698 L
.26301 .37698 L
.27743 .3731 L
.28197 .3638 L
.28197 .3638 L
.28135 .36257 L
.28135 .36257 L
.28122 .36027 L
.29123 .36354 L
.29083 .36402 L
.29083 .36446 L
.29083 .36446 L
.29947 .36768 L
.29947 .36768 L
.30595 .36909 L
.30591 .36909 L
.31085 .36909 L
.31085 .36909 L
.31195 .36984 L
.3119 .36984 L
.31684 .37557 L
.32222 .36953 L
.32222 .36953 L
.31283 .36393 L
.31287 .36398 L
.31265 .3634 L
.31265 .36345 L
.31186 .35983 L
.31186 .35983 L
.31182 .35979 L
.31186 .35983 L
.30992 .3593 L
.30996 .3593 L
.30516 .35847 L
.3052 .35851 L
.30357 .35719 L
.30357 .35714 L
.30198 .35304 L
.3015 .35586 L
.3015 .35582 L
.30044 .35529 L
.30049 .35534 L
.3015 .35172 L
.3015 .35172 L
.30062 .35057 L
.30062 .35062 L
.29907 .34824 L
.29987 .35044 L
.29987 .35044 L
.29832 .3519 L
.29938 .35472 L
.2981 .35066 L
.29625 .35265 L
.29625 .35265 L
.29612 .35291 L
.29616 .35291 L
.29594 .35097 L
.29824 .3481 L
.29555 .34872 L
.29934 .34669 L
.29934 .34669 L
.30022 .34466 L
.29912 .34713 L
.297 .34511 L
.2996 .34422 L
.29616 .344 L
.29806 .34228 L
.2922 .33959 L
.2922 .33959 L
.28602 .3347 L
.28598 .33474 L
.28439 .33126 L
.28439 .33126 L
.28827 .32086 L
.28549 .31645 L
.27862 .32914 L
.26847 .33011 L
.26852 .33011 L
.26614 .33038 L
.26614 .33038 L
.26318 .32985 L
.26318 .32985 L
.26076 .32976 L
.26358 .3295 L
.26345 .32654 L
.25185 .32937 L
.2519 .32932 L
.24202 .32372 L
.24303 .31869 L
.24303 .31869 L
.23787 .31984 L
.23325 .32747 L
.22474 .3276 L
.21821 .33408 L
.21821 .33408 L
.21151 .33289 L
.21151 .33289 L
.19652 .33655 L
.19652 .33655 L
.19017 .33607 L
F
.15608 .39793 m
.15428 .39489 L
.1534 .39841 L
.15009 .39749 L
.14198 .40732 L
.14246 .40397 L
.13095 .40886 L
.10922 .41213 L
.1041 .40833 L
.1041 .40833 L
.09793 .40683 L
.10516 .4127 L
.09405 .40534 L
.08086 .39815 L
.0679 .39497 L
.0836 .40212 L
.08523 .40648 L
.07632 .40578 L
.07632 .40578 L
.07099 .40516 L
.07174 .41058 L
.06702 .4082 L
.06733 .41111 L
.06345 .41257 L
.06032 .41292 L
.06504 .41724 L
.07368 .41803 L
.07412 .42178 L
.0552 .42368 L
.06539 .42619 L
.07196 .42456 L
.07015 .42712 L
.0761 .42566 L
.05864 .43082 L
.07213 .43571 L
.07213 .43571 L
.08607 .43889 L
.12694 .43426 L
.12698 .43426 L
.12698 .40952 L
.14162 .4082 L
.15604 .39793 L
F
.08779 .30362 m
.09048 .30168 L
.08818 .30004 L
.08779 .30362 L
F
.09453 .40344 m
.097 .40194 L
.09048 .40172 L
.09453 .40344 L
F
P
P
p
.4 .991 .425 r
p
p
.97619 .43097 m
.96592 .43488 L
.95119 .43466 L
.95137 .43188 L
.92972 .4343 L
.92972 .4343 L
.92606 .43131 L
.9213 .43735 L
.90353 .43726 L
.89224 .44131 L
.88329 .43959 L
.88871 .44131 L
.88849 .4414 L
.87209 .44286 L
.87046 .43907 L
.8466 .43713 L
.81384 .44462 L
.80022 .44444 L
.80057 .44211 L
.79444 .44541 L
.79444 .44541 L
.77795 .44255 L
.80084 .44947 L
.79392 .45304 L
.77531 .45564 L
.7705 .45207 L
.76142 .45238 L
.76504 .44885 L
.76138 .45176 L
.72716 .44766 L
.72959 .44308 L
.72959 .4455 L
.71301 .44462 L
.72002 .43541 L
.72028 .43973 L
.70772 .44153 L
.70172 .43937 L
.70754 .43752 L
.69974 .43933 L
.69841 .44281 L
.69621 .43629 L
.69621 .43629 L
.69524 .43289 L
.70538 .43228 L
.70913 .42875 L
.70251 .4325 L
.69048 .42518 L
.68245 .42672 L
.69352 .42914 L
.69268 .44233 L
.6825 .44224 L
.67623 .43796 L
.68161 .43073 L
.67209 .43325 L
.67209 .43325 L
.6578 .43078 L
.64078 .43219 L
.62584 .4269 L
.61883 .42817 L
.62169 .43113 L
.61675 .42976 L
.61689 .42425 L
.60542 .42359 L
.60714 .42072 L
.59749 .42244 L
.59929 .41883 L
.59347 .42019 L
.59193 .42077 L
.59039 .42513 L
.58435 .42769 L
.60044 .42482 L
.60944 .42778 L
.58144 .43461 L
.58161 .43466 L
.57676 .43263 L
.57676 .43263 L
.58355 .41645 L
.57368 .41023 L
.57372 .41023 L
.58003 .40864 L
.57416 .40736 L
.57416 .40736 L
.56208 .40666 L
.56455 .40141 L
.55666 .40132 L
.55622 .39537 L
.55194 .39409 L
.55185 .39414 L
.56217 .39272 L
.56217 .39272 L
.56243 .38629 L
.56243 .38633 L
.55966 .37985 L
.55966 .37985 L
.5586 .37809 L
.5586 .37809 L
.56058 .37685 L
.56058 .37685 L
.57055 .37765 L
.5705 .37765 L
.57451 .37028 L
.57848 .36962 L
.57848 .36962 L
.58399 .375 L
.58413 .37244 L
.58933 .37152 L
.58593 .37011 L
.58898 .36755 L
.59621 .36914 L
.59211 .37218 L
.59802 .37403 L
.59797 .37399 L
.60123 .37465 L
.60119 .37465 L
.60419 .37465 L
.59982 .37346 L
.60203 .37178 L
.59678 .36953 L
.60586 .36477 L
.60582 .36477 L
.60983 .35979 L
.60988 .35983 L
.61856 .35485 L
.61852 .35489 L
.62213 .35273 L
.62734 .35476 L
.62932 .35172 L
.62932 .35168 L
.63333 .35644 L
.62853 .36067 L
.62853 .36067 L
.6235 .36777 L
.6302 .37266 L
.6302 .37262 L
.63545 .37465 L
.64065 .37244 L
.64087 .36993 L
.63642 .36777 L
.63285 .3679 L
.63977 .36032 L
.63981 .36032 L
.64489 .35855 L
.63946 .35701 L
.64259 .34881 L
.64259 .34881 L
.65132 .35128 L
.65758 .34846 L
.66213 .34418 L
.66213 .34418 L
.66949 .34524 L
.67403 .34938 L
.67928 .34841 L
.67928 .34846 L
.6877 .35176 L
.68964 .34705 L
.69819 .3485 L
.69815 .3485 L
.69577 .35595 L
.71235 .36124 L
.71129 .36878 L
.71843 .3694 L
.71966 .37491 L
.72668 .37487 L
.73108 .37989 L
.73104 .37989 L
.73236 .38007 L
.73241 .38007 L
.7444 .38457 L
.7575 .38157 L
.76173 .38796 L
.76173 .38796 L
.77332 .3828 L
.78717 .38051 L
.80877 .38183 L
.80877 .38183 L
.81543 .38232 L
.81755 .38959 L
.82284 .39131 L
.8228 .39131 L
.83232 .39034 L
.83739 .38175 L
.84568 .37928 L
.84652 .37619 L
.85644 .37769 L
.85216 .36936 L
.84643 .36861 L
.8455 .36221 L
.8455 .36221 L
.84572 .3619 L
.84577 .36186 L
.84577 .36186 L
.84872 .36464 L
.8575 .36508 L
.87086 .37817 L
.87412 .39096 L
.86971 .39369 L
.86327 .39162 L
.86437 .39369 L
.85772 .39533 L
.8772 .4067 L
.89581 .40811 L
.9045 .40582 L
.91054 .40653 L
.90802 .40842 L
.91662 .41349 L
.92425 .4134 L
.92363 .41027 L
.92707 .41173 L
.92707 .41173 L
.93192 .41548 L
.93823 .41521 L
.91257 .39991 L
.91442 .38461 L
.92888 .39489 L
.93214 .39868 L
.9284 .40362 L
.93289 .40882 L
.94766 .41036 L
.9504 .40851 L
.96821 .41631 L
.97381 .41477 L
.97138 .4205 L
.96146 .42112 L
.97482 .42147 L
.97482 .42147 L
.97619 .42309 L
.97619 .42309 L
.97619 .42309 L
.97619 .43097 L
F
.02381 .42309 m
.02597 .42571 L
.04184 .41997 L
.04272 .42381 L
.05101 .42496 L
.04052 .4276 L
.03845 .4254 L
.02381 .43097 L
.02381 .43097 L
.02381 .42309 L
.02381 .42309 L
F
P
.87522 .39061 m
.87588 .37138 L
.87994 .37266 L
.87897 .38064 L
.88294 .37866 L
.87835 .39321 L
.87522 .39061 L
F
.91067 .38241 m
.91287 .38435 L
.91067 .38241 L
F
.87341 .44546 m
.87959 .44396 L
.87346 .44546 L
F
.88757 .44996 m
.89934 .44877 L
.88757 .44996 L
F
.86993 .44788 m
.88016 .44824 L
.88466 .44978 L
.86702 .45163 L
.86221 .44912 L
.87055 .44793 L
F
.76314 .45622 m
.77875 .45767 L
.77081 .46014 L
.7631 .45622 L
F
.76314 .45966 m
.75802 .46208 L
.74563 .46045 L
.7631 .45966 L
F
.63598 .4399 m
.64224 .44392 L
.64965 .44356 L
.65247 .43713 L
.63598 .43995 L
F
.65075 .44757 m
.64299 .44409 L
.68122 .45357 L
.65071 .44757 L
F
P
P
p
.452 .192 .96 r
p
.58166 .25922 m
.5828 .2556 L
.57831 .24634 L
.57831 .24634 L
.58064 .24718 L
.58064 .24718 L
.58973 .24735 L
.58973 .24735 L
.59268 .25507 L
.58995 .26116 L
.58995 .26116 L
.58166 .25922 L
F
P
P
p
.034 .916 .007 r
p
.35882 .16071 m
.347 .15873 L
.34603 .16415 L
.34603 .16415 L
.34753 .17002 L
.34753 .17002 L
.3578 .16521 L
.35877 .16071 L
F
P
P
p
.775 .507 .285 r
p
.34131 .27257 m
.33699 .27266 L
.33902 .27496 L
.33329 .27672 L
.33638 .27844 L
.32782 .27654 L
.31931 .27826 L
.31477 .28228 L
.31534 .28025 L
.31063 .27857 L
.31049 .27394 L
.31133 .28135 L
.31133 .28135 L
.30586 .27429 L
.30952 .26856 L
.32156 .2664 L
.3205 .25736 L
.3231 .25322 L
.3231 .25322 L
.33228 .25569 L
.32857 .26133 L
.33364 .25944 L
.33726 .26129 L
.33933 .26376 L
.33933 .26376 L
.33761 .26574 L
.34131 .27257 L
F
P
P
p
.119 .722 .967 r
p
.77632 .27743 m
.77738 .27266 L
.77994 .27646 L
.78188 .27535 L
.78902 .281 L
.78823 .29034 L
.78197 .29647 L
.78197 .29647 L
.77985 .30185 L
.78567 .30701 L
.78602 .30675 L
.77914 .31133 L
.77914 .31133 L
.77019 .30926 L
.77019 .30926 L
.77293 .30516 L
.77685 .30467 L
.77482 .30106 L
.7843 .29255 L
.78452 .28889 L
.78452 .28889 L
.78452 .28267 L
.78003 .28086 L
.77632 .27756 L
F
P
P
p
.547 .166 .168 r
p
.46512 .32319 m
.45489 .30494 L
.45489 .30494 L
.46561 .30644 L
.46534 .31058 L
.46825 .31878 L
.47707 .31878 L
.47707 .32222 L
.47707 .32222 L
.47707 .32319 L
.47707 .32319 L
.46517 .32319 L
F
P
P
p
.112 .232 .468 r
p
.61318 .29339 m
.61521 .2836 L
.61517 .28355 L
.62143 .28743 L
.62059 .28995 L
.62059 .28995 L
.61772 .29603 L
.61318 .29334 L
F
P
P
p
.415 .006 .195 r
p
.61517 .28355 m
.62884 .28713 L
.64052 .29405 L
.64043 .294 L
.63752 .30026 L
.63752 .30026 L
.62059 .28995 L
.62059 .28995 L
.62143 .28743 L
.61517 .28355 L
F
P
P
p
.068 .424 .581 r
p
.55123 .36071 m
.53854 .36984 L
.53629 .37063 L
.53629 .37063 L
.53629 .3731 L
.53629 .3731 L
.54264 .37399 L
.54255 .37399 L
.54727 .37108 L
.55362 .372 L
.55362 .372 L
.56001 .36698 L
.56001 .36702 L
.56067 .35935 L
.56067 .35939 L
.55551 .35807 L
.55551 .35807 L
.55335 .36248 L
.55123 .36071 L
F
P
P
p
.743 .876 .464 r
p
.53488 .23448 m
.53228 .2347 L
.53228 .2347 L
.53466 .23774 L
.53461 .23774 L
.54206 .23964 L
.54929 .25922 L
.54929 .25922 L
.55079 .26314 L
.55908 .26093 L
.57262 .26327 L
.57262 .26327 L
.58166 .25922 L
.58166 .25922 L
.5828 .2556 L
.57831 .24634 L
.57831 .24634 L
.57681 .24277 L
.57676 .24272 L
.57782 .23823 L
.57787 .23823 L
.58139 .22835 L
.58139 .22835 L
.57504 .22549 L
.57504 .21944 L
.57884 .21786 L
.57884 .21442 L
.57196 .2194 L
.56345 .22125 L
.56345 .22125 L
.55864 .22125 L
.55763 .23073 L
.54762 .22857 L
.54493 .23082 L
.54369 .23444 L
.53488 .23452 L
F
P
P
p
.547 .828 .869 r
p
.58139 .22835 m
.57504 .22549 L
.57504 .21944 L
.57884 .21786 L
.57884 .21442 L
.57196 .2194 L
.56345 .22125 L
.56345 .22125 L
.56354 .21561 L
.5582 .21561 L
.5582 .20723 L
.56213 .20335 L
.56213 .20335 L
.56213 .20335 L
.56684 .20291 L
.56684 .20291 L
.57183 .20291 L
.58047 .20864 L
.58047 .20864 L
.58787 .21292 L
.58787 .21292 L
.58726 .22491 L
.58726 .22509 L
.58139 .22831 L
F
P
P
p
.69 .04 .542 r
p
.5828 .1907 m
.57769 .19131 L
.57769 .19127 L
.56684 .20291 L
.56684 .20291 L
.57183 .20291 L
.58047 .20864 L
.58047 .20864 L
.58726 .20578 L
.58739 .197 L
.5828 .1907 L
F
P
P
P
P
p
.001 w
.97619 .4881 m
.97619 .4881 L
.97619 .47857 L
.97619 .46905 L
.97619 .45952 L
.97619 .45 L
.97619 .44048 L
.97619 .43095 L
.97619 .42143 L
.97619 .4119 L
.97619 .40238 L
.97619 .39286 L
.97619 .38333 L
.97619 .37381 L
.97619 .36429 L
.97619 .35476 L
.97619 .34524 L
.97619 .33571 L
.97619 .32619 L
.97619 .31667 L
.97619 .30714 L
.97619 .29762 L
.97619 .2881 L
.97619 .27857 L
.97619 .26905 L
.97619 .25952 L
.97619 .25 L
.97619 .24048 L
.97619 .23095 L
.97619 .22143 L
.97619 .2119 L
.97619 .20238 L
.97619 .19286 L
.97619 .18333 L
.97619 .17381 L
.97619 .16429 L
.97619 .15476 L
.97619 .14524 L
.97619 .13571 L
.97619 .12619 L
.97619 .11667 L
.97619 .10714 L
.97619 .09762 L
.97619 .0881 L
.97619 .07857 L
.97619 .06905 L
.97619 .05952 L
.97619 .05 L
.97619 .04048 L
.97619 .03095 L
Mistroke
.97619 .02143 L
.97619 .0119 L
Mfstroke
.97619 .0119 m
.97619 .0119 L
.96667 .0119 L
.95714 .0119 L
.94762 .0119 L
.9381 .0119 L
.92857 .0119 L
.91905 .0119 L
.90952 .0119 L
.9 .0119 L
.89048 .0119 L
.88095 .0119 L
.87143 .0119 L
.8619 .0119 L
.85238 .0119 L
.84286 .0119 L
.83333 .0119 L
.82381 .0119 L
.81429 .0119 L
.80476 .0119 L
.79524 .0119 L
.78571 .0119 L
.77619 .0119 L
.76667 .0119 L
.75714 .0119 L
.74762 .0119 L
.7381 .0119 L
.72857 .0119 L
.71905 .0119 L
.70952 .0119 L
.7 .0119 L
.69048 .0119 L
.68095 .0119 L
.67143 .0119 L
.6619 .0119 L
.65238 .0119 L
.64286 .0119 L
.63333 .0119 L
.62381 .0119 L
.61429 .0119 L
.60476 .0119 L
.59524 .0119 L
.58571 .0119 L
.57619 .0119 L
.56667 .0119 L
.55714 .0119 L
.54762 .0119 L
.5381 .0119 L
.52857 .0119 L
.51905 .0119 L
Mistroke
.50952 .0119 L
.5 .0119 L
.49048 .0119 L
.48095 .0119 L
.47143 .0119 L
.4619 .0119 L
.45238 .0119 L
.44286 .0119 L
.43333 .0119 L
.42381 .0119 L
.41429 .0119 L
.40476 .0119 L
.39524 .0119 L
.38571 .0119 L
.37619 .0119 L
.36667 .0119 L
.35714 .0119 L
.34762 .0119 L
.3381 .0119 L
.32857 .0119 L
.31905 .0119 L
.30952 .0119 L
.3 .0119 L
.29048 .0119 L
.28095 .0119 L
.27143 .0119 L
.2619 .0119 L
.25238 .0119 L
.24286 .0119 L
.23333 .0119 L
.22381 .0119 L
.21429 .0119 L
.20476 .0119 L
.19524 .0119 L
.18571 .0119 L
.17619 .0119 L
.16667 .0119 L
.15714 .0119 L
.14762 .0119 L
.1381 .0119 L
.12857 .0119 L
.11905 .0119 L
.10952 .0119 L
.1 .0119 L
.09048 .0119 L
.08095 .0119 L
.07143 .0119 L
.0619 .0119 L
.05238 .0119 L
.04286 .0119 L
Mistroke
.03333 .0119 L
.02381 .0119 L
Mfstroke
.02381 .0119 m
.02381 .02143 L
.02381 .03095 L
.02381 .04048 L
.02381 .05 L
.02381 .05952 L
.02381 .06905 L
.02381 .07857 L
.02381 .0881 L
.02381 .09762 L
.02381 .10714 L
.02381 .11667 L
.02381 .12619 L
.02381 .13571 L
.02381 .14524 L
.02381 .15476 L
.02381 .16429 L
.02381 .17381 L
.02381 .18333 L
.02381 .19286 L
.02381 .20238 L
.02381 .2119 L
.02381 .22143 L
.02381 .23095 L
.02381 .24048 L
.02381 .25 L
.02381 .25952 L
.02381 .26905 L
.02381 .27857 L
.02381 .2881 L
.02381 .29762 L
.02381 .30714 L
.02381 .31667 L
.02381 .32619 L
.02381 .33571 L
.02381 .34524 L
.02381 .35476 L
.02381 .36429 L
.02381 .37381 L
.02381 .38333 L
.02381 .39286 L
.02381 .40238 L
.02381 .4119 L
.02381 .42143 L
.02381 .43095 L
.02381 .44048 L
.02381 .45 L
.02381 .45952 L
.02381 .46905 L
.02381 .47857 L
Mistroke
.02381 .4881 L
.02381 .4881 L
Mfstroke
.02381 .4881 m
.03333 .4881 L
.04286 .4881 L
.05238 .4881 L
.0619 .4881 L
.07143 .4881 L
.08095 .4881 L
.09048 .4881 L
.1 .4881 L
.10952 .4881 L
.11905 .4881 L
.12857 .4881 L
.1381 .4881 L
.14762 .4881 L
.15714 .4881 L
.16667 .4881 L
.17619 .4881 L
.18571 .4881 L
.19524 .4881 L
.20476 .4881 L
.21429 .4881 L
.22381 .4881 L
.23333 .4881 L
.24286 .4881 L
.25238 .4881 L
.2619 .4881 L
.27143 .4881 L
.28095 .4881 L
.29048 .4881 L
.3 .4881 L
.30952 .4881 L
.31905 .4881 L
.32857 .4881 L
.3381 .4881 L
.34762 .4881 L
.35714 .4881 L
.36667 .4881 L
.37619 .4881 L
.38571 .4881 L
.39524 .4881 L
.40476 .4881 L
.41429 .4881 L
.42381 .4881 L
.43333 .4881 L
.44286 .4881 L
.45238 .4881 L
.4619 .4881 L
.47143 .4881 L
.48095 .4881 L
.49048 .4881 L
Mistroke
.5 .4881 L
.50952 .4881 L
.51905 .4881 L
.52857 .4881 L
.5381 .4881 L
.54762 .4881 L
.55714 .4881 L
.56667 .4881 L
.57619 .4881 L
.58571 .4881 L
.59524 .4881 L
.60476 .4881 L
.61429 .4881 L
.62381 .4881 L
.63333 .4881 L
.64286 .4881 L
.65238 .4881 L
.6619 .4881 L
.67143 .4881 L
.68095 .4881 L
.69048 .4881 L
.7 .4881 L
.70952 .4881 L
.71905 .4881 L
.72857 .4881 L
.7381 .4881 L
.74762 .4881 L
.75714 .4881 L
.76667 .4881 L
.77619 .4881 L
.78571 .4881 L
.79524 .4881 L
.80476 .4881 L
.81429 .4881 L
.82381 .4881 L
.83333 .4881 L
.84286 .4881 L
.85238 .4881 L
.8619 .4881 L
.87143 .4881 L
.88095 .4881 L
.89048 .4881 L
.9 .4881 L
.90952 .4881 L
.91905 .4881 L
.92857 .4881 L
.9381 .4881 L
.94762 .4881 L
.95714 .4881 L
.96667 .4881 L
Mistroke
.97619 .4881 L
.97619 .4881 L
Mfstroke
P
P
% End of Graphics
MathPictureEnd</world>;

	}
	
}