/**
 * Copyright Akiyah ( http://wonderfl.net/user/Akiyah )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rjxm
 */

package{
    import net.hires.debug.Stats;
    import flash.display.*;
    import flash.events.*;
    import flash.net.*;
    import flash.system.*;
    import flash.filters.*;
    import flash.geom.*;
    import org.papervision3d.lights.*;
    import org.papervision3d.core.effects.view.*;
    import org.papervision3d.core.geom.TriangleMesh3D;
    import org.papervision3d.core.proto.MaterialObject3D;
    import org.papervision3d.events.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.materials.special.*;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.objects.*;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.view.BasicView;

    [SWF(backgroundColor="0x303030")]
    public class Sample extends ReflectionView {
        private var cube:Cube;
            
        Security.loadPolicyFile("http://assets.wonderfl.net/crossdomain.xml");
        private const path:String = "http://assets.wonderfl.net/images/related_images";
        private const filename:String = path+"/3/35/3590/359061d357d721a573fae94cc4d8b2819a72122c";
        private const filename1:String = path + "/e/ed/ed1c/ed1cadf0fdd830922653b0fa2a5667315bb85ef5";
        private const filename2:String = path + "/2/29/2944/2944a982d2a8d7928f0e8add944f8d28158090e3";
        private const filename3:String = path + "/3/39/3933/393330f30c725032b7ddee52247d9d46c7041bfa"
        
        public function Sample() {
            addChild(new Stats());
            viewportReflection.filters = [new BlurFilter()];

            var material:CompositeMaterial = new CompositeMaterial();
            //material.addMaterial(new ColorMaterial(0x808080));
            material.addMaterial(new BitmapFileMaterial(filename3));
            material.addMaterial(new WireframeMaterial(0x000000));

            var surfaceMaterial:CompositeMaterial = new CompositeMaterial();
            surfaceMaterial.addMaterial(new BitmapFileMaterial(filename1));
            surfaceMaterial.addMaterial(new WireframeMaterial(0x000000));

            var points:Array = [new Point(-10, -5), new Point(3, -5), new Point(0, 5), new Point(-10, 5), new Point(-15, 0)];
            var obj:Polygon3D = new Polygon3D(points, material, 2, surfaceMaterial, -15, -5, 20, 5);
            obj.y = 6;
            obj.rotationX = 90;
            scene.addChild(obj);

            points = [new Point(3, -5), new Point(15, -5), new Point(20, 0), new Point(15, 5), new Point(0, 5)];
            obj = new Polygon3D(points, material, 2, surfaceMaterial, -15, -5, 20, 5);
            obj.y = 6;
            obj.x = 1;
            obj.rotationX = 90;
            scene.addChild(obj);

            var mlist:MaterialsList = new MaterialsList({all:material, top:surfaceMaterial, bottom:surfaceMaterial});
            cube = new Cube(mlist, 12, 10, 2);
            cube.rotationX = 90;
            //cube.z = -15;
            cube.y = 18;
            scene.addChild(cube);

            addEventListener(Event.ENTER_FRAME, update);
        }

        public function update(e:Event):void {
            cube.rotationZ += 1;

            var camera_length:Number = 50;
            var c:Number = (mouseX / stage.width - 0.5) * (Math.PI * 2);
            var d:Number = (mouseY / stage.height - 0.5) * (Math.PI);
            camera.x = Math.sin(c) * Math.cos(d) * camera_length;
            camera.z = Math.cos(c) * Math.cos(d) * camera_length;
            camera.y = Math.sin(d) * camera_length;

            singleRender();
        }
    }
}

import flash.geom.*;
import org.papervision3d.Papervision3D;
import org.papervision3d.core.geom.*;
import org.papervision3d.core.geom.renderables.*;
import org.papervision3d.core.math.*;
import org.papervision3d.core.proto.*;    
 
class Polygon3D extends TriangleMesh3D
{
    private var minx:Number;
    private var miny:Number;
    private var maxx:Number;
    private var maxy:Number;


    public function Polygon3D( points:Array, sideMaterial:MaterialObject3D, height:Number, surfaceMaterial:MaterialObject3D,
                               minx:Number, miny:Number, maxx:Number, maxy:Number)
    {
        super( sideMaterial, new Array(), new Array(), null );
 
        this.minx = minx;
        this.miny = miny;
        this.maxx = maxx;
        this.maxy = maxy;
 
        var n:int = points.length;
        var i:Number;
        var vs0:Array = [];
        var vs1:Array = [];

        for each (var p:Point in points) {
            var v:Vertex3D;
            v = new Vertex3D(p.x, height * 0.5, p.y);
            this.geometry.vertices.push(v);
            vs0.push(v);
            v = new Vertex3D(p.x, -height * 0.5, p.y);
            this.geometry.vertices.push(v);
            vs1.push(v);
        }

        var uv00:NumberUV = new NumberUV(0, 0);
        var uv01:NumberUV = new NumberUV(0, 1);
        var uv10:NumberUV = new NumberUV(1, 0);
        var uv11:NumberUV = new NumberUV(1, 1);
        for (i = 0; i < n; i++) {
            var i2:Number = (i + 1) % n;
            this.geometry.faces.push( new Triangle3D(this, [vs0[i], vs1[i2], vs0[i2]], sideMaterial, [uv00, uv11, uv10]) );
            this.geometry.faces.push( new Triangle3D(this, [vs0[i],  vs1[i], vs1[i2]], sideMaterial, [uv00, uv01, uv11]) );
        }

        var ps:Array;
        for (i = 0; i < (n - 2)/2; i++) {
            ps = [vs0[i], vs0[n-2-i], vs0[n-1-i]];
            this.geometry.faces.push( new Triangle3D(this, ps, surfaceMaterial, to_uvs(ps)));            
            ps = [vs1[i], vs1[n-1-i], vs1[n-2-i]];
            this.geometry.faces.push( new Triangle3D(this, ps, surfaceMaterial, rev(to_uvs(ps))));
        }
        for (i = 0; i < (n - 3)/2; i++) {
            ps = [vs0[i], vs0[i+1], vs0[n-2-i]];
            this.geometry.faces.push( new Triangle3D(this, ps, surfaceMaterial, to_uvs(ps)));            
            ps = [vs1[i], vs1[n-2-i], vs1[i+1]];
            this.geometry.faces.push( new Triangle3D(this, ps, surfaceMaterial, rev(to_uvs(ps))));
        }
        
        this.geometry.ready = true;
        if(Papervision3D.useRIGHTHANDED)
            this.geometry.flipFaces();
    }
    
    private function to_uvs(ps:Array):Array
    {
        var uvs:Array = [];
        for each (var p:Vertex3D in ps) {
            uvs.push(new NumberUV((p.x - minx)/(maxx - minx), (p.z - miny)/(maxy - miny)));
        }
        return uvs;
    }
    private function rev(uvs:Array):Array
    {
        var ruvs:Array = [];
        for each (var uv:NumberUV in uvs) {
            ruvs.push(new NumberUV(uv.u, 1 - uv.v));
        }
        return ruvs;
    }
}
