/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rjoE
 */






package 
{
    import com.actionscriptbible.Example;
    import flash.display.Shape;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Point;
    import flash.text.TextField;
    
    
    public class HexMap extends Example 
    {
        private static const R:int = 50;
        private var MP:Point = new Point;
        private var LP:Point = new Point;
        
        private var debugger:TextField = new TextField;
        
        public function HexMap() {
            
            var s:Shape = this.addChild(new Shape) as Shape;
            with (s.graphics) lineStyle(1), drawRect(0, 0, 465, 465);
            
            
            this.addChild(debugger);
            debugger.text = "Debugger";
            
            this.stage.addEventListener(MouseEvent.MOUSE_DOWN, onMouseDown)
            this.stage.addEventListener(MouseEvent.MOUSE_UP, onMouseUp);
            this.addEventListener(Event.ENTER_FRAME, draw);
        }    
        
        private function onMouseUp(e:MouseEvent):void {
            this.stage.removeEventListener(Event.ENTER_FRAME, onMouseMove);
        }
        
        private function onMouseDown(e:MouseEvent):void {
            LP.x = mouseX, LP.y = mouseY;
            this.stage.addEventListener(Event.ENTER_FRAME, onMouseMove);
        }
        
        private var vc:Point = new Point;
        
        private static const M_W:int = 3 * R;
        private static const M_H:int = R * Math.sqrt(3) >> 0;
        
        private function onMouseMove(e:Event):void {
            vc.x -= LP.x - mouseX, vc.y -= LP.y - mouseY;
            LP.x = mouseX, LP.y = mouseY;
            
            if (Math.abs(vc.x) > M_W) vc.x = 0;
            if (Math.abs(vc.y) > M_H) vc.y = 0;
            
            debugger.text = "x : " + vc.x + "\ny : " + vc.y;
        }
        
        private static const $P0:Point = new Point(R * .5, R * Math.sqrt(3) / 2);
        private static const $P1:Point = new Point(R , 0);
        
        private function draw(e:Event):void {
            
            this.graphics.clear();
            
            var $CP:Point = new Point(vc.x - R, vc.y - M_H);
            var $PA:Point = new Point($CP.x, $CP.y);
            var $PB:Point = new Point($CP.x, $CP.y + $P0.y);
            
            var $T:Point = new Point();
            
            var $pointer:Point = new Point();
            
            for (var i:int = 1; i < 80; i++) {
                this.graphics.lineStyle(1,0);
                this.graphics.moveTo($CP.x, $CP.y);
                this.graphics.lineTo($CP.x + ($T.x -= $P0.x), $CP.y + ($T.y += $P0.y));
                this.graphics.lineTo($CP.x + ($T.x -= $P1.x), $CP.y + ($T.y += $P1.y));
                this.graphics.lineTo($CP.x + ($T.x -= $P0.x), $CP.y + ($T.y -= $P0.y));
                $T = new Point(0, 0);
                
                $CP.y += $P0.y * 2;
                
                if ((i % 8) == 0) {
                    $CP.x += R * 1.5;
                    $CP.y = (($pointer.x % 2) != 0) ? $PA.y : $PB.y;
                    $pointer.x ++;
                }
                $pointer.y ++;
            }
        }
    }
}