/**
 * Copyright nacookan ( http://wonderfl.net/user/nacookan )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rivI
 */

// マウス位置で上下左右、マウスボタンON/OFFで前後、カーソルキーで回転。
package {
    import flash.display.*;
    import flash.events.*;

    [SWF(frameRate="60")]    
    public class OverAction extends Sprite {
        public function OverAction():void {
            var area:Sprite = new Sprite();
            for(var i:Number = 0; i < 500; i++){
                var circle:Sprite = new Sprite();
                var color:Number = rnd(255 * 255 * 255);
                var alpha:Number = (rnd(40) + 20) / 100;
                circle.graphics.beginFill(color, alpha);
                circle.graphics.drawCircle(0, 0, rnd(30) + 10);
                circle.graphics.endFill();
                circle.x = 500 - rnd(1000);
                circle.y = 500 - rnd(1000);
                circle.z = 500 - (i * 2);
                circle.rotationX = rnd(180);
                circle.rotationY = rnd(180);
                area.addChild(circle);
            }
            
            var mouse_down:Boolean = false;
            var left_on:Boolean = false;
            var up_on:Boolean = false;
            var right_on:Boolean = false;
            var down_on:Boolean = false;
            
            addEventListener(Event.ENTER_FRAME, function(e:Event):void{
                var x_diff:Number = (stage.stageWidth / 2) - stage.mouseX;
                var y_diff:Number = (stage.stageHeight / 2) - stage.mouseY;
                area.x += x_diff / 10;
                area.y += y_diff / 10;
                area.z += 10 * (mouse_down ? 1 : -1);
                if(left_on) area.rotationY += 3;
                if(right_on) area.rotationY -= 3;
                if(up_on) area.rotationX += 3;
                if(down_on) area.rotationX -= 3;
            });
            
            stage.addEventListener(MouseEvent.MOUSE_DOWN, function(e:MouseEvent):void{
                mouse_down = true;
            });
            
            stage.addEventListener(MouseEvent.MOUSE_UP, function(e:MouseEvent):void{
                mouse_down = false;
            });

            stage.addEventListener(KeyboardEvent.KEY_DOWN, function(e:KeyboardEvent):void {
                switch(e.keyCode){
                    case 0x25: left_on = true; break;
                    case 0x26: up_on = true; break;
                    case 0x27: right_on = true; break;
                    case 0x28: down_on = true; break;
                }
            });
            
            stage.addEventListener(KeyboardEvent.KEY_UP, function(e:KeyboardEvent):void {
                switch(e.keyCode){
                    case 0x25: left_on = false; break;
                    case 0x26: up_on = false; break;
                    case 0x27: right_on = false; break;
                    case 0x28: down_on = false; break;
                }
            });
            
            area.x = (stage.stageWidth - area.width) / 2 + 500;
            area.y = (stage.stageHeight - area.height) / 2 + 500;
            area.z = 4000;
            addChild(area);
        }
        
        private function rnd(max:Number):Number{
            return Math.floor(Math.random() * max);
        }
    }
}