/**
 * Copyright Hakuhin ( http://wonderfl.net/user/Hakuhin )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/riXV
 */

// -------------------------------------------------
//
// インターレース風の横線を表示するフィルタ
//
//
// FULL SCREEN 表示にしてブラウザのサイズを変えても
// Flash スクリーンのライン表示が維持されている事が確認できます。
//
// -------------------------------------------------
package {
	import flash.events.*;
	import flash.display.*;
	import flash.net.*;
	import flash.text.*;
	import flash.utils.*;
	import flash.system.*;
	import flash.geom.*;
	import flash.filters.*;
	import flash.ui.*;
	import flash.media.*;

    public class Main extends Sprite {
        public function Main() {



// -------------------------------------------------
// コンストラクタ
// -------------------------------------------------

// 100%表示
stage.scaleMode = StageScaleMode.NO_SCALE;

// 左上
stage.align = StageAlign.TOP_LEFT;
stage.align = "TL";

// ビデオを配置
var video_obj : Video = new Video();
addChild(video_obj);

// ストリーム
var connection:NetConnection = new NetConnection();
connection.connect(null);	
var netStream:NetStream = new NetStream(connection);

// ビデオとストリームを関連付け
video_obj.attachNetStream(netStream);

// メタデータ取得
var obj:Object = new Object();
obj.onMetaData = function(param:Object):void{
}
netStream.client = obj;

// リソース読み込み開始
load();


// -------------------------------------------------
// 読み込み
// -------------------------------------------------
function load():void{

	// 動画のURL
	var movie_url:String = "http://actionscript.web.officelive.com/wonderfl/movie000.mp4";

	// サウンドをOFF
	var trans : SoundTransform = netStream.soundTransform;
	trans.volume = 0.0;
	netStream.soundTransform = trans;

	// 再生開始
	netStream.play(movie_url);

	// 初期化へ
	init();
}


// -------------------------------------------------
// 初期化
// -------------------------------------------------
function init():void{

	// ステージサイズ
	var w:uint;
	var h:uint;
	
	// リサイズ時にフィット
	stage.addEventListener(Event.RESIZE,ResizeFunc);
	function ResizeFunc(e:Event):void{
		w = stage.stageWidth;
		h = stage.stageHeight;
		video_obj.width = w;
		video_obj.height = h;
	}
	ResizeFunc(null);

	// シェーダバイトコード
	var binary : ByteArray = CustomFilterGetByteArray();
	
	// シェーダ作成
	var shader:Shader = new Shader();
	shader.byteCode = binary;
	var filter:ShaderFilter = new ShaderFilter(shader); 

	// パラメータアクセス用
	var data : ShaderData  = shader.data;
	var param : ShaderParameter;

	// パラメータ
	var odd_multiplier:Number = 0.5;	// 奇数列のカラーの乗算成分 (デフォルト 1.0)
	var odd_offset:Number = 0;			// 奇数列のカラーの加算成分 (デフォルト   0)
	var even_multiplier:Number = 1.5;	// 偶数列のカラーの乗算成分 (デフォルト 1.0)
	var even_offset:Number = 0;			// 偶数列のカラーの加算成分 (デフォルト   0)
	
	addEventListener(Event.ENTER_FRAME,function(e:Event):void{

		//  奇数列のカラーの乗算成分
		param = data.odd_multiplier;
		param.value = [odd_multiplier];

		// 奇数列のカラーの加算成分
		param = data.odd_offset;
		param.value = [odd_offset];

		//  奇数列のカラーの乗算成分
		param = data.even_multiplier;
		param.value = [even_multiplier];

		// 偶数列のカラーの加算成分
		param = data.even_offset;
		param.value = [even_offset];

		// 適応
		video_obj.filters = [filter];
	});

	// テキスト表示
	var tf : TextField = new TextField();
	tf.x = 5;
	tf.y = 5;
	tf.width = 300;
	tf.height = 60;
	tf.border = true;
	tf.background = true;
	tf.alpha = 0.9;
	
	// 書式
	var format : TextFormat = new TextFormat();
	format.font = "ＭＳ ゴシック";
	tf.defaultTextFormat = format;

	addChild(tf);
	addEventListener(Event.ENTER_FRAME,function(e:Event):void{
		var str:String = "";
		str += "奇数列のカラーの乗算成分:" + (Math.floor(odd_multiplier * 100) / 100) + "　(1,2キーで変更)\n";
		str += "奇数列のカラーの加算成分:" + odd_offset + "　(3,4キーで変更)\n";
		str += "偶数列のカラーの乗算成分:" + (Math.floor(even_multiplier * 100) / 100) + "　(5,6キーで変更)\n";
		str += "偶数列のカラーの加算成分:" + even_offset + "　(7,8キーで変更)\n";

		tf.text = str;
	});
	
	
	// キー操作
	stage.addEventListener(KeyboardEvent.KEY_DOWN, KeyDown);
	function KeyDown(event:KeyboardEvent):void{
		if(event.keyCode == 49)		odd_multiplier -= 0.05;
		if(event.keyCode == 50)		odd_multiplier += 0.05;
		if(event.keyCode == 51)		odd_offset -= 5;
		if(event.keyCode == 52)		odd_offset += 5;
		if(event.keyCode == 53)		even_multiplier -= 0.05;
		if(event.keyCode == 54)		even_multiplier += 0.05;
		if(event.keyCode == 55)		even_offset -= 5;
		if(event.keyCode == 56)		even_offset += 5;
		
		if(odd_multiplier < -2.0)	odd_multiplier = -2.0;
		if(odd_multiplier >  2.0)	odd_multiplier =  2.0;
		if(even_multiplier < -2.0)	even_multiplier = -2.0;
		if(even_multiplier >  2.0)	even_multiplier =  2.0;
		if(odd_offset < -255)		odd_offset = -255;
		if(odd_offset >  255)		odd_offset =  255;
		if(even_offset < -255)		even_offset = -255;
		if(even_offset >  255)		even_offset =  255;
	};

}


// -------------------------------------------------
// シェーダバイトコード
// -------------------------------------------------
function CustomFilterGetByteArray():ByteArray{

	var a:ByteArray = new ByteArray();
	var f:Function;

	f = a.writeUnsignedInt;
	f(0xa5010000); f(0x00a41400); f(0x496e7465); f(0x726c6163); 
	f(0x65537479); f(0x6c654669); f(0x6c746572); f(0xa00c6e61); 
	f(0x6d657370); f(0x61636500); f(0x696e7465); f(0x726c6163); 
	f(0x65207374); f(0x796c6500); f(0xa00c7665); f(0x6e646f72); 
	f(0x0048616b); f(0x7568696e); f(0x00a00876); f(0x65727369); 
	f(0x6f6e0001); f(0x00a00c64); f(0x65736372); f(0x69707469); 
	f(0x6f6e0083); f(0x43839383); f(0x5e815b83); f(0x8c815b83); 
	f(0x58959782); f(0xcc89a190); f(0xfc82f095); f(0x8ea682b7); 
	f(0x82e98374); f(0x8342838b); f(0x835e00a1); f(0x01020000); 
	f(0x0c5f4f75); f(0x74436f6f); f(0x726400a3); f(0x00047372); 
	f(0x6300a102); f(0x0401000f); f(0x64737400); f(0xa1010100); 
	f(0x00026576); f(0x656e5f6d); f(0x756c7469); f(0x706c6965); 
	f(0x7200a201); f(0x64656661); f(0x756c7456); f(0x616c7565); 
	f(0x003f8000); f(0x00a20c64); f(0x65736372); f(0x69707469); 
	f(0x6f6e008b); f(0xf4909497); f(0xf182cc83); f(0x4a838981); 
	f(0x5b82cc8f); f(0xe68e5a90); f(0xac95aa00); f(0xa1010801); 
	f(0x80086576); f(0x656e5f6f); f(0x66667365); f(0x7400a208); 
	f(0x64656661); f(0x756c7456); f(0x616c7565); f(0x000000a2); 
	f(0x0c646573); f(0x63726970); f(0x74696f6e); f(0x008bf490); 
	f(0x9497f182); f(0xcc834a83); f(0x89815b82); f(0xcc89c18e); 
	f(0x5a90ac95); f(0xaa00a101); f(0x01000001); f(0x6f64645f); 
	f(0x6d756c74); f(0x69706c69); f(0x657200a2); f(0x01646566); 
	f(0x61756c74); f(0x56616c75); f(0x65003f80); f(0x0000a20c); 
	f(0x64657363); f(0x72697074); f(0x696f6e00); f(0x8aef9094); 
	f(0x97f182cc); f(0x834a8389); f(0x815b82cc); f(0x8fe68e5a); 
	f(0x90ac95aa); f(0x00a10108); f(0x0180046f); f(0x64645f6f); 
	f(0x66667365); f(0x7400a208); f(0x64656661); f(0x756c7456); 
	f(0x616c7565); f(0x000000a2); f(0x0c646573); f(0x63726970); 
	f(0x74696f6e); f(0x008aef90); f(0x9497f182); f(0xcc834a83); 
	f(0x89815b82); f(0xcc89c18e); f(0x5a90ac95); f(0xaa001d02); 
	f(0x00c10000); f(0x10003003); f(0x00f10200); f(0x10001d04); 
	f(0x00f30300); f(0x1b003202); f(0x00204000); f(0x00001d02); 
	f(0x00100200); f(0x40000802); f(0x00100200); f(0x80001e01); 
	f(0x80200200); f(0xc0003201); f(0x80100000); f(0x00002801); 
	f(0x80200180); f(0xc0001d02); f(0x80800080); f(0x00003400); 
	f(0x00000280); f(0x00000304); f(0x00e20000); f(0xfc001f02); 
	f(0x00200180); f(0x40003202); f(0x0010437f); f(0x00000403); 
	f(0x00800200); f(0xc0000303); f(0x00800200); f(0x80000104); 
	f(0x00e20300); f(0x00003500); f(0x00000000); f(0x00000304); 
	f(0x00e20000); f(0xa8001f02); f(0x00200180); f(0x00003202); 
	f(0x0010437f); f(0x00000403); f(0x00800200); f(0xc0000303); 
	f(0x00800200); f(0x80000104); f(0x00e20300); f(0x00003600); 
	f(0x00000000); f(0x00001d01); f(0x00f30400); 

	f = a.writeShort;
	f(0x1b00); 

	return a;

}


            
        }
    }
}


// ↓ pbk ファイルのコード
/* -----------------------------------------------------------------------------
	パラメータ
	even_multiplier	偶数列のカラーの乗算成分 (デフォルト 1.0)
	even_offset		偶数列のカラーの加算成分 (デフォルト   0)
	odd_multiplier	奇数列のカラーの乗算成分 (デフォルト 1.0)
	odd_offset		奇数列のカラーの加算成分 (デフォルト   0)
 ----------------------------------------------------------------------------- */
/*
<languageVersion : 1.0;>
kernel InterlaceStyleFilter<
	namespace : "interlace style";
	vendor : "Hakuhin";
	version : 1;
	description : "インターレース風の横線を表示するフィルタ";
>{
	input image4 src;	// 入力イメージ
	output pixel4 dst;	// 出力ピクセル


	// -------------------------------------
	// パラメータ
	// -------------------------------------
	parameter float even_multiplier<
		defaultValue:float(1.0);
		description : "偶数列のカラーの乗算成分";
	>;
	parameter int even_offset<
		defaultValue:int(0);
		description : "偶数列のカラーの加算成分";
	>;
	parameter float odd_multiplier<
		defaultValue:float(1.0);
		description : "奇数列のカラーの乗算成分";
	>;
	parameter int odd_offset<
		defaultValue:int(0);
		description : "奇数列のカラーの加算成分";
	>;


	// -------------------------------------
	// ピクセルごとに実行される関数
	// -------------------------------------
	void evaluatePixel(){

		// ピクセルの位置を取得
		float2 pos = outCoord();

		// ソースイメージからピクセルカラーを取得
		float4 color = sampleNearest(src,pos);

		// 奇数ライン
		if(int(mod(pos.y,2.0)) == 0){
			color.rgb *= odd_multiplier;
			color.rgb += float(odd_offset) / 255.0;

		// 偶数ライン
		}else{
			color.rgb *= even_multiplier;
			color.rgb += float(even_offset) / 255.0;
		}

		// ピクセルカラーを出力
		dst = color;
	}
}
*/




// -------------------------------------------------
// 外部画像をサムネイルとしてキャプチャ
// -------------------------------------------------
import flash.net.*;
import flash.events.*;
import flash.display.*;
import flash.geom.*;
function ThumbnailCapture(url:String,time:uint,stage:Stage):void{

	// キャプチャタイミング
	Wonderfl.capture_delay( time );

	
	// スプライト作成
	var sprite : Sprite = new Sprite();

	// ステージ最前面に配置
	stage.addChildAt(sprite,stage.numChildren);
	
	// ローダー
	var loader_obj : Loader = new Loader();
	loader_obj.contentLoaderInfo.addEventListener (Event.INIT,function(e:Event):void{

		// メモリからインスタンス化
		var loader_memory : Loader = new Loader();
		loader_memory.contentLoaderInfo.addEventListener (Event.INIT,function(e:Event):void{

			// キャプチャ
			var bmp : BitmapData = new BitmapData(loader_memory.width,loader_memory.height,true,0);
			sprite.addChild(loader_memory);
			bmp.draw(sprite);
			sprite.removeChild(loader_memory);
			loader_memory.unload();
			loader_obj.unload();
			loader_memory = null;
			loader_obj = null;
			
			
			// 画像を配置
			var bmp_obj : Bitmap = new Bitmap(bmp);
			bmp_obj .width = stage.stageWidth;
			bmp_obj .height = stage.stageHeight;
			stage.addChild(bmp_obj );
			
		});
		
		// 読み込み開始
		loader_memory.loadBytes(loader_obj.contentLoaderInfo.bytes);
	});
	
	// 読み込み開始
	loader_obj.load(new URLRequest(url));
}