/**
 * Copyright simultechnology ( http://wonderfl.net/user/simultechnology )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/riKg
 */

package
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.text.TextField;
	import flash.text.TextFormat;
	
	[SWF(backgroundColor="0x000000")]  
	public class Main extends Sprite
	{
		private var _maruArray:Array = new Array();
		private var _onPositionX:Number;
		private var _onPositionY:Number;
		
		public function Main()
		{
			// 文字列フォーマットの指定
			var tm:TextFormat = new TextFormat();
			tm.bold = true;
			tm.font = "Gothic";
			tm.color = 0xFFFFFF;
			tm.size = 20;
			// 文字列の作成
			var tf:TextField = new TextField();
			tf.defaultTextFormat = tm;
			tf.width = 300;
			tf.text = "Click anywhere!!";
			tf.x = stage.stageWidth/2;
			tf.y = stage.stageHeight/2;
			this.stage.addChildAt(tf, 0);
			this.addEventListener(Event.ENTER_FRAME, onEnter);
			stage.addEventListener(MouseEvent.CLICK, onClick);
		}
		
		private function makeBall():void {
			
			for (var i:int = 0; i < 50; i++) {
				var maru:Sprite = new Sprite();
				maru.graphics.beginFill(Math.random() * 0xFFFFFF, Math.random());
				maru.graphics.drawCircle(0, 0, Math.random() * 20);
				maru.graphics.endFill();
				// wonderfl上のステージ上のどこか
				maru.x = Math.random() * 465;
				maru.y = Math.random() * 465;
				_maruArray.push(maru);
				this.addChild(maru);
			}
		}
		
		private function onClick(e:MouseEvent):void
		{
			makeBall();
			_onPositionX = mouseX;
			_onPositionY = mouseY;
		}
		
		private function onEnter(e:Event):void
		{
			var len:int = _maruArray.length;
			for (var i:int = 0; i < len; i++) {
				var n:Number = Math.random();
				var m:Number = Math.random();
				var distance:Number = n + m;
				
				if (distance >0.95 && distance < 1.05) {
					_maruArray[i].x = _maruArray[i].x * n + _onPositionX * m;
					_maruArray[i].y = _maruArray[i].y * m + _onPositionY * n;
					// 円オブジェクトとマウスの距離が10以内に近づいたら、見えなくする
					if (Math.abs(_maruArray[i].x - _onPositionX) < 10) {
						_maruArray[i].alpha = 0;
					}
				}
			}
		}
	}
}