/**
 * Copyright littlepad ( http://wonderfl.net/user/littlepad )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/riH9
 */

package {
    import flash.display.BlendMode;
    import flash.geom.ColorTransform;
    import flash.events.Event;
    import flash.geom.Point;
    import flash.display.Bitmap;
    import flash.geom.Matrix;
    import flash.text.TextFormat;
    import flash.text.TextField;
    import flash.display.PixelSnapping;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        private var _particles:Array;
        private var _textPoints:Array;
        private var _bmd:BitmapData;
        private var _bmp:Bitmap;
        private var _effectBmd:BitmapData;
        private var _effectBmp:Bitmap;
        public function FlashTest() {
            init();
        }
        
        private function init():void {
            _bmd = new BitmapData(465, 465, false, 0x000000);
            _bmp = new Bitmap(_bmd, PixelSnapping.NEVER, false);
            addChild(_bmp);
            
            _effectBmd = new BitmapData(465/4, 465/4, false, 0x000000);
            _effectBmp = new Bitmap(_effectBmd, PixelSnapping.NEVER, true);
            _effectBmp.scaleX = _effectBmp.scaleY = 4;
            _effectBmp.blendMode = BlendMode.ADD;
            addChild(_effectBmp);
            
            var tf:TextField = new TextField();
            var tfm:TextFormat = new TextFormat();
            tfm.font = "_sans";
            tfm.size = 100;
            tfm.color = 0x000000;
            tf.defaultTextFormat = tfm;
            tf.text = "wonderfl";
            tf.width = tf.textWidth;
            var textBmd:BitmapData = new BitmapData(tf.width, tf.height, false, 0xFFFFFF);
            textBmd.draw(tf, new Matrix());
            
            _textPoints = new Array();
            _particles = new Array();
            for(var i:uint = 0; i < textBmd.width; i++){
                for(var j:uint = 0; j < textBmd.height; j++){
                    var c:Number = textBmd.getPixel(i, j);
                    if(c == 0){
                        _textPoints.push(new Point(i + 45, j + 150));
                        var p:Particle = new Particle();
                        p.x = Math.random() * 465;
                        p.y = Math.random() * 465;
                        _particles.push(p);
                    }
                }
            }
            addEventListener(Event.ENTER_FRAME, update);

        }
        
        private function update(e:Event):void {
            _bmd.lock();
            _bmd.colorTransform(_bmd.rect, new ColorTransform(1, 1, 1, 1, -10, -3, -3));
            for(var i:uint = 0; i < _particles.length; i++){
                _particles[i].x = _particles[i].x + (_textPoints[i].x - _particles[i].x) / 80;
                _particles[i].y = _particles[i].y + (_textPoints[i].y - _particles[i].y) / 80;
                if(Math.abs(_textPoints[i].x - _particles[i].x) < 1){
                    _particles[i].x = _textPoints[i].x;
                }
                if(Math.abs(_textPoints[i].y - _particles[i].y) < 1){
                    _particles[i].y = _textPoints[i].y;
                }
                _bmd.setPixel(_particles[i].x, _particles[i].y, _particles[i].c);
            }
            _bmd.unlock();
            _effectBmd.fillRect(_effectBmd.rect, 0x000000);
            _effectBmd.draw(_bmd, new Matrix(1/4, 0, 0, 1/4));
        }

    }
}

internal class Particle {
    public var x:Number;
    public var y:Number;
    public var c:Number;
    public function Particle(){
        x = 0;
        y = 0;
        c = 0xFFFFFF;
    }

}
