/**
 * Copyright kotobuki ( http://wonderfl.net/user/kotobuki )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rhvb
 */

// A simple example of how to connect a Wii Nunchuck to
// an Arduino board via a WiiChuck adapter
// 
// You have to upload Firmata/I2CFirmata (included in Arduino 0017)
// in prior to run this example
// 
// Reference
// http://todbot.com/blog/2008/02/18/wiichuck-wii-nunchuck-adapter-available/
// 
// Hardware
// http://www.switch-science.com/products/detail.php?product_id=221
// http://store.fungizmos.com/index.php?main_page=product_info&cPath=69&products_id=212
// http://www.sparkfun.com/commerce/product_info.php?products_id=9281

package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.utils.getTimer;
    import funnel.*;
    import funnel.gui.OnScreenController;
    import funnel.i2c.*;

    public class ArduinoI2CTest_Nunchuck extends Sprite {
        private var aio:Arduino;
        private var nunchuck:WiiNunchuck;
        private var joystickX:OnScreenController;
        private var joystickY:OnScreenController;
        private var accelX:OnScreenController;
        private var accelY:OnScreenController;
        private var accelZ:OnScreenController;
        private var zButton:OnScreenController;
        private var cButton:OnScreenController;

        public function ArduinoI2CTest_Nunchuck() {
            var config:Configuration = Arduino.FIRMATA;
            config.enablePowerPins();
            aio = new Arduino(config);
            aio.addEventListener(FunnelEvent.I2C_POWER_PINS_READY, onI2CPowerPinsReady);

            createGUI();
        }

        private function onI2CPowerPinsReady(event:Event):void {
            nunchuck = new WiiNunchuck(aio);
            nunchuck.addEventListener(Event.CHANGE, onChange);
            addEventListener(Event.ENTER_FRAME, loop);
        }

        private function loop(event:Event):void {

        }

        private function onChange(e:Event):void {
            joystickX.value = nunchuck.joystickX;
            joystickY.value = nunchuck.joystickY;
            accelX.value = nunchuck.x;
            accelY.value = nunchuck.y;
            accelZ.value = nunchuck.z;
            cButton.value = nunchuck.cButton;
            zButton.value = nunchuck.zButton;
        }

        private function createGUI():void {
            joystickX = new OnScreenController("Joy X", 128, OnScreenController.ANALOG, false, -1, 1);
            joystickX.y = 0;
            addChild(joystickX);

            joystickY = new OnScreenController("Joy Y", 128, OnScreenController.ANALOG, false, -1, 1);
            joystickY.y = 20;
            addChild(joystickY);

            accelX = new OnScreenController("Accel X", 128, OnScreenController.ANALOG, false, -1, 1);
            accelX.y = 40;
            addChild(accelX);

            accelY = new OnScreenController("Accel Y", 128, OnScreenController.ANALOG, false, -1, 1);
            accelY.y = 60;
            addChild(accelY);

            accelZ = new OnScreenController("Accel Z", 128, OnScreenController.ANALOG, false, -1, 1);
            accelZ.y = 80;
            addChild(accelZ);

            cButton = new OnScreenController("C", 58, OnScreenController.DIGITAL_TOGGLE, false);
            cButton.y = 100;
            addChild(cButton);

            zButton = new OnScreenController("Z", 58, OnScreenController.DIGITAL_TOGGLE, false);
            zButton.y = 120;
            addChild(zButton);
        }
    }
}