/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rhVs
 */

/*
Matrix3D.appendScale();
と同じ機能の関数を作ってみる。

処理としては
パラメーターで作った行列にentity行列をappendする。

パラメーターで作る行列は
scaleを変えるだけなので対角行列になるが、
これはめんどくさいだけなので、
行列は作らずに、対応する要素毎に乗算するのみ。


各要素をrandomで値を入れて、appendScaleし、
行列の各要素を比較して確認とした。

appendScale
http://help.adobe.com/ja_JP/AS3LCR/Flash_10.0/flash/geom/Matrix3D.html#appendScale()

*/
package {
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.TimerEvent;
	import flash.geom.Matrix3D;
	import flash.text.TextField;
	import flash.geom.Vector3D;
	import flash.system.Capabilities;
	import flash.utils.Timer;
	public class Main extends Sprite {
		private var builtinStage:Sprite = Create.newSprite( { x:stage.stageWidth / 2, y:stage.stageWidth/2 } );
		private var mtrx3DStage:Sprite = Create.newSprite( { x:stage.stageWidth / 2, y:stage.stageWidth/2 } );
		//ビルトイン関数用の赤い四角
		private var builtinRect:Sprite = Create.newSprite( { z:0 }, Create.drawRect( { x: -50, y: -50, width:100, height:100, color:0xFF0000 , alpha:0.5 } ));
		//同機能関数(mtrx3D)用の青い丸
		private var mtrx3DRect:Sprite = Create.newSprite( { z:0 }, Create.drawCircle( { radius:50, color:0x0000FF , alpha:0.5 } ));
		private var tf:TextField = Create.newTextField( { width:stage.stageWidth, height:stage.stageHeight, wordWrap:true } );
		//確認用の値を用意
		private var builtinEntity:Matrix3D=new Matrix3D();
		private var mtrx3DEntity:Matrix3D=new Matrix3D();
		public function Main() {
			
			addChild(tf);
			addChild(builtinStage);
			addChild(mtrx3DStage);
			builtinStage.addChild(builtinRect);
			mtrx3DStage.addChild(mtrx3DRect);
			
			var myTimer:Timer = new Timer(1000);
			myTimer.addEventListener(TimerEvent.TIMER, TIMER);
			myTimer.start();
			addEventListener(Event.ENTER_FRAME, ENTER_FRAME);
		}
		private function setTex():void {
			var txt:String = "◆同機能関数Mtrx3D.appendScale" + Capabilities.version + "での実行結果\n\n";
			var builtinRawData:Vector.<Number>=builtinEntity.rawData;
			txt+="↓Matrix3D.appendScaleの結果\n"+builtinRawData+"\n";
			var mtrx3DRawData:Vector.<Number>=mtrx3DEntity.rawData;
			txt+="\n↓同機能関数Mtrx3D.appendScaleの結果\n"+mtrx3DRawData+"\n\n";
			txt+=Util.hikaku(builtinRawData,mtrx3DRawData);
			tf.text = txt;
		}
		
		private function TIMER(e:TimerEvent):void {
			if (Math.random() < 0.5) {
				//たまには初期化してやらないと、画面から外れ続けてしまうので。
				builtinEntity.identity();
				mtrx3DEntity.identity();
			}
			var xScale:Number = Math.random() * 10 - 5;
			var yScale:Number = Math.random() * 10 - 5;
			var zScale:Number = Math.random() * 10 - 5;
			//計算
			builtinEntity.appendScale(xScale, yScale, zScale);
			Mtrx3D.appendScale(mtrx3DEntity, xScale, yScale, zScale);
			setTex();
		}
		private function ENTER_FRAME(e:Event):void {
			var temp:Vector3D;
			temp = builtinEntity.decompose()[2].add(builtinRect.transform.matrix3D.decompose()[2]);
			temp.scaleBy(0.5);
			builtinRect.scaleX = temp.x;
			builtinRect.scaleY = temp.y;
			builtinRect.scaleZ = temp.z;
			
			temp = mtrx3DEntity.decompose()[2].add(mtrx3DRect.transform.matrix3D.decompose()[2]);
			temp.scaleBy(0.5);
			mtrx3DRect.scaleX = temp.x;
			mtrx3DRect.scaleY = temp.y;
			mtrx3DRect.scaleZ = temp.z;
		}
	}
}

class Mtrx3D{
	import flash.geom.Matrix3D;
	public static function appendScale(entity:Matrix3D,xScale:Number,yScale:Number,zScale:Number):void {
		var e:Vector.<Number>=Vector.<Number>(entity.rawData);
		e[0]*=xScale;
		e[1]*=yScale;
		e[2]*=zScale;
		e[4]*=xScale;
		e[5]*=yScale;
		e[6]*=zScale;
		e[8]*=xScale;
		e[9]*=yScale;
		e[10]*=zScale;
		e[12]*=xScale;
		e[13]*=yScale;
		e[14]*=zScale;
		entity.rawData=e;
	}

}

import flash.geom.Matrix3D;
import flash.geom.Vector3D;
class Util {
	import flash.system.Capabilities;	
	public static function version():uint{
		var ver_array:Array = Capabilities.version.substr(4).split(",");
		return int(ver_array[0])*100000000+int(ver_array[1])*1000000+int(ver_array[2])*1000+int(ver_array[3]);
	}
	
	public static function hikaku(v0:Vector.<Number>,v1:Vector.<Number>):String {
		var _str:String="↓二つのMatrixの要素毎の差(比)\n";
		var _n:int=v0.length;
		for (var i:int = 0; i < _n; i++) {
			if (v0[i]==v1[i]) {
				_str += "["+i+"]:"+(v0[i]-v1[i])+"\n";
			}else{
				_str += "[" + i + "]:" +(v0[i]-v1[i])+"("+ (v0[i] - v1[i]) / ((v0[i] + v1[i]) * 0.5) + ")\n";
			}
		}
		return _str;
	}

	public static function random16():Vector.<Number> {
		var _v:Vector.<Number>=new Vector.<Number>(16,true);
		for (var i:int=0; i<16; i++) {
			_v[i]=Math.random()*200-100;
		}
		return _v;
	}
	public static function randomMatrix3D():Matrix3D{
		var mt:Matrix3D = new Matrix3D();
		var v:Vector.<Vector3D>=new Vector.<Vector3D>(3);
		v[0]=new Vector3D(200*Math.random()-100,200*Math.random()-100,200*Math.random()-100);//平行移動、
		v[1]=new Vector3D(10*Math.random()-5,10*Math.random()-5,10*Math.random()-5);//回転
		v[2] = new Vector3D(3 * Math.random(), 3 * Math.random(), 3 * Math.random());//拡大 / 縮小
		mt.recompose(v);
		return new Matrix3D(mt.rawData);
	}
}


import flash.display.DisplayObject;
import flash.display.Graphics;
import flash.text.TextField;
import flash.text.TextFieldType;
import flash.text.TextFormat;
import flash.display.Sprite;
import flash.display.Shape;
import flash.display.SimpleButton;

class Create{
	public static var defaultTextFormat:TextFormat = new TextFormat();
	
	public static function newSimpleButton(x_y_w_h_txt:Array = null,property:Array=null,graphics:Array=null):SimpleButton{
		
		var _x:Number = x_y_w_h_txt[0];
		var _y:Number = x_y_w_h_txt[1];
		var _width:Number = x_y_w_h_txt[2];
		var _height:Number = x_y_w_h_txt[3];
		var _text:String = x_y_w_h_txt[4];
		
		var upState:Sprite = newSprite({x:_x,y:_y},{graphics:toDrawRect({color:0xCCCCCC,width:_width,height:_height,round:8})});
		upState.addChild(newShape({x:2,y:2},{graphics:toDrawRect({color:0xE5E5E5,width:_width-4,height:_height-4,round:6})}));
		var overState:Sprite = newSprite({x:_x,y:_y},{graphics:toDrawRect({color:0xBBBBBB,width:_width,height:_height,round:8})});
		overState.addChild(newShape({x:2,y:2},{graphics:toDrawRect({color:0xEEEEEE,width:_width-4,height:_height-4,round:6})}));
		var downState:Sprite = newSprite({x:_x,y:_y},{graphics:toDrawRect({color:0xAAAAAA,width:_width,height:_height,round:8})});
		downState.addChild(newShape({x:2,y:2},{graphics:toDrawRect({color:0xDDDDDD,width:_width-4,height:_height-4,round:6})}));
		var hitTestState:Shape = newShape({x:_x,y:_y},{graphics:toDrawRect({width:_width,height:_height,round:8})});

		if(x_y_w_h_txt[4]){
			upState.addChild(newTextField({x:0,y:2,width:x_y_w_h_txt[2],height:x_y_w_h_txt[3]-2,text:x_y_w_h_txt[4],setTextFormat:[{font:"_sans",align:"center"}]}));
			overState.addChild(newTextField({x:0,y:2,width:x_y_w_h_txt[2],height:x_y_w_h_txt[3]-2,text:x_y_w_h_txt[4],setTextFormat:[{font:"_sans",align:"center"}]}));
			downState.addChild(newTextField({x:0,y:3,width:x_y_w_h_txt[2],height:x_y_w_h_txt[3]-3,text:x_y_w_h_txt[4],setTextFormat:[{font:"_sans",align:"center"}]}));
		}
		var sb:SimpleButton = new SimpleButton(upState,overState,downState,hitTestState);
		
		return sb;
	}
	public static function toDrawRect(... args):Array{
		var _x:Number = args[0]["x"]?args[0]["x"]:0;
		var _y:Number = args[0]["y"]?args[0]["y"]:0;
		var _width:Number = args[0]["width"]?args[0]["width"]:100;
		var _height:Number = args[0]["height"]?args[0]["height"]:100;
		var _color:Number = args[0]["color"]?args[0]["color"]:0xFF0000;
		var _alpha:Number = args[0]["alpha"]?args[0]["alpha"]:1;
		var _round:Number = args[0]["round"]?args[0]["round"]:0;
		var _lineSize:Number = args[0]["lineSize"]?args[0]["lineSize"]:0;
		var _lineColor:Number = args[0]["lineColor"]?args[0]["lineColor"]:0;
		var _lineAlpha:Number = args[0]["lineAlpha"]?args[0]["lineAlpha"]:0;
		var _ellipseWidth:Number = args[0]["ellipseWidth"]?args[0]["ellipseWidth"]:_round;
		var _ellipseHeight:Number = args[0]["ellipseHeight"]?args[0]["ellipseHeight"]:_ellipseWidth;
		return [{beginFill:[_color,_alpha]},{drawRoundRect:[_x,_y,_width,_height,_ellipseWidth,_ellipseHeight]}];
	}
	public static function drawRect(... args):Object{
		var _x:Number = args[0]["x"]?args[0]["x"]:0;
		var _y:Number = args[0]["y"]?args[0]["y"]:0;
		var _width:Number = args[0]["width"]?args[0]["width"]:100;
		var _height:Number = args[0]["height"]?args[0]["height"]:100;
		var _color:Number = args[0]["color"]?args[0]["color"]:0xFF0000;
		var _alpha:Number = args[0]["alpha"]?args[0]["alpha"]:1;
		var _round:Number = args[0]["round"]?args[0]["round"]:0;
		var _lineSize:Number = args[0]["lineSize"]?args[0]["lineSize"]:0;
		var _lineColor:Number = args[0]["lineColor"]?args[0]["lineColor"]:0;
		var _lineAlpha:Number = args[0]["lineAlpha"]?args[0]["lineAlpha"]:0;
		var _ellipseWidth:Number = args[0]["ellipseWidth"]?args[0]["ellipseWidth"]:_round;
		var _ellipseHeight:Number = args[0]["ellipseHeight"]?args[0]["ellipseHeight"]:_ellipseWidth;
		var resultObj:Object;
		if(_round || _ellipseWidth || _ellipseHeight){
			resultObj = { graphics:[ { beginFill:[_color, _alpha] }, { drawRoundRect:[_x, _y, _width, _height, _ellipseWidth, _ellipseHeight] } ] };
		}else {
			resultObj = { graphics:[ { beginFill:[_color, _alpha] }, { drawRect:[_x, _y, _width, _height] } ] };
		}
		return resultObj;
	}
	public static function drawCircle(... args):Object{
		var _x:Number = args[0]["x"]?args[0]["x"]:0;
		var _y:Number = args[0]["y"]?args[0]["y"]:0;
		var _color:Number = args[0]["color"]?args[0]["color"]:0xFF0000;
		var _alpha:Number = args[0]["alpha"]?args[0]["alpha"]:1;
		var _r:Number = args[0]["r"]?args[0]["r"]:100;
		var _radius:Number = args[0]["radius"]?args[0]["radius"]:_r;
		var _width:Number = args[0]["width"]?args[0]["width"]:_radius;
		var _height:Number = args[0]["height"]?args[0]["height"]:_radius;
		var _lineSize:Number = args[0]["lineSize"]?args[0]["lineSize"]:0;
		var _lineColor:Number = args[0]["lineColor"]?args[0]["lineColor"]:0;
		var _lineAlpha:Number = args[0]["lineAlpha"]?args[0]["lineAlpha"]:0;
		var resultObj:Object;
		if(_width == _height){
			resultObj = { graphics:[ { beginFill:[_color, _alpha] }, { drawCircle:[_x, _y, _radius] } ] };
		}else {
			resultObj = { graphics:[ { beginFill:[_color, _alpha] }, { drawEllipse:[_x, _y, _width, _height] } ] };
		}
		return resultObj;
	}

	public static function newShape(... args):Shape{
		var sp:Shape;
		var _str:String;
		var _length:int = args.length;
		for (var i:int = 0; i < _length; i++) {
			var _obj:Object = args[i];
			if(i == 0){
				if(_obj.Shape){
					sp = _obj.Shape;
				}else{
					sp = new Shape();
				}
			}
			if(_obj.graphics){
				for (var j:int = 0; j < _obj.graphics.length; j++) {
					if(_obj.graphics[j]){
						for (_str in _obj.graphics[j]) {
							//trace(_str,_obj.graphics[j][_str])
							sp.graphics[_str].apply(null, _obj.graphics[j][_str]);
						}
					}
				}
			}
			for (_str in _obj) {
				if(_str != "Shape" && _str != "graphics"){
					sp[_str] = _obj[_str];
				}
			}
		}
		return sp;
	}
	public static function newSprite(... args):Sprite{
		var sp:Sprite;
		var _str:String;
		var _length:int = args.length;
		for (var i:int = 0; i < _length; i++) {
			var _obj:Object = args[i];
			if(i == 0){
				if(_obj.Sprite){
					sp = _obj.Sprite;
				}else{
					sp = new Sprite();
				}
			}
			if(_obj.graphics){
				for (var j:int = 0; j < _obj.graphics.length; j++) {
					if(_obj.graphics[j]){
						for (_str in _obj.graphics[j]) {
							sp.graphics[_str].apply(null, _obj.graphics[j][_str]);
						}
					}
				}
			}
			for (_str in _obj) {
				if(_str != "Sprite" && _str != "graphics" && _str != "addChild"){
					sp[_str] = _obj[_str];
				}
			}
			if(_obj.addChild){
				sp.addChild(_obj.addChild);
			}
		}
		return sp;
	}
	public static function newTextField(... args):TextField{
		var ta:TextField = new TextField();
		ta.defaultTextFormat = defaultTextFormat;
		var _length:int = args.length;
		for (var i:int = 0; i < _length; i++) {
			var _obj:Object = args[i];
			for (var _str:String in _obj) {
				if(_str != "setTextFormat"){
					ta[_str] = _obj[_str];
				}
			}
			if(_obj.setTextFormat){
				var format:TextFormat = new TextFormat();
				if(_obj.setTextFormat[0] is TextFormat){
					format = _obj.setTextFormat[0];
				}else{
					for (var tf_str:String in _obj.setTextFormat[0]) {
						format[tf_str] = _obj.setTextFormat[0][tf_str];
					}
				}
				ta.setTextFormat(format,isNaN(_obj.setTextFormat[1])?-1:_obj.setTextFormat[1],isNaN(_obj.setTextFormat[2])?-1:_obj.setTextFormat[2]);
			}
		}
		return ta;
	}
}
