/**
 * Copyright codalx ( http://wonderfl.net/user/codalx )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rhHu
 */

package 
{
    import net.hires.debug.Stats;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Point;
    
    [SWF(backgroundColor="#000000", width="465", height="465", frameRate="30")]
    public class FlashTest extends Sprite 
    {
        public function FlashTest():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private const RAD : Number = Math.PI / 180;
        private const R : Number = 60 * RAD;
        private const W : int = 465;
        
        private var _point : Point;
        private var _phase : Number = 0;
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            _point = new Point();
            
            x = -W;
            y = -W / 5;
            
            stage.addChild(new Stats);
            
            with((stage.addChildAt(new Shape, 0) as Shape).graphics){
                beginFill(0x0); drawRect(0, 0, W, W); endFill();
            }
            
            addEventListener(Event.ENTER_FRAME, _update);
        }
        
        private function _update(e:Event):void
        {
            graphics.clear();
            
            for (var i:int = 0; i <= 1024; i += 40) {
            for (var j:int = 0; j <= 1024; j += 4) {                
                _point.x = j;
                _point.y = _getWaves(j+_phase, i+_phase);
                
                _point.x = _point.x * Math.cos(R) + i * Math.sin(R);
                _point.y = _point.y * Math.cos(R) - ( -_point.x * Math.sin(R) + i * Math.cos(R)) * Math.sin(R);
                
                graphics.lineStyle(0.5, (i / W * 0xFF | 0) << 16 | (j / W * 0xFF | 0) << 8 | 0xFF, 0.8);
                
                if (j == 0)
                    graphics.moveTo(_point.x, _point.y);
                else
                    graphics.lineTo(_point.x, _point.y);
            }}
            
            _phase += Math.PI % (2 * Math.PI);
        }
        
        private function _getWaves(px:Number, pz:Number):Number
        {
            return 90*(Math.cos(Math.sqrt(px*px+pz*pz)*RAD)) + Math.cos(5*Math.sqrt(px*px+pz*pz)*RAD);
        }
    }
    
}