/**
 * Copyright zahir ( http://wonderfl.net/user/zahir )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rhGg
 */

package
{
    import flash.display.BitmapData;
    import flash.display.Graphics;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.display.TriangleCulling;
    import flash.events.Event;
    import flash.geom.Matrix3D;
    import flash.geom.PerspectiveProjection;
    import flash.geom.Utils3D;
    import flash.geom.Vector3D;
    import flash.text.TextField;
    
    import net.hires.debug.Stats;
    
    public class Triangles_tes3 extends Sprite
    {
        private const v:Vector.<Vector.<Number>> = new <Vector.<Number>>[
            new <Number>[-10.0000, 10.0000, 10.0000],
            new <Number>[-10.0000, -10.0000, 10.0000],
            new <Number>[10.0000, 10.0000, 10.0000],
            new <Number>[10.0000, -10.0000, 10.0000],
            
            new <Number>[10.0000, 10.0000, -10.0000],
            new <Number>[10.0000, -10.0000, -10.0000],
            new <Number>[-10.0000, 10.0000, -10.0000],
            new <Number>[-10.0000, -10.0000, -10.0000]
        ];
        
        private var cube:Vector.<Number>;
        
        private var vertices:Vector.<Number>;
        private var uvts:Vector.<Number>;
        private var indices:Vector.<int>;
        private var sortedIndices:Vector.<int>;
        private var faces:Array;
        
        private var pv:Vector.<Number>;
        private var transVertex:Vector.<Number>;
        
        private var t:TextField;
        private var g:Graphics;
        private var proj:Matrix3D;
        
        private var bd:BitmapData;
        
        private var rot:Number = 0;
        
        private var cull:String = TriangleCulling.POSITIVE;
        
        
        public function Triangles_tes3()
        {
            super();
            var s:Shape = addChild( new Shape() ) as Shape;
            s.x = s.y = 465>>1;
            g = s.graphics;
            
            addChild( (t = new TextField()) );
            t.width = 100;
            t.x = stage.stageWidth - t.width;
            
            addChild( new Stats() );
            
            // init
            
            cube = createCube();
            
            vertices = new <Number>[];
            uvts = new <Number>[];
            indices = new <int>[];
            faces = [];
            proj = new PerspectiveProjection().toMatrix3D();
            
            bd = new BitmapData(256,256);
            for(var b:int = 0; b<=256; b++)
            {
                for(var g:int = 0; g<=256; g++)
                {
                    bd.setPixel( g,b, (0x0000 | (g<<8) | b) );
                }
            }
            
            // creation vertices
            var cl:int = 10; // 10 -> 6000poly 15 -> 20250poly
            var margin:int = 25;
            var m:Matrix3D = new Matrix3D();
            for( var i:int = 0; i<cl; i++)
            {
                for( var j:int = 0; j<cl; j++)
                {
                    for( var k:int = 0; k<cl; k++)
                    {
                        m.identity();
                        m.appendScale( 0.5, 0.5, 0.5);
                        m.appendTranslation( k * margin, j * margin, i * margin);
                        appendCube( m );
                    }
                }
            }
            var len:int = vertices.length / 3;
            for( i = 0; i<len; i++){
                indices[i] = i;
            }
            
            sortedIndices = new Vector.<int>( indices.length, true);
            
            t.appendText( "poly :: " +  vertices.length/18);
            
            pv = new Vector.<Number>( vertices.length, true );
            
            addEventListener(Event.ENTER_FRAME, function(e:Event):void{ render(); });
            
            render();
        }
        
        private function render():void
        {
            var m:Matrix3D = new Matrix3D();
            
            m.appendRotation( rot, Vector3D.X_AXIS );
            m.appendRotation( rot++, Vector3D.Y_AXIS );
            m.appendTranslation(0,0, 800);
            m.append( proj );
            Utils3D.projectVectors( m, vertices, pv, uvts);
            
            /*// sort none
            g.clear();
            g.beginBitmapFill( bd, null, true, true);
            g.drawTriangles( pv , null, uvts, cull);
            g.endFill();
            //*/
            
            // z-sort
            //*
            var face:Face;
            var inc:int = 0;
            var len:int = indices.length;
            for (var i:int = 0; i<len; i+=3)
            {
                face = faces[inc] as Face;
                face.x = indices[i];
                face.y = indices[ i + 1 ];
                face.z = indices[ i + 2 ];
                var i3:int = i*3;
                face.w = uvts[ i3 + 2 ] + uvts[ i3 + 5 ] + uvts[ i3 + 8 ];
                inc++;
            }
            inc = 0;
            faces.sortOn("w", Array.NUMERIC);
            for each (face in faces){
                sortedIndices[inc++] = face.x;
                sortedIndices[inc++] = face.y;
                sortedIndices[inc++] = face.z;
            }
            g.clear();
            
            //g.beginFill( 0x00cc00, 1);
            g.beginBitmapFill( bd, null, true, false);
            g.drawTriangles( pv , sortedIndices, uvts, cull);
            g.endFill();
            //*/
        }
        
        public function appendCube( matrix:Matrix3D ):void
        {
            if(!transVertex) transVertex = new Vector.<Number>();
            matrix.transformVectors( cube, transVertex );
            vertices = vertices.concat( transVertex );
            uvts.push(
                1,1,0, 1,0,0, 0,1.0,
                0,1,0, 0,0,0, 1,1,0,
                
                0,0,0, 0,1,0, 1,0,0,
                1,0,0, 1,1,0, 0,1,0,
                
                1,1,0, 1,0,0, 0,1.0,
                0,1,0, 0,0,0, 1,1,0,
                
                1,1,0, 1,0,0, 0,1.0,
                0,1,0, 0,0,0, 1,1,0,
                
                0,0,0, 0,1,0, 1,0,0,
                1,0,0, 1,1,0, 0,1,0,
                
                1,1,0, 1,0,0, 0,1.0,
                0,1,0, 0,0,0, 1,1,0
            );
            faces.push( new Face(), new Face(), new Face(), new Face(),new Face(), new Face(), new Face(), new Face(),new Face(), new Face(), new Face(), new Face() );
        }
        
        public function createCube():Vector.<Number>
        {
            if(cube) return cube;
            var vertices:Vector.<Number> = new <Number>[];
            vertices = vertices.concat( v[2], v[3], v[1] );
            vertices = vertices.concat( v[2], v[1], v[0] );
            
            vertices = vertices.concat( v[4], v[5], v[3] );
            vertices = vertices.concat( v[4], v[3], v[2] );
            
            vertices = vertices.concat( v[6], v[7], v[5] );
            vertices = vertices.concat( v[6], v[5], v[4] );
            
            vertices = vertices.concat( v[0], v[1], v[7] );
            vertices = vertices.concat( v[0], v[7], v[6] );
            
            vertices = vertices.concat( v[4], v[2], v[0] );
            vertices = vertices.concat( v[4], v[0], v[6] );
            
            vertices = vertices.concat( v[3], v[5], v[7] );
            vertices = vertices.concat( v[3], v[7], v[1] );
            return vertices;
        }
    }
}
class Face{
    public var w:Number, x:Number, y:Number, z:Number;
}