/**
 * Copyright paq ( http://wonderfl.net/user/paq )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rgzA
 */

// forked from bkzen's 【問題】Graphics の drawCircle と drawRoundRect が壊れました
package 
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.GradientType;
	import flash.display.Graphics;
	import flash.display.PixelSnapping;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.filters.BlurFilter;
	import flash.geom.Matrix;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.utils.ByteArray;
	
	/**
	 * Graphics.drawCircle と drawRoundRect が壊れました。
	 * 別の方法で、半径 CIRCLE_RADIUS の 円を書きなさい。
	 * @mxmlc -o bin/CircleTest.swf -load-config+=obj\Alltest3Config.xml
	 * @author jc at bk-zen.com
	 */
	public class CircleTest extends Sprite
	{
		private const ANSWER_COLOR: uint = 0x003366;
		private const COLOR: uint = 0x3399CC;
		private const CIRCLE_RADIUS: Number = 50;
		
		public function CircleTest() 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e: Event = null): void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			//
			var centerX: Number = (stage.stageWidth - CIRCLE_RADIUS) / 2;
			var centerY: Number = (stage.stageHeight - CIRCLE_RADIUS) / 2;
			var g: Graphics = graphics;
			// 差を見るために解答として先に半径+1 の円を描いておきます。
			g.beginFill(ANSWER_COLOR); g.drawCircle(centerX-125, centerY, CIRCLE_RADIUS + 1);
			
			// 
			drawCircle(g, centerX, centerY, CIRCLE_RADIUS, COLOR);
		}
		
		/**
		 * これを作る。
		 * @param	g
		 * @param	x
		 * @param	y
		 * @param	r
		 * @param	color
		 */
		public function drawCircle(g: Graphics, x: Number, y: Number, r: Number, color: uint): void
		{
			// 一時的に使用するBitmapを作成します。
			var temp_width:uint = r * 10;  // 幅
			var temp_height:uint = r * 10; // 高さ
			var temp_bmd:BitmapData = new BitmapData(temp_width, temp_height, true, 0x00ffffff);
			var temp_bmp:Bitmap = new Bitmap(temp_bmd);
			// 塗りつぶす
			temp_bmd.fillRect(new Rectangle(0, 0, temp_width, temp_height), 0xFF000000);
			// そしてぼかす！
			temp_bmp.filters = [new BlurFilter(temp_width, temp_height, 5)];
			
			// こちらが実際に使うBitmap
			temp_width = r * 11;  // 幅
			temp_height = r * 11; // 高さ
			var bmd:BitmapData = new BitmapData(temp_width, temp_height, true, 0x00ffffff);
			var bmp:Bitmap = new Bitmap(bmd);
			// Matrixで位置をずらさないと途切れる
			var m:Matrix = new Matrix();
			m.translate(r, r)
			// さっき作ったbmpを描画
			bmd.draw(temp_bmp, m);
			// smoothing を true にして、縮小することによってアンチエイリアスがかかる。
			bmp.smoothing = true;
			bmp.scaleX = 0.25;
			bmp.scaleY = 0.25;
			// 位置調整
			bmp.x = x - r-r*0.5;
			bmp.y = y - r - r * 0.5;
			// 子を追加
			addChild(bmp);
			
			temp_bmd.dispose();
			
			// ピクセルを全て取得
			var stream:ByteArray = bmd.getPixels(new Rectangle(0, 0, temp_width, temp_height));
			
			var num:uint = stream.length;
			var xx:uint = 0, yy:uint = 0, i:uint = 0;
			for (i = 0; i < num; i++ )
			{
				var alpha:Number = stream[i];
				i += 3;
				/* i += 3の代わりに↓のソースコードを入れると、色が取得できる
				 * var red:Number   = stream[i++];
				 * var green:Number = stream[i++];
				 * var blue:Number  = stream[i++];
				*/
				
				// 閾値を超えていた場合は色を入れて、それより低い場合はアルファを0に。
				// 129が一番滑らかに見える（気がする）
				if (alpha > 129)
				{
					bmd.setPixel32(xx, yy, 0xFF003366);
				}
				else
				{
					bmd.setPixel32(xx, yy, 0x00000000);
				}
				xx++;
				if (xx >= temp_width)
				{
					xx = 0;
					yy++;
				}
			}
		}
		
	}

}