/**
 * Copyright GreekFellows ( http://wonderfl.net/user/GreekFellows )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rgtJ
 */

package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Matrix3D;
    import flash.geom.Vector3D;
    
    /**
     * ...
     * @author Greek Fellows
     */
    public class Main extends Sprite 
    {
        private var sprite:Sprite;
        private var core:Sprite;
        
        private var array:Array;
        private var colors:Array;
        private var radii:Array;
        private var zsorted:Array;
        
        private var mxs:Array;
        private var mys:Array;
        private var mzs:Array;
        
        private var axs:Array;
        private var ays:Array;
        private var azs:Array;
        
        private var release:Boolean;
        
        private var field:Number;
        
        public function Main():void 
        {
            this.array = [];
            this.colors = [];
            this.radii = [];
            this.zsorted = [];
            
            this.mxs = [];
            this.mys = [];
            this.mzs = [];
            
            this.axs = [];
            this.ays = [];
            this.azs = [];
            
            this.release = false;
            
            this.field = 500;
            
            init();
            
            var bg:Sprite = new Sprite();
            bg.graphics.beginFill(0xffffff, 0);
            bg.graphics.drawRect(0, 0, 465, 465);
            bg.graphics.endFill();
            this.addChild(bg);
            
            this.sprite = new Sprite();
            this.sprite.x=465/2;
            this.sprite.y=465/2;
            this.sprite.z=0;
            this.addChild(this.sprite);
            
            this.core=new Sprite();
            this.core.x=0;
            this.core.y=0;
            this.core.z=0;
            this.sprite.addChild(this.core);
            
            this.addEventListener(MouseEvent.MOUSE_DOWN, startRelease);
            this.addEventListener(MouseEvent.MOUSE_UP, stopRelease);
            
            this.addEventListener(Event.ENTER_FRAME, spin);
            this.addEventListener(Event.ENTER_FRAME, orbitalize);
        }
        
        private function init():void {
            // change array here
            this.array = [];
            
            for (var creation:int = 0; creation < 50; creation++) {
                this.array.push( { vector:new Vector3D(Math.floor(Math.random() * this.field) - this.field / 2, Math.floor(Math.random() * this.field) - this.field / 2, Math.floor(Math.random() * this.field) - this.field / 2), color:Math.floor(Math.random() * 0xffffff / 5) * 5, radius:Math.random() * 45 + 5 } );
                this.mxs.push(0);
                this.mys.push(0);
                this.mzs.push(0);
                this.axs.push(0);
                this.ays.push(0);
                this.azs.push(0);
            }
        }
        
        private    function spin(e:Event):void {
            this.core.transform.matrix3D.appendRotation((mouseY - 300) / 100, Vector3D.X_AXIS);
            this.core.transform.matrix3D.appendRotation((mouseX - 400) / 100, Vector3D.Y_AXIS);
            
            this.sprite.graphics.clear();
            
            sortbyZ();
            
            for (var a:int = 0; a < this.zsorted.length; a++) {
                this.sprite.graphics.beginFill(this.zsorted[a].color, .75);
                this.sprite.graphics.drawCircle(graph(this.zsorted[a].vector,false).x, graph(this.zsorted[a].vector,false).y, this.zsorted[a].radius);
                this.sprite.graphics.endFill();
            }
        }
        
        private function orbitalize(e:Event):void {
            if (!release) {
                for (var ex:int = 0; ex < this.array.length; ex++) {
                    this.mxs[ex] += (0 - this.array[ex].vector.x) / 60;
                    this.mys[ex] += (0 - this.array[ex].vector.y) / 60;
                    this.mzs[ex] += (0 - this.array[ex].vector.z) / 60;
                    
                    this.array[ex].vector.x += this.mxs[ex];
                    this.array[ex].vector.y += this.mys[ex];
                    this.array[ex].vector.z += this.mzs[ex];
                    
                    this.mxs[ex] *= .95;
                    this.mys[ex] *= .95;
                    this.mzs[ex] *= .95;
                }
            } else {
                for (var ix:int = 0; ix < this.array.length; ix++) {
                    this.axs[ix] += Math.floor(Math.random() * 100 - 50) / 100;
                    this.ays[ix] += Math.floor(Math.random() * 100 - 50) / 100;
                    this.azs[ix] += Math.floor(Math.random() * 100 - 50) / 100;
                    
                    this.array[ix].vector.x += this.axs[ix];
                    this.array[ix].vector.y += this.ays[ix];
                    this.array[ix].vector.z += this.azs[ix];
                    
                    if (this.axs[ix] > 5 || this.azs[ix] < -5) {
                        this.axs[ix] *= (2 / 5);
                    }
                    if (this.ays[ix] > 5 || this.azs[ix] < -5) {
                        this.ays[ix] *= (2 / 5);
                    }
                    if (this.azs[ix] > 5 || this.azs[ix] < -5) {
                        this.azs[ix] *= (2 / 5);
                    }
                    
                    if (this.array[ix].vector.x > field / 2) {
                        this.axs[ix] *= -1;
                        this.array[ix].vector.x = field / 2;
                    }
                    if (this.array[ix].vector.x < -field / 2) {
                        this.axs[ix] *= -1;
                        this.array[ix].vector.x = -field / 2;
                    }
                    if (this.array[ix].vector.y > field / 2) {
                        this.ays[ix] *= -1;
                        this.array[ix].vector.y = field / 2;
                    }
                    if (this.array[ix].vector.y < -field / 2) {
                        this.ays[ix] *= -1;
                        this.array[ix].vector.y = -field / 2;
                    }
                    if (this.array[ix].vector.z > field / 2) {
                        this.azs[ix] *= -1;
                        this.array[ix].vector.z = field / 2;
                    }
                    if (this.array[ix].vector.z < -field / 2) {
                        this.azs[ix] *= -1;
                        this.array[ix].vector.z = -field / 2;
                    }
                }
            }
        }
        
        private function startRelease(me:MouseEvent):void {
            this.release = true;
        }
        
        private function stopRelease(me:MouseEvent):void {
            this.release = false;
        }
        
        private function graph(vector:Vector3D,transformVector:Boolean=true):Vector3D {
            var mat:Matrix3D = this.core.transform.matrix3D.clone();
            
            var xy:Vector3D = vector;
            if (transformVector) xy = mat.transformVector(vector);
            xy.w = (750 + xy.z) / 750;
            xy.project();
            
            return xy;
        }
        
        private function sortbyZ():void {
            this.zsorted = [];
            var mat:Matrix3D = this.core.transform.matrix3D.clone();
            
            for (var b:int = 0; b < this.array.length; b++) {
                this.zsorted.push( { vector:mat.transformVector(this.array[b].vector), color:this.array[b].color, radius:this.array[b].radius, z:mat.transformVector(this.array[b].vector).z } );
            }
            
            this.zsorted.sortOn("z", Array.NUMERIC | Array.DESCENDING);
        }
        
    }
    
}