/**
 * Copyright ll_koba_ll ( http://wonderfl.net/user/ll_koba_ll )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rgeG
 */

// forked from checkmate's fladdict challenge for amateurs
// マイクが必要です。
/**
 * Every frame you get screen caputre of the stage.
 * Generate new frame image with using last frames screen capture.
 * This is a starting point of recursive generative art.
 */
package {
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.display.Sprite;
    import flash.display.Graphics;
    import flash.events.Event;
    import flash.geom.ColorTransform;
    import flash.geom.Matrix;
    import flash.geom.Point;
    import flash.media.Microphone;
    import flash.events.StatusEvent;
    import flash.filters.*;

    
    public class Beginner extends Sprite {
        /**
         * Overwrite this update function.
         * Every frame the function is invoked with two bitmaps.
         * First one contains reference to the stage bitmap.
         * Second one contains static copy of stage.
         */
         
        public var canvas:BitmapData;
        public var drawHere:BitmapData;
        public var mat:Matrix;
        
        private var _mic:Microphone;
        private const RADIAN:Number = Math.PI*2;

        public function update():void{
            if (_mic == null) {
                _mic = Microphone.getMicrophone();
                _mic.setUseEchoSuppression(true);
                _mic.setLoopBack(true);
                _mic.setSilenceLevel(100,1000);
            }
            if (_mic.activityLevel < 0) return;
            trace(_mic.activityLevel);

            var mt:Matrix = new Matrix();
            mt.translate(240, 240);

            drawHere.draw(gizagiza(_mic.activityLevel*4), mt);
            canvas.draw(drawHere, null, null);

            canvas.colorTransform(drawHere.rect, new ColorTransform(Math.random()*0.4+0.6,Math.random()*0.4+0.6,Math.random()*0.4+0.6,1,0,0,0,0));
            
        }

        private function gizagiza(r:Number):Sprite {

            var a:Number = RADIAN/(r*2);
            var offset:Number = -RADIAN*0.25;
            var l:int = r*2;
            var s:Sprite = new Sprite();
            var g:Graphics = s.graphics;
            var f:Boolean = true;
            g.lineStyle(1, Math.random()*0xFFFFFF);
            g.moveTo(Math.cos(offset)*r, Math.sin(offset)*r);
            for (var i:int = 0; i<l; i++) {
                var rr:Number = Math.random()*r/2;
                if (i%5 != 0){
                    rr = 1;
                }
                g.lineTo(Math.cos(a*i + offset)*(r+rr), Math.sin(a*i + offset)*(r+rr));
            }
            g.lineTo(Math.cos(offset)*r, Math.sin(offset)*r);
            return s;
        }
        
               
        
        /**
         * ---------------------------------------
         * DO NOT CHANGE FOLLOWING CODES
         * DO NOT ACCESS FOLLOWING PROPERTIES DIRECTLY
         * ---------------------------------------
        */
        
       
        private var bitmap:Bitmap;
        
        
        public function Beginner() {
            canvas = new BitmapData(480,480,false,0x000000);
            bitmap = new Bitmap(canvas);
            addChild(bitmap);
            addEventListener(Event.ENTER_FRAME, _update);
        }
        
        public function _update(e:Event):void{
            if(drawHere)
                drawHere.dispose();
            drawHere = canvas.clone();
            update();
        }
    }
}
