/**
 * Copyright tokufxug ( http://wonderfl.net/user/tokufxug )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rgUm
 */

// forked from azuremous's forked from: FIO Basic Example: LED arduino
// forked from kotobuki's FIO Basic Example: LED
// forked from kotobuki's Gainer Basic Example: LED
// 画面上のボタンを押すとFIOボード上のD13に接続されたLEDが点灯し、
// ボタンを離すとボード上もLEDが消灯します
// 
// Reference
// http://funnel.cc/Main/GettingStarted
// http://funnel.cc/Hardware/FIO

package {
    import flash.display.Sprite;
    import flash.events.MouseEvent;
    
    import funnel.*;
    import funnel.ui.*;

    public class ArduinoBasic_LED extends Sprite {
        
        private var arduino:Arduino;
        
        private var squareButton:Sprite;

        public function ArduinoBasic_LED() {
            
            
            var config:Configuration = Arduino.FIRMATA;
            config.setDigitalPinMode(13, OUT);
            
            arduino = new Arduino(config);
            
            var onBoardLED:Pin = arduino.digitalPin(13);
            
            // ボタンの作成
            squareButton = new Sprite();
            squareButton.graphics.beginFill(0x808080);
            squareButton.graphics.drawRect(-25, -25, 50, 50);
            squareButton.graphics.endFill();
            squareButton.x = stage.stageWidth / 2;
            squareButton.y = stage.stageHeight / 2;
            squareButton.buttonMode = true;
            this.addChild(squareButton);

            
            // ボタンでLED入
            squareButton.addEventListener(MouseEvent.MOUSE_DOWN, 
	            function mousePressed(e:MouseEvent):void {
	        
	            		onBoardLED.value = 1.0;
	            		squareButton.scaleX = 1.2;
	            		squareButton.scaleY = 1.2;
	        		}
            );
            
            // ボタンでLED切
            squareButton.addEventListener(MouseEvent.MOUSE_UP, 
            
	            function mouseReleased(e:MouseEvent):void {
		            onBoardLED.value = 0.0;
		            squareButton.scaleX = 1.0;
		            squareButton.scaleY = 1.0;
	        		}
            );
        }
    }
}
