/**
 * Copyright HaraMakoto ( http://wonderfl.net/user/HaraMakoto )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rfxw
 */

// forked from 9re's Wonderfl Tank Game BulletRenderer Sample 0
// このコードを新着弾一覧http://flash-games.wonderfl.net/tank/list/bullets
// に表示させるためにはinfinite-tank-bullet
// というタグを追加してください
package
{
	// ai0
	import flash.display.BitmapData;
	import flash.display.Shape;
	import flash.display.Sprite;
	import flash.geom.ColorTransform;
	import flash.geom.Point;
	import flash.geom.Rectangle;
	import flash.system.Security;

        import flash.display.Bitmap;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.filters.BlurFilter;
	import flash.filters.DropShadowFilter;
	import flash.filters.GlowFilter;
	import flash.geom.ColorTransform;
	import flash.geom.Point;
        import flash.geom.Matrix;


	//
	// net.wonderfl
	import net.wonderfl.game.infinity_tank.development.*;
	/**
	 * @author 9re
	 */
	// クラス名は必ずBulletRendererにして、BulletRendererBaseを拡張して下さい
	// http://flash-games.wonderfl.net/static/asdoc/net/wonderfl/game/infinity_tank/bullet/BulletRendererBase.html
	[SWF(backgroundColor="#000000")]
	public class BulletRenderer extends BulletRendererBase
	{
		private var _ctfm:ColorTransform;
		private var _bullet:BitmapData;
		private var _point:Point;
		private var _color:HSBColor;
		private var _hue:int;
                private var _thunder:Thundaga;
		private var counter:int = 0;
                private var thunderList:Array = new Array();

		public function BulletRenderer() {
			_ctfm = new ColorTransform(1, 1, 1, 1 - 1/4);
			_bullet = new BitmapData(6, 6);
			_bullet.fillRect(new Rectangle(0, 0, 60, 6), 0x7fff0000);
			_point = new Point();
			_color = new HSBColor(0, 1, 0);
                        _thunder = new Thundaga();
                        addChild(_thunder);
                        _thunder.setBmd();
                        thunderList.push({x:0,y:0});
                        thunderList.push({x:0,y:0});
                        thunderList.push({x:0,y:0});
                        thunderList.push({x:0,y:0});
                        //addChild(thunderList[0]);
		}

		// このメソッドは毎フレーム呼ばれます。
		// _sceneプロパティーについては、詳しくは
		// http://flash-games.wonderfl.net/static/asdoc/net/wonderfl/game/infinity_tank/model/BattleScene.html
		// をご覧下さい
		override public function draw($bitmapData:BitmapData):void {
			$bitmapData.lock();
			
                        _color.hue = _hue;
			_hue += 7;
			_bullet.fillRect(new Rectangle(0, 0, 6, 60), 0x7f000000 | HSBColor.convertHSBtoRGB(_color.hue, 1, 0.6));
			// 弾道の尾を引かせるために前の像をアルファで少し残す
			$bitmapData.colorTransform($bitmapData.rect, _ctfm);
			// myBulletListが自分の弾のリスト。このようにfor文で回す
                       //雷発射
                         
                         var bmd:BitmapData
                         var m:Matrix = new Matrix()
                         var bullcounter:int = 0;
                         if(counter%20==0){
                             
                             _thunder.generateThunder(25,0,25,550-50);
                         }
                         for (var i:BoundBox = _scene.myBulletList; i; i = i.next) {
                                if(counter%20==0){
                                    
                                    if(!thunderList[bullcounter]) {
                                        //thunderList.push({x:i.position.x-465/2, y:i.position.y-465/2});
                                    }
                                    if(thunderList[bullcounter]) {
				        thunderList[bullcounter].x = i.position.x-25;
                                        thunderList[bullcounter].y = i.position.y-550;
                                        
                                    }
                                }
                                // i.positionに弾の座標が入ります。中心座標なので、左へ2、上へ3だけずらします
				_point.x = i.position.x - 2;
				_point.y = i.position.y - 3;
                                // bitmapdataに弾のビットマップを座標の所へコピーする
                                bmd = _thunder.bmd;
                                m.identity();
                                m.translate( thunderList[bullcounter].x, thunderList[bullcounter].y );
                                $bitmapData.draw( bmd, m, null, null, null, true );
                                bullcounter++;
			}
                        
			$bitmapData.copyPixels(_bullet, _bullet.rect, _point);
			$bitmapData.unlock();
                        counter++;
		}
		
	}


}

///////////////////////////////////////////////////////////////////////////////////////

import flash.display.Sprite;
import caurina.transitions.properties.CurveModifiers;
import caurina.transitions.Tweener;
import flash.geom.Point;
import flash.filters.BlurFilter;
import flash.filters.DropShadowFilter;
import flash.filters.GlowFilter;
import flash.geom.ColorTransform;
import flash.display.Bitmap;
import flash.display.BitmapData;
import caurina.transitions.Equations;
import flash.geom.Matrix;
import flash.events.Event;
import flash.events.MouseEvent;

class Thundaga extends Sprite
	{
		private var bmp:Bitmap = new Bitmap();
		public var bmd:BitmapData;
		private var ct:ColorTransform = new ColorTransform(1,1,1,1,-10,50,20,-80);
		private var tt:ThunderBody;
		private var glow0:GlowFilter;
		private var glow1:GlowFilter;
		private var glow3:GlowFilter;
		
		
		public function Thundaga()
		{
			//bmd = _bmd;
			tt = new ThunderBody();
			addChild(bmp);
			
			addChild(tt);
			
			addEventListener(Event.ENTER_FRAME, enterFrameHandler);
		}
                public function setBmd(_bmd:BitmapData=null):void {
                    if(_bmd==null) {
                        bmd = new BitmapData(50,550,true,0x000000);    
                    } else {
                        bmd = _bmd;
                        }
                    tt.setBmd(bmd);
                    //bmp.bitmapData = bmd;
                }
		
		private function addStageHandler(event:Event):void {
			stage.addEventListener(MouseEvent.CLICK, stageClick);
		}
		
		private function stageClick(event:MouseEvent):void {
			tt.generateThunder(10,10,300,420);
		}
		public function generateThunder(sx:Number,sy:Number,tx:Number, ty:Number):void {
                    tt.generateThunder(sx, sy, tx, ty);
                }

		private var blurFilter:BlurFilter = new BlurFilter(3,3);
		private function enterFrameHandler(event:Event):void {
			if(bmd) {
                            bmd.colorTransform( bmd.rect, ct );
			    bmd.applyFilter(bmd,bmd.rect, new Point(0,0), blurFilter);
                        }
		}
	}

	
	

class ThunderBody extends Sprite {
	private var tPoint:Sprite = new Sprite();
	private var oPoint:Point = new Point(0,0);
	private var graphDrawLayer:Sprite = new Sprite();
	public var myBmd:BitmapData;
	private var _bomb:Bomb;
	private var ThunderNodeList:Array = new Array();
	private var TListNum:int = 10;
	private var TListCounter:int = 0;
	
	public function ThunderBody() {
		CurveModifiers.init();
		_bomb = new Bomb();
		makeThunders();
	}
        public function setBmd(_bmd:BitmapData):void {
            myBmd = _bmd;
            _bomb.bmd = myBmd;
        }	

	private function makeThunders():void {
		var i:int;
		for(i=0; i<TListNum; i++) {
			var TN:ThunderNode  =new ThunderNode();
			graphDrawLayer.addChild(TN);
			ThunderNodeList.push(TN);
		}
	}
	
	public function generateThunder(sx:Number,sy:Number,tx:Number, ty:Number):void {
		tPoint.x = oPoint.x= sx;
		tPoint.y = oPoint.y = sy;
		var leng:int = 3;
		TListCounter = 0;
		var dxUnit:Number = (tx-sx)/leng;
		var dyUnit:Number = (ty-sy)/leng;
		var bz:Array = new Array();
    	var i:int;
    	for(i=0;i<leng;i++) {
    		bz.push({x:dxUnit*i+(-5+10*Math.random())+sx, y:dyUnit*i+(-10+20*Math.random())*i/leng+sy});
    	}
		for(i=0; i<TListNum; i++) {
			ThunderNodeList[i].reset();
		}
    	
    	Tweener.addTween(tPoint, {x:tx, y:ty, time:0.2, _bezier:bz, transition:Equations.easeNone,onUpdate:drawLine,
    		onComplete:_bomb.makeBomb, onCompleteParams:[tx,ty]});
	}
	
	private function drawLine():void {
		var dPoint:Point = new Point(tPoint.x-10+20*Math.random(), tPoint.y+5*Math.random());
		graphDrawLayer.graphics.clear();
		graphDrawLayer.graphics.lineStyle(2,0xFFFFFF);
		graphDrawLayer.graphics.moveTo(oPoint.x, oPoint.y);
		graphDrawLayer.graphics.lineTo(dPoint.x, dPoint.y);
		
		//不意のタイミングで枝生成
		if(Math.random()>0.5 && TListCounter<TListNum){
			ThunderNodeList[TListCounter].makeNode(dPoint.x, dPoint.y, 5*Math.random(), 30*Math.random() );
			TListCounter++;
		}
		var i:int = 0;
		for(i=0; i<TListNum; i++) {
			ThunderNodeList[i].update();
		}
		if(myBmd)myBmd.draw(graphDrawLayer);
		oPoint.x = dPoint.x;
		oPoint.y = dPoint.y;
	}
}

class ThunderNode extends Sprite {
	private var myBmd:BitmapData;
	private var isStarted:Boolean = false;
	public var vx:Number, vy:Number;
	public var px:Number, py:Number;
	private var counter:int = 0;
	public function ThunderNode() {
		
	}
	
	public function makeNode(sx:Number, sy:Number, _vx:Number, _vy:Number):void {
		isStarted = true;
		px = sx;
		py = sy;
		vx = _vx;
		vy = _vy;
		
	}
	public function update():void {
		if(!isStarted) return;
		vx += 0.1 * Math.cos(counter*Math.PI/180)-1+Math.random()*2;
		vy += 2 * Math.sin(counter*Math.PI/180)-1+Math.random()*2;
		this.graphics.clear();
		this.graphics.lineStyle(1,0xFFFFFF);
		this.graphics.moveTo(px, py);
		this.graphics.lineTo(px+vx, py+vy);
		px += vx;
		py += vy;
                counter++;
	}
	public function reset():void {
		isStarted = false;
		counter = 360 * Math.random();
		this.graphics.clear();
	}
}

class Bomb extends Sprite {
	private var posList:Array = new  Array();
	public var bombList:Array = new Array();
	public var bombNum:int = 20;
	public var bmd:BitmapData;
	private var blush:Sprite = new Sprite();
	private var bombLayer:Sprite = new Sprite();
	public function Bomb() {
		var i:int;
		for(i=0; i<bombNum; i++) {
			var _bChild:bombChild = new bombChild();
			posList.push(_bChild); 
			var _bBody:Sprite = new Sprite();
			blushShape(_bBody);
			bombLayer.addChild(_bBody);
			bombList.push(_bBody);
		}
		blushShape(blush);

	}
	
	private function blushShape(sp:Sprite):void {
		sp.graphics.beginFill(0xffffff);
		sp.graphics.drawCircle(0,0,10);
		sp.graphics.endFill();
	}
	
	public function makeBomb(tx:Number, ty:Number):void {
		var i:int;
		for(i=0; i<bombNum; i++) {
			posList[i].vx = -10+20*Math.random();
			posList[i].vy = -30+30*Math.random();
			
			posList[i].x = tx + posList[i].vx;
			posList[i].y = ty + posList[i].vy;
			posList[i].vx *= 0.1;
			posList[i].vy *= 0.1;
			posList[i].scaleVal = Math.random();
			posList[i].counter=0;
			
			bombList[i].x = posList[i].x;
			bombList[i].y = posList[i].y;
		}
		alpha=0;
		Tweener.addTween(this, {alpha:1, time:0.5, transition:Equations.easeOutQuint, onUpdate:onUpdateHandler});
	}
	private function onUpdateHandler():void {
		var i:int;
		for(i=0; i<bombNum; i++) {
			posList[i].update();
			var mtx:Matrix = new Matrix();
			mtx.translate(posList[i].x, posList[i].y);
			bombList[i].scaleX = bombList[i].scaleY = posList[i].scaleVal;
		}
		if(bmd)bmd.draw(bombLayer);
	}
	
}
class bombChild {
	public var x:Number, y:Number;
	public var vx:Number, vy:Number;
	public var scaleVal:Number = 0.1;
	public var scaleStep:Number = 0.1;
	public var scaleTarget:Number = 0.5;
	public var scaleScale:Number;
	public var counter:int = 0;
	private var Deccel:Number = 0.9;
	public function bombChild() {
		scaleStep = 2*Math.random();
		scaleScale = 2*Math.random();
	}
	public function update():void {
		x += vx;
		y += vy;
		vx *= 0.9;
		vy *= 0.9;
		scaleVal = scaleScale * Math.sin(counter*Math.PI/180);
		counter += scaleStep * (180 - counter);
	}
}
///////////////////////////////////////////////////////////////////////////////////////

class HSBColor
{
    /**
     * Constructs an HSVColor with optional parameters
     *  
     *  @langversion 3.0
     *  @playerversion Flash 10
     *  @playerversion AIR 1.5
     *  @productversion Flex 4
     */
    public function HSBColor(hue:Number = NaN, saturation:Number = NaN, 
        brightness:Number = NaN)
    {
        this.hue = hue;
        this.saturation = saturation;
        this.brightness = brightness;
    }
    
    private var _hue:Number;
    /**
     * The hue value for the HSV color. This represents an angle, in 
     * degrees, around the HSV cone. The supplied value will be modulated
     * by 360 so that the stored value of hue will be in the range [0,360).
     *  
     *  @langversion 3.0
     *  @playerversion Flash 10
     *  @playerversion AIR 1.5
     *  @productversion Flex 4
     */
    public function get hue():Number
    {
        return _hue;
    }
    public function set hue(value:Number):void
    {
        _hue = value % 360;
        _hue += 360;
        _hue %= 360;
    }
    
    private var _saturation:Number;
    /**
     * The saturation parameter for this HSV color. This is a value between
     * 0 (black) and 1 (full saturation), which represents the distance
     * from the center in the HSV cone.
     *  
     *  @langversion 3.0
     *  @playerversion Flash 10
     *  @playerversion AIR 1.5
     *  @productversion Flex 4
     */
    public function get saturation():Number
    {
        return _saturation;
    }
    public function set saturation(value:Number):void
    {
        _saturation = value;
    }
    
    private var _brightness:Number;
    /**
     * The brightness parameter for this HSB color. This is a value between
     * 0 (black) and 1 (full brightness), which represents the distance
     * from the apex of the HSB cone.
     *  
     *  @langversion 3.0
     *  @playerversion Flash 10
     *  @playerversion AIR 1.5
     *  @productversion Flex 4
     */
    public function get brightness():Number
    {
        return _brightness;
    }
    public function set brightness(value:Number):void
    {
        _brightness = value;
    }
    
    /**
     * Converts an HSB color specified by the parameters to a
     * uint RGB color.
     *  
     *  @langversion 3.0
     *  @playerversion Flash 10
     *  @playerversion AIR 1.5
     *  @productversion Flex 4
     */
    public static function convertHSBtoRGB(hue:Number, saturation:Number, 
        brightness:Number):uint
    {
        // Conversion taken from Foley, van Dam, et al
        var r:Number, g:Number, b:Number;
        if (saturation == 0)
        {
            r = g = b = brightness;
        }
        else
        {
            var h:Number = (hue % 360) / 60;
            var i:int = int(h);
            var f:Number = h - i;
            var p:Number = brightness * (1 - saturation);
            var q:Number = brightness * (1 - (saturation * f));
            var t:Number = brightness * (1 - (saturation * (1 - f)));
            switch (i) {
                case 0:
                    r = brightness;
                    g = t;
                    b = p;
                    break; 
                case 1:
                    r = q;                    
                    g = brightness;
                    b = p;
                    break; 
                case 2:
                    r = p;
                    g = brightness;
                    b = t; 
                    break;
                case 3:
                    r = p;
                    g = q;
                    b = brightness;
                    break; 
                case 4:
                    r = t;
                    g = p;
                    b = brightness; 
                    break;
                case 5: 
                    r = brightness;
                    g = p;
                    b = q;
                    break;
            }
        }
        r *= 255;
        g *= 255;
        b *= 255;
        return (r << 16 | g << 8 | b);
    }
    
    /**
     * Converts a color from RGB format into an HSBColor
     *  
     *  @langversion 3.0
     *  @playerversion Flash 10
     *  @playerversion AIR 1.5
     *  @productversion Flex 4
     */
    static public function convertRGBtoHSB(rgb:uint):HSBColor
    {
        // Conversion taken from Foley, van Dam, et al
        var hue:Number, saturation:Number, brightness:Number;
        var r:Number = ((rgb >> 16) & 0xff) / 255;
        var g:Number = ((rgb >> 8) & 0xff) / 255;
        var b:Number = (rgb & 0xff) / 255;
        var max:Number = Math.max(r, Math.max(g, b));
        var min:Number = Math.min(r, Math.min(g, b));
        var delta:Number = max - min;
        brightness = max;
        if (max != 0)
            saturation = delta / max;
        else
            saturation = 0;
        if (saturation == 0)
            hue = NaN;
        else
        {
            if (r == max)
                hue = (g - b) / delta;
            else if (g == max)
                hue = 2 + (b - r) / delta
            else if (b == max)
                hue = 4 + (r - g) / delta;
            hue = hue * 60;
            if (hue < 0)
                hue += 360;
        }
        return new HSBColor(hue, saturation, brightness);
    }
}