/**
 * Copyright enecre ( http://wonderfl.net/user/enecre )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/rfUa
 */

//初心者なりに頑張って、しかしゆっくり作り中です。
package {
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.display.Loader;
    import flash.net.URLRequest;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import caurina.transitions.Tweener;
    import flash.text.TextFormat;   
	[SWF(width = 465, height = 465, frameRate = 20, backgroundColor = 0xaaaaff)]
    public class FlashTest extends Sprite {
    	
    		private const len_TEHAI:int = 5;
    		
    		private var hai:Vector.<Hai>;
		private var tf:TextField = new TextField();
		
		private var positions:Vector.<int>;
		
		private var tehai:Tehai;
		private var yama:Yama;
		private var timer:GUITimer;
    	
        public function FlashTest() {
            // write as3 code here..
            tf.width = 500;
            var format:TextFormat = new TextFormat();
            format.font = "Meiryo";
            tf.setTextFormat(format);
            tf.text = "Hello, Wonderfl Mahjong!";
            addChild(tf);
            loadHaiga();
            stage.addEventListener(MouseEvent.CLICK,clickHandler);
            //手牌の表示位置初期化
            positions = new Vector.<int>();
        		var beginX:int = (465 - len_TEHAI * 31) / 2;
        		for (var i:int=0;i<len_TEHAI;i++){
        			positions[i] = beginX + i * 31;
        		}
        		timer = new GUITimer(5,400,400);
       		timer.addEventListener(GUITimer.TIME_UP,function():void{
            		tf.appendText("Timee Up!!!");
       		});
       		addChild(timer);
            init();
        }
        
        private function init():void{
        		tehai = new Tehai(len_TEHAI);
        		yama = new Yama();
        		timer.init();
        }
        
        private function gameStart():void{
        		timer.start();
       		haipai();
        }
        
        private function haipai():void{
        		tf.appendText(String(length));
        		tsumo(yama.pop());
        		tsumo(yama.pop());
        		tsumo(yama.pop());
        		tsumo(yama.pop());
        		ripai();
        }
        
        private function tsumo(n:int):void{
        		var target:Hai = hai[n] as Hai;
        		tehai.tsumo(target);
        		target.x = 0;
        		target.y = 320;
        		addChild(target);
        		target.moveTo(positions[len_TEHAI-1]);
        		tehai.activate();
        }
        
        private function sute(e:Event = null):void{
        		tehai.sute(hai[1]);
        		ripai();
        }
        
        private function ripai():void{
        		tf.appendText("test");
        		tehai.ripai(positions);
        }
        
        private function loadHaiga():void{//牌画の読み込み
        		hai = new Vector.<Hai>(136);
            for(var i:int = 0;i<hai.length;i++){
            hai[i] = new Hai(i);
            hai[i].addEventListener(SuteEvent.DEFAULT,function():void{
            		tf.appendText("bar");
            });
            }
        }
        
        private function clickHandler(e:MouseEvent):void{
        	if(e.target !== stage)return;
        		init();
        		gameStart();
        }
    }
}
class Tehai　{
    private var tehai:Vector.<Hai>;
    private var len_Tehai:int;
    public function Tehai(n:int){
        tehai = new Vector.<Hai>();
        len_Tehai = n;
    }
    
    public function activate():void{
    		var len:int = tehai.length;
    		for(var i:int=0;i<len;i++){
    			tehai[i].active = true;
    		}
    }
    
    public function ripai(positions:Vector.<int>):void{
    		sort();
    		
    		var len:int = tehai.length;
        	for(var i:int=0;i<len;i++){
        		tehai[i].moveTo(positions[i]);	
        	}
    }
    
    private function sort():void{
    		tehai.sort(function(x:Hai,y:Hai):Number{
    			return x.hai136 - y.hai136;
    		});
    }
    
    public function haipai(haipai:Array):void{
    		if(len_Tehai - 1 != haipai.length){
    			throw new Error("エラー");
    			return;
    		}
    		this.tehai = Vector.<Hai>(haipai);
    }
    public function tsumo(hai:Hai):void{
        tehai.push(hai);
    }
    public function sute(hai:Hai):void{
        var index:int = tehai.indexOf(hai);
        tehai.splice(index,1);
    }
    public function isTenpai():Boolean{
    		return false;
    }
    
    public function length():int{
    		return this.tehai.length;
    }
}
import flash.display.Loader;
import flash.net.URLRequest;
import flash.events.EventDispatcher;
import flash.text.TextField;
import flash.utils.Timer;
import flash.events.*;
import flash.events.TimerEvent;
import caurina.transitions.Tweener;

import flash.display.Loader;
import flash.filters.BlurFilter;
import flash.filters.ColorMatrixFilter;
import flash.filters.BevelFilter;

class Hai extends Loader{
	
	public static const name:Vector.<String> = Vector.<String>([
		"1m","1m","1m","1m","2m","2m","2m","2m","3m","3m","3m","3m","4m","4m","4m","4m","0m","5m","5m","5m","6m","6m","6m","6m","7m","7m","7m","7m","8m","8m","8m","8m","9m","9m","9m","9m",
		"1p","1p","1p","1p","2p","2p","2p","2p","3p","3p","3p","3p","4p","4p","4p","4p","0p","5p","5p","5p","6p","6p","6p","6p","7p","7p","7p","7p","8p","8p","8p","8p","9p","9p","9p","9p",
		"1s","1s","1s","1s","2s","2s","2s","2s","3s","3s","3s","3s","4s","4s","4s","4s","0s","5s","5s","5s","6s","6s","6s","6s","7s","7s","7s","7s","8s","8s","8s","8s","9s","9s","9s","9s",
		"1z","1z","1z","1z","2z","2z","2z","2z","3z","3z","3z","3z","4z","4z","4z","4z","5z","5z","5z","5z","6z","6z","6z","6z","7z","7z","7z","7z"
	]);
	
	private var _hai136:int;
	public var active:Boolean=false;
	
	public function get hai136():int{
		return this._hai136;
	}
	
	public function Hai(n:int){
		super();
		this._hai136 = n;
		var url:String = "http://www14.atpages.jp/enecre/uploads/tenhou/" + Hai.name[n] + ".gif";
		contentLoaderInfo.addEventListener(Event.COMPLETE,function(e:Event):void{
			width = 31;
      	    height = 47;
		});
        	load(new URLRequest(url));
        	
        	this.addEventListener(MouseEvent.MOUSE_OVER,onMouseOver);
        	this.addEventListener(MouseEvent.MOUSE_OUT,onMouseOut);
        	this.addEventListener(MouseEvent.CLICK,onClick);
    }
    
    private function onClick(e:Event):void{
    		if (!this.active)return;
    		this.active = false;
    		dispatchEvent(new SuteEvent(SuteEvent.DEFAULT,this._hai136));
    		exitTween();
    }
    public function enterTween():void{
        	Tweener.addTween(this,{x:300 , time:0.5, transition:"easeOutQuint"});
    }
    
    private function exitTween():void{
    		Tweener.addTween(this,{x:400,time:0.3,onComplete:function():void{this.parent.removeChild(this);}});
    }
    
    public function moveTo(toX:Number):void{
    		Tweener.addTween(this,{x:toX, time:0.5});
    }
    
    private function onMouseOver(e:Event):void{
    		var matrixfilter:ColorMatrixFilter = new ColorMatrixFilter([
    			0.7,0,0  ,0,0,
    			 0 ,1,0  ,0,0,
    			 0 ,0,0.7,0,0,
    			 0 ,0, 0 ,1,0
    			]);
    		this.filters = [matrixfilter];
    }
    
    private function onMouseOut(e:Event):void{
    		this.filters = [];
    }
}

import flash.events.Event;
class SuteEvent extends Event{
	
	public static const DEFAULT:String = "default";
	
	private var hai136:int;
	
	public function SuteEvent(name:String, n:int){
		super(name);
		this.hai136 = n;
	}
}

class Yama{
    private const n_HAI:int = 136;
    private const n_WANPAI:int = 14;
    
    private var yama:Vector.<int> = new Vector.<int>(n_HAI);
    public function Yama(){
        for(var i:int=0;i<n_HAI;i++){
            yama[i] = i
        }
        
        shuffle();
    }
    private function shuffle():void{
    		var k:int = n_HAI;
        while(k){
        		var rand:int = Math.floor(Math.random()*k);
			var tmp:int = yama[--k];
			yama[k] = yama[rand];
			yama[rand] = tmp;
        }
    }
    public function pop():int{
        return yama.pop();
    }
    
    public function length():int{
    		return yama.length;
    }
}
class GUITimer extends TextField{
	public static const TIME_UP:String = "timeUp";
	
	private var _timeLimit:int;
	private var _time_left:int;
	private var _timer:Timer = new Timer(1000);
	public function GUITimer(t:int,x:Number,y:Number){
		_timeLimit = t;
		this.x = x;
		this.y = y;
		_timer.addEventListener(TimerEvent.TIMER,function():void{
			_time_left--;
			text = String(_time_left);
			if (_time_left == 0){
				dispatchEvent(new Event(GUITimer.TIME_UP));
				_timer.stop();
			}
		});
		init();
	}
	
	public function init():void{
		this.text = String(_timeLimit);
		_time_left = _timeLimit;
		_timer.reset();
	}
	public function start():void{
		_timer.start();
	}
	public function stop():void{
		_timer.stop();
	}
}